;  
;  This is a set of basic functions required for work with VBE2.0 
;  (for stack based calling uncomment commented lines and remove underscores)
;  written by Blaz Novak, 16. jun. 1998
;  comments were written later in order to annoy you :)
;

.586p                                ;it would probably work w/ 386p+
.model flat, C
assume cs: flat, ds:flat, es:flat, fs:flat, gs:flat, ss: flat

VBEinfo struc			     ;basic data about gr. adapter
	VbeSignature db 'VBE2'	     ;VBE signature
	VbeVersion   dw 0	     ;VBE version (BCD?)
	OEMString    dd 0	     ;OEM string pointer
	Capabilities dd 0	     ;Graphics controller capabilities
	VideoModeptr dd 0	     ;Video mode list pointer
	TotalMemory  dw 0	     ;Memory size (in 64KB blocks)
	OEMswRev     dw 0	     ;VBE implementation sw. revision
	OEMvendor    dd 0	     ;Vendor name pointer
	OEMproduct   dd 0	     ;Product name pointer
	OEMprodrev   dd 0	     ;Product revision pointer
	ReservedVBEi db 222 dup (0)  ;VBE reserved area
	OEMdata      db 256 dup (0)  ;OEM strings data area
VBEinfo ends

ModeInfoBlock struc                   ;data about selected mode         
	ModeAttributes      dw 0      ; mode attributes
	WinAAttributes      db 0      ; window A attributes
	WinBAttributes      db 0      ; window B attributes
	WinGranularity      dw 0      ; window granularity
	WinSize             dw 0      ; window size
	WinASegment         dw 0      ; window A start segment
	WinBSegment         dw 0      ; window B start segment
	WinFuncPtr          dd 0      ; pointer to window function
	BytesPerScanLine    dw 0      ; bytes per scan line
	XResolution         dw 0      ; horizontal resolution in pixels or chars
	YResolution         dw 0      ; vertical resolution in pixels or chars
	XCharSize           db 0      ; character cell width in pixels
	YCharSize           db 0      ; character cell height in pixels
	NumberOfPlanes      db 0      ; number of memory planes
	BitsPerPixel        db 0      ; bits per pixel
	NumberOfBanks       db 0      ; number of banks
	MemoryModel         db 0      ; memory model type
	BankSize            db 0      ; bank size in KB
	NumberOfImagePages  db 0      ; number of images
	ReservedMIB1        db 0      ; reserved for page function
	RedMaskSize         db 0      ; size of direct color red mask in bits
	RedFieldPosition    db 0      ; bit position of lsb of red mask
	GreenMaskSize       db 0      ; size of direct color green mask in bits
	GreenFieldPosition  db 0      ; bit position of lsb of green mask
	BlueMaskSize        db 0      ; size of direct color blue mask in bits
	BlueFieldPosition   db 0      ; bit position of lsb of blue mask
	RsvdMaskSize        db 0      ; size of direct color reserved mask in bits
	RsvdFieldPosition   db 0      ; bit position of lsb of reserved mask
	DirectColorModeInfo db 0      ; direct color mode attributes
	PhysBasePtr         dd 0      ; physical address for linear frame buffer
	OffScreenMemOffset  dd 0      ; pointer to start of off screen memory
	OffScreenMemSize    dw 0      ; amount of off screen memory in 1k units
	ReservedMIB2        db 206 dup (0)  ; remainder of ModeInfoBlock
ModeInfoBlock ends											       

RealmodeRegs struc	              ;register structure used for
	redi dd 0		      ;simulating real mode IRQs
	resi dd 0
	rebp dd 0
	rreserved dd 0
	rebx dd 0
	redx dd 0
	recx dd 0
	reax dd 0
	rflags dw 0
	res  dw 0
	rds  dw 0
	rfs  dw 0
	rgs  dw 0
	rip dw 0
	rcs dw 0
	rsp dw 0
	rss  dw 0
RealmodeRegs ends

                                      ;error messages
	OK	       EQU 0h
	RMEMALLOCFAIL  EQU 1h
	VBE00FAIL      EQU 2h
	PMFUNCADDRFAIL EQU 3h
	GETMDATAFAIL   EQU 4h
	MODEFAIL       EQU 5h
	SETMODEFAIL    EQU 6h
	VBEBELOW2      EQU 7h
                                      ;offsets of structures
	VBCKS          EQU 200h
	VBR            EQU 230h

code segment para public 'code' USE32
VBEinit_ proc				       ;(error:int)VBEinit(void)
	pusha				       ;store general
	push es				       ;and es registers
	mov eax, 100h                          ;allocate dos mem
	mov ebx, 34h                           ;one paragraph more than needed
	int 31h				       ;do it...
	jc  memallocfail		       ;did you fail?
	mov word ptr _dosselect, dx            ;store selector
	mov word ptr _dosmemseg, ax	       ;store real mode segment
	xor ebx, ebx			       ;
	mov bx, ax			       ;calculate linear address
	shl ebx, 4			       ;of VBEinfoBlock
	mov dword ptr _vbeinfoblock, ebx       ;store VBEinfoBlock address
	add ebx, VBR                           ;calculate lin.addr of modeblock		
	mov dword ptr _modeblock, ebx	       ;and store it...
	mov es, dx                             ;dx holds selector of allocated mem.
	mov eax, 0			       ;
	mov cx, 0d0h			       ; we have to clear the whole
	cld				       ; regs structure otherwise
	mov edi, 0h			       ; some extenders won't like it
	rep stosd			       ;
	mov ax, _dosmemseg		       ;load real mode segment of allocated mem
	mov dword ptr es:[0], "2EBV"	       ;VBE2.0 infoblock header: VBE2
	mov dword ptr es:[reax+VBCKS], 4f00h   ;init fake real mode regs: VBE function number
	mov  word ptr es:[res+VBCKS], ax       ;VBEinfoBlock segment
	mov dword ptr es:[redi+VBCKS], 0h      ;	     offset (=0))
	mov edi, VBCKS                         ;register's offset (es:edi)
	mov ax, 300h		               ;sim. real mode int.
	mov bx, 10h		               ;int 10...
	mov cx, 0h		               ;nothing to copy(stack)...
	int 31h                                ;int...
	cmp word ptr es:[edi.reax], 4fh        ;supported&successful??
	jne vbe0fail			       ;no...
	mov dx, word ptr _dosselect	       ;in case registers got owerwritten
	mov es, dx                             ;load es again
	mov byte ptr _vbe2p, 0                 ;vbe <2
	mov ax, word ptr es:[VbeVersion]       ;get vbe ver. info
	cmp ah, 2                              ;is it >=2?
	jb novbe2			       ;no
	mov byte ptr _vbe2p, 1		       ;yes
	mov dword ptr es:[reax+VBCKS], 4f0ah   ; get protected mode
	mov dword ptr es:[rebx+VBCKS], 0h      ; function's addresses
	mov edi, VBCKS                         ;same as before...
	mov ax, 300h			       ; this function will tell us
	mov bx, 10h			       ; linear address of the p.mode
	mov cx, 0h			       ; function for display swapping
	int 31h				       ; (SetDisplayStart)
	cmp word ptr es:[edi.reax], 4fh        ;supported&successful??
	jne pmaddrfail			       ;no...
	mov dx, word ptr _dosselect	       ;loading es again...
	mov es, dx			       ;
	xor ebx, ebx			       ;
	mov bx, word ptr es:[res+VBCKS]	       ; calculate address of the 
	shl ebx, 4			       ; table of offsets & code
	add ebx, dword ptr es:[redi+VBCKS]     ; =es:di
	mov dword ptr _pmodefunc, ebx	       ;and store pmode function table
	xor edx, edx			       ;address
	mov dx, word ptr ds:[ebx+2]	       ;dx=flat:[ebx+2]
	add ebx, edx			       ;dx=offset of function
	mov dword ptr _sdstart, ebx	       ;store function's address
	mov dword ptr _vbeerror, OK            ;error = 0
	jmp vinitend			       ;goto end
memallocfail:				       ;
	mov dword ptr _vbeerror, RMEMALLOCFAIL ;
	jmp vinitend			       ;
vbe0fail:				       ;
	mov dword ptr _vbeerror, VBE00FAIL     ;
	jmp vinitend			       ;
pmaddrfail:				       ;
	mov dword ptr _vbeerror, PMFUNCADDRFAIL;	
	jmp vinitend			       ;
novbe2:
	mov dword ptr _vbeerror, VBEBELOW2
	jmp vinitend
vinitend:				       ;
	pop es				       ;load saved registers 
	popa				       ;from stack
	mov eax, dword ptr _vbeerror	       ;set return value
	ret				       ;end
VBEinit_ endp

VBEgetmodeinfo_ proc			       ;(error:int)VBEgetmodeifo(mode:int)
	;mov eax, dword ptr [esp+4]	       ;uncomment this for stack
	pusha				       ;based calling
	push es				       ;store regs.
	xor ecx, ecx			       ;move argument (passed in eAX)
	mov ecx, eax			       ;into eCX
	and ecx, 1ffh			       ;only lower 9 bits for mode number
	mov dx, word ptr _dosselect	       ;
	mov ax, word ptr _dosmemseg	       ; load segment/selector data
	mov es, dx			       ;
	mov dword ptr es:[VBCKS+reax], 4f01h   ;VBE GetModeInfo
	mov word ptr es:[VBCKS+res], ax	       ;segment of modeinfo struct
	mov dword ptr es:[VBCKS+redi], VBR     ;offset of Mi.struct
	mov dword ptr es:[VBCKS+recx], ecx     ;mode number
	mov edi, VBCKS			       ;es:edi=location of regs.struct
	mov ax,	300h			       ;
	mov bx,	10h			       ;
	mov cx,	0h			       ;
	int 31h				       ;
	mov dword ptr _vbeerror, OK	       ;
	cmp word ptr es:[edi.reax], 4fh	       ;supported&successfull?
	je gmiend			       ;yes
	mov dword ptr _vbeerror, GETMDATAFAIL  ;
gmiend: pop es				       ;
	popa				       ;
	mov eax, dword ptr _vbeerror	       ;return value...
	ret				       ;end
VBEgetmodeinfo_ endp

VBEsetmode_ proc	     		       ;(error:int)VBEsetmode(mode:int)
	;mov eax, dword ptr [esp+4]            ;stack calling (for reg.call remove...)
	pusha				       ;store regs.
	push es				       ;
	mov word ptr _want_mode, ax	       ;store mode nr. for later ref. 	
	xor ebx, ebx			       ;
	mov ebx, eax			       ;store argument in eBX 
	mov dx, word ptr _dosselect	       ;
	mov es, dx			       ;
	and bx, 1ffh			       ;set mode:
	or  bx, 4000h			       ;mode number|4000h(LFB)
	mov ax, 4f02h			       ;function number
	int 10h				       ;set mode...
	cmp ax, 4fh			       ;supported&successfull?
	jne setmodeoops			       ;no...
	mov al, byte ptr _ismap		       ;is phys. memory already mapped
	cmp al, 0			       ;?
	je  physaddrmap			       ;no
	mov ax, 801h			       ;unmap it
	mov ebx, dword ptr _linear1	       ;it's linear address 
	mov ecx, ebx			       ;in BX:CX
	shr ebx, 16			       ;
	int 31h				       ;
	mov byte ptr _ismap, 0		       ;
physaddrmap:
	mov dx, word ptr _dosselect	       ;map phys. memory:
	mov es, dx			       ;
	mov ax, 800h			       ;
	mov ebx, dword ptr es:[VBR+PhysBasePtr];it's physical address
	mov ecx, ebx			       ;in BX:CX
	shr ebx, 16			       ;
	xor edi, edi			       ;
	xor esi, esi			       ;size in SI:DI
	mov si, word ptr es:[TotalMemory]      ;because size in VBEinfoblock is
	int 31h				       ;in 64KB units -> si=size in 64KB, di=0 
	shl ebx, 16			       ;get linear address of mapped
	mov bx, cx			       ;memmory: BX:CX
	mov byte ptr _ismap, 1		       ;
	xor eax, eax			       ;
	xor edx, edx			       ;
	mov ax, word ptr es:[VBR+XResolution]  ;calculate size of one page:
	mov word ptr _Xres, ax		       ;Xres*Yres*Bpp
	mul word ptr es:[VBR+YResolution]      ;meanwhile store X&Y resolution
	shl edx, 16			       ;in separate vars.
	add eax, edx			       ;ax=Xres*Yres
	xor edx, edx			       ;
	mov dl, byte ptr es:[VBR+BitsPerPixel] ;dl=bpp
	shr dl, 3			       ;divide bpp by 8 -> Bpp
	mov byte ptr _Bpp, dl
	mul edx				       ; eAX * Bpp
	mov dword ptr _pagelen, eax	       ;store length of one page
	mov dword ptr _linear1, ebx	       ;linear address of 1st page
	add ebx, eax			       ;
	mov dword ptr _linear2, ebx	       ;linear address of 2nd page
	mov dword ptr _linearfb, ebx	       ;linearfb=pointer for page
	mov ax, word ptr es:[VBR+YResolution]  ;that is NOT currently displayed
	mov word ptr _Yres, ax		       ;store Yres
	mov dword ptr _vbeerror, OK	       ;
	jmp vsetend			       ;
setmodeoops:				       ;
	mov dword ptr _vbeerror, SETMODEFAIL   ;
	jmp vsetend			       ;
vsetend:				       ;
	pop es				       ;
	popa				       ;
	mov eax, dword ptr _vbeerror	       ;return value
	ret				       ;end
VBEsetmode_ endp

VBEswappage_ proc     			       ;(error:int)VBEswappage(retr:int)
	;mov eax, dword ptr [esp+4]	       ;for stack based calling
	pusha				       ;store regs.
	push es				       ;
	xor ebx, ebx			       ;
	cmp al, 1			       ;if argument=1 -> wait for retrace
	jne noretrace			       ;before swapping pages
	add bl, 80h			       ;otherwise swap imediately
noretrace:				       ;
	mov eax, 4f07h                         ;is this needed? maybe...
	mov edx, dword ptr _linearfb	       ;linearfb points to page in background
	cmp edx, dword ptr _linear1	       ;which page is currently on screen?
	je swapto2			       ;
swapto1:mov edx, dword ptr _linear1	       ;linearfb=1st page
	mov dword ptr _linearfb, edx	       ;
	mov edx, dword ptr _pagelen	       ;display 2nd page
	shr edx, 2			       ;
	mov cx, dx			       ;CX:DX=pixel/scanline of
	shr edx, 16			       ;0,0 pixel
	jmp swap			       ;
swapto2:mov edx, dword ptr _linear2	       ;linearfb=2nd page
	mov dword ptr _linearfb, edx	       ;
	mov cx, 0			       ;display 1st page
	mov dx, 0			       ;
swap:	call [_sdstart]			       ;swap it...
vswapend:				       ;
	mov dword ptr _vbeerror, OK	       ;
	pop es				       ;
	popa				       ;
	mov eax, dword ptr _vbeerror	       ;return error value
	ret				       ;end...
VBEswappage_ endp

VBEend_ proc				       ;(void)VBEend(void)
	pusha				       ;store regs.
	push es				       ;
	mov ax, 3h			       ;switch to usual mode 3
	int 10h				       ;
	mov ax, 101h			       ;deallocate memory...
	mov dx, word ptr _dosselect	       ;
	int 31h				       ;
	mov al, byte ptr _ismap		       ;
	cmp al, 0			       ;
	je demapped			       ;is gr.mem. mapped?
	mov ax, 801h			       ;
	mov ebx, dword ptr _linear1	       ;gr.card's phys. mem addr.
	mov ecx, ebx			       ;
	shr ebx, 16			       ;
	int 31h				       ;unmap it..
	mov byte ptr _ismap, 0		       ;
demapped:				       ;
	pop es				       ;
	popa				       ;
	ret				       ;end..
VBEend_ endp
public VBEinit_
public VBEgetmodeinfo_
public VBEsetmode_
public VBEswappage_
public VBEend_
code ends

data segment para public 'data' USE32
	_linearfb dd 0     ;linear frame buffer start... public
	_linear1  dd 0     ;1st frame buffer
	_linear2  dd 0     ;2nd frame buffer
	_vbeerror dd 0     ;errorcode ... public (int)
	_dosmemseg dw 0    ;segment of DOS memory
	_dosselect dw 0    ;selector of DOS memory block
	_pmodefunc dd 0    ;address of protected mode VBE functions 
	_sdstart   dd 0    ;address for set display start
	_modeblock dd 0    ;modeblock pointer
	_vbeinfoblock dd 0 ;vbeinfoblock pointer
	_want_mode dw 0    ;temporary mode nr.
	_ismap     db 0    ;is currently in vesa mode? (phys.addr.mapping active?)
	_pagelen   dd 0    ;length of one page
	_Xres dw 0         ;guess what..
	_Yres dw 0         ;same thing
	_Bpp db 0          ;bytes per pixel ... works if bpp=8*n ; n=1,2,3,...
	_vbe2p db 0        ;is vbe >= 2.0 ?
	public _linearfb   ;make some vars. public
	public _linear1
	public _linear2
	public _vbeerror
	public _dosselect
	public _dosmemseg
	public _modeblock
	public _vbeinfoblock
	public _pmodefunc
	public _sdstart
	public _ismap
	public _vbe2p
	public _Xres
	public _Yres
	public _Bpp
data ends
end