/*
 * header file for VBE2/1.2 library
 * structures copied from VESA's VBE/Core standard v2.0
 */

typedef struct {
     unsigned char      VbeSignature[4];           
     unsigned char VbeVerMinor,VbeVerMajor;          
     unsigned short int ostr1,ostr2;
     //unsigned int      *OemStringPtr;        
     unsigned int      Capabilities;        
     unsigned short int      VideoModePtr;        
     unsigned short int TotalMemory;         
     unsigned char OemSoftwareRevMinor,OemSoftwareRevMajor;      
     unsigned int      *OemVendorNamePtr;    
     unsigned int      *OemProductNamePtr;   
     unsigned int      *OemProductRevPtr;    
     unsigned char      Reserved[222];       
     unsigned char      OemData[256];        
} VBEIBlock;

typedef struct {
     unsigned short int ModeAttributes;
     unsigned char      WinAAttributes;      
     unsigned char      WinBAttributes;      
     unsigned short int WinGranularity;      
     unsigned short int WinSize;             
     unsigned short int WinASegment;         
     unsigned short int WinBSegment;         
     unsigned int      *WinFuncPtr;          
     unsigned short int BytesPerScanLine;    
     unsigned short int XResolution;         
     unsigned short int YResolution;         
     unsigned char      XCharSize;           
     unsigned char      YCharSize;           
     unsigned char      NumberOfPlanes;      
     unsigned char      BitsPerPixel;        
     unsigned char      NumberOfBanks;       
     unsigned char      MemoryModel;         
     unsigned char      BankSize;            
     unsigned char      NumberOfImagePages;  
     unsigned char      Reserved1;            
     unsigned char      RedMaskSize;         
     unsigned char      RedFieldPosition;    
     unsigned char      GreenMaskSize;       
     unsigned char      GreenFieldPosition;  
     unsigned char      BlueMaskSize;        
     unsigned char      BlueFieldPosition;   
     unsigned char      RsvdMaskSize;        
     unsigned char      RsvdFieldPosition;   
     unsigned char      DirectColorModeInfo; 
     unsigned int      *PhysBasePtr;         
     unsigned int      *OffScreenMemOffset;  
     unsigned short int OffScreenMemSize;    
     unsigned char      Reserved2[206];       
} VBEMBlock;

extern int VBEinit (void);
extern int VBEgetmodeinfo (int);
extern int VBEsetmode (int);
extern int VBEswappage (int);
extern void VBEend (void);
extern char* linearfb;
extern char* linear1;
extern char* linear2;
extern int vbeerror;
extern short int dosselect;
extern short int dosmemseg;
extern VBEIBlock* vbeinfoblock;
extern VBEMBlock* modeblock;
extern char vbe2p;
extern int BVesaInit(void);
extern int BVesaGetmodeinfo(int modenr);
extern int BVesaSetmode(int modenr);
extern int BVesaSetdisp(int x, int y, int retrace);
extern int BVesaSetscan(int len);
extern int BVesaCpymem(char* data, int len, int offset);
extern void BVesaEnd(void);
extern void setcolor(char c, char r, char g, char b);
extern int TotalGraphicMem();