#include <stdlib.h>
/* unit to handle filling of screen */
typedef struct l_break {
                          int x; 
                          struct l_break *next;
                       } l_break;
                       
struct l_break *tabfill;
int allocatedtab;
void addbreakline(int y,int x1,int x2) { /* adds breaked line */
  struct l_break *b1,*b2,*btmp;
  b1=malloc(sizeof(l_break));
  b2=malloc(sizeof(l_break));
  if (y>=allocatedtab) /* new line is beyond the end of the current buffer */
  {
    int i;
    tabfill=realloc(tabfill,((y)+10)*sizeof(l_break)); /* reallocate our buffer if needed */  
    for (i=allocatedtab;i<y+10;i++) {
      tabfill[i].next=malloc(sizeof(l_break));
      tabfill[i].x=0;
      (*tabfill[i].next).x=XRES;
      (*tabfill[i].next).next=NULL;
    }
    allocatedtab=y+10;
  }
  (*b1).x=x1;         /* new break line is setuped */
  (*b2).x=x2;         /* now we have to find where to insert it */
  (*b1).next=b2;
  btmp=&(tabfill[y]);
  while(x1>=(*(*btmp).next).x) { /* this will be the case at least once */
    btmp=(*btmp).next;
  };
  (*b2).next=(*btmp).next; /* now insert our new break */
  (*btmp).next=b1;
}

void addbreakrect(int x1, int y1, int x2,int y2) { /* adds breaked rectangle */
  int i;

//  printf("adding rectangl x1:%i y1:%i x2:%i y2:%i\n",x1,y1,x2,y2);  
  for (i=y1;i<=y2;i++) {
    addbreakline(i,x1,x2); 
  }
};

int getleft(int cx,int cy ) { /* gets left corner of current line cy that is greater tthan cx */

  struct l_break b1,b2;
  if (cy>=allocatedtab) { /* if line is not in our left/right buffer */
    if (cx==0) return(0); else return(XRES);
    /*there are only two options, end of line or beggining */
  }
  b1=tabfill[cy];
  b2=*b1.next;

  //printf("block1: %i, %i     x: %i, y: %i\n",b1.x,b2.x,cx,cy );
  if ((cx<=b1.x) && (b1.x!=b2.x)) return(b1.x); /* find next start after curx */
  while (b2.next!=NULL) {  
    b1=*b2.next;
    b2=*b1.next;
    if ((cx<=b1.x) && (b1.x!=b2.x)) {    /*if we have suitable block start */
      return(b1.x);
    }
  }
  return(XRES);  
};
int getright(int cx,int cy ) { /* gets right corner of current line cy that is greater tthan cx */
  struct l_break b1,b2;
  if (cy>=allocatedtab) {/* if line is not in our left/right buffer */
    return(XRES);
  }
  b1=tabfill[cy];
  b2=*b1.next;
    if ((cx<=b1.x) && (b1.x!=b2.x)) return(b2.x);
  while (b2.next!=NULL) {  
    b1=*b2.next;
    b2=*b1.next;
      if ((cx<=b1.x) && (b1.x!=b2.x)) return(b2.x);/*if we have suitable block start we have an end too */
  }
  return(-1);  
};

void textoutput() { /* no comment on this, just for debugging */
  int i;
  struct l_break *b;
  for (i=0;i<allocatedtab;i++) {
    b=&tabfill[i];
    while (b!=NULL) {
      printf("%i, ",(*b).x);
      b=(*b).next;
    }
    printf("\n");  
  }

}

void initfill(int startnum) { /* allocates starting memory field */
  int i;
  tabfill=malloc(startnum*sizeof(l_break)); /* allocates */
  allocatedtab=startnum; 
  for (i=0;i<startnum;i++) { /* put defaults in there */
    tabfill[i].next=malloc(sizeof(l_break));
    tabfill[i].x=0;
    (*tabfill[i].next).x=XRES;
    (*tabfill[i].next).next=NULL;
  }
}
void freefill() { /* frees whole field */
  int i;
  struct l_break b,bb;
  for (i=0;i<allocatedtab;i++) { /*trough all lines */
    b=tabfill[i];
    while (b.next!=NULL) { /* till we reach the end */
      bb=*b.next;
      free(b.next);
      b=bb; 
    }  
  }
  free(tabfill);
}
     
         