/* Virtual Output system */

#include <stdlib.h>
#include "..\defs.h"
#include "defpal.h"
#include "vos.h"

#include "..\bvbex.h"
struct vwindow {
					int starty,endy;
					word targety;
					word loaded;
					word sizey;
				} vwindow;

int maxlines=1600;
int cwindow=-1;				
char buff[100]="               ";
struct vwindow w1,w2;

void memstosd(dword strt,dword length,dword color);
#pragma aux memstosd=\
	"rep stosd"\
	parm [edi] [ecx] [eax]\
	modify [edi ecx];

word getcolor(byte r,byte g, byte b);
word getdefcolor(byte c);
  
word getdefcolor(byte c) {
	return(getcolor(defpal[(int)c*3],defpal[(int)c*3+1],defpal[(int)c*3+2]));
};
  
word getcolor(byte r,byte g, byte b) {
	#ifdef BPP32
		return((((word)r)<<16)|(((word)g)<<8)|(((word)b)));
	#else    
		word rr=r>>3,gg=g>>2,bb=b>>3;
		return((rr<<11)|(gg<<5)|(bb));
	#endif
}
  
void VOSputpixel(word x, word y,byte color) { /* outputs one pixel */
	word* finalofs;
	if (y>=cscreen.yres) {
		VOSresize(cscreen.xres,y+YSCAL); /* if we went below current border */
    }
	finalofs=(word *)(cscreen.data+(x+y*cscreen.xres)*ByPP); /*calculate adress */
	if ((x>0) && (x<cscreen.xres) && (y>0)) { /*everything ok*/ 
		*(finalofs)=getdefcolor(color);
	}
}

void VOSputpixel16(word x, word y,word color) { /* outputs one pixel */
	word* finalofs;
	if (y>=cscreen.yres) {
		VOSresize(cscreen.xres,y+YSCAL); /* if we went below current border */
	}
	finalofs=(word *)(cscreen.data+(x+y*cscreen.xres)*ByPP); /*calculate adress */
	if ((x>0) && (x<cscreen.xres) && (y>0)) { /*everything ok*/ 
		*(finalofs)=color;
	}
}

void VOSinvertpix(word x, word y){
	word* finalofs;
	
	if (y>=cscreen.yres) {
		VOSresize(cscreen.xres,y+YSCAL); /* if we went below current border */
	}
	finalofs=(word *)(cscreen.data+(x+y*cscreen.xres)*ByPP); /*calculate adress */
	if ((x>0) && (x<cscreen.xres) && (y>0)) { /*everything ok*/ 
		*(finalofs)=~(*finalofs);
	}
}
  
int VOSclear() { /*heh.. what does it say? */
	memstosd((dword)cscreen.data,(dword)cscreen.xres*cscreen.yres*ByPP/4,0);    
}

int VOSinit(word xres,word yres) {
/* mallocate, set constants and clear the VOS */
	dword memsize=(dword)xres*((dword)yres+1)*ByPP;
	if (((cscreen.data=(dword)malloc(memsize))==-1)) {
		return (-1);
		printf("Not enough memmory for VOS init\n");
	}
	cscreen.xres=xres;
	cscreen.yres=yres;
	maxlines=GetVBEMem()/(XRES*ByPP)-1;
	if (yres>=maxlines) {
		w1.loaded=0;
		w2.loaded=0; /* no windows are loaded to video screen */
		w1.starty=-1;
		w2.starty=-1;
		w1.endy=-1;
		w2.endy=-1;		
		w1.targety=0;
		w2.targety=maxlines/2+1;
		w1.sizey=maxlines/2;
		w2.sizey=maxlines/2-1;
		cwindow=-1;
	} else {
		w1.loaded=0;
		w1.targety=0;
		w1.sizey=maxlines;
		cwindow=-1;
	}
	VOSclear();
	return(0);  
  }

/* VOSresize .. is really pain in the ass.. i don't know why isn't it working ok? */
/* maybe a watcom bug or sth */
/* wonderful.. works with watcom 11 */
/* bastards... */
int VOSresize(word xres,word yres) { /* doesn't support x resizing right now */
	byte *tmp; 
	dword oldmemsize=(dword)cscreen.xres*((dword)cscreen.yres)*ByPP;
	dword memsize=(dword)xres*((dword)yres+1)*ByPP;
    
    
	if ((cscreen.data=(byte *)realloc(cscreen.data,memsize))==-1) {
		printf("Not enough memmory for VOS resize\n");
		return (-1);
	}
    
	memstosd((dword)cscreen.data+oldmemsize,(memsize-oldmemsize)/4,0);    
	/* clear the buffer we allocated */
//	tmp=malloc(xres);
 
    
	cscreen.xres=xres;
	cscreen.yres=yres;
	return(0);
}

void VOStovideo(word starty, word endy, word targety) {
	movetovideo(
	(dword)cscreen.data+(dword)starty*cscreen.xres*ByPP,
	(dword)abs((int)endy-(int)starty)*cscreen.xres*ByPP,
	(dword)targety					 *cscreen.xres*ByPP);
}
word arr[16*64+64];
word arr11[16*64+64];
word arr5[16*64+64];
void VOSfadeout(word starty, word targety) {
#ifdef FADES
	word *scrmem=malloc(XRES*YRES*ByPP);
	word *sourc=(word *)((dword)cscreen.data+(dword)starty*XRES);
	int x,y,i,j;

	for (i=0;i<16;i++) 
		for (j=0;j<64;j++) 
		{
			arr[i*64+j]=j*i/15;
			arr11[i*64+j]=(j*i/15)<<11;
			arr5[i*64+j]=(j*i/15)<<5;
		}
	
	for (i=15;i>0;i--) {
		int ii=i<<6;
		for (j=0;j<XRES*YRES;j++) 
		{
		
			scrmem[j]=
					 (arr11	[(	sourc[j]	>>11		)	|ii])
					|(arr5	[((	sourc[j]	>>5	)	&63	)	|ii])
					|(arr	[(	sourc[j]			&31	)	|ii]);					
	
		}
		
		movetovideo(
			scrmem,
			(dword)XRES*YRES*ByPP,
			(dword)targety*XRES);
	}
	free(scrmem);
#endif
}
void VOSfadein(word starty, word targety) {
#ifdef FADES
	word *scrmem=malloc(XRES*YRES*ByPP);
	word *sourc=((dword)cscreen.data+(dword)starty*cscreen.xres);
	int x,y,i,j;

	for (i=0;i<16;i++) 
		for (j=0;j<64;j++) 
		{
			arr[i*64+j]=j*i/15;
			arr11[i*64+j]=(j*i/15)<<11;
			arr5[i*64+j]=(j*i/15)<<5;
		}
	
	for (i=0;i<16;i++) {
		int ii=i<<6;
		for (j=0;j<XRES*YRES;j++) 
		{
		
			scrmem[j]=
					 (arr11	[(	sourc[j]	>>11		)	|ii])
					|(arr5	[((	sourc[j]	>>5	)	&63	)	|ii])
					|(arr	[(	sourc[j]			&31	)	|ii]);					
	
		}
		
		movetovideo(
			scrmem,
			(dword)XRES*YRES*ByPP,
			(dword)targety*cscreen.xres);
	}
	free(scrmem);
#endif
}


void VOSfree(void) {
	free(cscreen.data);
}
void Retrace();
	#pragma aux Retrace=\
	"mov dx,3dah"\
	"vert1:"\
	"in al,dx"\
	"test al,8"\
	"jz vert1"\
	"vert2:"\
	"in al,dx"\
	"test al,8"\
	"jnz vert2"\
	modify [dx al]; 
 
void VOSreneww1(word y) {
	cwindow=1;
	w1.loaded=1;
	w1.starty=y-(w1.sizey-YRES)/2;
	if (w1.starty<0) w1.starty=0;
	w1.endy=w1.starty+w1.sizey;
	if (w1.endy>cscreen.yres) w1.endy=cscreen.yres;
	
	if (w1.endy-w1.starty<w1.sizey) {
		w1.starty=w1.endy-w1.sizey;
	}
	if (w1.starty<0) w1.starty=0;
	
	VOStovideo(w1.starty,w1.endy,w1.targety);

	
}

void VOSreneww2(word y) {
	cwindow=2;
	w2.loaded=1;
	w2.starty=y-(w2.sizey-YRES)/2;
	if (w2.starty<0) w2.starty=0;
	w2.endy=w2.starty+w2.sizey;
	if (w2.endy>cscreen.yres) w2.endy=cscreen.yres;

	if (w2.endy-w2.starty<w2.sizey) {
		w2.starty=w2.endy-w2.sizey;
	}
	
	if (w2.starty<0) w2.starty=0;
	
	VOStovideo(w2.starty,w2.endy,w2.targety);

}


void VOSdisplay(word y) {
/* displays VOS to screen NO MATTER WHAT */
/* very optimized, so there is not a lot of window switching */

	if (cwindow==1) { /* check if we could use already loaded windows */
		if ((w1.starty<=y)&&(w1.endy>=y+YRES))
		{
			setCRTstart(w1.targety+y-w1.starty,0,ON);
		} else 
		{
			if (!((w2.starty<=y)&&(w2.endy>=y+YRES)))
				VOSreneww2(y);
			cwindow=2;
			setCRTstart(w2.targety+y-w2.starty,0,ON);			
		}
	} else
	if (cwindow==2) {
		if ((w2.starty<=y)&&(w2.endy>=y+YRES))
		{
			setCRTstart(w2.targety+y-w2.starty,0,ON);
		} else
		{
			if (!((w1.starty<=y)&&(w1.endy>=y+YRES)))
				VOSreneww1(y);
			cwindow=1;
			setCRTstart(w1.targety+y-w1.starty,0,ON);			
		}
		
	} else 
	{
		VOSreneww1(y);
		setCRTstart(w1.targety,0,ON);
	}

}

 
 