Unit CFont;

{ Version 1.0 }
{ Developed by Spellcaster }
{ This unit provides suport for a 16x16 colorfont... This unit enables to   }
{ read a font from a file (with just a four bytes header that states the    }
{ X and Y size of the font, altough that is ignored... The rest of the file }
{ is raw data of all the characters (or just some characters) from code 32  }
{ (blank space) to code 122 (the char 'z')...                               }
{ All the theory behind this unit was explained in the Graphics article of  }
{ issue 9 of 'The Mag', in the Colorfonts section...                        }
{ The only diference is that this unit uses pointers to save base memory... }

Interface

Type CChar=Array[1..16,1..16] Of Byte;
     CChars=Array[' '..''] Of CChar;

Var Font:^CChars;
    CFontX,CFontY:Integer;
    CFontSize:Word;

Procedure LoadFont(Filename:String);
Procedure PutLetter(X,Y:Integer;N:Char;Where:Word);
Procedure PutString(X,Y:integer;N:string;Where:Word);
Procedure KillFont;

Implementation

Uses Mode13h;

Procedure LoadFont(Filename:String);
Var F:File;
Begin
     CFontSize:=SizeOf(Font^);
     GetMem(Font,CFontSize);
     Assign(F,Filename);
     Reset(F,1);
     BlockRead(F,CFontX,2);
     BlockRead(F,CFontY,2);
     BlockRead(F,Font^,FileSize(f)-4);
     Close(F);
End;

Procedure PutLetter(X,Y:Integer;N:Char;Where:Word);
Var Cfx,Cfy:Byte;
Begin
     For Cfy:=1 To 16 Do
     Begin
          For Cfx:=1 To 16 Do
          Begin
               PutPixel(X+Cfx-1,Y+Cfy-1,Font^[N,Cfy,Cfx],Where);
          End;
     End;
End;

Procedure PutString(X,Y:Integer;N:String;Where:Word);
Var Index:Byte;
Begin
     For Index:=0 To Length(N)-1 Do
     Begin
          PutLetter(X+Index*16,Y,N[Index+1],Where);
     End;
End;

Procedure KillFont;
Begin
     FreeMem(Font,CFontSize);
End;

Begin
End.