Program Polygon3d;

Uses Crt,Mode13h;

Type Poly3d=Record
                  X1,Y1,Z1,
                  X2,Y2,Z2,
                  X3,Y3,Z3,
                  X4,Y4,Z4,
                  Xc,Yc,Zc:Real;
                  Color:Byte;
            End;

{ Timing variables }
Var MemClock:LongInt Absolute $40:$6C;
    Start,Finish:LongInt;
    Frames:LongInt;
    C:Char;

Var Poly:Poly3d;

Procedure Gen3dPoly(X1,Y1,Z1,X2,Y2,Z2,
                    X3,Y3,Z3,X4,Y4,Z4:Real;
                    C:Byte;Var P:Poly3d);
Begin
     P.X1:=X1; P.Y1:=Y1; P.Z1:=Z1;
     P.X2:=X2; P.Y2:=Y2; P.Z2:=Z2;
     P.X3:=X3; P.Y3:=Y3; P.Z3:=Z3;
     P.X4:=X4; P.Y4:=Y4; P.Z4:=Z4;
     P.Xc:=(X1+X2+X3+X4)/4;
     P.Yc:=(Y1+Y2+Y3+Y4)/4;
     P.Zc:=(Z1+Z2+Z3+Z4)/4;
     P.Color:=C;
End;

Procedure Conv3d(X,Y,Z:Real;Var Xt,Yt:Integer);
Begin
     Xt:=160+Trunc((X*256/Z));
     Yt:=100+Trunc((Y*256/Z));
End;

Procedure Draw3dPoly(P:Poly3d;Where:Word);
Var Tx1,Tx2,Tx3,Tx4,
    Ty1,Ty2,Ty3,Ty4:Integer;
Begin
     Conv3d(P.X1,P.Y1,P.Z1,Tx1,Ty1);
     Conv3d(P.X2,P.Y2,P.Z2,Tx2,Ty2);
     Conv3d(P.X3,P.Y3,P.Z3,Tx3,Ty3);
     Conv3d(P.X4,P.Y4,P.Z4,Tx4,Ty4);
     FPoly(Tx1,Ty1,Tx2,Ty2,Tx3,Ty3,Tx4,Ty4,P.Color,Where);
End;

Procedure Translate(Var P:Poly3d;Xt,Yt,Zt:Real);
Begin
     P.X1:=P.X1+Xt; P.Y1:=P.Y1+Yt; P.Z1:=P.Z1+Zt;
     P.X2:=P.X2+Xt; P.Y2:=P.Y2+Yt; P.Z2:=P.Z2+Zt;
     P.X3:=P.X3+Xt; P.Y3:=P.Y3+Yt; P.Z3:=P.Z3+Zt;
     P.X4:=P.X4+Xt; P.Y4:=P.Y4+Yt; P.Z4:=P.Z4+Zt;
     P.Xc:=P.Xc+Xt; P.Yc:=P.Yc+Yt; P.Zc:=P.Zc+Zt;
End;

Procedure Rotate3dPoly(Var P:Poly3d;XAng,YAng,ZAng:Integer);
Var Angle:Integer;
    Temp:Real;
Begin
     { Transform negative angles into positive ones }
     If XAng<0 Then XAng:=XAng+360;
     If YAng<0 Then YAng:=YAng+360;
     If ZAng<0 Then ZAng:=ZAng+360;
     { Make the coordinates of the points relative to the center }
     P.X1:=P.X1-P.Xc; P.Y1:=P.Y1-P.Yc; P.Z1:=P.Z1-P.Zc;
     P.X2:=P.X2-P.Xc; P.Y2:=P.Y2-P.Yc; P.Z2:=P.Z2-P.Zc;
     P.X3:=P.X3-P.Xc; P.Y3:=P.Y3-P.Yc; P.Z3:=P.Z3-P.Zc;
     P.X4:=P.X4-P.Xc; P.Y4:=P.Y4-P.Yc; P.Z4:=P.Z4-P.Zc;
     { Rotate all points of poly around Z axis }
     Angle:=ZAng;
     Temp:=P.X1;
     P.X1:=Temp*Cosines^[Angle]-P.Y1*Sines^[Angle];
     P.Y1:=P.Y1*Cosines^[Angle]+Temp*Sines^[Angle];
     Temp:=P.X2;
     P.X2:=Temp*Cosines^[Angle]-P.Y2*Sines^[Angle];
     P.Y2:=P.Y2*Cosines^[Angle]+Temp*Sines^[Angle];
     Temp:=P.X3;
     P.X3:=Temp*Cosines^[Angle]-P.Y3*Sines^[Angle];
     P.Y3:=P.Y3*Cosines^[Angle]+Temp*Sines^[Angle];
     Temp:=P.X4;
     P.X4:=Temp*Cosines^[Angle]-P.Y4*Sines^[Angle];
     P.Y4:=P.Y4*Cosines^[Angle]+Temp*Sines^[Angle];
     { Rotate all points of poly around X axis }
     Angle:=XAng;
     Temp:=P.Z1;
     P.Z1:=Temp*Cosines^[Angle]-P.Y1*Sines^[Angle];
     P.Y1:=P.Y1*Cosines^[Angle]+Temp*Sines^[Angle];
     Temp:=P.Z2;
     P.Z2:=Temp*Cosines^[Angle]-P.Y2*Sines^[Angle];
     P.Y2:=P.Y2*Cosines^[Angle]+Temp*Sines^[Angle];
     Temp:=P.Z3;
     P.Z3:=Temp*Cosines^[Angle]-P.Y3*Sines^[Angle];
     P.Y3:=P.Y3*Cosines^[Angle]+Temp*Sines^[Angle];
     Temp:=P.Z4;
     P.Z4:=Temp*Cosines^[Angle]-P.Y4*Sines^[Angle];
     P.Y4:=P.Y4*Cosines^[Angle]+Temp*Sines^[Angle];
     { Rotate all points of poly around Y axis }
     Angle:=YAng;
     Temp:=P.X1;
     P.X1:=Temp*Cosines^[Angle]-P.Z1*Sines^[Angle];
     P.Z1:=P.Z1*Cosines^[Angle]+Temp*Sines^[Angle];
     Temp:=P.X2;
     P.X2:=Temp*Cosines^[Angle]-P.Z2*Sines^[Angle];
     P.Z2:=P.Z2*Cosines^[Angle]+Temp*Sines^[Angle];
     Temp:=P.X3;
     P.X3:=Temp*Cosines^[Angle]-P.Z3*Sines^[Angle];
     P.Z3:=P.Z3*Cosines^[Angle]+Temp*Sines^[Angle];
     Temp:=P.X4;
     P.X4:=Temp*Cosines^[Angle]-P.Z4*Sines^[Angle];
     P.Z4:=P.Z4*Cosines^[Angle]+Temp*Sines^[Angle];
     { Transform the coordinates again }
     P.X1:=P.X1+P.Xc; P.Y1:=P.Y1+P.Yc; P.Z1:=P.Z1+P.Zc;
     P.X2:=P.X2+P.Xc; P.Y2:=P.Y2+P.Yc; P.Z2:=P.Z2+P.Zc;
     P.X3:=P.X3+P.Xc; P.Y3:=P.Y3+P.Yc; P.Z3:=P.Z3+P.Zc;
     P.X4:=P.X4+P.Xc; P.Y4:=P.Y4+P.Yc; P.Z4:=P.Z4+P.Zc;
End;

Begin
     InitGraph;
     InitVirt;
     InitTables;
     SetColor(1,63,63,0);
     Cls(0,Vp[1]);
     Gen3dPoly(0,-20,1500,20,0,1500,0,20,1500,-20,0,1500,1,Poly);
     Repeat
           Cls(0,Vp[1]);
           Draw3dPoly(Poly,Vp[1]);
           CopyPage(Vp[1],VGA);
           Translate(Poly,0,0,-15);
     Until (Keypressed) Or (Poly.Z1<=200);
     Frames:=0;
     Start:=MemClock;
     Repeat
           Cls(0,Vp[1]);
           Draw3dPoly(Poly,Vp[1]);
           CopyPage(Vp[1],Vga);
           Rotate3dPoly(Poly,3,2,4);
           Inc(Frames);
     Until Keypressed;
     Finish:=MemClock;
     ClearTables;
     CloseVirt;
     CloseGraph;
     WriteLn('We analised ',Frames,' frames...');
     WriteLn('It took ',((Finish-Start)/18.2):7:2,' seconds to draw them.');
     WriteLn('So, we achieved ',(Frames/((Finish-Start)/18.2)):7:2,' FPS !');
     C:=ReadKey;
End.
