;===================================================================
; TALES OF INFINITY - INTRO V1.0
;                   
; done 11'95 by Capella/Escape
;
; Using EGA-mode 640*350 pixel with 16 colors
; The logo needs the 1st 3 Bitplanes to get 8 colors [2^3 = 8]
; The scrolly is running in the 4th bitplane
;===================================================================

ideal
model large
p386n
stack 256

assume cs:tales_code

textlength      = 480
scrollerypos    = 300*80
sinuspeed       = 4

segment tales_code 

start:          mov ax,tales_data       ; the data-segment to DS
                mov ds,ax
                assume ds:tales_data

                mov ax,0a000h           ; the video-ram to ES
                mov es,ax
                assume es:0a000h

                mov ax,tales_text       ; the text-segment to FS                
                mov fs,ax
                assume fs:tales_text

                mov ax,1201h      ;disable DAC-setting
                mov bx,31h
                int 10h

                mov dx,03dah      ; reset Flip-Flop
                in al,dx          ; (needed to reset sequence-controller)

                mov cx,17         ; merge DAC with 16mode-colorlines
                mov dx,03c0h
                xor al,al
set_p:          out dx,al
                out dx,al
                inc al
                dec cx
                jnz set_p

                mov dx,03dah      ; reset Flip-Flop
                in al,dx

                mov dx,03c0h      ; reset sequence-controller
                mov al,32
                out dx,al

                mov ax,0010h      ; turn on 640*350 pixelmode with 16 colors
                int 10h           ; and 2 graphics-pages
              
                mov si,offset colorpal  ;set colorpal for 16 colors
                mov dx,03c8h
                mov cx,16*3
                xor al,al
                out dx,al
                inc dx
col_l:          mov al,[ds:si]
                out dx,al
                inc si
                dec cx
                jnz col_l
             
warte:          mov ax,0a800h     ; begin of 1st loop
                mov es,ax         ; page 1 is now on and we're copying the new
                                  ; positions of the logo and the scrolly on
                call clear_page   ; the 2nd page
                call print_logo    
                call do_scrolly
                
                mov dx,03d4h      ; switching to 2nd page
                mov ax,800ch
                out dx,ax
                
                mov dx,03dah      ; waiting for vertical-retrace, after this
wb1:            in al,dx          ; the monitor will show the 2nd page
                test al,8         ; (used for timing)
                jne wb1
wb2:            in al,dx
                test al,8
                je wb2
                
                mov ax,0a000h     ; begin of the 2nd loop
                mov es,ax         ; page 2 is on now and we're copying the new
                                  ; positions of the logo and the scrolly to
                call clear_page   ; the 1st page
                call print_logo
                call do_scrolly

                mov dx,03d4h      ; switching to the 1st page
                mov ax,000ch
                out dx,ax
                
                mov dx,03dah      ; again timing with the vertical-retrace to
wb3:            in al,dx          ; make the movement smoooooooth......
                test al,8
                jne wb3
wb4:            in al,dx
                test al,8
                je wb4

                in al,60h         ; checks for the ESC-key
                cmp al,01
                jne warte
                
                mov ax,1200h      ; enable DAC-setting
                mov bx,31h
                int 10h

                mov ax,0003h      ; activate textmode
                int 10h

                mov ah,09h             ; shows the end-text on screen
                mov dx,offset endtext
                int 21h
                
                mov ax,4c00h      ; bye, bye
                int 21h

;============================================
; THE ROUTINES
;============================================

include "shift_c.inc"   ; this routine scrolls the scrolly bit by bit
include "get_c.inc"     ; this routine reads 81 chars from text into the buffer
include "print_s.inc"   ; this routine prints 80-chars on the screen

;
; PRINT_LOGO  = shows the logo at the specified position in DI
;

print_logo:     mov si,[ds:sinuspos]            ; get value from the counter
                add si,offset sinus_table       ; add begin of table to it

                mov ax,[ds:si]                  ; read ypos for logo
                cmp ax,0ffffh                   ; compare with end-byte
                jne pl0                         ; no! then go on
                xor ax,ax                       ; else reset to begin of table
                mov [ds:sinuspos],ax
                jmp pl00

pl0:            add [ds:sinuspos],sinuspeed     ; increment sinus-counter
pl00:           mov di,ax                       ; always in 2 steps coz of WORD
                add di,12                       ; -size of sinus-datas
                push di

                mov dx,03c4h            ; copy plane 1
                mov ax,0102h
                out dx,ax
                
                mov cx,70               ; get 70 lines of the logo
                mov si,offset logo

pl2:            push cx
                push si
                push di

                mov cx,52/4             ; each line has 440 pixel (55*8)
pl1:            mov eax,[ds:si]
                mov [es:di],eax
                add si,4
                add di,4
                dec cx
                jnz pl1

                mov ax,[ds:si]
                mov [es:di],ax
                inc si
                inc di
                mov al,[ds:si]
                mov [es:di],al
                
                pop di
                pop si
                pop cx

                add si,4*55
                add di,80
                
                dec cx
                jnz pl2
                
                pop di
                push di
                
                mov dx,03c4h            ; copy plane 2
                mov ax,0202h
                out dx,ax
                
                mov cx,70
                mov si,offset logo
                add si,1*55

pl4:            push cx
                push si
                push di

                mov cx,52/4
pl3:            mov eax,[ds:si]
                mov [es:di],eax
                add si,4
                add di,4
                dec cx
                jnz pl3

                mov ax,[ds:si]
                mov [es:di],ax
                inc si
                inc di
                mov al,[ds:si]
                mov [es:di],al
                
                pop di
                pop si
                pop cx

                add si,4*55
                add di,80
                dec cx
                jnz pl4
                
                pop di

                mov dx,03c4h            ; copy plane 3
                mov ax,0402h
                out dx,ax

                mov cx,70
                mov si,offset logo
                add si,2*55

pl6:            push cx
                push si
                push di

                mov cx,52/4
pl5:            mov eax,[ds:si]
                mov [es:di],eax
                add si,4
                add di,4
                dec cx
                jnz pl5

                mov ax,[ds:si]
                mov [es:di],ax
                inc si
                inc di
                mov al,[ds:si]
                mov [es:di],al
                
                pop di
                pop si
                pop cx

                add si,4*55
                add di,80
                dec cx
                jnz pl6

                ret

;
; CLEAR_PAGE = clears the page before putting the logo on the next position
;

clear_page:     mov dx,03c4h
                mov ax,0702h
                out dx,ax

                mov cx,350*80/4
                xor di,di
                xor eax,eax
cp1:            mov [es:di],eax
                add di,4
                dec cx
                jnz cp1

                ret

;
; DO_SCROLLY = puts the scrolly on the screen at the actual page
;

do_scrolly:     mov dx,03c4h            ; turn on all 3 bitmaps used by the
                mov ax,0802h            ; logo
                out dx,ax

                mov si,offset scroll_buffer  ; scroll the scrolly-chars
                call shift_chars
                mov si,offset scroll_buffer
                call shift_chars

                mov ax,[ds:scroll_count]     ; check if we scrolled 8 pixel
                add ax,2                     ; if yes we've to increment the
                cmp ax,8                     ; text-counter by 1 (8pixel)   
                jb ds1
                
                mov si,[ds:textpos]
                inc si
                cmp si,textlength
                jb ds2
                xor si,si
ds2:            mov [ds:textpos],si

                mov di,offset scroll_buffer  ; read 81 chars into buffer
                mov cx,81                    ; for pixel-scrolling   
                call get_chars
                
                xor ax,ax
ds1:            mov [ds:scroll_count],ax

                mov si,offset scroll_buffer  ; put them on the screen
                mov di,scrollerypos
                call print_scroll

                ret

ends  tales_code

segment  tales_data  

endtext         db "TALES OF INFINITY - Groningen's No.1 Board........",13,10
                db "Call at: +31-(0)50-5734105  ; 288oo bps /24h online /running PCBoard",13,10,10
                db "Code&GFX by Capella/Escape",13,10
                db "Text by your SysoGOD Lord Beavis/Escape",13,10,10,"$"




cflag           db 0    ; needed for the bitscrolling of the chars

textpos         dw 0    ; shows the actual position of the scrolly
scroll_count    dw 0    ; counts the bit-movements
sinuspos        dw 0    ; shows the actual position of the sinus_table

scroll_buffer   db 81*16 dup (0)        ; buffer to store 81 chars from the
                                        ; scrolltext to show them on the
                                        ; screen....

include "colorpal.db"   ; the table with 16 colors for the Logo and Scrolly
include "bold.db"       ; the charset
include "tales1.db"     ; the logo

Label sinus_table WORD  ; the sinustable

                dw 000,000,000 
                dw 080,080
                dw 160
                dw 240
                dw 320
                dw 400
                
                ypos = 480
                rept 111
                dw ypos
                ypos = ypos +160
                endm

                ypos = 111*160+480
                rept 111
                dw ypos
                ypos = ypos -160
                endm

                dw 400    
                dw 320,320     
                dw 240,240,240
                dw 160,160,160   
                dw 080,080,080 
                   

                dw 0ffffh,0ffffh,0ffffh,0ffffh,0ffffh,0ffffh    ; eof-bytes

ends  tales_data

segment  tales_text  

itext           db 160 dup (32)
                db " Test-Scrolly, Test-Scrolly, hye man, this is a Test-Scrolly, can you be"   
                db "live it ???????      Yes, it's a Test-Scrolly !!!!!! Simple but who care"
                db "s ?!?!?!?!     call also our other boards listed up in the Escape.NFO-fi"
                db "le !       anything else ???? no!, well let's wrap this shit .......    "
                db 80 dup (32)
                db 80 dup (32)
                
ends  tales_text

end start






