/*
 * FILE common.h 
 * 
 * Copyright 1996, Hanns Kucer
 * 
 */

/*******************************************************************
 COMMON DEFS
********************************************************************/
#ifndef GTC_DEFS
#define GTC_DEFS
#define MAX_TOKENLEN 80          /* max lenght of a token  */
#endif

/*******************************************************************
 COMMON TYPES
********************************************************************/
#ifndef GTC_TYPES
#define GTC_TYPES

/* KEY *************************************************************/
#define HASH_SIZE 1033             /* I found this prime to be OK   */
#define ISKEYW(k) ((k)>=0 && (k)<=(NUM_KEYWORDS-1))
#define GETKEY(k) ((k)->key)
typedef struct key_struct *key_t;
struct key_struct {
   int   key;                       /* the actual inter T_KEY        */
   char  *sym;                      /* string literal                */ 
   key_t next;                      /* next in list                  */ 
   unsigned char def;               /* undefined/defined/used        */ 
};
#define T_DEFINED 1
#define T_REFERED 2

/* TOKEN ***********************************************************/
typedef struct token_struct *token;
struct token_struct{
   key_t  key;                      /* token key                      */
   int    lno;                      /* source line#                   */
   token prev;                      /* prev token in list             */
   token next;                      /* next token in list             */
   unsigned char type;              /* numerical or string            */  
};

#endif
