/*
 * FILE lang.h 
 * 
 * Copyright 1996, Hanns Kucer
 * 
 */

#ifndef LANG_TASM_386PM
#define LANG_TASM_386PM

/* 
 * These are integer constants (I call them keys) representing the 
 * various keywords and directives that I know about the GNU as-format.
 * I also define some handy macros.
 */

/* types */
enum {T_NONE,T_NUM,T_STR,T_DWORD,T_WORD,T_BYTE};

/* keyword groups */
enum {T_UDEF=-1,T_DIR,T_SPEC,T_CPU,T_REG,T_LABL};
#define ISUDEF(k) ((k)<(T_GLOBAL)) 

/* keywords (order is significant) */
enum {T_GLOBAL,T_SPACE,T_ALIGN,T_ASCII,T_DD,T_DW,T_DB};
#define ISDIR(k) ((k)>=(T_GLOBAL) && (k)<=(T_DB))

enum {T_LBRACE=(T_DB+1),T_RBRACE,T_COMMA,T_COLON,T_PLUS,T_MINUS,T_DATA,
      T_CODE,T_FILE,T_COMM,T_LCOMM,T_STAR,T_SCALE,T_APP,T_NOAPP,T_DOLLAR};
#define ISSPEC(k) ((k)>=(T_LBRACE) && (k)<=(T_DOLLAR))

enum {
   /* no operands */
   T_NOP=(T_DOLLAR+1),T_REP,T_REPE,T_REPZ,T_REPNE,T_REPNZ,T_SCASB,T_RET,T_LEAVE,T_CDQ,
   T_STI,T_CLI,T_STD,T_CLD,T_STC,T_CLC,
   
   /* 1 op */
   T_PUSH,T_POP,T_INC,T_DEC,T_DIV,T_IDIV,T_NOT,T_NEG,T_INT,T_MUL,

   T_JCXZ,T_JECXZ,T_CALL,T_LOOP,T_JMP,T_JE,T_JNE,T_JA,T_JAE,T_JNA,T_JG,T_JGE,
   T_JNG,T_JB,T_TBE,T_JNB,T_JL,T_JLE,T_JNL,T_JC,T_JNC,T_JO,T_JNO,T_JP,T_JNP,
   T_JS,T_JNS,
   
   T_SETAE,T_SETNB,T_SETBE,T_SETNA,T_SETA,T_SETNBE,T_SETE,T_SETZ,T_SETNE,
   T_SETNZ,T_SETL,T_SETNGE,T_SETGE,T_SETNL,T_SETLE,T_SETNG,T_SETG,T_SETNLE,
   T_SETS,T_SETNS,T_SETC,T_SETNC,T_SETO,T_SETNO,T_SETP,T_SETPE,T_SETNP,T_SETPO,
   
   /* 2 op */
   T_MOV,T_MOVSB,T_MOVZB,T_MOVSW,T_MOVZW,T_ADD,T_SUB,
   T_SHR,T_SAR,T_SHL,T_SAL,T_AND,T_OR,T_XOR,T_TEST,T_CMP,
   T_LEA,T_ENTER,

   /* unknown number of ops */
   T_IMUL
};
#define ISBRANCH(k) ((k)>=(T_JCXZ) && (k)<=(T_JNS))
#define ISCPU(k) ((k)>=(T_NOP) && (k)<=(T_IMUL))
#define ISCPU0(k) ((k)>=(T_NOP) && (k)<=(T_CLC))
#define ISCPU1(k) ((k)>=(T_PUSH) && (k)<=(T_SETPO))
#define ISCPU2(k) ((k)>=(T_MOV) && (k)<=(T_ENTER))
#define ISCPUX(k) ((k)>=(T_IMUL) && (k)<=(T_IMUL))

enum {
   T_AL=(T_IMUL+1),T_AH,T_BL,T_BH,T_CL,T_CH,T_DL,T_DH,
   T_AX,T_BX,T_CX,T_DX,T_SI,T_DI,T_BP,T_SP,
   T_EAX, T_EBX, T_ECX,T_EDX,T_ESI,T_EDI,T_EBP,T_ESP
};
#define ISREG(k) ((k)>=(T_AL) && (k)<=(T_ESP))
#define NUM_KEYWORDS (T_ESP+1)

#define ISLABL(tk) ((tk)->key->key>=(NUM_KEYWORDS) && (tk)->type==(T_NONE))

/* Ok, here are the symbols typically found in GNU .s-files */
char *keywords[NUM_KEYWORDS]={
   ".globl",".space",".align",".ascii",".long",".word",".byte",
   
   "(",")",",",":","+","-",".data",".text",".file",".comm",".lcomm",
   "*","","/APP","/NO_APP","$",

   "nop","rep","repe","repz","repne","repnz","scasb","ret","leave","cltd",
   "sti","cli","std","cld","stc","clc",
   
   "push","pop","inc","dec","div","idiv","not","neg","int","mul",

   "jcxz","jecxz","call","loop","jmp","je","jne","ja","jae","jna","jg","jge",
   "jng","jb","jbe","jnb","jl","jle","jnl","jc","jnc","jo","jno","jp","jnp",
   "js","jns",
   
   "setae","setnb","setbe","setna","seta","setnbe","sete","setz","setne",
   "setnz","setl","setnge","setge","setnl","setle","setng","setg","setnle",
   "sets","setns","setc","setnc","seto","setno","setp","setpe","setnp","setpo",
   
   "mov","movsb","movzb","movsw","movzw",
   "add","sub",
   "shr","sar","shl","sal",
   "and","or","xor","test","cmp",
   "lea","enter",
   
   "imul",
   
   "%al","%ah","%bl","%bh","%cl","%ch","%dl","%dh",
   "%ax","%bx","%cx","%dx","%si","%di","%bp","%sp",   
   "%eax","%ebx","%ecx","%edx","%esi","%edi","%ebp","%esp"
};

/* ... and these are the TASM equivalents (I think) */
char *tasmwords[NUM_KEYWORDS]={
   "GLOBAL","DB","ALIGN","DB","DD","DW","DB",
   
   "[","]",",",":","+","-","","",
   "\t%TITLE","STRUC","LSTRUC","","*","; BEGIN INLINE ASM:",
   "; END INLINE ASM.","OFFSET ",

   "NOP","REP","REPE","REPZ","REPNE","REPNZ","SCASB","RET","LEAVE","CDQ",
   "STI","CLI","STD","CLD","STC","CLC",
   
   "PUSH","POP","INC","DEC","DIV","IDIV","NOT","NEG","INT","MUL",
   
   "JCXZ","JECXZ","CALL","LOOP","JMP","JE","JNE","JA","JAE","JNA","JG","JGE",
   "JNG","JB","JBE","JNB","JL","JLE","JNL","JC","JNC","JO","JNO","JP","JNP",
   "JS","JNS",
   
   "SETAE","SETNB","SETBE","SETNA","SETA","SETNBE","SETE","SETZ","SETNE",
   "SETNZ","SETL","SETNGE","SETGE","SETNL","SETLE","SETNG","SETG","SETNLE",
   "SETS","SETNS","SETC","SETNC","SETO","SETNO","SETP","SETPE","SETNP","SETPO",
   
   "MOV","MOVSB","MOVZB","MOVSX","MOVZX",
   "ADD","SUB",
   "SHR","SAR","SHL","SAL",
   "AND","OR","XOR","TEST","CMP",
   "LEA","ENTER",
   
   "IMUL",
    
   "al","ah","bl","bh","cl","ch","dl","dh",
   "ax","bx","cx","dx","si","di","bp","sp",   
   "eax","ebx","ecx","edx","esi","edi","ebp","esp",
};

char separators[]={
   '"',':',',','+','-','*','$','(',')'
};
#define NUM_SEPARATORS 9

#endif /* LANG_TASM_386PM */   
