;****************************************************************************
; Filename: MEMCPY.ASM
;   Author: Peter Andersson
;  Version: 0.0
;  Created: 1995.02.12
;  Updated: -
;****************************************************************************
; Copyright Peter Andersson, 1994-1995.
; All rights reserved.
;****************************************************************************
; Function: PVOID @memcpy(PVOID dest,PVOID source,ULONG length);
;    Input: Eax, dest - pointer to destination memory
;           Edx, source - pointer to source string memory
;           Ecx, length - number of bytes to copy
;   Output: pointer to the destination memory
;  Comment: Copies memory from <source> to <dest> and returns a pointer to dest.
;           Use memmove when the memory you are about to copy might overlap.
;****************************************************************************

        Include STDDEF.INC

        Codeseg

Proc    memcpy  ,3
                Push    Ebx,Eax
                Jecxz   @@Exit02
                Jmp     @@Next01
        Align   4
@@Loop01:       Mov     Ebx,[Edx]                       ; Copy the first
                Mov     [Eax],Ebx                       ; large part
                Mov     Ebx,[Edx+4]
                Mov     [Eax+4],Ebx
                Mov     Ebx,[Edx+8]
                Mov     [Eax+8],Ebx
                Mov     Ebx,[Edx+12]
                Mov     [Eax+12],Ebx
                Add     Edx,16
                Add     Eax,16
@@Next01:       Sub     Ecx,16
                Jae     @@Loop01
                Add     Cl,16
                Jz      @@Exit02
                Sub     Cl,4
                Jb      @@Next02
                Mov     Ebx,[Edx]
                Mov     [Eax],Ebx
                Add     Edx,4
                Add     Eax,4
                Sub     Cl,4
                Jb      @@Next02
                Mov     Ebx,[Edx]
                Mov     [Eax],Ebx
                Add     Edx,4
                Add     Eax,4
                Sub     Cl,4
                Jb      @@Next02
                Mov     Ebx,[Edx]
                Mov     [Eax],Ebx
                Add     Edx,4
                Add     Eax,4
@@Next02:       Cmp     Cl,-4
                Je      @@Exit02
                Mov     Bl,[Edx]
                Cmp     Cl,-3
                Mov     [Eax],Bl
                Je      @@Exit02
                Mov     Bl,[Edx+1]
                Cmp     Cl,-2
                Mov     [Eax+1],Bl
                Je      @@Exit02
                Mov     Bl,[Edx+2]
                Mov     [Eax+2],Bl
@@Exit02:       Pop     Eax,Ebx
                Ret
Endp

        End
