unit ems;
interface
var
ems_error : byte;

Function Ems_Installed: Boolean;
Function ems_avail  : integer;
function alloc_ems(pages : integer) : integer;
function realloc_ems(handle,pages : integer) : integer;
procedure map_ems(handle, logpage,physpage : integer);
Function ems_address : word;
procedure free_ems(handle : integer);
function ems_version : integer;
procedure save_ems(handle : integer);
procedure restore_ems(handle : integer);

implementation
uses dos;
{$s-}
Type
  ST3  = string[3];

Const
  EMM_INT                    = $67;
  DOS_Int                    = $21;
  GET_PAGE_FRAME             = $41;
  GET_UNALLOCATED_PAGE_COUNT = $42;
  ALLOCATE_PAGES             = $43;
  MAP_PAGES                  = $44;
  DEALLOCATE_PAGES           = $45;
  GET_VERSION                = $46;
  STATUS_OK                  = 0;


Function Ems_Installed: Boolean;
Var
  Emm_Device_Name   : string[8];
  Int_67_Device_Name: string[8];
  Position          : integer;
  Regs              : registers;

Begin
  Int_67_Device_Name := '';
  Emm_Device_Name    := 'EMMXXXX0';
  with Regs do Begin
    AH := $35;
    AL := EMM_INT;
    Intr (DOS_Int, Regs);
    For Position := 0 to 7 do
      Int_67_Device_Name :=
        Int_67_Device_Name + Chr (mem[ES:Position + $0A]);
    Ems_Installed := True;
    If Int_67_Device_Name <> Emm_Device_Name then
      Ems_Installed := False;
  end;
end;

Function ems_avail  : integer; assembler;
asm
  mov  ah,GET_UNALLOCATED_PAGE_COUNT;
  int  EMM_INT
  mov  ax,bx
end;

function alloc_ems(pages : integer) : integer; assembler; {Returns handle}
asm
  mov  ah,ALLOCATE_PAGES;
  mov  bx,pages
  int  EMM_INT
  mov  ems_error,ah
  mov  ax,dx
end;

function realloc_ems(handle,pages : integer) : integer; assembler;
asm
  mov  ah,51h
  mov  dx,handle
  mov  bx,pages
  int  EMM_INT
  mov  ems_error,ah
  mov  ax,bx
end;

procedure map_ems(handle, logpage,physpage : integer); assembler;
asm
  mov  ah,MAP_PAGES
  mov  dx,handle
  mov  bx,logpage
  mov  al,byte ptr physpage
  Int  EMM_INT
  mov  ems_error,ah
end;

Function ems_address : word; assembler;
asm
  mov  ah,GET_PAGE_FRAME
  int  EMM_INT
  mov  ax,bx
end;

procedure free_ems(handle : integer); assembler;
asm
  mov  ah,DEALLOCATE_PAGES
  mov  dx,handle
  int  EMM_INT
  mov  ems_error,ah
end;

function ems_version : integer; assembler;
asm
  mov  ah,GET_VERSION
  int  EMM_INT
end;

procedure save_ems(handle : integer); assembler;
asm
  mov  dx,handle
  mov  ah,47h
  int  EMM_INT
  mov  ems_error,ah
end;

procedure restore_ems(handle : integer); assembler;
asm
  mov  dx,handle
  mov  ah,48h
  int  EMM_INT
  mov  ems_error,ah
end;

end.

