const
  (* Voice register mapping. *)
  SET_CONTROL           = $00;
  SET_FREQUENCY         = $01;
  SET_START_HIGH        = $02;
  SET_START_LOW         = $03;
  SET_END_HIGH          = $04;
  SET_END_LOW           = $05;
  SET_VOLUME_RATE       = $06;
  SET_VOLUME_START      = $07;
  SET_VOLUME_END        = $08;
  SET_VOLUME            = $09;
  SET_ACC_HIGH          = $0a;
  SET_ACC_LOW           = $0b;
  SET_BALANCE           = $0c;
  SET_VOLUME_CONTROL    = $0d;
  SET_VOICES            = $0e;

  GET_CONTROL           = $80;
  GET_FREQUENCY         = $81;
  GET_START_HIGH        = $82;
  GET_START_LOW         = $83;
  GET_END_HIGH          = $84;
  GET_END_LOW           = $85;
  GET_VOLUME_RATE       = $86;
  GET_VOLUME_START      = $87;
  GET_VOLUME_END        = $88;
  GET_VOLUME            = $89;
  GET_ACC_HIGH          = $8a;
  GET_ACC_LOW           = $8b;
  GET_BALANCE           = $8c;
  GET_VOLUME_CONTROL    = $8d;
  GET_VOICES            = $8e;
  GET_IRQV              = $8f;

  (* RESET control register *)
  GF1_MASTER_RESET      = $01;
  GF1_OUTPUT_ENABLE     = $02;
  GF1_MASTER_IRQ        = $04;

  DMA_CONTROL           = $41;
  SAMPLE_CONTROL        = $49;

  (* TIMER *)
  TIMER_CONTROL         = $45;
  TIMER1                = $46;
  TIMER2    = $47;

  GF1_MIX_CTRL    = $000;  (* 2X0 *)
  GF1_TIMER_CTRL  = $008;  (* 2X8 *)
  GF1_TIMER_DATA  = $009;  (* 2X9 *)
  GF1_IRQ_CTRL    = $00B;  (* 2XB *)

  (* GF1_IRQ_STATUS (PORT 3X6) *)
  MIDI_TX_IRQ           = $01;
  MIDI_RX_IRQ           = $02;
  GF1_TIMER1_IRQ        = $04;
  GF1_TIMER2_IRQ        = $08;
  WAVETABLE_IRQ         = $20;
  ENVELOPE_IRQ          = $40;
  DMA_TC_IRQ    = $80;

  _active_voice = $102;
  _command = $103;
  _data_low = $104;
  _data_high = $105;
  _dram_io = $107;

  active_voice : word =  _active_voice;
  command : word = _command;
  data_low : word = _data_low;
  data_high : word = _data_high;
  dram_io : word = _dram_io;
  gus_info : array[0..7] of byte = ($42,$45,$54,$41,$2f,$41,$44,$4e);
  gus_cnt : integer = 0;

Procedure GUSDelay;
Function  GUSPeek(Loc : Longint) : Byte;
Procedure GUSPoke(Loc : Longint; B : Byte);
Function GUSProbe(adr : word) : Boolean;
Procedure GUSFind;
Function  GUSFindMem : Longint;
Procedure GUSVoiceControl( V, B : Byte);
Procedure GUSSetFreq( V : Byte; hz : Word);
Procedure GUSSetBalance( V, Bal : Byte);
Procedure GUSSetVolume( V : Byte; Vol : Word);
Procedure GUSStopVoice( V : Byte);
Procedure GUSPlayVoice( V, Mode : word;VBegin, VStart, VEnd : Longint);
Procedure GUSPlayAll( V, Mode : word;VBegin, VStart, VEnd : Longint;
                      freq,vol : word);
procedure gussetramp(chn,vstart,vend,rate : integer);
procedure GusSetOfs(v : byte;vbegin : longint);
Procedure GUSReset;
procedure gusdeinit;
