#*      Makefile
#*
#* Include file for MIDAS Module Player for Linux
#*
#* $Id: Makefile,v 1.7 1996/08/03 13:16:59 jpaana Exp $
#*
#* Copyright 1996 Petteri Kangaslampi and Jarno Paananen
#*
#* This file is part of the MIDAS Sound System, and may only be
#* used, modified and distributed under the terms of the MIDAS
#* Sound System license, LICENSE.TXT. By continuing to use,
#* modify or distribute this file you indicate that you have
#* read the license and understand and accept it fully.
#*


# Destination directory for midp executable
DEST = /usr/local/bin


CPP = gcc
#CPPOPTS = -O2 -fomit-frame-pointer -m486 -g -fpack-struct -funsigned-char -S -Wall -bi486-linux -D__LINUX__ -D_MIT_POSIX_THREADS -DDEBUG
#CPPOPTS = -O6 -frisc -fomit-frame-pointer -mpentium -g -fpack-struct -funsigned-char -fstrength-reduce -Wall -D__LINUX__ -D_MIT_POSIX_THREADS -DDEBUG
CPPOPTS = -O6 -frisc -fomit-frame-pointer -mpentium -fpack-struct -funsigned-char -fstrength-reduce -Wall -D__LINUX__ -DDEBUG
ASM = gcc
ASMOPTS = $(CPPOPTS)
LINK = gcc -Wall -O2 -fomit-frame-pointer -mpentium -L. -o
LIB = ar
TOUCH = /usr/bin/touch

.SUFFIXES:
.SUFFIXES: .c .h .S .o

OBJS = midas.o dsm.o dsmmix.o mmem.o errors.o mutils.o postproc.o mglobals.o \
       gmplayer.o gmpcmds.o file.o rawfile.o loadmod.o loadxm.o loads3m.o \
       uss.o

all :                   midp

%.o:			%.c
		$(CPP) $(CPPOPTS) -c $< -o $@

%.o:			%.S
		$(ASM) $(ASMOPTS) -c $< -o $@

midp: 		midplx.o libmidas.a
		$(LINK) midp midplx.o -lmidas

libmidas.a:	$(OBJS)
		rm -f libmidas.a
		$(LIB) r libmidas.a $(OBJS)
		ranlib libmidas.a

convert:	dsmmix.wdisasm
		sed -e s/_// -e s/+// -e s/.bss/.lcomm/ -e s/repe/rep\;/ dsmmix.wdisasm > dsmmix.S


midplx.o :      midplx.c midas.h

midas.o : midas.c midas.h

gmplayer.o : gmplayer.c lang.h mtypes.h errors.h sdevice.h gmplayer.h \
	mmem.h

gmpcmds.o : gmpcmds.c lang.h mtypes.h errors.h sdevice.h gmplayer.h

loadmod.o : loadmod.c lang.h mtypes.h errors.h mglobals.h mmem.h file.h \
	sdevice.h gmplayer.h mutils.h

loadxm.o : loadxm.c lang.h mtypes.h errors.h mglobals.h mmem.h file.h \
	sdevice.h gmplayer.h mutils.h xm.h

loads3m.o : loads3m.c lang.h mtypes.h errors.h mglobals.h mmem.h file.h \
	sdevice.h gmplayer.h mutils.h

file.o : file.c lang.h mtypes.h errors.h mmem.h rawfile.h file.h

rawfile.o : rawfile.c lang.h mtypes.h errors.h mmem.h rawfile.h

dsm.o : dsm.c lang.h errors.h mmem.h dsm.h sdevice.h dsm.h mutils.h \
	mglobals.h

mmem.o : mmem.c lang.h errors.h mmem.h

errors.o : errors.c lang.h errors.h

mutils.o : mutils.c lang.h mutils.h

dsmmix.o : dsmmix.S

mixsd.o : mixsd.c lang.h mtypes.h errors.h mmem.h mixsd.h dma.h sdevice.h \
	dsm.h

postproc.o : postproc.S

uss.o : uss.c sdevice.h lang.h mtypes.h errors.h mmem.h sdevice.h

mglobals.o : mglobals.c mglobals.h

midas.h : lang.h mtypes.h errors.h mglobals.h mmem.h file.h sdevice.h \
	gmplayer.h dsm.h mutils.h rawfile.h


clean:
		rm -f *.o *~ midp libmidas.a

install:	midp
		install -s midp $(DEST)

tar:
		tar cf ../midp.tar *
		gzip -9 ../midp.tar

#* $Log: Makefile,v $
#* Revision 1.7  1996/08/03 13:16:59  jpaana
#* Added non-Pthread configuration
#*
#* Revision 1.6  1996/08/02 19:00:41  jpaana
#* Added libmidas.a
#*
#* Revision 1.5  1996/06/05 19:40:35  jpaana
#* Modified for pthreads
#*
#* Revision 1.4  1996/05/25 15:49:57  jpaana
#* Still fixed dependencies
#*
#* Revision 1.3  1996/05/24 20:40:12  jpaana
#* Fixed dependencies
#*
#* Revision 1.2  1996/05/24 16:19:39  jpaana
#* Fixed to actually work
#*
#* Revision 1.1  1996/05/24 14:37:07  jpaana
#* Initial revision
#*





