.386p
.model flat,syscall
.code

                include P:\nms.mac
                include p:\nms.ext


DMA_init                PROC    PUBLIC USES eax ebx ecx edx

                        cmp     DMA_addr,0
                        jne     DMA_init_done
                        call    [SYS_allocdma]
                        jc      DMA_init_fail
                        mov     DMA_addr,edx
                        mov     DMA_phys,ebx
DMA_init_done:          clc
                        ret
DMA_init_fail:          stc
                        ret
DMA_init                ENDP


; 0 - /Channel
; 1 - \
; 2 - /00 = Verify , 01 = Write
; 3 - \10 = Read , 11 = Forbidden
; 4 - Autoinit - 1 = Enabled
; 5 - Direction - 0 = Forward
; 6 - /00 = Demand transfer mode , 01 = Singled transfer mode
; 7 - \10 = Block transfer mode , 11 = Cascade

comment $
͸
 "DMA_Setup"   PROGRAM A CHANNEL ON THE 8237 DMA CONTROLLER               
             A general routine to program the DMA controler.              
                                                                          
 By Adam Seychell and slightly modified by Alexander Boczar               
                                                                          
                                                                          
 INPUT:        AL    Mode Register  ( bits 0..1 ignored )                 
               AH    channel   ( 0..7 )                                   
               EBX   Physical Base Address ( 0..0ffffffh )                
               ECX   Bytes to transfer     ( 1..10000h )                  
                                                                          
                                                                          
Destroys:  none                                                           
                                                                          
        code has been optimized and fully tested.                         
 $

DMA_setup               PROC    USES eax ebx ecx edx edi
                        xor     edx,edx
                        and     ah,7
                        mov     DMA_channel,ah
                        and     al,NOT 3
                        mov     DMA_curmode,al

                        ; -----  set channel mask register ------
                        movzx   edi,DMA_channel
                        mov     eax,edi
                        shr     edi,2
                        and     al,03h
                        or      al,04h
                        mov     dl,DMA_sngl[edi]
                        out     dx,al

                        ; ----- set mode register ------
                        and     al,03h
                        or      al,DMA_curmode
                        mov     dl,DMA_mode[edi]
                        out     dx,al

                        ; ------  clear MSB/LSB flip flop -----------
                        mov     dl,DMA_clrff[edi]
                        out     dx,al

                        ;---- set byte count register ----
                        movzx   edi,DMA_channel
                        mov     eax,ecx
                        mov     ecx,edi
                        shr     ecx,2
                        shr     eax,cl                                  ; divide count address by 2 for DMA # 2
                        dec     eax                                     ; count - 1
                        mov     dl,DMA_cntlst[edi]                         ; bits 0..7
                        out     dx,al
                        shr     eax,8
                        out     dx,al                                   ; bits 8..15

                        ;---- set channel base address ---
                        shr     ebx,cl                                  ; divide base address by 2 for DMA # 2
                        mov     al,bl                                   ; set bits 0..7
                        mov     dl,DMA_addrlst[edi]
                        out     dx,al
                        mov     al,bh                                   ; set bits 8..15
                        out     dx,al

                        shr     ebx,15                                  ; divide base address by 8000h for DMA # 2
                        xor     cl,1
                        shr     ebx,cl                                  ; divide base address by 10000h for DMA # 1
                        mov     al,bl                                   ; set bits 16..23 ( in LSB page register )
                        mov     dl,DMA_pagelst[edi]
                        out     dx,al

                        ; -----  clear channel (mask register) ------
                        mov     eax,edi
                        shr     edi,2
                        and     al,03h
                        mov     dl,DMA_sngl[edi]
                        out     dx,al
                        ret
DMA_setup               ENDP
comment $
͸
 "DMA_getpos"  GET POSITION OF A DMA CHANNEL                              
                                                                          
 By Alexander Boczar                                                      
                                                                          
                                                                          
 INPUT:        AL    channel   ( 0..7 )                                   
                                                                          
 OUTPUT:       EAX   bytes left until end of buffer                       
                                                                          
Destroys:  EAX                                                            
                                                                          
          Code sux...                                                     
 $

DMA_getpos              PROC    USES ebx ecx edx esi edi
                        clr     edx
                        and     al,7h
                        mov     DMA_channel,al
                        movzx   edi,al
                        mov     esi,edi
                        shr     edi,2

                        mov     dl,DMA_clrff[edi]
                        clr     al
                        out     dx,al

                        mov     dl,DMA_cntlst[esi]
                        cli

                        mov     ecx,8                   ;Max retries!

DMA_getpos_l1:          dec     ecx
                        js      DMA_getpos_abort

                        in      al,dx
                        mov     ah,al
                        in      al,dx
                        xchg    al,ah
                        mov     bx,ax

                        in      al,dx
                        mov     ah,al
                        in      al,dx
                        xchg    al,ah

                        sub     bx,ax
                        cmp     bx,4
                        jg      DMA_getpos_l1

                        cmp     bx,-4
                        jl      DMA_getpos_l1

                        cmp     ax,16*1024
                        jae     DMA_getpos_l1

                        sti
                        and     eax,0ffffh
                        cmp     DMA_channel,3
                        jbe     DMA_getpos_not16bit
                        shl     eax,1
DMA_getpos_not16bit:    jmp     DMA_getpos_done
DMA_getpos_abort:       clr     eax
DMA_getpos_done:        ret
DMA_getpos              ENDP

comment $
͸
 "DMA_stop"  Stops a DMA channel                                          
                                                                          
 By Alexander Boczar                                                      
                                                                          
                                                                          
 INPUT:        AL    channel   ( 0..7 )                                   
                                                                          
 OUTPUT:       none                                                       
                                                                          
Destroys:      none                                                       
                                                                          
            Optimized.... NOT!                                            
 $

DMA_stop                PROC    USES eax edx edi
                        clr     edx
                        and     al,7h
                        mov     DMA_channel,al
                        movzx   edi,al
                        shr     edi,2

                        mov     dl,DMA_sngl[edi]
                        mov     al,DMA_channel
                        and     al,3
                        or      al,4
                        out     dx,al

                        mov     dl,DMA_clrff[edi]
                        clr     al
                        out     dx,al
                        ret
DMA_stop                ENDP

.data

DMA_curmode             db      0
DMA_channel             db      0

;* 1st & 2nd DMA Controler's ports *;

DMA_stat                db      008h,0D0h        ;* read status register *;
DMA_cmd                 db      008h,0D0h        ;* write command register *;
DMA_req                 db      009h,0D2h        ;* write request register *;
DMA_sngl                db      00Ah,0D4h        ;* write single bit register *;
DMA_mode                db      00Bh,0D6h        ;* write mode register *;
DMA_clrff               db      00Ch,0D8h        ;* clear byte ptr flip;flop *;
DMA_mclr                db      00Dh,0DAh        ;* master clear register *;
DMA_clrm                db      00Eh,0DCh        ;* clear mask register *;
DMA_wrtall              db      00Fh,0DEh        ;* write all mask register *;

; * ports for 8 channels *;

DMA_pagelst             db      087h,083h,081h,082h,08Fh,08Bh,089h,08Ah ; page register
DMA_addrlst             db      000h,002h,004h,006h,0C0h,0C4h,0C8h,0CCh ; base adddress
DMA_cntlst              db      001h,003h,005h,007h,0C2h,0C6h,0CAh,0CEh ; base count

                public  DMA_phys
DMA_phys                dd      0
                public  DMA_addr
DMA_addr                dd      0

                        END
