.386p
.model flat,syscall
.code

		include p:\nms.mac
                include p:\nms.str
		include p:\nms.ext

		public	DSM_cmdlist


;Ĵ DSM test 

DSM_test		PROC	USES esi ebx
			mov	ebx,[esi]
			lea	esi,DSM_typelist
DSM_test_l1:            cmp     dwptr [esi],-1
			je	DSM_test_fail
			lodsd
			cmp	eax,ebx
			lodsd
			je	DSM_test_ok
			jmp	DSM_test_l1
DSM_test_ok:		clc
			ret
DSM_test_fail:		stc
			ret
DSM_test		ENDP

;Ĵ DSM start 

DSM_init		PROC
			pushad
			mov	nms_error,23h
			call	DSM_test
			jc	DSM_init_fail
			jmp	eax

DSM_init1:		lea	edi,DSM_voiceinfo
                        mov     ecx,32*size dsmvoc
			clr	eax
		rep	stosb
			mov	DSM_module,esi
			movzx	eax,bptr 45[esi]
			mov	DSM_chns,eax
			call	[DRV_setchns]
			movzx	ecx,bptr 46[esi]
			mov	DSM_samples,ecx
			movzx	ecx,bptr 47[esi]
			mov	DSM_songlength,ecx
			add	esi,64
			mov	DSM_panningsofs,esi
			add	esi,eax
			mov	DSM_pattlistofs,esi
			clr	eax
			clr	ebx
DSM_init1_l1:		lodsb
			cmp	al,bl
			jle	DSM_init1_1
			mov	bl,al
DSM_init1_1:		dec	ecx
			jnz	DSM_init1_l1
			inc	ebx
			mov	DSM_patterns,ebx
			mov	eax,DSM_chns
			shl	eax,3
			mul	ebx
			add	esi,eax 		;Skip TrackNames
			mov	DSM_sampleofs,esi
			mov	eax,DSM_samples
			shl	eax,5
			add	esi,eax
			mov	DSM_pattdataofs,esi
			mov	eax,DSM_patterns
			imul	eax,DSM_chns
			shl	eax,8
			add	eax,esi

			call	[DRV_clrsamples]

			lea	esi,DSM_init_sample
			mov	edi,DSM_sampleofs
                        mov     sam.number[esi],1
                        mov     sam.send[esi],eax
			mov	edx,DSM_samples
DSM_init1_l2:           mov     ebx,sam.send[esi]
                        mov     sam.sstart[esi],ebx
			movzx	ecx,wptr 23[edi]
			add	ecx,ebx
                        mov     sam.send[esi],ecx
			movzx	ecx,wptr 27[edi]
			add	ebx,ecx
                        mov     sam.lstart[esi],ebx
			movzx	ecx,wptr 27[edi]
			add	ebx,ecx
                        mov     sam.lend[esi],ebx
			clr	ebx
			cmp	bptr 22[edi],16
			jne	DSM_init_not16bit
			or	bl,cnt_16bit
DSM_init_not16bit:	cmp	ecx,2h
			jne	DSM_init_noloop
			or	bl,cnt_loop
DSM_init_noloop:        mov     sam.stype[esi],ebx
			call	[DRV_setsample]
			add	edi,32
                        inc     sam.number[esi]
			dec	edx
			jnz	DSM_init1_l2

			call	[DRV_initsamples]
			jc	DSM_init_fail

			mov	DSM_speed,6
			mov	DSM_counter,0
			mov	DSM_songpos,0
			mov	DSM_pattpos,0

			mov	esi,DSM_panningsofs
			lea	edi,DSM_voiceinfo
			mov	ecx,DSM_chns
DSM_init1_setdefs_l1:	lodsb
                        mov     dsmvoc.panning[edi],al
                        mov     dsmvoc.period[edi],1712
                        add     edi,size dsmvoc
			dec	ecx
			jnz	DSM_init1_setdefs_l1

			mov	eax,125
			call	[DRV_setbpm]
			popad
			clc
			ret
DSM_init_fail:		popad
			stc
			ret
DSM_typelist		dd	'mSD',DSM_init1
			dd	-1
DSM_init_sample         db      size sam dup(0)
DSM_init		ENDP

;Ĵ DSM exit 

DSM_exit		PROC
			ret
DSM_exit		ENDP

;Ĵ DSM play 

DSM_play		PROC
			call	[DRV_activate]
			ret
DSM_play		ENDP

;Ĵ DSM stop 

DSM_stop		PROC	USES eax
			mov	eax,DSM_chns
			dec	eax
DSM_stop_l1:		call	[DRV_setactivechn]
			call	[DRV_stopchn]
			dec	eax
			jns	DSM_stop_l1
			call	[DRV_deactivate]
			ret
DSM_stop		ENDP

;Ĵ DSM playtick 

DSM_playtick		PROC
			pushad
			call	[FMT_jmp_tick]

			inc	DSM_counter
			mov	al,DSM_counter
			cmp	DSM_speed,al
			je	DSM_playtick_new
			call	DSM_nonew
			jmp	DSM_playtick_done
DSM_playtick_new:	mov	DSM_counter,0

			mov	eax,DSM_songpos
			and	eax,07fh
			mov	ebx,DSM_pattpos
			and	ebx,03fh
			shl	eax,16
			or	eax,ebx
			mov	FMT_pos,eax

			call	[FMT_jmp_row]

			call	DSM_setupvoices
			call	DSM_playvoices

			inc	DSM_pattpos
			cmp	DSM_pattpos,64
			jne	DSM_playtick_nonewpatt
DSM_playtick_nextpatt:	mov	eax,DSM_pattbreakpos
			mov	DSM_pattbreakpos,0
			mov	DSM_pattpos,eax
			mov	DSM_posjumpflag,0
			inc	DSM_songpos
			mov	eax,DSM_songlength
			cmp	DSM_songpos,eax
			jb	DSM_playtick_nonewpatt
			mov	DSM_songpos,0
			call	[FMT_jmp_end]
DSM_playtick_nonewpatt: test	DSM_posjumpflag,1
			jnz	DSM_playtick_nextpatt
DSM_playtick_done:	popad
			ret
DSM_playtick		ENDP

;Ĵ DSM playtick nonewnotes 

DSM_nonew:		clr	eax
			lea	edi,DSM_voiceinfo
DSM_nonew_l1:		call	[DRV_setactivechn]
			push	eax
			call	DSM_checkfx
			pop	eax
                        add     edi,size dsmvoc
			inc	eax
			cmp	eax,DSM_chns
			jne	DSM_nonew_l1
			ret

;Ĵ DSM playtick setupvoices 

DSM_setupvoices:	mov	esi,DSM_pattlistofs
			add	esi,DSM_songpos
			movzx	esi,bptr [esi]
			imul	esi,DSM_chns
			shl	esi,8
			mov	eax,DSM_pattpos
			imul	eax,DSM_chns
			shl	eax,2
			add	esi,eax
			add	esi,DSM_pattdataofs
			lea	edi,DSM_voiceinfo
			clr	eax
DSM_setupvoices_l1:	call	[DRV_setactivechn]
			push	eax
			call	DSM_setupvoice
			pop	eax
			add	esi,4
                        add     edi,size dsmvoc
			inc	eax
			cmp	eax,DSM_chns
			jne	DSM_setupvoices_l1
			ret

;Ĵ DSM playtick playvoices 

DSM_playvoices: 	clr	eax
			lea	edi,DSM_voiceinfo
DSM_playvoices_l1:	call	[DRV_setactivechn]
			push	eax
                        mov     al,dsmvoc.control[edi]
			test	al,80h
			jz	DSM_playvoices_skip
			and	eax,not 80h
                        mov     dsmvoc.control[edi],al
			call	[DRV_setmode]
			call	[DRV_startchn]
DSM_playvoices_skip:	pop	eax
                        add     edi,size dsmvoc
			inc	eax
			cmp	eax,DSM_chns
			jne	DSM_playvoices_l1
			ret

;Ĵ DSM setupvoice 

DSM_setupvoice: 	mov	ebx,[esi]
                        mov     dsmvoc.line[edi],ebx

			mov	eax,ebx
			shr	eax,16
			mov	cl,al
			shr	cl,4
			cmp	cl,2h
			jne	DSM_setupvoice_notsamvolofs
			and	al,0fh
                        mov     bptr dsmvoc.command2[edi],al
			mov	al,20h
DSM_setupvoice_notsamvolofs:
                        mov     bptr dsmvoc.command[edi],al
                        mov     bptr dsmvoc.syntax[edi],ah

			test	ebx,000000ffh
			jz	DSM_setupvoice_setregs

                        mov     eax,dsmvoc.inst[edi]
                        mov     dsmvoc.oldinst[edi],eax

			and	ebx,000000ffh
                        mov     dsmvoc.inst[edi],ebx
			mov	eax,ebx
			call	[DRV_setactivesample]

                        mov     dsmvoc.sstart[edi],0

			dec	ebx
			shl	ebx,5
			add	ebx,DSM_sampleofs
			cmp	wptr 29[ebx],0002h
			je	DSM_setupvoice_noloop
                        or      dsmvoc.control[edi],cnt_loop

			movzx	eax,wptr 27[ebx]
                        mov     dsmvoc.lstart[edi],eax

			movzx	ecx,wptr 29[ebx]
			add	ecx,eax
                        mov     dsmvoc.send[edi],ecx
                        mov     dsmvoc.lend[edi],ecx

			movzx	ecx,bptr 25[ebx]
                        mov     dsmvoc.fine[edi],ecx

                        mov     eax,dsmvoc.vol[edi]
                        mov     dsmvoc.oldvol[edi],eax
			movzx	eax,bptr 26[ebx]
                        mov     dsmvoc.vol[edi],eax
			shl	eax,2
			call	[DRV_setvol]
			jmp	DSM_setupvoice_setregs

DSM_setupvoice_noloop:  and     dsmvoc.control[edi],NOT cnt_loop
                        mov     dsmvoc.lstart[edi],0
			movzx	eax,wptr 23[ebx]
                        mov     dsmvoc.send[edi],eax
                        mov     dsmvoc.lend[edi],eax

			movzx	ecx,bptr 25[ebx]
                        mov     dsmvoc.fine[edi],ecx

                        mov     eax,dsmvoc.vol[edi]
                        mov     dsmvoc.oldvol[edi],eax
			movzx	eax,bptr 26[ebx]
                        mov     dsmvoc.vol[edi],eax
			shl	eax,2
			call	[DRV_setvol]

DSM_setupvoice_setregs: test    dsmvoc.line[edi],0000ff00h
			jz	DSM_checkmorefx

                        movzx   eax,bptr dsmvoc.line[edi+1]
                        mov     ebx,dsmvoc.fine[edi]
			imul	ebx,60*4
			add	ebx,eax
			add	ebx,eax
			mov	eax,DSM_periods[ebx]
                        mov     dsmvoc.period[edi],eax

			call	[DRV_stopchn]

                        mov     eax,dsmvoc.sstart[edi]
			call	[DRV_setstart]
                        mov     eax,dsmvoc.send[edi]
			call	[DRV_setend]
                        mov     eax,dsmvoc.lstart[edi]
			call	[DRV_setlstart]
                        mov     eax,dsmvoc.lend[edi]
			call	[DRV_setlend]
                        mov     eax,dsmvoc.vol[edi]
			shl	eax,2
			call	[DRV_setvol]
                        movzx   eax,dsmvoc.panning[edi]
			call	[DRV_setpan]
                        mov     eax,dsmvoc.period[edi]
			call	DSM_per2freq
			call	[DRV_setfreq]
                        or      dsmvoc.control[edi],80h
			jmp	DSM_checkmorefx

DSM_checkfx:            test    dsmvoc.line[edi],0ffff0000h
			jz	DSM_FX_nofx
                        mov     ebx,dsmvoc.command[edi]
			jmp	DSM_FX_fxtab[ebx*4]
DSM_FX_fxtab		dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_volslide
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_efx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx
			dd	DSM_FX_nofx;DSM_FX_samvolofs
DSM_FX_nofx:		ret
DSM_FX_efx:             mov     ebx,dsmvoc.syntax[edi]
			and	ebx,0f0h
			shr	ebx,2
			jmp	DSM_FX_efxtab[ebx]
DSM_FX_efxtab		dd	DSM_FX_noefx
			dd	DSM_FX_noefx
			dd	DSM_FX_noefx
			dd	DSM_FX_noefx
			dd	DSM_FX_noefx
			dd	DSM_FX_noefx
			dd	DSM_FX_noefx
			dd	DSM_FX_noefx
			dd	DSM_FX_noefx
			dd	DSM_FX_noefx
			dd	DSM_FX_noefx
			dd	DSM_FX_noefx
			dd	DSM_FX_noefx
			dd	DSM_FX_noefx
			dd	DSM_FX_noefx
			dd	DSM_FX_noefx
DSM_FX_noefx:		ret
DSM_checkmorefx:        test    dsmvoc.line[edi],0ffff0000h
			jz	DSM_FX_nofx2
                        mov     ebx,dsmvoc.command[edi]
			jmp	DSM_FX_fx2tab[ebx*4]
DSM_FX_fx2tab		dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_dynamic
			dd	DSM_FX_setsamofs
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_setvol
			dd	DSM_FX_pattbreak
			dd	DSM_FX_efx2
			dd	DSM_FX_setspeed
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_3d
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
			dd	DSM_FX_nofx2
                        dd      DSM_FX_sam_volofs
DSM_FX_nofx2:           mov     eax,dsmvoc.period[edi]
			call	[DSM_per2freq]
			call	[DRV_setfreq]
			ret
DSM_FX_efx2:            mov     ebx,dsmvoc.syntax[edi]
			and	ebx,0f0h
			shr	ebx,2
			jmp	DSM_FX_efx2tab[ebx]
DSM_FX_efx2tab		dd	DSM_FX_noefx2
			dd	DSM_FX_noefx2
			dd	DSM_FX_noefx2
			dd	DSM_FX_noefx2
			dd	DSM_FX_noefx2
			dd	DSM_FX_noefx2
			dd	DSM_FX_noefx2
			dd	DSM_FX_noefx2
			dd	DSM_FX_noefx2
			dd	DSM_FX_noefx2
			dd	DSM_FX_noefx2
			dd	DSM_FX_noefx2
			dd	DSM_FX_noefx2
			dd	DSM_FX_noefx2
			dd	DSM_FX_noefx2
			dd	DSM_FX_noefx2
DSM_FX_noefx2:		ret



DSM_FX_dynamic:         mov     ebx,dsmvoc.syntax[edi]
			shr	ebx,4
			and	ebx,0fh
			jmp	DSM_FX_dynamictab[ebx*4]
DSM_FX_dynamictab	dd	DSM_FX_setpanning
			dd	DSM_FX_nodynfx
			dd	DSM_FX_nodynfx
			dd	DSM_FX_nodynfx
			dd	DSM_FX_nodynfx
			dd	DSM_FX_nodynfx
			dd	DSM_FX_nodynfx
			dd	DSM_FX_nodynfx
			dd	DSM_FX_nodynfx
			dd	DSM_FX_nodynfx
			dd	DSM_FX_nodynfx
			dd	DSM_FX_nodynfx
			dd	DSM_FX_nodynfx
			dd	DSM_FX_nodynfx
			dd	DSM_FX_nodynfx
			dd	DSM_FX_nodynfx
DSM_FX_nodynfx: 	ret

DSM_FX_setpanning:      mov     eax,dsmvoc.syntax[edi]
			and	eax,0fh
                        mov     dsmvoc.panning[edi],al
			call	[DRV_setpan]
			ret

DSM_FX_setsamofs:       mov     eax,dsmvoc.syntax[edi]
			shl	eax,8
			jnz	DSM_FX_setsamofs_ok
                        mov     eax,dsmvoc.samofs[edi]
DSM_FX_setsamofs_ok:    mov     dsmvoc.samofs[edi],eax
                        add     eax,dsmvoc.sstart[edi]
			call	[DRV_setstart]
			ret

DSM_FX_volslide:        mov     ebx,dsmvoc.vol[edi]
                        mov     eax,dsmvoc.command[edi]
			mov	ecx,eax
			and	eax,0fh
			sub	ebx,eax
			jnc	DSM_FX_volslide_1
			clr	ebx
DSM_FX_volslide_1:      mov     dsmvoc.vol[edi],ebx
			shr	ecx,4
			add	ebx,eax
			cmp	ebx,40h
			jbe	DSM_FX_volslide_2
			mov	ebx,40h
DSM_FX_volslide_2:      mov     dsmvoc.vol[edi],ebx
			mov	eax,ebx
			shl	eax,2
			call	[DRV_setvol]
			ret

DSM_FX_setvol:          mov     eax,dsmvoc.syntax[edi]
			cmp	al,40h
			jbe	DSM_FX_setvol_ok
			mov	eax,40h
DSM_FX_setvol_ok:       mov     dsmvoc.vol[edi],eax
			shl	eax,2
			call	[DRV_setvol]
			ret

DSM_FX_pattbreak:       mov     eax,dsmvoc.syntax[edi]
			cmp	eax,63h
			jbe	DSM_FX_pattbreak_ok
			mov	eax,63h
DSM_FX_pattbreak_ok:	mov	ebx,eax
			and	eax,0fh
			shr	ebx,8
			imul	ebx,10
			add	eax,ebx
			mov	DSM_pattbreakpos,eax
			mov	DSM_posjumpflag,1
			ret

DSM_FX_setspeed:        mov     eax,dsmvoc.syntax[edi]
			and	eax,0ffh
			jz	DSM_FX_setspeed_not
			cmp	al,01fh
			ja	DSM_FX_setbpm
			mov	DSM_counter,0
			mov	DSM_speed,al
DSM_FX_setspeed_not:	ret
DSM_FX_setbpm:		call	[DRV_setbpm]
			ret

DSM_FX_sam_volofs:      call    DSM_FX_setsamofs
                        mov     eax,dsmvoc.command2[edi]
			inc	eax
			shl	eax,2
                        mov     dsmvoc.vol[edi],eax
			shl	eax,2
			call	[DRV_setvol]
			ret

DSM_FX_3d:              mov     al,bptr dsmvoc.syntax[edi]
			mov	bl,al
			shr	bl,6
			and	al,03fh
			mov	bh,al
			shr	al,3
			shr	bh,1
			or	bl,bl
			jnz	DSM_FX_3d_000_089
			add	al,7
			mov	ah,40h
			sub	ah,bh
			jmp	DSM_FX_3d_done
DSM_FX_3d_000_089:	cmp	bl,1
			jne	DSM_FX_3d_090_179
			mov	ah,15
			sub	ah,al
			mov	al,ah
			mov	ah,20h
			sub	ah,ah
			jmp	DSM_FX_3d_done
DSM_FX_3d_090_179:	cmp	bl,2
			jne	DSM_FX_3d_180_269
			mov	ah,8
			sub	ah,al
			mov	al,ah
			mov	ah,bh
			inc	ah
			jmp	DSM_FX_3d_done
DSM_FX_3d_180_269:	mov	ah,20h
			add	ah,bh
DSM_FX_3d_done: 	clr	ebx
			mov	bl,ah
			and	al,0ffh
                        mov     dsmvoc.panning[edi],al
			call	[DRV_setpan]
			mov	eax,ebx
                        mov     dsmvoc.vol[edi],eax
			call	[DRV_setvol]
			ret

;Ĵ DSM Period -> Frequency 

DSM_per2freq:		mov	ebx,3300000;3486169;3608676;3546894
			clr	edx
			xchg	eax,ebx
			div	ebx
			ret


.data

dsmvoc                  STRUC,NONUNIQUE
line                    dd      ?
inst                    dd      ?
oldinst                 dd      ?
vol                     dd      ?
oldvol                  dd      ?
command                 dd      ?
command2                dd      ?
syntax                  dd      ?
sstart                  dd      ?
send                    dd      ?
lstart                  dd      ?
lend                    dd      ?
fine                    dd      ?
samofs                  dd      ?
panning                 db      ?
tone                    db      ?       ;1=Tone ON, 0=Tone OFF
control                 db      ?       ;Playmodee 1000B=STRING,0000B=NO ST
empty                   db      ?       ;This is empty
glissando               db      ?       ;1=Glissando ON, 0=Glissando OFF
period                  dd      ?       ;Current amigafrequency
oldperiod               dd      ?       ;Previous amigafrequency
wantedamiga             dd      ?       ;Wanted tone
amigaofs                dd      ?       ;amiga offset note
oldamigaofs             dd      ?       ;old amiga offset note
wantedamigaofs          dd      ?       ;wanted amiga offset
portadir                db      ?       ;Toneportamento direction
tonespd                 db      ?       ;Toneportamento speed
vibcmd                  db      ?       ;Vibrato command sine/ramp...
vibpos                  db      ?       ;Vibrato position
wavecontrol             db      ?       ;Vibrato/Tremolo wavecontroller
tremcmd                 db      ?       ;Tremolo command sine/ramp...
trempos                 db      ?       ;Tremolo position
supertrig               db      ?       ;Trigs noteretrig and notedelay
dsmvoc                  ENDS


DSM_speed		db	6
DSM_counter		db	0
DSM_posjumpflag 	db	0
DSM_pattbreakpos	dd	0
DSM_pattpos		dd	0
DSM_songpos		dd	0

DSM_patterns		dd	0
DSM_songlength		dd	0
DSM_samples		dd	0
DSM_chns		dd	0

DSM_module		dd	0

DSM_panningsofs 	dd	0
DSM_pattlistofs 	dd	0
DSM_sampleofs		dd	0
DSM_pattdataofs 	dd	0

DSM_periods		dd	1712,1616,1524,1440,1356,1280,1208,1140,1076,1016, 960, 906 ; Tuning 0, Normal
			dd	 856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453
			dd	 428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226
			dd	 214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113
			dd	 107, 101,  95,  90,  85,  80,	75,  71,  67,  63,  60,  56

			dd	1700,1604,1514,1430,1348,1274,1202,1134,1070,1010, 954, 900 ; Tuning 1
			dd	 850, 802, 757, 715, 674, 637, 601, 567, 535, 505, 477, 450
			dd	 425, 401, 379, 357, 337, 318, 300, 284, 268, 253, 239, 225
			dd	 213, 201, 189, 179, 169, 159, 150, 142, 134, 126, 119, 113
			dd	 106, 100,  94,  89,  84,  79,	75,  71,  67,  63,  59,  56

			dd	1688,1592,1504,1418,1340,1264,1194,1126,1064,1004, 948, 894 ; Tuning 2
			dd	 844, 796, 752, 709, 670, 632, 597, 563, 532, 502, 474, 447
			dd	 422, 398, 376, 355, 335, 316, 298, 282, 266, 251, 237, 224
			dd	 211, 199, 188, 177, 167, 158, 149, 141, 133, 125, 118, 112
			dd	 105,  99,  94,  88,  83,  79,	74,  70,  66,  62,  59,  56

			dd	1676,1582,1492,1408,1330,1256,1184,1118,1056, 996, 940, 888 ; Tuning 3
			dd	 838, 791, 746, 704, 665, 628, 592, 559, 528, 498, 470, 444
			dd	 419, 395, 373, 352, 332, 314, 296, 280, 264, 249, 235, 222
			dd	 209, 198, 187, 176, 166, 157, 148, 140, 132, 125, 118, 111
			dd	 104,  99,  93,  88,  83,  78,	74,  70,  66,  62,  59,  55

			dd	1664,1570,1482,1398,1320,1246,1176,1110,1048, 990, 934, 882 ; Tuning 4
			dd	 832, 785, 741, 699, 660, 623, 588, 555, 524, 495, 467, 441
			dd	 416, 392, 370, 350, 330, 312, 294, 278, 262, 247, 233, 220
			dd	 208, 196, 185, 175, 165, 156, 147, 139, 131, 124, 117, 110
			dd	 104,  98,  92,  87,  82,  78,	73,  69,  65,  62,  58,  55

			dd	1652,1558,1472,1388,1310,1238,1168,1102,1040, 982, 926, 874 ; Tuning 5
			dd	 826, 779, 736, 694, 655, 619, 584, 551, 520, 491, 463, 437
			dd	 413, 390, 368, 347, 328, 309, 292, 276, 260, 245, 232, 219
			dd	 206, 195, 184, 174, 164, 155, 146, 138, 130, 123, 116, 109
			dd	 103,  97,  92,  87,  82,  77,	73,  69,  65,  61,  58,  54

			dd	1640,1548,1460,1378,1302,1228,1160,1094,1032, 974, 920, 868 ; Tuning 6
			dd	 820, 774, 730, 689, 651, 614, 580, 547, 516, 487, 460, 434
			dd	 410, 387, 365, 345, 325, 307, 290, 274, 258, 244, 230, 217
			dd	 205, 193, 183, 172, 163, 154, 145, 137, 129, 122, 115, 109
			dd	 102,  96,  91,  86,  81,  77,	72,  68,  64,  61,  57,  54

			dd	1628,1536,1450,1368,1292,1220,1150,1086,1026, 968, 914, 862 ; Tuning 7
			dd	 814, 768, 725, 684, 646, 610, 575, 543, 513, 484, 457, 431
			dd	 407, 384, 363, 342, 323, 305, 288, 272, 256, 242, 228, 216
			dd	 204, 192, 181, 171, 161, 152, 144, 136, 128, 121, 114, 108
			dd	 102,  96,  90,  85,  80,  76,	72,  68,  64,  60,  57,  54

			dd	1814,1712,1616,1524,1440,1356,1280,1208,1140,1076,1016, 960 ; Tuning -8
			dd	 907, 856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480
			dd	 453, 428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240
			dd	 226, 214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120
			dd	 113, 107, 101,  95,  90,  85,	80,  75,  71,  67,  63,  60

			dd	1800,1700,1604,1514,1430,1350,1272,1202,1134,1070,1010, 954 ; Tuning -7
			dd	 900, 850, 802, 757, 715, 675, 636, 601, 567, 535, 505, 477
			dd	 450, 425, 401, 379, 357, 337, 318, 300, 284, 268, 253, 238
			dd	 225, 212, 200, 189, 179, 169, 159, 150, 142, 134, 126, 119
			dd	 112, 106, 100,  94,  89,  84,	79,  75,  71,  67,  63,  59

			dd	1788,1688,1592,1504,1418,1340,1264,1194,1126,1064,1004, 948 ; Tuning -6
			dd	 894, 844, 796, 752, 709, 670, 632, 597, 563, 532, 502, 474
			dd	 447, 422, 398, 376, 355, 335, 316, 298, 282, 266, 251, 237
			dd	 223, 211, 199, 188, 177, 167, 158, 149, 141, 133, 125, 118
			dd	 111, 105,  99,  94,  88,  83,	79,  74,  70,  66,  62,  59

			dd	1774,1676,1582,1492,1408,1330,1256,1184,1118,1056, 996, 940 ; Tuning -5
			dd	 887, 838, 791, 746, 704, 665, 628, 592, 559, 528, 498, 470
			dd	 444, 419, 395, 373, 352, 332, 314, 296, 280, 264, 249, 235
			dd	 222, 209, 198, 187, 176, 166, 157, 148, 140, 132, 125, 118
			dd	 111, 104,  99,  93,  88,  83,	78,  74,  70,  66,  62,  59

			dd	1762,1664,1570,1482,1398,1320,1246,1176,1110,1048, 988, 934 ; Tuning -4
			dd	 881, 832, 785, 741, 699, 660, 623, 588, 555, 524, 494, 467
			dd	 441, 416, 392, 370, 350, 330, 312, 294, 278, 262, 247, 233
			dd	 220, 208, 196, 185, 175, 165, 156, 147, 139, 131, 123, 117
			dd	 110, 104,  98,  92,  87,  82,	78,  73,  69,  65,  61,  58

			dd	1750,1652,1558,1472,1388,1310,1238,1168,1102,1040, 982, 926 ; Tuning -3
			dd	 875, 826, 779, 736, 694, 655, 619, 584, 551, 520, 491, 463
			dd	 437, 413, 390, 368, 347, 328, 309, 292, 276, 260, 245, 232
			dd	 219, 206, 195, 184, 174, 164, 155, 146, 138, 130, 123, 116
			dd	 109, 103,  97,  92,  87,  82,	77,  73,  69,  65,  61,  58

			dd	1736,1640,1548,1460,1378,1302,1228,1160,1094,1032, 974, 920 ; Tuning -2
			dd	 868, 820, 774, 730, 689, 651, 614, 580, 547, 516, 487, 460
			dd	 434, 410, 387, 365, 345, 325, 307, 290, 274, 258, 244, 230
			dd	 217, 205, 193, 183, 172, 163, 154, 145, 137, 129, 122, 115
			dd	 108, 102,  96,  91,  86,  81,	77,  72,  68,  64,  61,  57

			dd	1724,1628,1536,1450,1368,1292,1220,1150,1086,1026, 968, 914 ; Tuning -1
			dd	 862, 814, 768, 725, 684, 646, 610, 575, 543, 513, 484, 457
			dd	 431, 407, 384, 363, 342, 323, 305, 288, 272, 256, 242, 228
			dd	 216, 203, 192, 181, 171, 161, 152, 144, 136, 128, 121, 114
			dd	 108, 101,  96,  90,  85,  80,	76,  72,  68,  64,  60,  57


DSM_name		db	'Dynamic Studio II',eol

DSM_cmdlist		db	'DSM',0                 ;fmt_id
			dd	DSM_name		;fmt_name
			dd	DSM_test		;fmt_test
			dd	DSM_init		;fmt_init
			dd	DSM_exit		;fmt_exit
			dd	DSM_play		;fmt_play
			dd	DSM_stop		;fmt_stop
			dd	DSM_playtick		;fmt_playtick

.data?
DSM_voiceinfo           db      32*size dsmvoc dup(?)
DSM_samstarts		dd	256 dup(?)

			END

