.386p
.model flat,syscall
.code

		include p:\nms.mac
                include p:\nms.str
		include p:\nms.ext

		public	MOD_cmdlist

;Ĵ Mod test 

MOD_test		PROC	USES esi ebx
			mov	ebx,1080[esi]
			lea	esi,MOD_typelist
MOD_test_l1:            cmp     dwptr [esi],-1
			je	MOD_test_fail
			lodsd
			cmp	eax,ebx
			lodsb
			je	MOD_test_ok
			jmp	MOD_test_l1
MOD_test_ok:		clc
			ret
MOD_test_fail:		stc
			ret
MOD_test		ENDP

;Ĵ Mod init 

MOD_init		PROC
			pushad
			mov	nms_error,23h
			call	MOD_test
			jc	MOD_init_fail
			mov	MOD_module,esi
			and	eax,0ffh
			mov	MOD_chns,eax
			call	[DRV_setchns]

			mov	esi,MOD_module

			add	esi,3b8h
			mov	ecx,128
			clr	eax
			clr	ebx
MOD_init_l1:		lodsb
			cmp	al,bl
			jbe	MOD_init_1
			mov	bl,al
MOD_init_1:		dec	ecx
			jnz	MOD_init_l1
			inc	ebx
			imul	ebx,MOD_chns
			shl	ebx,8
			add	ebx,MOD_module
			add	ebx,43ch

			call	[DRV_clrsamples]

			mov	edi,MOD_module
			lea	esi,MOD_init_sample
                        mov     sam.number[esi],1
                        mov     sam.send[esi],ebx
MOD_init_l2:            mov     ebx,sam.send[esi]
                        mov     sam.sstart[esi],ebx
			movzx	ecx,wptr 42[edi]
			xchg	cl,ch
			add	ecx,ecx
			add	ecx,ebx
                        mov     sam.send[esi],ecx
			movzx	ecx,wptr 46[edi]
			xchg	cl,ch
			add	ecx,ecx
			add	ecx,ebx
                        mov     sam.lstart[esi],ecx
			movzx	ebx,wptr 48[edi]
			xchg	bl,bh
			add	ebx,ebx
			add	ecx,ebx
                        mov     sam.lend[esi],ecx
                        mov     sam.stype[esi],0
			cmp	ebx,2
                        jbe     MOD_init_noloop
                        mov     sam.stype[esi],cnt_loop
MOD_init_noloop:	call	[DRV_setsample]
			add	edi,30
                        inc     sam.number[esi]
                        cmp     sam.number[esi],32
			jne	MOD_init_l2

			call	[DRV_initsamples]
			jc	MOD_init_fail

			mov	esi,MOD_module

			mov	ebx,0807h
			mov	ecx,56
			mov	edx,1712
                        cmp     dwptr 1080[esi],'.K.M'
			je	MOD_init_amiga
                        cmp     dwptr 1080[esi],'!K!M'
			je	MOD_init_amiga
                        cmp     dwptr 1080[esi],'8TLF'
			je	MOD_init_amiga
                        cmp     dwptr 1080[esi],'4TLF'
			je	MOD_init_amiga
			jmp	MOD_init_notamiga
MOD_init_amiga: 	mov	ebx,0d02h
			mov	ecx,113
			mov	edx,856
MOD_init_notamiga:	mov	MOD_lper,ecx
			mov	MOD_hper,edx

			lea	edi,MOD_voiceinfo
			mov	edx,MOD_chns
			inc	edx
			shr	edx,1
			clr	eax
MOD_init_setdefs_l1:	mov	esi,edi
                        mov     ecx,size modvoc
		rep	stosb
                        mov     modvoc.period[esi],1712
                        mov     modvoc.pan[esi],bl
			mov	esi,edi
                        mov     ecx,size modvoc
		rep	stosb
                        mov     modvoc.period[esi],1712
                        mov     modvoc.pan[esi],bh
			xchg	bl,bh
			dec	edx
			jnz	MOD_init_setdefs_l1

;                       mov     bptr MOD_voiceinfo+size modvoc*0+modvoc.active,1
;                       mov     bptr MOD_voiceinfo+size modvoc*1+modvoc.active,1
;                       mov     bptr MOD_voiceinfo+size modvoc*2+modvoc.active,1
;                       mov     bptr MOD_voiceinfo+size modvoc*3+modvoc.active,1

                        mov     MOD_songpos,0
			mov	MOD_pattpos,0
                        mov     MOD_speed,6
			mov	MOD_counter,0
                        mov     eax,125
			call	[DRV_setbpm]
			popad
			clc
			ret
MOD_init_fail:		popad
			stc
			ret
MOD_init_sample         db      size sam dup(0)
MOD_init		ENDP

;Ĵ Mod exit 

MOD_exit		PROC
			ret
MOD_exit		ENDP

;Ĵ Mod play 

MOD_play		PROC
			call	[DRV_activate]
			ret
MOD_play		ENDP

;Ĵ Mod stop 

MOD_stop		PROC	USES eax
			mov	eax,MOD_chns
			dec	eax
MOD_stop_l1:		call	[DRV_setactivechn]
			push	eax
			clr	eax
			call	[DRV_setvol]
			call	[DRV_stopchn]
			pop	eax
			dec	eax
			jns	MOD_stop_l1
			call	[DRV_deactivate]
			ret
MOD_stop		ENDP

;Ĵ Mod playtick 

MOD_playtick		PROC
			pushad
			call	[FMT_jmp_tick]

			inc	MOD_counter
			mov	al,MOD_counter
			cmp	MOD_speed,al
			je	MOD_playtick_new
			call	MOD_nonew
			jmp	MOD_playtick_done
MOD_playtick_new:	mov	MOD_counter,0
			cmp	MOD_pattdelay2,0
			je	MOD_playtick_nodelays
			call	MOD_nonew
			jmp	MOD_dskip
MOD_playtick_nodelays:
			mov	eax,MOD_songpos
			and	eax,07fh
			mov	ebx,MOD_pattpos
			and	ebx,03fh
			shl	eax,16
			or	eax,ebx
			mov	FMT_pos,eax

			call	[FMT_jmp_row]

			call	MOD_setupvoices
			call	MOD_playvoices

MOD_dskip:		inc	MOD_pattpos
			clr	al
			or	al,MOD_pattdelay
			jz	MOD_dskc
			mov	MOD_pattdelay2,al
			mov	MOD_pattdelay,0
MOD_dskc:		cmp	MOD_pattdelay2,0
			jz	MOD_dska
			dec	MOD_pattdelay2
			jz	MOD_dska
			dec	MOD_pattpos
MOD_dska:		cmp	MOD_pattbreakflag,1
			jne	MOD_nnpysk
			mov	MOD_pattbreakflag,0
			mov	eax,MOD_pattbreakpos
			mov	MOD_pattbreakpos,0
			mov	MOD_pattpos,eax
MOD_nnpysk:		cmp	MOD_pattpos,64
			jne	MOD_playtick_nonewpatt
MOD_playtick_nextpatt:	mov	eax,MOD_pattbreakpos
			mov	MOD_pattbreakpos,0
			mov	MOD_pattpos,eax
			mov	MOD_posjumpflag,0
			inc	MOD_songpos
			mov	esi,MOD_module
			movzx	eax,bptr 950[esi]
			cmp	MOD_songpos,eax
			jb	MOD_playtick_nonewpatt
			mov	MOD_songpos,0
			call	[FMT_jmp_end]
MOD_playtick_nonewpatt: test	MOD_posjumpflag,1
			jnz	MOD_playtick_nextpatt
MOD_playtick_done:	popad
			ret
MOD_playtick		ENDP

;Ĵ Mod playtick nonewnotes 

MOD_nonew:		mov	eax,0
			lea	edi,MOD_voiceinfo
MOD_nonew_l1:           cmp     modvoc.active[edi],1
			je	MOD_nonew_skip
			call	[DRV_setactivechn]
			push	eax
			call	MOD_checkfx
			pop	eax
MOD_nonew_skip:         add     edi,size modvoc
			inc	eax
			cmp	eax,MOD_chns
			jne	MOD_nonew_l1
			ret

;Ĵ Mod playtick setupvoices 

MOD_setupvoices:	mov	esi,MOD_module
			add	esi,MOD_songpos
			movzx	esi,bptr 952[esi]
			imul	esi,MOD_chns
			shl	esi,8
			mov	eax,MOD_pattpos
			imul	eax,MOD_chns
			shl	eax,2
			add	esi,eax
			add	esi,MOD_module
			add	esi,1084
			lea	edi,MOD_voiceinfo
			clr	eax
MOD_setupvoices_l1:     cmp     modvoc.active[edi],1
			je	MOD_setupvoices_skip
			call	[DRV_setactivechn]
			push	eax
			call	MOD_setupvoice
			pop	eax
MOD_setupvoices_skip:	add	esi,4
                        add     edi,size modvoc
			inc	eax
			cmp	eax,MOD_chns
			jne	MOD_setupvoices_l1
			ret

;Ĵ Mod playtick playvoices 

MOD_playvoices: 	clr	eax
			lea	edi,MOD_voiceinfo
MOD_playvoices_l1:      cmp     modvoc.active[edi],1
			je	MOD_playvoices_skip
			call	[DRV_setactivechn]
			push	eax

                        mov     eax,modvoc.lstart[edi]
			call	[DRV_setlstart]
                        mov     eax,modvoc.lend[edi]
			call	[DRV_setlend]

                        mov     al,modvoc.control[edi]
			mov	bl,al
			and	al,not 80h
                        mov     modvoc.control[edi],al
			call	[DRV_setmode]
			test	bl,80h
			jz	MOD_playvoices_not
			call	[DRV_startchn]
MOD_playvoices_not:	pop	eax
MOD_playvoices_skip:    add     edi,size modvoc
			inc	eax
			cmp	eax,MOD_chns
			jne	MOD_playvoices_l1
			ret

;Ĵ Mod setupvoice 

MOD_setupvoice:         cmp     dwptr [esi],0
			jne	MOD_setupvoice_plvskip
                        mov     eax,modvoc.period[edi]
			call	MOD_per2freq
			call	[DRV_setfreq]

MOD_setupvoice_plvskip: mov	eax,[esi]
			mov	bh,al
			xchg	al,ah
			rol	eax,16
			xchg	al,ah
                        mov     modvoc.line[edi],eax
                        mov     modvoc.syntax[edi],al
			xchg	al,ah
			mov	bl,al
			and	al,0fh
                        mov     modvoc.command[edi],al
			and	ebx,0f0f0h
			shr	bh,4
			shr	ebx,4
			jz	MOD_setupvoice_nonotedelay

                        mov     modvoc.inst[edi],ebx
			mov	eax,ebx
			call	[DRV_setactivesample]
                        mov     modvoc.sstart[edi],0
			imul	ebx,30
			add	ebx,MOD_module

			movzx	edx,wptr 12[ebx]
			xchg	dl,dh
			add	edx,edx
			jz	MOD_setupvoice_setregs
                        mov     modvoc.send[edi],edx
			movzx	ecx,bptr 14[ebx]
                        mov     modvoc.fine[edi],ecx
			movzx	ecx,bptr 15[ebx]
                        mov     modvoc.vol[edi],ecx

			movzx	ecx,wptr 16[ebx]
			xchg	cl,ch
			add	ecx,ecx

			cmp	wptr 18[ebx],0100h
			je	MOD_setupvoice_noloop
			cmp	wptr 18[ebx],0000h
			je	MOD_setupvoice_noloop
                        or      modvoc.control[edi],cnt_loop
                        mov     modvoc.lstart[edi],ecx
			movzx	edx,wptr 18[ebx]
			xchg	dl,dh
			add	edx,edx
			add	edx,ecx
                        mov     modvoc.send[edi],edx
                        mov     modvoc.lend[edi],edx
			jmp	MOD_setupvoice_setregs
MOD_setupvoice_noloop:  and     modvoc.control[edi],NOT cnt_loop
                        mov     modvoc.lstart[edi],0
                        mov     modvoc.lend[edi],edx

MOD_setupvoice_setregs: mov     eax,modvoc.line[edi]
			and	eax,0ff0h
			cmp	eax,0ed0h
			je	MOD_setupvoice_nonotedelay
                        mov     eax,modvoc.vol[edi]
			shl	eax,2
			call	[DRV_setvol]
MOD_setupvoice_nonotedelay:
                        test    modvoc.line[edi],0fff0000h
			jz	MOD_checkmorefx
                        mov     eax,modvoc.line[edi]
			and	eax,0ff0h
			cmp	eax,0e50h
			je	MOD_dosetfinetune
			shr	eax,8
			cmp	eax,3h
			je	MOD_FX_settoneporta
			cmp	eax,5h
			je	MOD_FX_settoneporta
			cmp	eax,9h
			jne	MOD_setperiod
			call	MOD_FX_setsamofs
			jmp	MOD_setperiod
MOD_dosetfinetune:	call	MOD_FX_setfinetune
MOD_setperiod:          mov     cx,wptr modvoc.line+2[edi]
			and	ecx,0fffh
			clr	ebx
MOD_ftuloop:		cmp	ecx,MOD_periods[ebx*4]
			jae	MOD_ftufound
			inc	ebx
			cmp	ebx,60
			jne	MOD_ftuloop
MOD_ftufound:           mov     modvoc.periodnum[edi],ebx
                        mov     eax,modvoc.fine[edi]
			imul	eax,60
                        mov     modvoc.finenum[edi],eax
			add	ebx,eax
			mov	eax,MOD_periods[ebx*4]
                        mov     modvoc.period[edi],eax

                        mov     eax,modvoc.line[edi]
			and	eax,0ff0h
			cmp	eax,0ed0h
			je	MOD_checkmorefx

			call	[DRV_stopchn]

                        test    modvoc.wavectrl[edi],4h
			jz	MOD_vibnoc
                        mov     modvoc.vibpos[edi],0h
MOD_vibnoc:             test    modvoc.wavectrl[edi],40h
			jz	MOD_trenoc
                        mov     modvoc.trempos[edi],0h
MOD_trenoc:
                        mov     eax,modvoc.sstart[edi]
			call	[DRV_setstart]
                        mov     eax,modvoc.send[edi]
			call	[DRV_setend]
                        mov     eax,modvoc.lstart[edi]
			call	[DRV_setlstart]
                        mov     eax,modvoc.lend[edi]
			call	[DRV_setlend]
                        mov     al,modvoc.pan[edi]
			call	[DRV_setpan]
                        mov     eax,modvoc.vol[edi]
			shl	eax,2
			call	[DRV_setvol]
                        mov     eax,modvoc.period[edi]
			call	[MOD_per2freq]
			call	[DRV_setfreq]
                        mov     eax,modvoc.send[edi]
                        sub     eax,modvoc.sstart[edi]
			cmp	eax,2
			jl	MOD_checkmorefx
                        or      modvoc.control[edi],80h
			jmp	MOD_checkmorefx

;Ĵ Mod Check Effects 

MOD_checkfx:            test    modvoc.line[edi],00000fffh
			jz	MOD_FX_nofx
                        movzx   ebx,modvoc.command[edi]
			jmp	MOD_FX_fxtab[ebx*4]
MOD_FX_fxtab		dd	MOD_FX_arp
			dd	MOD_FX_portaup
			dd	MOD_FX_portadown
			dd	MOD_FX_toneporta
			dd	MOD_FX_vibrato
			dd	MOD_FX_tonevolslide
			dd	MOD_FX_vibvolslide
			dd	MOD_FX_pretremolo
			dd	MOD_FX_nofx
			dd	MOD_FX_nofx
			dd	MOD_FX_prevolslide
			dd	MOD_FX_nofx
			dd	MOD_FX_nofx
			dd	MOD_FX_nofx
			dd	MOD_FX_efx
			dd	MOD_FX_nofx
MOD_FX_nofx:		ret
MOD_FX_efx:             mov     bl,modvoc.syntax[edi]
			and	ebx,0f0h
			shr	ebx,2
			jmp	MOD_FX_efxtab[ebx]
MOD_FX_efxtab		dd	MOD_FX_noefx
			dd	MOD_FX_noefx
			dd	MOD_FX_noefx
			dd	MOD_FX_setglissctrl
			dd	MOD_FX_setvibctrl
			dd	MOD_FX_setfinetune
			dd	MOD_FX_noefx
			dd	MOD_FX_settremctrl
			dd	MOD_FX_noefx
			dd	MOD_FX_noefx
			dd	MOD_FX_noefx
			dd	MOD_FX_noefx
			dd	MOD_FX_notecut
			dd	MOD_FX_noefx;MOD_FX_notedelay
			dd	MOD_FX_noefx
			dd	MOD_FX_noefx
MOD_FX_noefx:		ret
MOD_checkmorefx:        test    modvoc.line[edi],00000fffh
			jz	MOD_FX_nofx2
                        mov     bl,modvoc.command[edi]
			and	ebx,0fh
			jmp	MOD_FX_fx2tab[ebx*4]
MOD_FX_fx2tab		dd	MOD_FX_nofx2
			dd	MOD_FX_nofx2
			dd	MOD_FX_nofx2
			dd	MOD_FX_nofx2
			dd	MOD_FX_nofx2
			dd	MOD_FX_nofx2
			dd	MOD_FX_nofx2
			dd	MOD_FX_nofx2
			dd	MOD_FX_setpan1
			dd	MOD_FX_nofx2
			dd	MOD_FX_nofx2
			dd	MOD_FX_posjump
			dd	MOD_FX_setvol
			dd	MOD_FX_patternbreak
			dd	MOD_FX_efx2
			dd	MOD_FX_setspeed
MOD_FX_nofx2:           mov     eax,modvoc.period[edi]
			call	[MOD_per2freq]
			call	[DRV_setfreq]
			ret
MOD_FX_efx2:            mov     bl,modvoc.syntax[edi]
			and	ebx,0f0h
			shr	ebx,2
			jmp	MOD_FX_efx2tab[ebx]
MOD_FX_efx2tab		dd	MOD_FX_noefx2
			dd	MOD_FX_fineportaup
			dd	MOD_FX_fineportadown
			dd	MOD_FX_setglissctrl
			dd	MOD_FX_setvibctrl
			dd	MOD_FX_setfinetune
			dd	MOD_FX_jumploop
			dd	MOD_FX_settremctrl
			dd	MOD_FX_setpan2
			dd	MOD_FX_noefx2
			dd	MOD_FX_finevolup
			dd	MOD_FX_finevoldown
			dd	MOD_FX_notecut
			dd	MOD_FX_notedelay
			dd	MOD_FX_pattdelay
			dd	MOD_FX_noefx2
MOD_FX_noefx2:		ret

MOD_FX_arp:		clr	edx
			movzx	eax,MOD_counter
			mov	ebx,3
			div	ebx
			mov	ebx,edx
			cmp	ebx,0
			je	MOD_FX_arp2
			cmp	ebx,2
			je	MOD_FX_arp1
                        movzx   ebx,modvoc.syntax[edi]
			shr	ebx,4
			jmp	MOD_FX_arp3
MOD_FX_arp1:            movzx   ebx,modvoc.syntax[edi]
			and	ebx,0fh
			jmp	MOD_FX_arp3
MOD_FX_arp2:            mov     eax,modvoc.period[edi]
			jmp	MOD_FX_arp4
MOD_FX_arp3:            add     ebx,modvoc.periodnum[edi]
                        add     ebx,modvoc.finenum[edi]
			mov	eax,MOD_periods[ebx*4]
MOD_FX_arp4:		call	[MOD_per2freq]
			call	[DRV_setfreq]
			ret

MOD_FX_fineportaup:	mov	MOD_portmask,0fh
MOD_FX_portaup:         movzx   eax,modvoc.syntax[edi]
			and	eax,MOD_portmask
			mov	MOD_portmask,0ffh
			neg	eax
                        add     eax,modvoc.period[edi]
			cmp	eax,MOD_lper
			jae	MOD_FX_portaupok
			mov	eax,MOD_lper
MOD_FX_portaupok:       mov     modvoc.period[edi],eax
			call	[MOD_per2freq]
			call	[DRV_setfreq]
			ret

MOD_FX_fineportadown:	mov	MOD_portmask,0fh
MOD_FX_portadown:       movzx   eax,modvoc.syntax[edi]
			and	eax,MOD_portmask
			mov	MOD_portmask,0ffh
                        add     eax,modvoc.period[edi]
			cmp	eax,MOD_hper
			jle	MOD_FX_portadownok
			mov	eax,MOD_hper
MOD_FX_portadownok:     mov     modvoc.period[edi],eax
			call	[MOD_per2freq]
			call	[DRV_setfreq]
			ret

MOD_FX_settoneporta:    movzx   ecx,wptr modvoc.line+2[edi]
			and	ecx,0fffh
                        mov     ebx,modvoc.fine[edi]
			imul	ebx,60*4
			lea	ebx,MOD_periods[ebx]
			clr	eax
MOD_FX_stp_l:		cmp	[ebx+eax*4],ecx
			jbe	MOD_FX_stp_found
			inc	eax
			cmp	eax,60
			jne	MOD_FX_stp_l
			mov	eax,59
MOD_FX_stp_found:       mov     ecx,modvoc.fine[edi]
			and	ecx,8
			jz	MOD_FX_stp_goss
			or	eax,eax
			jz	MOD_FX_stp_goss
			dec	eax
MOD_FX_stp_goss:	mov	ebx,[ebx+eax*4]
                        mov     modvoc.wantedper[edi],ebx
                        mov     eax,modvoc.period[edi]
                        mov     modvoc.tpdir[edi],0
			cmp	eax,ebx
			je	MOD_FX_stp_clear
			jl	MOD_FX_stp_done
                        mov     modvoc.tpdir[edi],1
MOD_FX_stp_done:	ret
MOD_FX_stp_clear:       mov     modvoc.wantedper[edi],0
			ret
MOD_FX_toneporta:	clr	eax
                        or      al,modvoc.syntax[edi]
			jz	MOD_FX_tp_nochange
                        mov     modvoc.tpspeed[edi],al
                        mov     modvoc.syntax[edi],0
MOD_FX_tp_nochange:     cmp     modvoc.wantedper[edi],0
			je	MOD_FX_tp_done
                        mov     al,modvoc.tpspeed[edi]
                        cmp     modvoc.tpdir[edi],0
			jne	MOD_FX_tp_up
MOD_FX_tp_down:         add     modvoc.period[edi],eax
                        mov     eax,modvoc.wantedper[edi]
                        cmp     modvoc.period[edi],eax
			jle	MOD_FX_tp_setper
                        mov     modvoc.period[edi],eax
                        mov     modvoc.wantedper[edi],0
			jmp	MOD_FX_tp_setper
MOD_FX_tp_up:           sub     modvoc.period[edi],eax
                        mov     eax,modvoc.wantedper[edi]
                        cmp     modvoc.period[edi],eax
			jge	MOD_FX_tp_setper
                        mov     modvoc.period[edi],eax
                        mov     modvoc.wantedper[edi],0
			jmp	MOD_FX_tp_setper
MOD_FX_tp_setper:       mov     eax,modvoc.period[edi]
                        test    modvoc.glissfunk[edi],0fh
			jz	MOD_FX_tp_gliss_skip
			mov	ecx,eax
                        mov     ebx,modvoc.fine[edi]
			imul	ebx,60*4
			lea	ebx,MOD_periods[ebx]
			clr	eax
MOD_FX_tp_l:		cmp	[ebx+eax*4],ecx
			jbe	MOD_FX_tp_found
			inc	eax
			cmp	eax,60
			jne	MOD_FX_tp_l
			mov	eax,59
MOD_FX_tp_found:	mov	eax,[ebx+eax*4]
MOD_FX_tp_gliss_skip:	call	MOD_per2freq
			call	[DRV_setfreq]
MOD_FX_tp_done: 	ret

MOD_FX_vibrato: 	clr	eax
                        or      al,modvoc.syntax[edi]
			jz	MOD_FX_vibrato2
                        mov     cl,modvoc.vibcmd[edi]
			and	al,0fh
			jz	MOD_FX_vib_skip
			and	ecx,0f0h
			or	ecx,eax
MOD_FX_vib_skip:        mov     al,modvoc.syntax[edi]
			and	al,0f0h
			jz	MOD_FX_vib_skip2
			and	ecx,0fh
			or	ecx,eax
MOD_FX_vib_skip2:       mov     modvoc.vibcmd[edi],cl
MOD_FX_vibrato2:        mov     al,modvoc.vibpos[edi]
			shr	al,2
			and	eax,1fh
                        mov     cl,modvoc.wavectrl[edi]
			and	ecx,03h
			jz	MOD_FX_vib_sine
			shl	al,3h
			cmp	cl,1h
			je	MOD_FX_vib_rampdown
			mov	cl,0ffh
			jmp	MOD_FX_vib_set
MOD_FX_vib_rampdown:    cmp     modvoc.vibpos[edi],0
			jae	MOD_FX_vib_rampdown2
			mov	cl,0ffh
			sub	cl,al
			jmp	MOD_FX_vib_set
MOD_FX_vib_rampdown2:	mov	cl,al
			jmp	MOD_FX_vib_set
MOD_FX_vib_sine:	mov	cl,MOD_FX_vibtab[eax]
MOD_FX_vib_set:         mov     al,modvoc.vibcmd[edi]
			and	al,0fh
			imul	ecx,eax
			shr	ecx,7
                        mov     eax,modvoc.period[edi]
                        cmp     modvoc.vibpos[edi],0
			jb	MOD_FX_vib_neg
			add	eax,ecx
			jmp	MOD_FX_vibrato3
MOD_FX_vib_neg: 	sub	eax,ecx
MOD_FX_vibrato3:	call	MOD_per2freq
			call	[DRV_setfreq]
                        mov     al,modvoc.vibcmd[edi]
			shr	al,2
			and	al,03ch
                        add     modvoc.vibpos[edi],al
			ret

MOD_FX_tonevolslide:	call	MOD_FX_tp_nochange
			jmp	MOD_FX_volslide

MOD_FX_vibvolslide:	call	MOD_FX_vibrato2
			jmp	MOD_FX_volslide


MOD_FX_pretremolo:      mov     eax,modvoc.period[edi]
			call	MOD_per2freq
			call	[DRV_setfreq]
MOD_FX_tremolo: 	clr	eax
                        or      al,modvoc.syntax[edi]
			jz	MOD_FX_tremolo2
                        mov     cl,modvoc.tremcmd[edi]
			and	al,0fh
			jz	MOD_FX_termolo_skip
			and	cl,0f0h
			or	cl,al
MOD_FX_termolo_skip:    mov     al,modvoc.syntax[edi]
			and	al,0f0h
			jz	MOD_FX_tremolo_skip2
			and	cl,0fh
			or	cl,al
MOD_FX_tremolo_skip2:   mov     modvoc.tremcmd[edi],cl
MOD_FX_tremolo2:        mov     al,modvoc.trempos[edi]
			shr	al,2
			and	eax,01fh
			clr	ecx
                        mov     cl,modvoc.wavectrl[edi]
			shr	cl,4
			and	cl,03h
			jz	MOD_FX_tremolo_sine
			shl	eax,3
			cmp	cl,01h
			je	MOD_FX_tremolo_rampdown
			mov	cl,0ffh
			jmp	MOD_FX_tremolo_set
MOD_FX_tremolo_rampdown:cmp     modvoc.trempos[edi],0
			jge	MOD_FX_tremolo_ramp2
			mov	cl,0ffh
			sub	cl,al
			jmp	MOD_FX_tremolo_set
MOD_FX_tremolo_ramp2:	mov	cl,al
			jmp	MOD_FX_tremolo_set
MOD_FX_tremolo_sine:	mov	cl,MOD_FX_vibtab[eax]
MOD_FX_tremolo_set:     mov     al,modvoc.tremcmd[edi]
			and	eax,0fh
			and	ecx,0ffh
			imul	ecx,eax
			shr	ecx,6
                        mov     eax,modvoc.vol[edi]
                        cmp     modvoc.trempos[edi],0
			jb	MOD_FX_tremolo_neg
			add	eax,ecx
			jmp	MOD_FX_tremolo3
MOD_FX_tremolo_neg:	sub	eax,ecx
MOD_FX_tremolo3:	jae	MOD_FX_tremolo_skip3
			clr	eax
MOD_FX_tremolo_skip3:	cmp	eax,40h
			jbe	MOD_FX_tremolo_ok
			mov	eax,40h
MOD_FX_tremolo_ok:	shl	eax,2
			call	[DRV_setvol]
                        mov     al,modvoc.tremcmd[edi]
			shr	al,2
			and	al,03ch
                        add     modvoc.trempos[edi],al
			ret

MOD_FX_setpan1:         mov     al,modvoc.syntax[edi]
			and	al,0f0h
			shr	al,4
			call	[DRV_setpan]
                        movzx   eax,modvoc.syntax[edi]
			call	[FMT_jmp_cmd]
			ret

MOD_FX_setsamofs:       movzx   eax,modvoc.syntax[edi]
			shl	eax,8
			jz	MOD_FX_setsamofs_useold
                        mov     modvoc.samofs[edi],eax
MOD_FX_setsamofs_useold:mov     ebx,modvoc.samofs[edi]
                        add     ebx,modvoc.sstart[edi]
                        cmp     ebx,modvoc.send[edi]
			jge	MOD_FX_setsamofs_skip
                        mov     modvoc.sstart[edi],ebx
			ret
MOD_FX_setsamofs_skip:
                        mov     eax,modvoc.sstart[edi]
                        add     eax,4                   ;Should be 2
                        mov     modvoc.send[edi],eax
			ret

MOD_FX_prevolslide:     mov     eax,modvoc.period[edi]
                        call    [MOD_per2freq]
			call	[DRV_setfreq]
MOD_FX_volslide:        mov     ebx,modvoc.vol[edi]
                        movzx   eax,modvoc.syntax[edi]
			mov	ecx,eax
			shr	ecx,4
			je	MOD_FX_volslidedown
MOD_FX_volslideup:	add	ebx,ecx
			cmp	ebx,40h
			jbe	MOD_FX_volslideok
			mov	ebx,40h
			jmp	MOD_FX_volslideok
MOD_FX_volslidedown:	and	eax,0fh
			sub	ebx,eax
			jns	MOD_FX_volslideok
			clr	ebx
MOD_FX_volslideok:      mov     modvoc.vol[edi],ebx
			mov	eax,ebx
			shl	eax,2
			call	[DRV_setvol]
			ret

MOD_FX_posjump:         movzx   eax,modvoc.syntax[edi]
			dec	eax
			mov	MOD_songpos,eax
			mov	MOD_pattbreakpos,0
			mov	MOD_posjumpflag,1
			ret

MOD_FX_setvol:          movzx   ebx,modvoc.syntax[edi]
			cmp	ebx,40h
			jbe	MOD_FX_setvol_ok
			mov	ebx,40h
MOD_FX_setvol_ok:       mov     modvoc.vol[edi],ebx
			mov	eax,ebx
			shl	eax,2
			call	[DRV_setvol]
			ret

MOD_FX_patternbreak:    movzx   eax,modvoc.syntax[edi]
			mov	ebx,eax
			and	eax,0fh
			shr	ebx,4
			imul	ebx,10
			add	ebx,eax
			mov	MOD_pattbreakpos,ebx
			mov	MOD_posjumpflag,1
			ret

MOD_FX_setglissctrl:    mov     al,modvoc.syntax[edi]
			and	al,0fh
                        and     modvoc.glissfunk[edi],0f0h
                        or      modvoc.glissfunk[edi],al
			ret

MOD_FX_setvibctrl:      mov     al,modvoc.syntax[edi]
			and	al,0fh
                        and     modvoc.wavectrl[edi],0f0h
                        or      modvoc.wavectrl[edi],al
			ret

MOD_FX_setfinetune:     mov     al,modvoc.syntax[edi]
			and	eax,0fh
                        mov     modvoc.fine[edi],eax
			imul	eax,60
                        mov     modvoc.finenum[edi],eax
			ret

MOD_FX_jumploop:        mov     al,modvoc.syntax[edi]
			and	eax,0fh
			jz	MOD_FX_setloop
                        cmp     modvoc.loopcnt[edi],0
			je	MOD_FX_jumpcnt
                        dec     modvoc.loopcnt[edi]
			jz	MOD_FX_jmploop_done
MOD_FX_jmploop:         movzx   eax,modvoc.pattpos[edi]
			mov	MOD_pattbreakpos,eax
			mov	MOD_pattbreakflag,1
MOD_FX_jmploop_done:	ret
MOD_FX_jumpcnt:         mov     modvoc.loopcnt[edi],al
			jmp	MOD_FX_jmploop
MOD_FX_setloop: 	mov	eax,MOD_pattpos
                        mov     modvoc.pattpos[edi],al
			ret

MOD_FX_settremctrl:     mov     al,modvoc.syntax[edi]
			and	al,0fh
			shl	al,4
                        and     modvoc.wavectrl[edi],0fh
                        or      modvoc.wavectrl[edi],al
			ret

MOD_FX_setpan2:         mov     al,modvoc.syntax[edi]
			and	al,0fh
			call	[DRV_setpan]
			ret

MOD_FX_retrignote:      mov     bl,modvoc.syntax[edi]
			and	ebx,0fh
			jz	MOD_FX_rtn_end
			clr	eax
			or	al,MOD_counter
			jnz	MOD_FX_rtn_skip
                        movzx   eax,wptr modvoc.line+2[edi]
			and	eax,0fffh
			jnz	MOD_FX_rtn_end
			clr	eax
			or	al,MOD_counter
MOD_FX_rtn_skip:	clr	edx
			div	ebx
			or	edx,edx
			jnz	MOD_FX_rtn_end
MOD_FX_doretrig:	;call	 [DRV_stopchn]
			call	[DRV_startchn]
MOD_FX_rtn_end: 	ret

MOD_FX_finevolup:       mov     cl,modvoc.syntax[edi]
			and	ecx,0fh
                        mov     ebx,modvoc.vol[edi]
			jmp	MOD_FX_volslideup

MOD_FX_finevoldown:     mov     al,modvoc.syntax[edi]
			and	eax,0fh
                        mov     ebx,modvoc.vol[edi]
			jmp	MOD_FX_volslidedown

MOD_FX_notecut:         mov     al,modvoc.syntax[edi]
			and	al,0fh
			cmp	al,MOD_counter
			jne	MOD_FX_notecut_skip
			clr	eax
                        mov     modvoc.vol[edi],eax
			call	[DRV_setvol]
MOD_FX_notecut_skip:	ret

MOD_FX_notedelay:       mov     al,modvoc.syntax[edi]
			and	al,0fh
			cmp	al,MOD_counter
			jne	MOD_FX_notedelay_skip
                        test    modvoc.line[edi],0ffff0000h
			jz	MOD_FX_notedelay_skip
			jmp	MOD_FX_doretrig
MOD_FX_notedelay_skip:	ret

MOD_FX_pattdelay:       mov     al,modvoc.syntax[edi]
			and	al,0fh
			cmp	MOD_pattdelay2,0
			jne	MOD_FX_pattdelay_skip
			inc	al
			mov	MOD_pattdelay,al
MOD_FX_pattdelay_skip:	ret

MOD_FX_setspeed:        mov     al,modvoc.syntax[edi]
			and	eax,0ffh
			jz	MOD_FX_setspeed_not
			cmp	al,01fh
			ja	MOD_FX_setbpm
			mov	MOD_counter,0
			mov	MOD_speed,al
MOD_FX_setspeed_not:	ret
MOD_FX_setbpm:		call	[DRV_setbpm]
			ret

;Ĵ Mod Period -> Frequency 

MOD_per2freq:		mov	ebx,3579364;3546894
			clr	edx
			xchg	eax,ebx
			div	ebx
			ret

.data

modvoc                  STRUC,NONUNIQUE
line                    dd      ?
sstart                  dd      ?
send                    dd      ?
lstart                  dd      ?
lend                    dd      ?
vol                     dd      ?
period                  dd      ?
periodnum               dd      ?
fine                    dd      ?
finenum                 dd      ?
inst                    dd      ?
command                 db      ?
syntax                  db      ?
control                 db      ?
pan                     db      ?
samofs                  dd      ?
wantedper               dd      ?
tpdir                   db      ?
tpspeed                 db      ?
glissfunk               db      ?
vibcmd                  db      ?
vibpos                  db      ?
tremcmd                 db      ?
trempos                 db      ?
wavectrl                db      ?
loopcnt                 db      ?
pattpos                 db      ?
status                  db      ?
active                  db      ?
modvoc                  ENDS

MOD_speed		db	6
MOD_counter		db	0
MOD_songpos		dd	0
MOD_pattpos		dd	0
MOD_chns		dd	0
MOD_module		dd	0
MOD_posjumpflag 	db	0
MOD_pattbreakflag	db	0
MOD_pattbreakpos	dd	0
MOD_pattdelay		db	0
MOD_pattdelay2		db	0
MOD_portmask		dd	0ffh
MOD_lper		dd	0
MOD_hper		dd	0

MOD_typelist		db	'1CHN',01,'2CHN',02,'3CHN',03,'4CHN',04,'M.K.',04
			db	'M!K!',04,'FLT4',04,'5CHN',05,'6CHN',06,'7CHN',07
			db	'8CHN',08,'OCTA',08,'FLT8',08,'9CHN',09,'10CH',10
			db	'11CH',11,'12CH',12,'13CH',13,'14CH',14,'15CH',15
			db	'16CH',16,'17CH',17,'18CH',18,'19CH',19,'20CH',20
			db	'21CH',21,'22CH',22,'23CH',23,'24CH',24,'25CH',25
			db	'26CH',26,'27CH',27,'28CH',28,'29CH',29,'30CH',30
			db	'31CH',31,'32CH',32
			dd	-1

MOD_FX_vibtab		db	  0, 24, 49, 74, 97,120,141,161
			db	180,197,212,224,235,244,250,253
			db	255,253,250,244,235,224,212,197
			db	180,161,141,120, 97, 74, 49, 24

MOD_periods		dd	1712,1616,1524,1440,1356,1280,1208,1140,1076,1016, 960, 906 ; Tuning 0, Normal
			dd	 856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453
			dd	 428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226
			dd	 214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113
			dd	 107, 101,  95,  90,  85,  80,	75,  71,  67,  63,  60,  56

			dd	1700,1604,1514,1430,1348,1274,1202,1134,1070,1010, 954, 900 ; Tuning 1
			dd	 850, 802, 757, 715, 674, 637, 601, 567, 535, 505, 477, 450
			dd	 425, 401, 379, 357, 337, 318, 300, 284, 268, 253, 239, 225
			dd	 213, 201, 189, 179, 169, 159, 150, 142, 134, 126, 119, 113
			dd	 106, 100,  94,  89,  84,  79,	75,  71,  67,  63,  59,  56

			dd	1688,1592,1504,1418,1340,1264,1194,1126,1064,1004, 948, 894 ; Tuning 2
			dd	 844, 796, 752, 709, 670, 632, 597, 563, 532, 502, 474, 447
			dd	 422, 398, 376, 355, 335, 316, 298, 282, 266, 251, 237, 224
			dd	 211, 199, 188, 177, 167, 158, 149, 141, 133, 125, 118, 112
			dd	 105,  99,  94,  88,  83,  79,	74,  70,  66,  62,  59,  56

			dd	1676,1582,1492,1408,1330,1256,1184,1118,1056, 996, 940, 888 ; Tuning 3
			dd	 838, 791, 746, 704, 665, 628, 592, 559, 528, 498, 470, 444
			dd	 419, 395, 373, 352, 332, 314, 296, 280, 264, 249, 235, 222
			dd	 209, 198, 187, 176, 166, 157, 148, 140, 132, 125, 118, 111
			dd	 104,  99,  93,  88,  83,  78,	74,  70,  66,  62,  59,  55

			dd	1664,1570,1482,1398,1320,1246,1176,1110,1048, 990, 934, 882 ; Tuning 4
			dd	 832, 785, 741, 699, 660, 623, 588, 555, 524, 495, 467, 441
			dd	 416, 392, 370, 350, 330, 312, 294, 278, 262, 247, 233, 220
			dd	 208, 196, 185, 175, 165, 156, 147, 139, 131, 124, 117, 110
			dd	 104,  98,  92,  87,  82,  78,	73,  69,  65,  62,  58,  55

			dd	1652,1558,1472,1388,1310,1238,1168,1102,1040, 982, 926, 874 ; Tuning 5
			dd	 826, 779, 736, 694, 655, 619, 584, 551, 520, 491, 463, 437
			dd	 413, 390, 368, 347, 328, 309, 292, 276, 260, 245, 232, 219
			dd	 206, 195, 184, 174, 164, 155, 146, 138, 130, 123, 116, 109
			dd	 103,  97,  92,  87,  82,  77,	73,  69,  65,  61,  58,  54

			dd	1640,1548,1460,1378,1302,1228,1160,1094,1032, 974, 920, 868 ; Tuning 6
			dd	 820, 774, 730, 689, 651, 614, 580, 547, 516, 487, 460, 434
			dd	 410, 387, 365, 345, 325, 307, 290, 274, 258, 244, 230, 217
			dd	 205, 193, 183, 172, 163, 154, 145, 137, 129, 122, 115, 109
			dd	 102,  96,  91,  86,  81,  77,	72,  68,  64,  61,  57,  54

			dd	1628,1536,1450,1368,1292,1220,1150,1086,1026, 968, 914, 862 ; Tuning 7
			dd	 814, 768, 725, 684, 646, 610, 575, 543, 513, 484, 457, 431
			dd	 407, 384, 363, 342, 323, 305, 288, 272, 256, 242, 228, 216
			dd	 204, 192, 181, 171, 161, 152, 144, 136, 128, 121, 114, 108
			dd	 102,  96,  90,  85,  80,  76,	72,  68,  64,  60,  57,  54

			dd	1814,1712,1616,1524,1440,1356,1280,1208,1140,1076,1016, 960 ; Tuning -8
			dd	 907, 856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480
			dd	 453, 428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240
			dd	 226, 214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120
			dd	 113, 107, 101,  95,  90,  85,	80,  75,  71,  67,  63,  60

			dd	1800,1700,1604,1514,1430,1350,1272,1202,1134,1070,1010, 954 ; Tuning -7
			dd	 900, 850, 802, 757, 715, 675, 636, 601, 567, 535, 505, 477
			dd	 450, 425, 401, 379, 357, 337, 318, 300, 284, 268, 253, 238
			dd	 225, 212, 200, 189, 179, 169, 159, 150, 142, 134, 126, 119
			dd	 112, 106, 100,  94,  89,  84,	79,  75,  71,  67,  63,  59

			dd	1788,1688,1592,1504,1418,1340,1264,1194,1126,1064,1004, 948 ; Tuning -6
			dd	 894, 844, 796, 752, 709, 670, 632, 597, 563, 532, 502, 474
			dd	 447, 422, 398, 376, 355, 335, 316, 298, 282, 266, 251, 237
			dd	 223, 211, 199, 188, 177, 167, 158, 149, 141, 133, 125, 118
			dd	 111, 105,  99,  94,  88,  83,	79,  74,  70,  66,  62,  59

			dd	1774,1676,1582,1492,1408,1330,1256,1184,1118,1056, 996, 940 ; Tuning -5
			dd	 887, 838, 791, 746, 704, 665, 628, 592, 559, 528, 498, 470
			dd	 444, 419, 395, 373, 352, 332, 314, 296, 280, 264, 249, 235
			dd	 222, 209, 198, 187, 176, 166, 157, 148, 140, 132, 125, 118
			dd	 111, 104,  99,  93,  88,  83,	78,  74,  70,  66,  62,  59

			dd	1762,1664,1570,1482,1398,1320,1246,1176,1110,1048, 988, 934 ; Tuning -4
			dd	 881, 832, 785, 741, 699, 660, 623, 588, 555, 524, 494, 467
			dd	 441, 416, 392, 370, 350, 330, 312, 294, 278, 262, 247, 233
			dd	 220, 208, 196, 185, 175, 165, 156, 147, 139, 131, 123, 117
			dd	 110, 104,  98,  92,  87,  82,	78,  73,  69,  65,  61,  58

			dd	1750,1652,1558,1472,1388,1310,1238,1168,1102,1040, 982, 926 ; Tuning -3
			dd	 875, 826, 779, 736, 694, 655, 619, 584, 551, 520, 491, 463
			dd	 437, 413, 390, 368, 347, 328, 309, 292, 276, 260, 245, 232
			dd	 219, 206, 195, 184, 174, 164, 155, 146, 138, 130, 123, 116
			dd	 109, 103,  97,  92,  87,  82,	77,  73,  69,  65,  61,  58

			dd	1736,1640,1548,1460,1378,1302,1228,1160,1094,1032, 974, 920 ; Tuning -2
			dd	 868, 820, 774, 730, 689, 651, 614, 580, 547, 516, 487, 460
			dd	 434, 410, 387, 365, 345, 325, 307, 290, 274, 258, 244, 230
			dd	 217, 205, 193, 183, 172, 163, 154, 145, 137, 129, 122, 115
			dd	 108, 102,  96,  91,  86,  81,	77,  72,  68,  64,  61,  57

			dd	1724,1628,1536,1450,1368,1292,1220,1150,1086,1026, 968, 914 ; Tuning -1
			dd	 862, 814, 768, 725, 684, 646, 610, 575, 543, 513, 484, 457
			dd	 431, 407, 384, 363, 342, 323, 305, 288, 272, 256, 242, 228
			dd	 216, 203, 192, 181, 171, 161, 152, 144, 136, 128, 121, 114
			dd	 108, 101,  96,  90,  85,  80,	76,  72,  68,  64,  60,  57


MOD_name		db	'Sound/noise/pro/star/fast-tracker',eol

MOD_cmdlist		db	'MOD',0                 ;fmt_id
                        dd      MOD_name                ;fmt_text
                        dd      MOD_test                ;fmt_check
			dd	MOD_init		;fmt_init
			dd	MOD_exit		;fmt_exit
			dd	MOD_play		;fmt_play
			dd	MOD_stop		;fmt_stop
			dd	MOD_playtick		;fmt_playtick

.data?
MOD_voiceinfo           db      32*size modvoc dup(?)

			END
