.386p
.model flat,syscall
.code

		include p:\nms.mac
		include p:\nms.str
		include p:\nms.ext

		public	XM_cmdlist

xm_periodmultiplier	=	2

;Ĵ XM test 

XM_test 		PROC	USES eax ecx esi edi
			clr	edi
XM_test_l0:		mov	al,XM_idstring[edi]
			or	al,al
			jz	XM_test_ok0
			cmp	al,[esi+edi]
			jne	XM_test_fail
			inc	edi
			jmp	XM_test_l0
XM_test_ok0:		clr	edi
			mov	ecx,20
XM_test_l1:		mov	al,38[esi+edi]
			or	al,al
			jz	XM_test_ok1
			mov	XM_name_oftracker[edi],al
			inc	edi
			dec	ecx
			jnz	XM_test_l1
XM_test_ok1:		mov	dwptr XM_name_oftracker[edi],eoldata
			clc
			ret
XM_test_fail:		stc
			ret
XM_test 		ENDP

;Ĵ XM init 

XM_init 		PROC
			pushad
			mov	nms_error,23h
			call	XM_test
			jc	XM_init_fail
			mov	nms_error,21h
			cmp	wptr 58[esi],0104h
			ja	XM_init_fail
			mov	nms_error,22h
			cmp	wptr 58[esi],0104h
			jb	XM_init_fail
			mov	XM_module,esi
			movzx	eax,wptr 68[esi]
			mov	XM_chns,eax
			call	[DRV_setchns]

			mov	XM_note2per,ofs XM_amiga_note2per
			mov	XM_per2freq,ofs XM_amiga_per2freq
			test	wptr 74[esi],0001b
			jz	XM_init_amiga
			mov	XM_note2per,ofs XM_linear_note2per
			mov	XM_per2freq,ofs XM_linear_per2freq
XM_init_amiga:

			mov	esi,XM_module
			movzx	ecx,wptr 70[esi]
			mov	esi,60[esi]
			add	esi,60
			add	esi,XM_module
			lea	edi,XM_pattlst
XM_init_pattloop:	mov	eax,esi
			stosd
			mov	eax,[esi]
			add	ax,7[esi]
			adc	eax,0
			add	esi,eax
			dec	ecx
			jnz	XM_init_pattloop

			mov	edi,XM_module
			movzx	ecx,wptr 72[edi]

			call	[DRV_clrsamples]

			call	XM_instinit		;ESI - Instptr , ecx Instnum

			call	[DRV_initsamples]
			jc	XM_init_fail

			mov	esi,XM_module
                        mov     XM_songpos,0
			mov	XM_pattpos,0
			mov	XM_pattofs,0
			movzx	eax,wptr 76[esi]
			or	al,al
			jnz	XM_init_speednotzero
			mov	al,6
XM_init_speednotzero:	mov	XM_speed,al
			mov	XM_counter,0
			movzx	eax,wptr 78[esi]
			or	al,al
			jnz	XM_init_bpmnotzero
			mov	al,125
XM_init_bpmnotzero:	mov	XM_bpm,al
			call	[DRV_setbpm]
			mov	XM_globalvol,64


			lea	edi,XM_voiceinfo
			mov	ecx,32*size xmvoc
			clr	eax
		rep	stosb

			mov	ebx,11111111111111111111111111111111b
;                      	mov     ebx,10000000000000000000000000000000b
			lea	edi,XM_voiceinfo
			mov	edx,32
XM_init_reset_l:	mov	xmvoc.period[edi],907
			mov	xmvoc.note[edi],'N/A'
			mov	xmvoc.basenote[edi],'N/A'
			test	ebx,80000000h
			jz	XM_init_reset_noplay
			or	xmvoc.control[edi],cnt_enabled
XM_init_reset_noplay:	rol	ebx,1
			add	edi,size xmvoc
			dec	edx
			jnz	XM_init_reset_l

			mov	eax,XM_songpos
			mov	ebx,XM_pattpos
			call	XM_getpattinfo
			mov	XM_pattofs,eax
			mov	XM_pattlen,ebx
			popad
			clc
			ret
XM_init_fail:		popad
			stc
			ret
XM_init 		ENDP

XM_instinit		PROC	USES eax ebx ecx edx esi edi ebp
			mov	ebp,esi
			lea	esi,XM_instinit_sample
			lea	edi,XM_instlst+4
			mov	sam.number[esi],16*1
XM_instinit_l1: 	push	ecx
			movzx	edx,wptr ds:[ebp+27]

			mov	[edi],ebp
			add	edi,4

			mov	ecx,ds:[ebp+29]
			mov	eax,ecx
			imul	eax,edx
			add	ebp,ds:[ebp]
			add	eax,ebp
			mov	sam.sstart[esi],eax
			mov	sam.send[esi],eax
			push	edx
XM_instinit_l2: 	dec	edx
			js	XM_instinit_lastsample

			mov	eax,sam.sstart[esi]
			mov	ebx,ds:[ebp]
			add	ebx,eax
			mov	sam.send[esi],ebx
			mov	ebx,ds:[ebp+4]
			add	ebx,eax
			mov	sam.lstart[esi],ebx
			add	ebx,ds:[ebp+8]
			mov	sam.lend[esi],ebx
			mov	sam.stype[esi],0
			test	bptr ds:[ebp+14],01h
			jz	XM_instinit_noloop
			or	sam.stype[esi],cnt_loop
XM_instinit_noloop:	test	bptr ds:[ebp+14],02h
			jz	XM_instinit_nobiloop
			or	sam.stype[esi],cnt_loop+cnt_biloop
XM_instinit_nobiloop:	test	bptr ds:[ebp+14],10h
			jz	XM_instinit_not16bit
			or	sam.stype[esi],cnt_16bit
XM_instinit_not16bit:
			mov	eax,sam.send[esi]

			call	XM_unpack
			call	[DRV_setsample]

			mov	sam.send[esi],eax
			mov	sam.sstart[esi],eax
			inc	sam.number[esi]
			add	ebp,ecx
			jmp	XM_instinit_l2
XM_instinit_lastsample: pop	edx
			add	sam.number[esi],16
			sub	sam.number[esi],edx
			mov	ebp,sam.send[esi]
			pop	ecx
			dec	ecx
			jnz	XM_instinit_l1
			ret
XM_instinit_icnt	dd	0
XM_instinit_scnt	dd	0
XM_instinit_sample	db	size sam dup(0)
XM_instinit		ENDP

;Ĵ XM exit 

XM_exit 		PROC
			ret
XM_exit 		ENDP

;Ĵ XM play 

XM_play 		PROC
			call	[DRV_activate]
			ret
XM_play 		ENDP

;Ĵ XM stop 

XM_stop 		PROC	USES eax
			mov	eax,XM_chns
			dec	eax
XM_stop_l1:		call	[DRV_setactivechn]
			call	[DRV_stopchn]
			dec	eax
			jns	XM_stop_l1
			call	[DRV_deactivate]
			ret
XM_stop 		ENDP

;Ĵ XM playtick 

XM_playtick		PROC
			pushad

			inc	XM_counter
			mov	al,XM_counter
			cmp	XM_speed,al
			je	XM_playtick_new
			call	XM_maintainvoices
			call	XM_updatevoices
			jmp	XM_playtick_done
XM_playtick_new:	mov	XM_counter,0
			mov	eax,XM_songpos
			and	eax,0ffh
			mov	ebx,XM_pattpos
			and	ebx,0ffh
			shl	eax,16
			or	eax,ebx
			mov	FMT_pos,eax

			call	[FMT_jmp_row]

			call	XM_setupvoices
			call	XM_updatevoices

			mov	eax,XM_pattpos
			cmp	eax,XM_pattlen
			jne	XM_playtick_nonewpatt
XM_playtick_nextpatt:	mov	ebx,XM_pattbreakpos
			mov	XM_pattbreakpos,0
			mov	XM_posjumpflag,0
			mov	XM_pattpos,ebx
			inc     XM_songpos
			mov	eax,XM_songpos
			call	XM_getpattinfo
			mov	XM_pattofs,eax
			mov	XM_pattlen,ebx
			mov	esi,XM_module
			movzx	eax,wptr 64[esi]
			cmp	XM_songpos,eax
			jb	XM_playtick_nonewpatt
			call	[FMT_jmp_end]
			movzx	eax,wptr 66[esi]
			mov	XM_songpos,eax
			clr	ebx
			call	XM_getpattinfo
			mov	XM_pattofs,eax
			mov	XM_pattlen,ebx
XM_playtick_nonewpatt:	test	XM_posjumpflag,1
			jnz	XM_playtick_nextpatt
XM_playtick_done:	call	[FMT_jmp_tick]
			popad
			ret
XM_playtick		ENDP

;Ĵ XM playtick setupvoices 

XM_setupvoices: 	mov	esi,XM_pattofs
			lea	edi,XM_voiceinfo
			clr	edx
XM_setupvoices_l:	push	edi
			lea	edi,XM_chnrow
			test	bptr [esi],80h
			jnz	XM_setupvoices_packed
			mov	ecx,5
		rep	movsb
			jmp	XM_setupvoices_next
XM_setupvoices_packed:	lodsb
			mov	cl,al
			and	cl,11111b
			clr	al
			test	cl,00001b
			jz	XM_setupvoices_nonote
			lodsb
			cmp	al,97
			jbe	XM_setupvoices_nonote
			clr	al
XM_setupvoices_nonote:	stosb
			clr	al
			test	cl,00010b
			jz	XM_setupvoices_noinst
			lodsb
XM_setupvoices_noinst:	stosb
			clr	al
			test	cl,00100b
			jz	XM_setupvoices_novol
			lodsb
XM_setupvoices_novol:	stosb
			clr	al
			test	cl,01000b
			jz	XM_setupvoices_noefx
			lodsb
XM_setupvoices_noefx:	stosb
			clr	al
			test	cl,10000b
			jz	XM_setupvoices_nosyn
			lodsb
XM_setupvoices_nosyn:	stosb
XM_setupvoices_next:	pop	edi
                        call    XM_setupvoice
			add     edi,size xmvoc
			inc	edx
			cmp	edx,XM_chns
			jb	XM_setupvoices_l
			mov	XM_pattofs,esi
			inc	XM_pattpos
			ret

;Ĵ XM setupvoice 

XM_setupvoice		PROC	PUBLIC USES eax ebx ecx edx esi edi

			movzx	eax,bptr XM_chnrow+2
			mov	xmvoc.volcmd[edi],eax
			movzx	eax,bptr XM_chnrow+3
			mov	xmvoc.command[edi],eax
			movzx	eax,bptr XM_chnrow+4
			mov	xmvoc.syntax[edi],eax

			movzx	eax,bptr XM_chnrow+0
			or	eax,eax
			jz	XM_setupvoice_nonote
			cmp	eax,97
			jne	XM_setupvoice_notkeyoff
			call	XM_efx_keyoff
			jmp	XM_setupvoice_nonote
XM_setupvoice_notkeyoff:dec	eax
			mov	xmvoc.note[edi],eax
			or	xmvoc.update[edi],upd_note
XM_setupvoice_nonote:

			movzx	eax,bptr XM_chnrow+1
			or	eax,eax
			jnz	XM_setupvoice_newinst
			test	xmvoc.update[edi],upd_note
			jz	XM_setupvoice_noplay
			cmp	xmvoc.command[edi],3h
			je	XM_setupvoice_noplay
			cmp	xmvoc.command[edi],5h
			je	XM_setupvoice_noplay
			mov	eax,xmvoc.inst[edi]
			jmp	XM_setupvoice_oldinst
XM_setupvoice_newinst:	cmp	xmvoc.command[edi],3h
			je	XM_setupvoice_onlyvol
			cmp	xmvoc.command[edi],5h
			je	XM_setupvoice_onlyvol
			mov	xmvoc.inst[edi],eax
			or	xmvoc.update[edi],upd_inst
			test	xmvoc.update[edi],upd_note
			jz	XM_setupvoice_oldinst
			or	xmvoc.update[edi],upd_play
XM_setupvoice_oldinst:	test	xmvoc.update[edi],upd_play
			jz	XM_setupvoice_noplay
			test	xmvoc.update[edi],upd_note
			jnz	XM_setupvoice_play
XM_setupvoice_onlyvol:	mov	eax,xmvoc.orgvol[edi]
			mov	ebx,xmvoc.orgpan[edi]
			mov	xmvoc.basevol[edi],eax
			mov	xmvoc.basepan[edi],ebx
			and	xmvoc.panenvctrl[edi],NOT 80h
			mov	xmvoc.panenvpos[edi],0
			mov	xmvoc.panenvptn[edi],0
			and	xmvoc.volenvctrl[edi],NOT 80h
			mov	xmvoc.volenvpos[edi],0
			mov	xmvoc.volenvptn[edi],0
			mov	xmvoc.fadevol[edi],65536
			jmp	XM_setupvoice_noplay
XM_setupvoice_play:	mov	esi,XM_instlst[eax*4]
			cmp	wptr 27[esi],0
			je	XM_setupvoice_noplay		;If no samples no play
;Volume envelope values
			lea	eax,129[esi]
			mov	xmvoc.volenvptr[edi],eax
			movzx	eax,bptr 225[esi]
			mov	xmvoc.volenvcnt[edi],eax
			movzx	eax,bptr 227[esi]
			mov	xmvoc.volenvsustain[edi],eax
			movzx	eax,bptr 228[esi]
			mov	xmvoc.volenvlstart[edi],eax
			movzx	eax,bptr 229[esi]
			mov	xmvoc.volenvlend[edi],eax
;Panning envelope values
			lea	eax,177[esi]
			mov	xmvoc.panenvptr[edi],eax
			movzx	eax,bptr 226[esi]
			mov	xmvoc.panenvcnt[edi],eax
			movzx	eax,bptr 230[esi]
			mov	xmvoc.panenvsustain[edi],eax
			movzx	eax,bptr 231[esi]
			mov	xmvoc.panenvlstart[edi],eax
			movzx	eax,bptr 232[esi]
			mov	xmvoc.panenvlend[edi],eax


                        mov     al,233[esi]
                        mov     ah,234[esi]
                        test    xmvoc.update[edi],upd_inst
                        jnz     XM_setupvoice_newenv
                        mov     bl,xmvoc.volenvctrl[edi]
                        mov     bh,xmvoc.panenvctrl[edi]
                        and     bl,80h
                        and     bh,80h
                        or      al,bl
                        or      ah,bh
XM_setupvoice_newenv:   mov     xmvoc.volenvctrl[edi],al
                        mov     xmvoc.panenvctrl[edi],ah


;-----------
			mov	al,235[esi]
			mov	xmvoc.vibtype[edi],al
			movzx	eax,bptr 236[esi]
			mov	xmvoc.vibsweep[edi],eax
			movzx	eax,bptr 237[esi]
			mov	xmvoc.vibdepth[edi],eax
			movzx	eax,bptr 238[esi]
			mov	xmvoc.vibrate[edi],eax
			movzx	eax,wptr 239[esi]
			mov	xmvoc.faderate[edi],eax

			mov	eax,xmvoc.note[edi]
			movzx	eax,bptr 33[esi+eax]
			mov	xmvoc.sample[edi],eax
			mov	ebx,xmvoc.inst[edi]
			shl	ebx,4
			or	eax,ebx
			mov	xmvoc.samplenum[edi],eax
			or	xmvoc.update[edi],upd_sample

			mov	eax,29[esi]
			add	esi,[esi]
			imul	eax,xmvoc.sample[edi]
			add	esi,eax
			mov	xmvoc.samptr[edi],esi
;-----------
			clr	eax
			mov	xmvoc.sstart[edi],eax
			mov	eax,0[esi]
			mov	xmvoc.send[edi],eax
			mov	eax,4[esi]
			mov	xmvoc.lstart[edi],eax
			add	eax,8[esi]
			mov	xmvoc.lend[edi],eax


			movsx	eax,bptr 12[esi]
			mov	xmvoc.orgvol[edi],eax
			movsx	ebx,bptr 15[esi]
			mov	xmvoc.orgpan[edi],ebx

			test	xmvoc.update[edi],upd_inst
			jz	XM_setupvoice_novolupd

			mov	xmvoc.panenvpos[edi],0
			mov	xmvoc.panenvptn[edi],0
			mov	xmvoc.volenvpos[edi],0
			mov	xmvoc.volenvptn[edi],0
			mov	xmvoc.fadevol[edi],65536
			mov	xmvoc.basevol[edi],eax
			mov	xmvoc.basepan[edi],ebx
XM_setupvoice_novolupd:
			movsx	eax,bptr 13[esi]
			mov	xmvoc.fine[edi],eax
			movsx	eax,bptr 16[esi]
			mov	xmvoc.basenote[edi],eax
;-----------
			and	xmvoc.control[edi],NOT cnt_fade+cnt_keyoff
			and	xmvoc.control[edi],NOT cnt_loop+cnt_biloop+cnt_16bit
			or	xmvoc.control[edi],cnt_start
			or	xmvoc.update[edi],upd_start+upd_end+upd_lstart+upd_lend

			mov	al,14[esi]
			test	al,1h
			jz	XM_setupvoice_noloop
			or	xmvoc.control[edi],cnt_loop
XM_setupvoice_noloop:	test	al,2h
			jz	XM_setupvoice_nobiloop
			or	xmvoc.control[edi],cnt_loop+cnt_biloop
XM_setupvoice_nobiloop: test	al,10h
			jz	XM_setupvoice_not16bit
			or	xmvoc.control[edi],cnt_16bit
XM_setupvoice_not16bit:
                        mov     eax,xmvoc.send[edi]
                        sub     eax,xmvoc.sstart[edi]
                        cmp     eax,2
                        jg      XM_setupvoice_ok1
                        and     xmvoc.control[edi],NOT cnt_start
XM_setupvoice_ok1:      mov     eax,xmvoc.lend[edi]
                        sub     eax,xmvoc.lstart[edi]
                        cmp     eax,2
                        jg      XM_setupvoice_ok2
                        and     xmvoc.control[edi],NOT cnt_loop+cnt_biloop
XM_setupvoice_ok2:      test    xmvoc.control[edi],cnt_loop
			jz	XM_setupvoice_loopok
                        mov     eax,xmvoc.lend[edi]
			cmp	xmvoc.send[edi],eax
			jb	XM_setupvoice_loopok
			mov	xmvoc.send[edi],eax
XM_setupvoice_loopok:	mov	eax,xmvoc.volenvlend[edi]
			sub	eax,xmvoc.volenvlstart[edi]
			cmp	eax,1
			jge	XM_setupvoice_volenvok
			and	xmvoc.volenvctrl[edi],NOT 4h
XM_setupvoice_volenvok: mov	eax,xmvoc.panenvlend[edi]
			sub	eax,xmvoc.panenvlstart[edi]
			cmp	eax,1
			jge	XM_setupvoice_panenvok
			and	xmvoc.panenvctrl[edi],NOT 4h
XM_setupvoice_panenvok:


			call	XM_calcperiod
			jc	XM_setupvoice_noplay
			mov	xmvoc.period[edi],eax
			or	xmvoc.update[edi],upd_period
XM_setupvoice_noplay:
			movzx	eax,bptr XM_chnrow+2
			cmp	al,10h
			jb	XM_setupvoice_notvol
			cmp	al,50h
			ja	XM_setupvoice_notvol
			sub	eax,10h
			mov	xmvoc.basevol[edi],eax
XM_setupvoice_notvol:
			call	XM_checkefx
			call	XM_calcenvvol
			call	XM_calcfinalvol
			call	XM_calcenvpan
			call	XM_calcfinalpan
			test	xmvoc.control[edi],cnt_fade
			jz	XM_setupvoice_done
			mov	ebx,xmvoc.faderate[edi]
			sub	xmvoc.fadevol[edi],ebx
			jns	XM_setupvoice_done
			mov	xmvoc.fadevol[edi],0
XM_setupvoice_done:	ret
XM_setupvoice		ENDP

;Ĵ XM updatevoices 

XM_updatevoices 	PROC	USES edx edi
			lea	edi,XM_voiceinfo
			clr	eax
XM_updatevoices_l:
			call	[DRV_setactivechn]
			call	XM_updatevoice
			add	edi,size xmvoc
			inc	eax
			cmp	eax,XM_chns
			jb	XM_updatevoices_l
			ret
XM_updatevoices 	ENDP

;Ĵ XM updatevoice 

XM_updatevoice		PROC	USES eax ecx
			and	xmvoc.update[edi],NOT upd_note+upd_inst

			clr	ecx
			test	xmvoc.control[edi],cnt_16bit
			jz	XM_updatevoice_8bit
			inc	ecx
XM_updatevoice_8bit:

                        test    xmvoc.control[edi],cnt_enabled
			jz	XM_updatevoice_notplay

			test	xmvoc.control[edi],cnt_start
			jz	XM_updatevoice_dontstop
			call	[DRV_stopchn]
XM_updatevoice_dontstop:

			test	xmvoc.update[edi],upd_sample
			jz	XM_updatevoice_notsample
			and	xmvoc.update[edi],not upd_sample
			mov	eax,xmvoc.samplenum[edi]
			call	[DRV_setactivesample]
XM_updatevoice_notsample:
			test	xmvoc.update[edi],upd_start
			jz	XM_updatevoice_notstart
			and	xmvoc.update[edi],not upd_start
			mov	eax,xmvoc.sstart[edi]
			shr	eax,cl
			call	[DRV_setstart]
XM_updatevoice_notstart:
			test	xmvoc.update[edi],upd_end
			jz	XM_updatevoice_notend
			and	xmvoc.update[edi],not upd_end
			mov	eax,xmvoc.send[edi]
			shr	eax,cl
			call	[DRV_setend]
XM_updatevoice_notend:
			test	xmvoc.update[edi],upd_lstart
			jz	XM_updatevoice_notlstart
			and	xmvoc.update[edi],not upd_lstart
			mov	eax,xmvoc.lstart[edi]
			shr	eax,cl
			call	[DRV_setlstart]
XM_updatevoice_notlstart:
			test	xmvoc.update[edi],upd_lend
			jz	XM_updatevoice_notlend
			and	xmvoc.update[edi],not upd_lend
			mov	eax,xmvoc.lend[edi]
			shr	eax,cl
			call	[DRV_setlend]
XM_updatevoice_notlend:
			test	xmvoc.update[edi],upd_vol
			jz	XM_updatevoice_notvol
			and	xmvoc.update[edi],not upd_vol
			mov	eax,xmvoc.vol[edi]
			call	[DRV_setvol]
XM_updatevoice_notvol:
			test	xmvoc.update[edi],upd_trmvol
			jz	XM_updatevoice_nottrmvol
			and	xmvoc.update[edi],not upd_trmvol
			mov	eax,xmvoc.trm_vol[edi]
			call	[DRV_setvol]
XM_updatevoice_nottrmvol:
			test	xmvoc.update[edi],upd_pan
			jz	XM_updatevoice_notpan
			and	xmvoc.update[edi],not upd_pan
			mov	eax,xmvoc.pan[edi]
			call	[DRV_setpan]
XM_updatevoice_notpan:
			test	xmvoc.update[edi],upd_period
			jz	XM_updatevoice_notperiod
			and	xmvoc.update[edi],not upd_period
			mov	eax,xmvoc.period[edi]
			call	[XM_per2freq]
			call	[DRV_setfreq]
XM_updatevoice_notperiod:
			test	xmvoc.update[edi],upd_vibper
			jz	XM_updatevoice_notvibper
			and	xmvoc.update[edi],not upd_vibper
			mov	eax,xmvoc.vib_per[edi]
			call	[XM_per2freq]
			call	[DRV_setfreq]
XM_updatevoice_notvibper:
			test	xmvoc.control[edi],cnt_start
			jz	XM_updatevoice_notplay
			and	xmvoc.control[edi],NOT cnt_start
			mov  	eax,xmvoc.control[edi]
			and	eax,NOT cnt_keyoff+cnt_fade+cnt_enabled
			call	[DRV_setmode]
			call	[DRV_startchn]
XM_updatevoice_notplay: ret
XM_updatevoice		ENDP

;Ĵ XM maintainvoices 

XM_maintainvoices	PROC	USES eax ebx edi
			lea	edi,XM_voiceinfo
			clr	eax
XM_maintainvoices_l:
  			call	XM_updateefx
			call	XM_calcenvvol
			call	XM_calcfinalvol
			call	XM_calcenvpan
			call	XM_calcfinalpan
			test	xmvoc.control[edi],cnt_fade
			jz	XM_maintainvoices_done
			mov	ebx,xmvoc.faderate[edi]
			sub	xmvoc.fadevol[edi],ebx
			jns	XM_maintainvoices_done
			mov	xmvoc.fadevol[edi],0
XM_maintainvoices_done: add	edi,size xmvoc
			inc	eax
			cmp	eax,XM_chns
			jb	XM_maintainvoices_l
			ret
XM_maintainvoices	ENDP

;Ĵ XM Check EFX 

XM_checkefx		PROC	USES eax ebx
			mov	eax,xmvoc.command[edi]
			shl	eax,8
			or	eax,xmvoc.syntax[edi]
			jz	XM_checkefx_noefx
			mov	eax,xmvoc.syntax[edi]
			mov	ebx,xmvoc.command[edi]
			call	XM_checkefx_efxlist[ebx*4]
XM_checkefx_noefx:	mov	ebx,xmvoc.volcmd[edi]
			shr	ebx,4
			sub	ebx,6
			js	XM_checkefx_novol
			mov	eax,xmvoc.volcmd[edi]
			and	eax,0fh
			call	XM_checkefx_vollist[ebx*4]
XM_checkefx_novol:	ret
XM_checkefx_efxlist	dd	XM_efx_noefx			;0	  Arpegio
			dd	XM_efx_noefx			;1    (*) Porta up
			dd	XM_efx_noefx			;2    (*) Porta down
			dd	XM_efx_settp			;3 (!)(*) Tone porta
			dd	XM_efx_noefx			;4    (*) Vibrato
			dd	XM_efx_settp			;5    (*) Tone porta+Volume slide
			dd	XM_efx_noefx			;6    (*) Vibrato+Volume slide
			dd	XM_efx_noefx			;7    (*) Tremolo
			dd	XM_efx_setpan			;8 (!)	  Set panning
			dd	XM_efx_setsamofs		;9 (!)	  Sample offset
			dd	XM_efx_noefx			;A    (*) Volume slide
			dd	XM_efx_noefx			;B (!)	  Position jump
			dd	XM_efx_setvol			;C (!)	  Set volume
			dd	XM_efx_pattbreak		;D (!)	  Pattern break
			dd	XM_efx_checkecmd		;E (!)	  Extended command
			dd	XM_efx_setspeed 		;F (!)	  Set tempo/BPM
			dd	XM_efx_setgvol			;G (!)	  Set global volume
			dd	XM_efx_noefx			;H    (*) Global volume slide
			dd	XM_efx_noefx	       		;I
			dd	XM_efx_noefx			;J
			dd	XM_efx_keyoff			;K (!)	  Key off
			dd	XM_efx_setenvpos		;L (!)	  Set envelope position
			dd	XM_efx_noefx		        ;M
			dd	XM_efx_noefx		        ;N
			dd	XM_efx_noefx		        ;O
			dd	XM_efx_noefx		        ;P    (*) Panning slide
			dd	XM_efx_noefx		        ;Q
			dd	XM_efx_noefx		        ;R    (*) Multi retrig note
			dd	XM_efx_special			;S
			dd	XM_efx_noefx		        ;T	  Tremor
			dd	XM_efx_noefx		        ;U
			dd	XM_efx_noefx		        ;V
			dd	XM_efx_noefx		        ;W
			dd	XM_efx_noefx		        ;X    (*) Extra fine porta (1=up,2=down)
			dd	XM_efx_noefx		        ;Y
			dd	XM_efx_noefx			;Z

XM_checkefx_vollist	dd	XM_vol_noefx			;6	  Volume slide down
			dd	XM_vol_noefx			;7	  Volume slide up
			dd	XM_vol_vslidedown		;8	  Fine volume slide down
			dd	XM_vol_vslideup 		;9	  Fine volume slide up
			dd	XM_vol_noefx			;A (!)	  Set vibrato speed
			dd	XM_vol_noefx			;B	  Vibrato
			dd	XM_vol_setpan			;C (!)	  Set panning
			dd	XM_vol_noefx			;D	  Panning slide left
			dd	XM_vol_noefx			;E	  Panning slide right
			dd	XM_vol_noefx			;F	  Tone porta
XM_checkefx		ENDP

;Ĵ XM Update EFX 

XM_updateefx		PROC	USES eax ebx
			cmp	xmvoc.command[edi],7
			je	XM_updateefx_noreset
			mov	eax,xmvoc.volcmd[edi]
			and	al,0f0h
			cmp	al,0b0h
			je	XM_updateefx_noreset
XM_updateefx_reset:	or	xmvoc.update[edi],upd_period
XM_updateefx_noreset:	mov	eax,xmvoc.command[edi]
			shl	eax,8
			or	eax,xmvoc.syntax[edi]
			jz	XM_updateefx_noefx
			mov	eax,xmvoc.syntax[edi]
			mov	ebx,xmvoc.command[edi]
			call	XM_updateefx_efxlist[ebx*4]
XM_updateefx_noefx:	mov	ebx,xmvoc.volcmd[edi]
			shr	ebx,4
			sub	ebx,6
			js	XM_updateefx_novol
			mov	eax,xmvoc.volcmd[edi]
			and	eax,0fh
			call	XM_updateefx_vollist[ebx*4]
XM_updateefx_novol:	ret
XM_updateefx_efxlist	dd	XM_efx_noefx			;0 (!)	  Arpegio
			dd	XM_efx_portaup			;1 (!)(*) Porta up
			dd	XM_efx_portadown		;2 (!)(*) Porta down
			dd	XM_efx_tp			;3 (!)(*) Tone porta
			dd	XM_efx_vib			;4 (!)(*) Vibrato
			dd	XM_efx_tvslide			;5 (!)(*) Tone porta+Volume slide
			dd	XM_efx_vvslide			;6 (!)(*) Vibrato+Volume slide
			dd	XM_efx_trm			;7 (!)(*) Tremolo
			dd	XM_efx_noefx			;8	  Set panning
			dd	XM_efx_noefx			;9	  Sample offset
			dd	XM_efx_volslide 		;A (!)(*) Volume slide
			dd	XM_efx_noefx			;B	  Position jump
			dd	XM_efx_noefx			;C	  Set volume
			dd	XM_efx_noefx			;D	  Pattern break
			dd	XM_efx_updateecmd		;E (!)	  Extended command
			dd	XM_efx_noefx			;F	  Set tempo/BPM
			dd	XM_efx_noefx			;G	  Set global volume
			dd	XM_efx_gvolslide		;H (!)(*) Global volume slide
			dd	XM_efx_noefx		        ;I
			dd	XM_efx_noefx		        ;J
			dd	XM_efx_noefx		        ;K	  Key off
			dd	XM_efx_noefx		        ;L	  Set envelope position
			dd	XM_efx_noefx		        ;M
			dd	XM_efx_noefx		        ;N
			dd	XM_efx_noefx		        ;O
			dd	XM_efx_noefx		        ;P (!)(*) Panning slide
			dd	XM_efx_noefx		        ;Q
			dd	XM_efx_noefx		        ;R (!)(*) Multi retrig note
			dd	XM_efx_noefx		        ;S
			dd	XM_efx_noefx		        ;T (!)	  Tremor
			dd	XM_efx_noefx		        ;U
			dd	XM_efx_noefx		        ;V
			dd	XM_efx_noefx		        ;W
			dd	XM_efx_noefx		        ;X (!)(*) Extra fine porta (1=up,2=down)
			dd	XM_efx_noefx		        ;Y
			dd	XM_efx_noefx		        ;Z

XM_updateefx_vollist	dd	XM_vol_vslidedown		;6 (!)	  Volume slide down
			dd	XM_vol_vslideup 		;7 (!)	  Volume slide up
			dd	XM_vol_noefx			;8 (!)	  Fine volume slide down
			dd	XM_vol_noefx 			;9 (!)	  Fine volume slide up
			dd	XM_vol_noefx			;A	  Set vibrato speed
			dd	XM_vol_noefx			;B (!)	  Vibrato
			dd	XM_vol_noefx			;C	  Set panning
			dd	XM_vol_noefx			;D (!)	  Panning slide left
			dd	XM_vol_noefx			;E (!)	  Panning slide right
			dd	XM_vol_noefx			;F (!)	  Tone porta
XM_updateefx		ENDP

XM_efx_noefx		PROC
			ret
XM_efx_noefx		ENDP

XM_efx_portaup		PROC
			or	al,al
			jnz	XM_efx_portaup_new
			mov	al,xmvoc.lastportaup[edi]
XM_efx_portaup_new:	mov	xmvoc.lastportaup[edi],al
			shl	eax,xm_periodmultiplier
			mov	ebx,xmvoc.period[edi]
			add	ebx,eax
			cmp	ebx,XM_periodlimitup
			jbe	XM_efx_portaup_done
			mov	ebx,XM_periodlimitup
XM_efx_portaup_done:	mov	xmvoc.period[edi],ebx
			or	xmvoc.update[edi],upd_period
			ret
XM_efx_portaup		ENDP

XM_efx_portadown	PROC
			or	al,al
			jnz	XM_efx_portadown_new
			mov	al,xmvoc.lastportadown[edi]
XM_efx_portadown_new:	mov	xmvoc.lastportadown[edi],al
			shl	eax,xm_periodmultiplier
			mov	ebx,xmvoc.period[edi]
			add	ebx,eax
			cmp	ebx,XM_periodlimitdown
			jae	XM_efx_portadown_done
			mov	ebx,XM_periodlimitdown
XM_efx_portadown_done:	mov	xmvoc.period[edi],ebx
			or	xmvoc.update[edi],upd_period
			ret
XM_efx_portadown	ENDP


XM_efx_settp		PROC	USES ecx
			test	xmvoc.update[edi],upd_note
			jz	XM_efx_settp_done
			call	XM_calcperiod
			mov	ebx,xmvoc.period[edi]
			xchg	eax,ebx
			mov	xmvoc.tp_reqper[edi],ebx
			mov	xmvoc.tp_dir[edi],0
			cmp	eax,ebx
			je	XM_efx_settp_clear
			and	xmvoc.control[edi],NOT cnt_start
			cmp	eax,ebx
			jl	XM_efx_settp_done
			mov	xmvoc.tp_dir[edi],1
			jmp	XM_efx_settp_done
XM_efx_settp_clear:	mov	xmvoc.tp_reqper[edi],0
XM_efx_settp_done:	ret
XM_efx_settp		ENDP

XM_efx_tp		PROC
			or	al,al
			jz	XM_efx_tp_new
			mov	xmvoc.tp_speed[edi],al
XM_efx_tp_new:		cmp	xmvoc.tp_reqper[edi],0
			je	XM_efx_tp_done
			movzx	eax,xmvoc.tp_speed[edi]
			shl	eax,xm_periodmultiplier
			or	xmvoc.update[edi],upd_period
			cmp	xmvoc.tp_dir[edi],0
			jne	XM_efx_tp_up
XM_efx_tp_down: 	add	xmvoc.period[edi],eax
			mov	eax,xmvoc.tp_reqper[edi]
			cmp	xmvoc.period[edi],eax
			jle	XM_efx_tp_done
			mov	xmvoc.period[edi],eax
			mov	xmvoc.tp_reqper[edi],0
			jmp	XM_efx_tp_done
XM_efx_tp_up:		sub	xmvoc.period[edi],eax
			mov	eax,xmvoc.tp_reqper[edi]
			cmp	xmvoc.period[edi],eax
			jge	XM_efx_tp_done
			mov	xmvoc.period[edi],eax
			mov	xmvoc.tp_reqper[edi],0
XM_efx_tp_done: 	ret
XM_efx_tp		ENDP

XM_efx_vib		PROC	USES ecx
			or	al,al
			jz	XM_efx_vib_2
			mov	cl,xmvoc.vib_cmd[edi]
			and	al,0fh
			jz	XM_efx_vib_skip
			and	ecx,0f0h
			or	ecx,eax
XM_efx_vib_skip:	mov	eax,xmvoc.syntax[edi]
			and	al,0f0h
			jz	XM_efx_vib_skip2
			and	ecx,0fh
			or	ecx,eax
XM_efx_vib_skip2:	mov	xmvoc.vib_cmd[edi],cl
XM_efx_vib_2:		mov	al,xmvoc.vib_pos[edi]
			shr	al,2
			and	eax,1fh
			mov	cl,xmvoc.wav_ctrl[edi]
			and	ecx,03h
			jz	XM_efx_vib_sine
			shl	al,3h
			cmp	cl,1h
			je	XM_efx_vib_rampdown
			mov	cl,0ffh
			jmp	XM_efx_vib_set
XM_efx_vib_rampdown:	cmp	xmvoc.vib_pos[edi],0
			jae	XM_efx_vib_rampdown2
			mov	cl,0ffh
			sub	cl,al
			jmp	XM_efx_vib_set
XM_efx_vib_rampdown2:	mov	cl,al
			jmp	XM_efx_vib_set
XM_efx_vib_sine:	mov	cl,XM_vibrato[eax]
XM_efx_vib_set: 	mov	al,xmvoc.vib_cmd[edi]
			and	al,0fh
			imul	ecx,eax
			shr	ecx,7-xm_periodmultiplier
			mov	eax,xmvoc.period[edi]
			cmp	xmvoc.vib_pos[edi],0
			jb	XM_efx_vib_neg
			add	eax,ecx
			jmp	XM_efx_vib_3
XM_efx_vib_neg: 	sub	eax,ecx
XM_efx_vib_3:		mov	xmvoc.vib_per[edi],eax
			or	xmvoc.update[edi],upd_vibper
			mov	al,xmvoc.vib_cmd[edi]
			shr	al,2
			and	al,03ch
			add	xmvoc.vib_pos[edi],al
			ret
XM_efx_vib		ENDP


XM_efx_tvslide		PROC
			push	eax
			clr	eax
			call	XM_efx_tp
			pop	eax
			call	XM_efx_volslide
			ret
XM_efx_tvslide		ENDP

XM_efx_vvslide		PROC
			push	eax
			clr	eax
			call	XM_efx_vib
			pop	eax
			call	XM_efx_volslide
			ret
XM_efx_vvslide		ENDP


XM_efx_trm		PROC	USES ecx
			or	al,al
			jz	XM_efx_trm_2
			mov	cl,xmvoc.trm_cmd[edi]
			and	al,0fh
			jz	XM_efx_trm_skip
			and	cl,0f0h
			or	cl,al
XM_efx_trm_skip:	mov	eax,xmvoc.syntax[edi]
			and	al,0f0h
			jz	XM_efx_trm_skip2
			and	cl,0fh
			or	cl,al
XM_efx_trm_skip2:	mov	xmvoc.trm_cmd[edi],cl
XM_efx_trm_2:		mov	al,xmvoc.trm_pos[edi]
			shr	al,2
			and	eax,01fh
			clr	ecx
			mov	cl,xmvoc.wav_ctrl[edi]
			shr	cl,4
			and	cl,03h
			jz	XM_efx_trm_sine
			shl	eax,3
			cmp	cl,01h
			je	XM_efx_trm_rampdown
			mov	cl,0ffh
			jmp	XM_efx_trm_set
XM_efx_trm_rampdown:	cmp	xmvoc.trm_pos[edi],0
			jge	XM_efx_trm_ramp2
			mov	cl,0ffh
			sub	cl,al
			jmp	XM_efx_trm_set
XM_efx_trm_ramp2:	mov	cl,al
			jmp	XM_efx_trm_set
XM_efx_trm_sine:	mov	cl,XM_vibrato[eax]
XM_efx_trm_set:		mov	al,xmvoc.trm_cmd[edi]
			and	eax,0fh
			and	ecx,0ffh
			imul	ecx,eax
			shr	ecx,4
			mov	eax,xmvoc.vol[edi]
			cmp	xmvoc.trm_pos[edi],0
			jb	XM_efx_trm_neg
			add	eax,ecx
			jmp	XM_efx_trm_3
XM_efx_trm_neg:		sub	eax,ecx
XM_efx_trm_3:		jae	XM_efx_trm_skip3
			clr	eax
XM_efx_trm_skip3:	cmp	eax,100h
			jbe	XM_efx_trm_ok
			mov	eax,100h
XM_efx_trm_ok:		mov	xmvoc.trm_vol[edi],eax
			or	xmvoc.update[edi],upd_trmvol
			mov	al,xmvoc.trm_cmd[edi]
			shr	al,2
			and	al,03ch
			add	xmvoc.trm_pos[edi],al
			ret
XM_efx_trm		ENDP

XM_efx_setpan		PROC
			mov	xmvoc.basepan[edi],eax
			ret
XM_efx_setpan		ENDP

XM_efx_setsamofs	PROC
			shl	eax,8
			jnz	XM_efx_setsamofs_new
			mov	ah,xmvoc.lastsamofs[edi]
XM_efx_setsamofs_new:	mov	xmvoc.lastsamofs[edi],ah
			add	eax,xmvoc.sstart[edi]
			cmp	eax,xmvoc.send[edi]
			jae	XM_efx_setsamofs_behind
			mov	xmvoc.sstart[edi],eax
			jmp	XM_efx_setsamofs_done
XM_efx_setsamofs_behind:mov	eax,xmvoc.sstart[edi]
			add	eax,4
			mov	xmvoc.send[edi],eax
XM_efx_setsamofs_done:	ret
XM_efx_setsamofs	ENDP

XM_efx_volslide 	PROC	USES ecx
			or	al,al
			jnz	XM_efx_volslide_new
			mov	al,xmvoc.lastvolslide[edi]
XM_efx_volslide_new:	mov	xmvoc.lastvolslide[edi],al
			mov	ebx,xmvoc.basevol[edi]
			mov	ecx,eax
			shr	ecx,4
			jz	XM_efx_volslide_down
			add	ebx,ecx
			cmp	ebx,40h
			jbe	XM_efx_volslide_done
			mov	ebx,40h
			jmp	XM_efx_volslide_done
XM_efx_volslide_down:	and	eax,0fh
			sub	ebx,eax
			jns	XM_efx_volslide_done
			clr	ebx
XM_efx_volslide_done:	mov	xmvoc.basevol[edi],ebx
			ret
XM_efx_volslide 	ENDP

XM_efx_setvol		PROC
			cmp	eax,40h
			jbe	XM_efx_setvol_ok
			mov	eax,40h
XM_efx_setvol_ok:	mov	xmvoc.basevol[edi],eax
			ret
XM_efx_setvol		ENDP

XM_efx_pattbreak	PROC
			mov	XM_pattbreakpos,eax
			mov	XM_posjumpflag,1
			ret
XM_efx_pattbreak	ENDP

XM_efx_checkecmd	PROC
			mov	ebx,eax
			shr	ebx,4
			and	eax,0fh
			jmp	XM_efx_checkecmdlist[ebx*4]
XM_efx_checkecmdlist	dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_fvslideup
			dd	XM_efx_fvslidedown
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
XM_efx_checkecmd	ENDP

XM_efx_updateecmd	PROC
			mov	ebx,eax
			shr	ebx,4
			and	eax,0fh
			jmp	XM_efx_updateecmdlist[ebx*4]
XM_efx_updateecmdlist	dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
			dd	XM_efx_noefx
XM_efx_updateecmd	ENDP

XM_efx_fvslideup	PROC
			or	al,al
			jnz	XM_efx_fvslideup_new
			mov	al,xmvoc.lastfvslideup[edi]
XM_efx_fvslideup_new:	mov	xmvoc.lastfvslideup[edi],al
			mov	ebx,xmvoc.basevol[edi]
			add	ebx,eax
			cmp	ebx,40h
			jbe	XM_efx_fvslideup_done
			mov	ebx,40h
XM_efx_fvslideup_done:	mov	xmvoc.basevol[edi],ebx
			ret
XM_efx_fvslideup	ENDP

XM_efx_fvslidedown	PROC
			or	al,al
			jnz	XM_efx_fvslidedown_new
			mov	al,xmvoc.lastfvslidedown[edi]
XM_efx_fvslidedown_new: mov	xmvoc.lastfvslidedown[edi],al
			mov	ebx,xmvoc.basevol[edi]
			sub	ebx,eax
			jns	XM_efx_fvslidedown_done
			clr	ebx
XM_efx_fvslidedown_done:mov	xmvoc.basevol[edi],ebx
			ret
XM_efx_fvslidedown	ENDP

XM_efx_setspeed 	PROC
			or	eax,eax
			jz	XM_efx_setspeed_done
			cmp	al,01fh
			ja	XM_efx_setspeed_bpm
			mov	XM_counter,0
			mov	XM_speed,al
			jmp	XM_efx_setspeed_done
XM_efx_setspeed_bpm:	call	[DRV_setbpm]
XM_efx_setspeed_done:	ret
XM_efx_setspeed 	ENDP

XM_efx_setgvol		PROC
			cmp	eax,40h
			jbe	XM_efx_setgvol_ok
			mov	eax,40h
XM_efx_setgvol_ok:	mov	XM_globalvol,eax
			ret
XM_efx_setgvol		ENDP

XM_efx_gvolslide	PROC	USES ecx
			or	al,al
			jnz	XM_efx_gvolslide_new
			mov	al,xmvoc.lastgvolslide[edi]
XM_efx_gvolslide_new:	mov	xmvoc.lastgvolslide[edi],al
			mov	ebx,XM_globalvol
			mov	ecx,eax
			shr	ecx,4
			jz	XM_efx_gvolslide_down
			add	ebx,ecx
			cmp	ebx,40h
			jbe	XM_efx_gvolslide_done
			mov	ebx,40h
			jmp	XM_efx_gvolslide_done
XM_efx_gvolslide_down:	and	eax,0fh
			sub	ebx,eax
			jns	XM_efx_gvolslide_done
			clr	ebx
XM_efx_gvolslide_done:	mov	XM_globalvol,ebx
			ret
XM_efx_gvolslide	ENDP

XM_efx_keyoff		PROC
			or     xmvoc.control[edi],cnt_keyoff
			or     xmvoc.control[edi],cnt_fade
			ret
XM_efx_keyoff		ENDP

XM_efx_setenvpos	PROC	USES esi
			mov	esi,xmvoc.volenvptr[edi]
			mov	xmvoc.volenvptn[edi],eax
			movzx	eax,wptr [esi+eax*4]
			mov	xmvoc.volenvpos[edi],eax
			ret
XM_efx_setenvpos	ENDP

XM_efx_special		PROC
			call	[FMT_jmp_cmd]
			ret
XM_efx_special		ENDP

XM_vol_noefx		PROC
			ret
XM_vol_noefx		ENDP

XM_vol_vslideup 	PROC
			mov	ebx,xmvoc.basevol[edi]
			add	ebx,eax
			cmp	ebx,40h
			jbe	XM_vol_vslideup_done
			mov	ebx,40h
XM_vol_vslideup_done:	mov	xmvoc.basevol[edi],ebx
			ret
XM_vol_vslideup 	ENDP

XM_vol_vslidedown	PROC
			mov	ebx,xmvoc.basevol[edi]
			sub	ebx,eax
			jns	XM_vol_vslidedown_done
			clr	ebx
XM_vol_vslidedown_done: mov	xmvoc.basevol[edi],ebx
			ret
XM_vol_vslidedown	ENDP

XM_vol_setpan		PROC
			shl	eax,4
			mov	xmvoc.basepan[edi],eax
			ret
XM_vol_setpan		ENDP


;Ĵ XM Calc envelope volume 

XM_calcenvvol		PROC	USES eax ebx ecx edx esi
			test	xmvoc.volenvctrl[edi],1h
			jz	XM_calcenvvol_noenv

			mov	esi,xmvoc.volenvptr[edi]

			test	xmvoc.volenvctrl[edi],80h
			jnz	XM_calcenvvol_atend

			mov	ebx,xmvoc.volenvptn[edi]
			movzx	eax,wptr 6[esi+ebx*4]
			movzx	ecx,wptr 2[esi+ebx*4]
			sub	eax,ecx
			mov	ecx,xmvoc.volenvpos[edi]
			movzx	edx,wptr 0[esi+ebx*4]
			sub	ecx,edx
			imul	ecx
			movzx	ecx,wptr 4[esi+ebx*4]
			movzx	edx,wptr 0[esi+ebx*4]
			sub	ecx,edx
			cdq
			idiv	ecx
			movzx	ecx,wptr 2[esi+ebx*4]
			add	eax,ecx
			mov	xmvoc.envvol[edi],eax

			mov	eax,xmvoc.volenvpos[edi]
			mov	edx,xmvoc.volenvsustain[edi]
			movzx	ecx,wptr [esi+edx*4]
			cmp	eax,ecx
			jb	XM_calcenvvol_beforesustain
			test	xmvoc.volenvctrl[edi],2h
			jz	XM_calcenvvol_beforesustain
			test	xmvoc.control[edi],cnt_keyoff
			jnz	XM_calcenvvol_beforesustain
			mov	xmvoc.volenvptn[edi],edx
			movzx	eax,wptr [esi+edx*4]
			mov	xmvoc.volenvpos[edi],eax
			movzx	eax,wptr 2[esi+edx*4]
			mov	xmvoc.envvol[edi],eax
			jmp	XM_calcenvvol_done
XM_calcenvvol_beforesustain:

			inc	xmvoc.volenvpos[edi]
			movzx	ecx,wptr 4[esi+ebx*4]
			cmp	xmvoc.volenvpos[edi],ecx
			jb	XM_calcenvvol_done

			inc	xmvoc.volenvptn[edi]
			test	xmvoc.volenvctrl[edi],4h
			jnz	XM_calcenvvol_loop
			mov	ecx,xmvoc.volenvptn[edi]
			cmp	ecx,xmvoc.volenvcnt[edi]
			jb	XM_calcenvvol_done
			movzx	eax,wptr 2[esi+ecx*4]
			mov	xmvoc.envvol[esi],eax
			or	xmvoc.volenvctrl[edi],80h
			or	xmvoc.control[edi],cnt_fade
			jmp	XM_calcenvvol_done

XM_calcenvvol_loop:	mov	ecx,xmvoc.volenvptn[edi]
			cmp	ecx,xmvoc.volenvlend[edi]
			jb	XM_calcenvvol_done
			mov	ebx,xmvoc.volenvlstart[edi]
			movzx	eax,wptr 0[esi+ebx*4]
			mov	xmvoc.volenvpos[edi],eax
			mov	xmvoc.volenvptn[edi],ebx
			jmp	XM_calcenvvol_done

XM_calcenvvol_atend:	mov	ebx,xmvoc.volenvcnt[edi]
			movzx	eax,wptr 2[esi+ebx*4]
			mov	xmvoc.envvol[edi],eax
			jmp	XM_calcenvvol_done

XM_calcenvvol_noenv:	mov	xmvoc.envvol[edi],64
			test	xmvoc.control[edi],cnt_keyoff
			jz	XM_calcenvvol_done
			mov	xmvoc.envvol[edi],0
XM_calcenvvol_done:	ret
XM_calcenvvol		ENDP

;Ĵ XM Calc final volume 

XM_calcfinalvol 	PROC	USES eax
			mov	eax,256
			imul	eax,xmvoc.fadevol[edi]
			shr	eax,16
			imul	eax,xmvoc.basevol[edi]
			shr	eax,6
			imul	eax,xmvoc.envvol[edi]
			shr	eax,6
			imul	eax,XM_globalvol
			shr	eax,6
			or	xmvoc.update[edi],upd_vol
			mov	xmvoc.vol[edi],eax
			ret
XM_calcfinalvol 	ENDP

;Ĵ XM Calc envelope panning 

XM_calcenvpan		PROC	USES eax ebx ecx edx esi
			test	xmvoc.panenvctrl[edi],1h
			jz	XM_calcenvpan_noenv

			mov	esi,xmvoc.panenvptr[edi]

			test	xmvoc.panenvctrl[edi],80h
			jnz	XM_calcenvpan_atend

			mov	ebx,xmvoc.panenvptn[edi]
			movzx	eax,wptr 6[esi+ebx*4]
			movzx	ecx,wptr 2[esi+ebx*4]
			sub	eax,ecx
			mov	ecx,xmvoc.panenvpos[edi]
			movzx	edx,wptr 0[esi+ebx*4]
			sub	ecx,edx
			imul	ecx
			movzx	ecx,wptr 4[esi+ebx*4]
			movzx	edx,wptr 0[esi+ebx*4]
			sub	ecx,edx
			cdq
			idiv	ecx
			movzx	ecx,wptr 2[esi+ebx*4]
			add	eax,ecx
			mov	xmvoc.envpan[edi],eax

			mov	eax,xmvoc.panenvpos[edi]
			mov	edx,xmvoc.panenvsustain[edi]
			movzx	ecx,wptr [esi+edx*4]
			cmp	eax,ecx
			jb	XM_calcenvpan_beforesustain
			test	xmvoc.panenvctrl[edi],2h
			jz	XM_calcenvpan_beforesustain
			test	xmvoc.control[edi],cnt_keyoff
			jnz	XM_calcenvpan_beforesustain
			mov	xmvoc.panenvptn[edi],edx
			movzx	eax,wptr [esi+edx*4]
			mov	xmvoc.panenvpos[edi],eax
			movzx	eax,wptr 2[esi+edx*4]
			mov	xmvoc.envpan[edi],eax
			jmp	XM_calcenvpan_done
XM_calcenvpan_beforesustain:

			inc	xmvoc.panenvpos[edi]
			movzx	ecx,wptr 4[esi+ebx*4]
			cmp	xmvoc.panenvpos[edi],ecx
			jb	XM_calcenvpan_done

			inc	xmvoc.panenvptn[edi]
			test	xmvoc.panenvctrl[edi],4h
			jnz	XM_calcenvpan_loop
			mov	ecx,xmvoc.panenvptn[edi]
			cmp	ecx,xmvoc.panenvcnt[edi]
			jb	XM_calcenvpan_done
			or	xmvoc.panenvctrl[edi],80h
			jmp	XM_calcenvpan_done

XM_calcenvpan_loop:	mov	ecx,xmvoc.panenvptn[edi]
			cmp	ecx,xmvoc.panenvlend[edi]
			jb	XM_calcenvpan_done
			mov	ebx,xmvoc.panenvlstart[edi]
			movzx	eax,wptr 0[esi+ebx*4]
			mov	xmvoc.panenvpos[edi],eax
			mov	xmvoc.panenvptn[edi],ebx
			jmp	XM_calcenvpan_done

XM_calcenvpan_atend:	mov	ebx,xmvoc.panenvcnt[edi]
			movzx	eax,wptr 2[esi+ebx*4]
			mov	xmvoc.envpan[edi],eax
			jmp	XM_calcenvpan_done

XM_calcenvpan_noenv:	mov	xmvoc.envpan[edi],32
XM_calcenvpan_done:	ret
			ret
XM_calcenvpan		ENDP

;Ĵ XM Calc final panning 

XM_calcfinalpan 	PROC	USES eax ebx edx
			mov	eax,xmvoc.basepan[edi]
			sub	eax,128
			jns	XM_calcfinalpan_pos
			neg	eax
XM_calcfinalpan_pos:	mov	ebx,128
			sub	ebx,eax
			mov	eax,xmvoc.envpan[edi]
			sub	eax,32
			imul	eax,ebx
			sar	eax,5
			add	eax,xmvoc.basepan[edi]
			shr	eax,4				;Convert to 0-15
			or	xmvoc.update[edi],upd_pan
			mov	xmvoc.pan[edi],eax
			ret
XM_calcfinalpan 	ENDP

;Ĵ XM Calc period 

XM_calcperiod		PROC
			cmp	xmvoc.basenote[edi],'N/A'
			je	XM_calcperiod_skip
			cmp	xmvoc.note[edi],'N/A'
			je	XM_calcperiod_skip
			mov	eax,xmvoc.basenote[edi]
			add	eax,xmvoc.note[edi]
			cmp	eax,118
			jbe	XM_calcperiod_okhigh
			mov	eax,118
XM_calcperiod_okhigh:	cmp	eax,0
			jae	XM_calcperiod_oklow
			mov	eax,0
XM_calcperiod_oklow:	mov	ebx,xmvoc.fine[edi]
			call	[XM_note2per]
			clc
			jmp	XM_calcperiod_done
XM_calcperiod_skip:	stc
XM_calcperiod_done:	ret
XM_calcperiod		ENDP

;Ĵ XM Get Pattern info 

XM_getpattinfo		PROC	USES ecx edx
			add	eax,XM_module
			movzx	eax,bptr 80[eax]
			mov	eax,XM_pattlst[eax*4]
			movzx	ecx,wptr 5[eax]
			push	ecx
			add	eax,[eax]
			cmp	ebx,ecx
			jae	XM_getpattinfo_skip
			cmp	ebx,0
			je	XM_getpattinfo_skip
XM_getpattinfo_l1:	mov	ecx,XM_chns
XM_getpattinfo_l2:	mov	dl,[eax]
			test	dl,10000000b
			jz	XM_getpattinfo_nopack
			inc	eax
			test	dl,00000001b
			jnz	XM_getpattinfo_1
			dec	eax
XM_getpattinfo_1:	test	dl,00000010b
			jnz	XM_getpattinfo_2
			dec	eax
XM_getpattinfo_2:	test	dl,00000100b
			jnz	XM_getpattinfo_3
			dec	eax
XM_getpattinfo_3:	test	dl,00001000b
			jnz	XM_getpattinfo_4
			dec	eax
XM_getpattinfo_4:	test	dl,00010000b
			jnz	XM_getpattinfo_nopack
			dec	eax
XM_getpattinfo_nopack:	add	eax,5
			dec	ecx
			jnz	XM_getpattinfo_l2
			dec	ebx
			jnz	XM_getpattinfo_l1
XM_getpattinfo_skip:	pop	ebx
			ret
XM_getpattinfo		ENDP

;Ĵ XM Period to frequency 

XM_note2per		dd	XM_linear_note2per
XM_per2freq		dd	XM_linear_per2freq

XM_linear_note2per	PROC	USES ebx ecx edx
			mov	ecx,16*4
			imul	ecx
			mov	ecx,10*12*16*4
			sub	ecx,eax
			sar	ebx,1
			sub	ecx,ebx
			mov	eax,ecx
			ret
XM_linear_note2per	ENDP

XM_linear_per2freq	PROC
			mov	ecx,768
			cdq
			idiv	ecx
			mov	ecx,eax
			mov	eax,XM_linear[edx*4]
			shr	eax,cl
			ret
XM_linear_per2freq	ENDP

XM_amiga_note2per	PROC	USES ebx ecx edx esi
			mov	ecx,12
			clr	edx
			idiv	ecx
			shl	eax,4
			or	eax,edx
			mov	edx,eax
			and	edx,0f0h
			shr	edx,4
			and	eax,00fh
			shl	eax,3
			mov	ecx,ebx
			sar	ecx,4

			mov	esi,eax
			add	esi,ecx
			push	XM_periods[esi*4+8*4]

			inc	ecx
			or	ebx,ebx
			jns	XM_amiga_note2per_plus
			dec	ecx
			dec	ecx
			neg	ebx
XM_amiga_note2per_plus:
			mov	esi,eax
			add	esi,ecx
			push	XM_periods[esi*4+8*4]

			mov	esi,ebx
			and	esi,0fh
			pop	ebx
			pop	eax
			imul	ebx,esi
			mov	ecx,16
			sub	ecx,esi
			imul	eax,ecx
			add	eax,ebx
			add	eax,eax
			mov	ecx,edx
			shr	eax,cl
			ret
XM_amiga_note2per	ENDP

XM_amiga_per2freq	PROC
			mov	ecx,eax
			clr	edx
			mov	eax,8363*1712
			idiv	ecx
			ret
XM_amiga_per2freq	ENDP

XM_unpack		PROC	USES eax ebx ecx
			mov	ebx,sam.send[esi]
			sub	ebx,sam.sstart[esi]
			jz	XM_unpack_done
			mov	ebx,sam.sstart[esi]
			test	sam.stype[esi],cnt_16bit
			jnz	XM_unpack_16
			clr	al
XM_unpack_8l:		add	al,[ebx]
			mov	[ebx],al
			inc	ebx
			cmp	ebx,sam.send[esi]
			jb	XM_unpack_8l
			jmp	XM_unpack_done
XM_unpack_16:		clr	eax
XM_unpack_16l:		add	ax,[ebx]
			mov	[ebx],ax
			add	ebx,2
			cmp	ebx,sam.send[esi]
			jb	XM_unpack_16l
XM_unpack_done: 	ret
XM_unpack		ENDP

.data

upd_sample		=	1 shl 0
upd_start		=	1 shl 1
upd_end 		=	1 shl 2
upd_lstart		=	1 shl 3
upd_lend		=	1 shl 4
upd_period		=	1 shl 5
upd_vol 		=	1 shl 6
upd_pan 		=	1 shl 7
upd_vibper		=	1 shl 8
upd_trmvol		=	1 shl 9
upd_note		=	1 shl 10
upd_inst		=	1 shl 11
upd_play		=	1 shl 12

cnt_enabled		=	1 shl 28
cnt_keyoff		=	1 shl 29
cnt_fade		=	1 shl 30
cnt_start		=	1 shl 31

xmvoc                   STRUC,NONUNIQUE
sstart                  dd      ?
send                    dd      ?
lstart                  dd      ?
lend                    dd      ?
note                    dd      ?
basenote                dd      ?
realnote                dd      ?
period                  dd      ?
freq                    dd      ?
fine                    dd      ?
inst                    dd      ?
instptr                 dd      ?
sample                  dd      ?
samptr                  dd      ?
samplenum               dd      ?
basevol                 dd      ?
orgvol                  dd      ?
vol                     dd      ?
basepan                 dd      ?
orgpan                  dd      ?
pan                     dd      ?
volcmd                  dd      ?
command                 dd      ?
syntax                  dd      ?
control                 dd      ?
update                  dd      ?

volenvptr               dd      ?
volenvcnt               dd      ?
volenvsustain           dd      ?
volenvlstart            dd      ?
volenvlend              dd      ?
volenvctrl              db      ?
volenvpos               dd      ?
volenvptn               dd      ?

panenvptr               dd      ?
panenvcnt               dd      ?
panenvsustain           dd      ?
panenvlstart            dd      ?
panenvlend              dd      ?
panenvctrl              db      ?
panenvpos               dd      ?
panenvptn               dd      ?

vibtype                 db      ?
vibsweep                dd      ?
vibdepth                dd      ?
vibrate                 dd      ?
faderate                dd      ?
fadevol                 dd      ?
envvol                  dd      ?
envpan                  dd      ?

tp_reqper               dd      ?
tp_dir                  db      ?
tp_speed                db      ?

vib_pos                 db      ?
vib_cmd                 db      ?
vib_per                 dd      ?

trm_pos                 db      ?
trm_cmd                 db      ?
trm_vol                 dd      ?

wav_ctrl                db      ?

lastportaup             db      ?
lastportadown           db      ?
lasttoneporta           db      ?
lastvibrato             db      ?
lasttonevolslide        db      ?
lastvibvolslide         db      ?
lasttremolo             db      ?
lastvolslide            db      ?
lastsamofs              db      ?
lastfvslideup           db      ?
lastfvslidedown         db      ?
lastgvolslide           db      ?
xmvoc			ENDS

XM_globalvol		dd	64

XM_pattbreakpos 	dd	0
XM_posjumpflag		dd	0

XM_periodlimitup	dd	54784
XM_periodlimitdown	dd	57

XM_idstring		db	'Extended Module: ',0

XM_name 		db	'Extended Module made with '
XM_name_oftracker	db	24 dup('$')
XM_cmdlist		db	'XM',0,0                ;fmt_id
			dd	XM_name 		;fmt_name
			dd	XM_test 		;fmt_test
			dd	XM_init 		;fmt_init
			dd	XM_exit 		;fmt_exit
			dd	XM_play 		;fmt_play
			dd	XM_stop 		;fmt_stop
			dd	XM_playtick		;fmt_playtick

XM_vibrato		db	  0, 24, 49, 74, 97,120,141,161
			db	180,197,212,224,235,244,250,253
			db	255,253,250,244,235,224,212,197
			db	180,161,141,120, 97, 74, 49, 24

XM_periods		dd	907,900,894,887,881,875,868,862,856,850,844,838,832,826,820,814
			dd	808,802,796,791,785,779,774,768,762,757,752,746,741,736,730,725
			dd	720,715,709,704,699,694,689,684,678,675,670,665,660,655,651,646
			dd	640,636,632,628,623,619,614,610,604,601,597,592,588,584,580,575
			dd	570,567,563,559,555,551,547,543,538,535,532,528,524,520,516,513
			dd	508,505,502,498,494,491,487,484,480,477,474,470,467,463,460,457
			dd	453,450,447,443,440,437,434,431

XM_linear		dd	535232,534749,534266,533784,533303,532822,532341,531861
			dd	531381,530902,530423,529944,529466,528988,528511,528034
			dd	527558,527082,526607,526131,525657,525183,524709,524236
			dd	523763,523290,522818,522346,521875,521404,520934,520464
			dd	519994,519525,519057,518588,518121,517653,517186,516720
			dd	516253,515788,515322,514858,514393,513929,513465,513002
			dd	512539,512077,511615,511154,510692,510232,509771,509312
			dd	508852,508393,507934,507476,507018,506561,506104,505647
			dd	505191,504735,504280,503825,503371,502917,502463,502010
			dd	501557,501104,500652,500201,499749,499298,498848,498398
			dd	497948,497499,497050,496602,496154,495706,495259,494812
			dd	494366,493920,493474,493029,492585,492140,491696,491253
			dd	490809,490367,489924,489482,489041,488600,488159,487718
			dd	487278,486839,486400,485961,485522,485084,484647,484210
			dd	483773,483336,482900,482465,482029,481595,481160,480726
			dd	480292,479859,479426,478994,478562,478130,477699,477268
			dd	476837,476407,475977,475548,475119,474690,474262,473834
			dd	473407,472979,472553,472126,471701,471275,470850,470425
			dd	470001,469577,469153,468730,468307,467884,467462,467041
			dd	466619,466198,465778,465358,464938,464518,464099,463681
			dd	463262,462844,462427,462010,461593,461177,460760,460345
			dd	459930,459515,459100,458686,458272,457859,457446,457033
			dd	456621,456209,455797,455386,454975,454565,454155,453745
			dd	453336,452927,452518,452110,451702,451294,450887,450481
			dd	450074,449668,449262,448857,448452,448048,447644,447240
			dd	446836,446433,446030,445628,445226,444824,444423,444022
			dd	443622,443221,442821,442422,442023,441624,441226,440828
			dd	440430,440033,439636,439239,438843,438447,438051,437656
			dd	437261,436867,436473,436079,435686,435293,434900,434508
			dd	434116,433724,433333,432942,432551,432161,431771,431382
			dd	430992,430604,430215,429827,429439,429052,428665,428278
			dd	427892,427506,427120,426735,426350,425965,425581,425197
			dd	424813,424430,424047,423665,423283,422901,422519,422138
			dd	421757,421377,420997,420617,420237,419858,419479,419101
			dd	418723,418345,417968,417591,417214,416838,416462,416086
			dd	415711,415336,414961,414586,414212,413839,413465,413092
			dd	412720,412347,411975,411604,411232,410862,410491,410121
			dd	409751,409381,409012,408643,408274,407906,407538,407170
			dd	406803,406436,406069,405703,405337,404971,404606,404241
			dd	403876,403512,403148,402784,402421,402058,401695,401333
			dd	400970,400609,400247,399886,399525,399165,398805,398445
			dd	398086,397727,397368,397009,396651,396293,395936,395579
			dd	395222,394865,394509,394153,393798,393442,393087,392733
			dd	392378,392024,391671,391317,390964,390612,390259,389907
			dd	389556,389204,388853,388502,388152,387802,387452,387102
			dd	386753,386404,386056,385707,385359,385012,384664,384317
			dd	383971,383624,383278,382932,382587,382242,381897,381552
			dd	381208,380864,380521,380177,379834,379492,379149,378807
			dd	378466,378124,377783,377442,377102,376762,376422,376082
			dd	375743,375404,375065,374727,374389,374051,373714,373377
			dd	373040,372703,372367,372031,371695,371360,371025,370690
			dd	370356,370022,369688,369355,369021,368688,368356,368023
			dd	367691,367360,367028,366697,366366,366036,365706,365376
			dd	365046,364717,364388,364059,363731,363403,363075,362747
			dd	362420,362093,361766,361440,361114,360788,360463,360137
			dd	359813,359488,359164,358840,358516,358193,357869,357547
			dd	357224,356902,356580,356258,355937,355616,355295,354974
			dd	354654,354334,354014,353695,353376,353057,352739,352420
			dd	352103,351785,351468,351150,350834,350517,350201,349885
			dd	349569,349254,348939,348624,348310,347995,347682,347368
			dd	347055,346741,346429,346116,345804,345492,345180,344869
			dd	344558,344247,343936,343626,343316,343006,342697,342388
			dd	342079,341770,341462,341154,340846,340539,340231,339924
			dd	339618,339311,339005,338700,338394,338089,337784,337479
			dd	337175,336870,336566,336263,335959,335656,335354,335051
			dd	334749,334447,334145,333844,333542,333242,332941,332641
			dd	332341,332041,331741,331442,331143,330844,330546,330247
			dd	329950,329652,329355,329057,328761,328464,328168,327872
			dd	327576,327280,326985,326690,326395,326101,325807,325513
			dd	325219,324926,324633,324340,324047,323755,323463,323171
			dd	322879,322588,322297,322006,321716,321426,321136,320846
			dd	320557,320267,319978,319690,319401,319113,318825,318538
			dd	318250,317963,317676,317390,317103,316817,316532,316246
			dd	315961,315676,315391,315106,314822,314538,314254,313971
			dd	313688,313405,313122,312839,312557,312275,311994,311712
			dd	311431,311150,310869,310589,310309,310029,309749,309470
			dd	309190,308911,308633,308354,308076,307798,307521,307243
			dd	306966,306689,306412,306136,305860,305584,305308,305033
			dd	304758,304483,304208,303934,303659,303385,303112,302838
			dd	302565,302292,302019,301747,301475,301203,300931,300660
			dd	300388,300117,299847,299576,299306,299036,298766,298497
			dd	298227,297958,297689,297421,297153,296884,296617,296349
			dd	296082,295815,295548,295281,295015,294749,294483,294217
			dd	293952,293686,293421,293157,292892,292628,292364,292100
			dd	291837,291574,291311,291048,290785,290523,290261,289999
			dd	289737,289476,289215,288954,288693,288433,288173,287913
			dd	287653,287393,287134,286875,286616,286358,286099,285841
			dd	285583,285326,285068,284811,284554,284298,284041,283785
			dd	283529,283273,283017,282762,282507,282252,281998,281743
			dd	281489,281235,280981,280728,280475,280222,279969,279716
			dd	279464,279212,278960,278708,278457,278206,277955,277704
			dd	277453,277203,276953,276703,276453,276204,275955,275706
			dd	275457,275209,274960,274712,274465,274217,273970,273722
			dd	273476,273229,272982,272736,272490,272244,271999,271753
			dd	271508,271263,271018,270774,270530,270286,270042,269798
			dd	269555,269312,269069,268826,268583,268341,268099,267857


.data?
XM_bpm			db	?
XM_speed		db	?
XM_counter		db	?
XM_songpos		dd	?
XM_pattpos		dd	?
XM_pattofs		dd	?
XM_pattlen		dd	?
XM_chns 		dd	?
XM_module		dd	?
XM_pattlst		dd	256 dup(?)
XM_instlst		dd	256 dup(?)
XM_chnrow		db	5 dup(?)
XM_voiceinfo		db	32*size xmvoc dup(?)

			END

