.386p
.model flat,syscall
.code

                        include p:\nms.mac
                        include p:\nms.ext

                public  DOS4G_cmdlist


DOS4G_detect            PROC    USES eax ebx ecx edx esi edi
                        mov     eax,0bfdch
                        clr     edx
                        clr     esi
                        int     15h
                        cmp     dx,0
                        je      DOS4G_detect_fail
                        and     edx,0ffffh
                        shl     edx,4
                        mov     esi,05ch
                        add     esi,edx
                        mov     ecx,256-4
                        lea     edi,DOS4G_name
DOS4G_detect_l:         lodsb
                        or      al,al
                        jz      DOS4G_detect_done
                        stosb
                        dec     ecx
                        jnz     DOS4G_detect_l
DOS4G_detect_done:      mov     eax,eoldata
                        stosd
                        clc
                        jmp     DOS4G_detect_ok
DOS4G_detect_fail:      stc
DOS4G_detect_ok:        ret
DOS4G_detect            ENDP



DOS4G_init              PROC
                        clc
                        ret
DOS4G_init              ENDP

DOS4G_allocdma          PROC    USES eax ecx

                        mov     eax,100h
                        mov     ebx,(64+16)*1024/16
                        int     31h

                        and     eax,0ffffh
                        shl     eax,4
                        add     eax,64*1024
                        and     eax,not 0ffffh

                        mov     ebx,eax
                        mov     edx,eax

                        clc

                        ret
DOS4G_allocdma          ENDP

DOS4G_getprginfo        PROC    USES eax ecx edx
                        mov     eax,6
                        mov     bx,ds
                        int     31h
                        mov     ebx,ecx
                        shl     ebx,16
                        mov     bx,dx                   ; ds segment base
                        push    ebx

                        mov     ah,62h
                        int     21h
                        mov     eax,6
                        int     31h
                        shl     ecx,16
                        mov     cx,dx
                        mov     edi,ecx
                        mov     ebx,[esp]
                        sub     edi,ebx
                        mov     bx,2ch[edi]
                        mov     eax,6
                        int     31h
                        shl     ecx,16
                        mov     cx,dx
                        mov     edi,ecx
                        pop     ebx
                        ret
DOS4G_getprginfo        ENDP

DOS4G_getvect           PROC    USES eax ebx es
                        mov     eax,3500h
                        mov     al,bl
                        int     21h
                        mov     cx,es
                        mov     edx,ebx
                        ret
DOS4G_getvect           ENDP

DOS4G_setvect           PROC    USES eax ds
                        mov     ds,cx
                        mov     eax,2500h
                        mov     al,bl
                        int     21h
                        ret
DOS4G_setvect           ENDP

.data

DOS4G_cmdlist           dd      'DS4G'                  ;sys_id
                        dd      DOS4G_name              ;sys_name
                        dd      DOS4G_detect            ;sys_detect
                        dd      DOS4G_init              ;sys_init
                        dd      DOS4G_allocdma          ;sys_allocdma
                        dd      DOS4G_getprginfo        ;sys_getprginfo
                        dd      DOS4G_getvect           ;sys_getvect
                        dd      DOS4G_setvect           ;sys_setvect

DOS4G_name              db      256 dup("$")
                        END

