/*
	Document Title : Free Diretion Rendering
	Author         : Ohad Eder Pressman aka Kombat/Immortals
	Date           : 20/02/1998

	Sample Source-Code
*/

//#define GENERATE_UGLY_TEXTURE

// Graphical and Mathematical routines/variables
#include "stuff.h"

// Constnats
const float CONE_RADIUS 	= 256;
const float PLANE_OFFSET 	= 650;
const float SPHERE_RADIUS = 256;


// Free-Direction Tunnel
void fd_tunnel(int x, int y, char *u, char *v, char *z)
{
	Vector Origin = {-128,128,0},
			 // Pixel Direction Calculation
			 Direction = {(x-160)/FOV,(y-100)/FOV,1},
			 Intersect;
	float a, b, c, delta,
			t1, t2, t;

	// Normalize our Direction Vector
	vec_norm(&Direction);

	// (Dx+Dy)*t + 2*(Ox*Dx+Oy*Dy)*t + (Ox+Oy-r) = 0
	a = sqr(Direction.x) + sqr(Direction.y);
	b = 2*(Origin.x*Direction.x + Origin.y*Direction.y);
	c = sqr(Origin.x) + sqr(Origin.y) - sqr(CONE_RADIUS);

	// delta =  ( b - 4ac )
	delta = sqrt(b*b - 4*a*c);

        //           -b + delta             -b + delta
	//	x1 =     ;   x2 = 
        //               2a                     2a
	t1 = (-b + delta) / (2*a+EPSILON);
	t2 = (-b - delta) / (2*a+EPSILON);

	// Find positive solution
	t = t1 > 0 ? t1 : t2;

	// Calculate Intersect Point (O + D*t)
	Intersect.x = Origin.x + Direction.x*t;
	Intersect.y = Origin.y + Direction.y*t;
	Intersect.z = Origin.z + Direction.z*t;

	// Calculate Mapping Coordinates (Radial Coordinates)
	*u = (char)(fabs(Intersect.z)*0.6);
	*v = (char)(fabs(atan2(Intersect.y, Intersect.x)*256/PI));

	// Calculate Depth
	t = 20000.0/t;
	*z = (char)(t > 63 ? 63 : t);
}

// Free-Direction Planes
void fd_planes(int x, int y, char *u, char *v, char *z)
{
	Vector Origin = {0,0,0},
			 // Pixel Direction Calculation
			 Direction = {(x-160)/FOV,(y-100)/FOV,1},
			 Intersect;
	float t;

	// Normalize our Direction Vector
	vec_norm(&Direction);

	// Find t
	t = (sgn(Direction.y)*PLANE_OFFSET-Origin.y) / Direction.y;

	// Calculate Intersect Point (O + D*t)
	Intersect.x = Origin.x + Direction.x*t;
	Intersect.y = Origin.y + Direction.y*t;
	Intersect.z = Origin.z + Direction.z*t;

	// Calculate Mapping Coordinates ( Coordiantes)
	*u = (char)(fabs(Intersect.x)*0.3);
	*v = (char)(fabs(Intersect.z)*0.3);

	// Calculate Depth
	t = sqr(Intersect.x-Origin.x) + sqr(Intersect.z-Origin.z);
	if (t <= EPSILON) *z = 0;
	else
	{
		t = 50000.0 / sqrt(t);
		*z = (char)(t > 63 ? 63 : t);
	}
}

// Free-Direction Sphere
void fd_sphere(int x, int y, char *u, char *v, char *z)
{
	Vector Origin = {0,-100,-100},
			 // Pixel Direction Calculation
			 Direction = {(x-160)/FOV,(y-100)/FOV-.4,.7},
			 Intersect;
	float a, b, c, delta,
			t1, t2, t;

	// Normalize our Direction Vector
	vec_norm(&Direction);

	// (Dx+Dy+Dz)*t + 2*(Ox*Dx+Oy*Dy+Oz*Dz)*t + (Ox+Oy+Oz-r) = 0
	a = sqr(Direction.x) + sqr(Direction.y) + sqr(Direction.z);
	b = 2*(Origin.x*Direction.x + Origin.y*Direction.y + Origin.z*Direction.z);
	c = sqr(Origin.x) + sqr(Origin.y) + sqr(Origin.z) - sqr(SPHERE_RADIUS);

	// delta =  ( b - 4ac )
	delta = sqrt(b*b - 4*a*c);

        //           -b + delta             -b + delta
	//	x1 =     ;   x2 = 
        //               2a                     2a
	t1 = (-b + delta) / (2*a);
	t2 = (-b - delta) / (2*a);

	// Find positive solution
	t = t1 > 0 ? t1 : t2;

	// Calculate Intersect Point (O + D*t)
	Intersect.x = Origin.x + Direction.x*t;
	Intersect.y = Origin.y + Direction.y*t;
	Intersect.z = Origin.z + Direction.z*t;

	// Calculate Mapping Coordinates (Radial Coordiantes)
	*u = asin((Intersect.y) / sqrt(sqr(Intersect.x) +
		  sqr(Intersect.y) +	sqr(Intersect.z)))*128+128;
	*v = atan2(Intersect.z, Intersect.x)*256/PI;

	// Calculate Depth
	t = (fabs(Intersect.z) / SPHERE_RADIUS) * 90;
	*z = (char)(t > 63 ? 63 : t);
}

void main()
{
	int i, j;
	char u, v, z;

	mode(0x13);

	// Generate a simple texture or Load one from a file
	init_txtr();

	// Generate a Free-Direction Tunnel
	for (i=0; i<320; i++)
		for (j=0; j<200; j++)
		{
			// Perform RayTracing, calculate mapp. coords. and shadow
			fd_tunnel(i,j,&u,&v,&z);
			// Put pixel from Texture, darken according to shadow
			vga[i + j*320] = texture[u+v*256] * (int)z >> 6;
		}

	delay(3000);

	// Generate Free-Direction Planes
	for (i=0; i<320; i++)
		for (j=0; j<200; j++)
		{
			// Perform RayTracing, calculate mapp. coords. and shadow
			fd_planes(i,j,&u,&v,&z);
			// Put pixel from Texture, darken according to shadow
			vga[i + j*320] = texture[u+v*256] * (int)z >> 6;
		}

	delay(3000);

	// Generate a Free-Direction Sphere
	for (i=0; i<320; i++)
		for (j=0; j<200; j++)
		{
			// Perform RayTracing, calculate mapp. coords. and shadow
			fd_sphere(i,j,&u,&v,&z);
			// Put pixel from Texture, darken according to shadow
			vga[i + j*320] = texture[u+v*256] * (int)z >> 6;
		}

	getchar();

	mode(3);

	cout << "\nFree Direction Rendering\n";
	cout << "Sample Source Code\n";
	cout << "Ohad Eder Pressman aka Kombat/Immortals 1998\n\n";
}
