program PxdTut7;
uses cossin, crt,dos;

{  degrees :                                 map :
                      270
                     1440
                                                 | --------------> X-axis
                                                 |
             180                 0/360           |
             960                 0/1920          |
                                                 |
                                                 |
                       90                        V  Y-axis
                      480



As the field of view is 60 degrees we increase the raycasting angle with
60 / 320 = 0.1875 degrees - therefore there are 360 / 0.1875 = 1920 entries
in the look-up tables and we also base our player-movement on these 1920
possible angles.

The world is a 100 X 100 grid with a grid-size of 64 X 64.
Texture-size is 128 X 128
}

TYPE

  Level =  RECORD
             tilename : Array[1..4] of string;
             map : Array[1..100,1..100] of byte
           END;


  LevelFileT = File of level;

  Table1920realT = Array[0..1920] of real;
  HeightTabT = Array[0..9050] of word;

  Virtual = Array[1..64000] of byte;
  Virscr = ^Virtual;                   {our virtual screen}

  VirtualTex = Array[1..16384] of byte;
  VirTex  = ^VirtualTex;


CONST
 {CONSTANTS FOR ANGLE VALUES OFTEN USED}
 ANG_0   = 0;
 ANG_6   = 32;
 ANG_30  = 160;
 ANG_90  = 480;
 ANG_180 = 960;
 ANG_270 = 1440;
 ANG_360 = 1920;

 {WORLD CONSTANTS}
 GRID_SIZE = 64;          {each cell in the world is 64 X 64 units}
 WORLD_SIZE = 100;        {the world is 100 X 100 cells}
 WORLD_UNIT_SIZE = WORLD_SIZE * GRID_SIZE;
 CEILING_COLOR = 35;
 FLOOR_COLOR   = 165;

 CLOSEST_WALL  = 32;      {how close can we go to a wall}
 HORIZON       = 100;     {guess....}
 VGA           = $A000;    {Segment of our VGA screen}


 {CONSTANTS FOR KEYBOARD-HANDLER - THE SCANCODES :}
 {notice that when you release a key the interrupt sends a 128 + scancode -}
 {hence the stop-codes}
 MOVE_FWD     = 72;          {forward arrow}
 STOP_FWD     = 128 + 72;
 MOVE_BACK    = 80;          {back arrow}
 STOP_BACK    = 128 + 80;
 MOVE_LEFT    = 75;          {left arrow}
 STOP_LEFT    = 128 + 75;
 MOVE_RIGHT   = 77;          {right arrow}
 STOP_RIGHT   = 128 + 77;
 QUIT_VALUE   = 1;           {The ESC key}


var
 {world vars}
 i,dummy : integer;
 ch : char;
 quit : boolean;
 LevelFile : LevelFileT;
 map : level;
 vaddr : word;
 scr2 : virscr;
 Tex1,Tex2,Tex3,Tex4 : virtex;
 TexAddr : Array[1..4] of word;  {Array of adresses of textures     }
 Faddr   : Word;                 {The address of the current texture}


 {look-up tables}
 ScaleTable  : Array[0..319] of real;
 YnextTable  : ^Table1920realT;
 XnextTable  : ^Table1920realT;
 TanTable    : ^Table1920realT;
 HeightTable : ^HeightTabT;

 {player vars}
 PlayerX, PlayerY, PlayerAng : integer;
 dx,dy : integer;                  {for movement}
 XMapPos, YMapPos : integer;       {which map pos are player at ?}


 {keyboard handler}
  OLDKbdHandler : procedure;       {store the original BIOS handler}
  move_dir   : integer;
  turn_value : integer;



{$F+}
PROCEDURE MyKbdHandler;
INTERRUPT;
VAR
 input : byte;
BEGIN
  input := Port[$60];     {port $60 is the data-port of the keyboard }

  case input of
   MOVE_FWD     : move_dir := 1;
   STOP_FWD     : move_dir := 0;
   MOVE_BACK    : move_dir := -1;
   STOP_BACK    : move_dir := 0;
   MOVE_LEFT    : turn_value := -ANG_6;
   STOP_LEFT    : turn_value := 0;
   MOVE_RIGHT   : turn_value := ANG_6;
   STOP_RIGHT   : turn_value := 0;
   QUIT_VALUE   : quit := true;
  end;

  port[$20] := $20;                    {acknowledge the interrupt}
END;
{$F-}


{******************************************************************}
{*      HERE GOES SOME GRAPHIC PROCEDURES / FUNCTIONS             *}
{******************************************************************}

PROCEDURE Display(FName: string;where:word;X,Y : integer);
var
   xsize,ysize : word;
   LoadFile: file;
   i : byte;

begin
    Assign(LoadFile,FName);
    Reset(LoadFile,1);
    BlockRead(loadfile,xsize,2);
    Blockread(loadfile,ysize,2);
    If Xsize=319 THEN
    BlockRead(LoadFile,mem[Where:0+(y*320)],(xsize+1)*(ysize+1))
    Else
    For i:=0 to ysize DO
      Blockread(Loadfile,Mem[Where:(i*320)+(x+(y*320))],Xsize+1);
    Close(LoadFile);
END;

PROCEDURE LoadPal(PalName: string);
TYPE
  ColorRec = record
              r,g,b: byte;
             end;
  PalType = array[0..255] of ColorRec;
  PalFileType = file of PalType;

Var
    PalFile: PalFileType;
    Pal: ^PalType;
    i: integer;
begin
    New(Pal);
    Assign(PalFile,PalName);
    Reset(PalFile);
    Read(PalFile,Pal^);
    Close(PalFile);
    for i := 0 to 255 do
    BEGIN
        Port[$3C8] := i;
        Port[$3C9] := Pal^[i].r;
        Port[$3C9] := Pal^[i].g;
        Port[$3C9] := Pal^[i].b;
    END;
    Dispose(Pal);
end;

PROCEDURE SetPal(Farvenr: byte;R,G,B : Byte);
Assembler;
   asm
      mov    dx,3c8h
      mov    al,[farvenr]
      out    dx,al
      inc    dx
      mov    al,[r]
      out    dx,al
      mov    al,[g]
      out    dx,al
      mov    al,[b]
      out    dx,al
End;


Procedure Clear (Col : Byte;where:word);
Assembler;
     asm
        mov     cx, 32000;
        mov     ax,where
        mov     es,ax
        xor     di,di
        mov     al,[col]
        mov     ah,al
        rep     stosw
      END;



FUNCTION GetPixel(x,y : integer;where :word) : byte;
Assembler;
asm
    mov     ax,[where]
    mov     es,ax         {es peger p $a000}
    mov     bx,[X]        { bx = x }
    mov     dx,[Y]        { dx = y }
    mov     di,bx         { offset = x}
    mov     bx, dx        { bx = dx = y }
    shl     dx, 8
    shl     bx, 6
    add     dx, bx        {dx = y*320 }
    add     di, dx        {offset = x + (y*320) }
    mov     al, es:[di]     {al = farvenr }
end;

PROCEDURE flip(source,dest:word);
ASSEMBLER;
asm
  mov     bx,ds
  mov     ax, dest
  mov     es, ax
  mov     ax, source
  mov     ds, ax
  xor     si, si
  xor     di, di
  mov     cx, 16000
  db      $66
  rep     movsw
  mov     ds,bx
END;


PROCEDURE Loadtexture(Picture : string;nr : integer);
VAR
 i,j : integer;
BEGIN
 Display(picture,Vaddr,0,0);
 For i:=0 to 128 DO
  For j:=0 to 128 DO
   mem[TexAddr[nr]:j+i*128]:=GetPixel(j,i,Vaddr);
 Clear(0,Vaddr);
END;


{*******************************************************************}
{*             CALCULATE THE TABLES FOR THE ENGINE                 *}
{*******************************************************************}

procedure CalcTables;
var
 i : integer;
 angle : real;
begin
  {calc scale-table - this will handle the fisheye effect}
  {this is just the sinus value to the difference between PlayerAngle and}
  {RayAngle - think about it... Some people use an invers cosinus wave.. }
  {but they suck 8)   This works !!!}

  Writeln('Calculating fisheye table');
  angle := 30;
  for i := 0 to 159 do
   begin
    ScaleTable[i] := SinDrg(90-angle);
    angle := angle - 0.1875;
   end;
  for i := 160 to 319 do
   begin
    ScaleTable[i] := SinDrg(90-angle);
    angle := angle + 0.1875;
   end;

 {Calc Ynext-table  -  for easy calculation of Y-step value in the Xray-proc}
 Writeln('Calculating Ynext table');
 angle := 0;
 new(YnextTable);
 for i := 0 to 1920 do
  begin
   If (i = ANG_90) or (i = ANG_270) then YnextTable^[i] := 0 else
   YnextTable^[i] := 64 * TanDrg(angle);
   angle := Angle + 0.1875;
  end;

 {Calc Xnext-Table  -  for easy calculation of X-step value in the Yray-proc}
 Writeln('Calculating Xnext table');
 angle := 0;
 new(XnextTable);
 for i := 0 to 1920 do
  begin
   if (i = ANG_0) or (i = ANG_360) or (i = ANG_180) then XnextTable^[i] := 0
    else
   XnextTable^[i] := 64 / TanDrg(angle);
  angle := angle + 0.1875;
  end;

 {Calc Tantable}
 Writeln('Calculating Tangens table');
 angle := 0;
 new(TanTable);
 for i := 0 to 1920 do
  begin
   If (i = ANG_90) or (i = ANG_270) then TanTable^[i] := 1 else
   Tantable^[i] := TanDrg(angle);
   angle := angle + 0.1875;
  end;


 {calc the HeightTable  -  This contains the scaled height of a wall sliver}
 {based on the distance to it}
 Writeln('Calculating Height table');
 new(HeightTable);
 HeightTable^[0] := 32000; {never allow player THIS close to a wall :)}
 for i:= 1 to 9050 do      {9050 is the max distance in a 100 X 100 world}
  begin
   HeightTable^[i] := Round(10000 / i);
  end;

Writeln('Done calculating tables...');
end;



Procedure DoBackground;
Assembler;
     asm
        mov     cx, 16000;    {cx is our counter register}
        mov     ax,[vaddr]
        mov     es,ax         {we want to draw to vaddr - our background}
        xor     di,di
        mov     al,CEILING_COLOR
        mov     ah,al
        rep     stosw       {clear the first 16000 bytes with ceiling color}
        mov     al,FLOOR_COLOR
        mov     ah,al
        mov     cx,16000    {and the next 16000 with floor-color}
        rep     stosw
     end;


{This functions scans through the map to find X-walls where a X-wall is}
{defined as the sides of the cells pictured below :                    }
{                   _______                                            }
{                  |       |                                           }
{      X-wall ---> |       | <--- X-wall                               }
{                  |-------|                                           }


FUNCTION Xray(x,y : integer; angle : integer; var Xhit : word;
              var Yhit : word;var texcol : byte) : byte;
var
 Xnext : integer;
 Xpos : integer;
 Ypos, Ynext : real;
 Xbeg : integer;
 XmapPos, YmapPos : integer;
 wallfound : boolean;

BEGIN
wallfound := false;
Xbeg := x shr 6 shl 6;  {Xbeg is now left side of current cell}

if (angle = ANG_0 ) or (angle = ANG_180) then
 begin
  Ynext := 0
 end
  else
 begin
  Ynext := YnextTable^[angle];   {get out Ystep value based on ray-angle}
 end;

if (angle > ANG_270) or (angle < ANG_90) then   {looking to the right ?}
 begin    {then we start our casting in RIGHT side of current cell...}
  Xpos := Xbeg + GRID_SIZE;
  Xnext := GRID_SIZE;   {... AND move the the right on map.}
 end
  else
 begin    {looking to the left ?}
  xpos := Xbeg;    {then we start at the LEFT side of current cell...}
  Xnext := - GRID_SIZE; {... AND move to the left on map.}
  Ynext := -Ynext; {this is because Tangens somehow has wrong sign when}
                   {you look to the right.}
 end;

 if (angle = ANG_0) or (angle = ANG_180) then
  Ypos := y
 else
  Ypos := (Xpos-x) * tantable^[angle] + y;  {where in current cell do we}
                                            {begin our ray-casting ??   }

If (Ypos > WORLD_UNIT_SIZE) or (Ypos < 0) then Ypos := 0; {just to be sure...}


repeat
 XmapPos := Xpos shr 6;
 if (angle > ANG_270) or (angle < ANG_90) then inc(XmapPos);
 YmapPos := Round(Ypos) shr 6 + 1; {which cell have we hit with our ray ??}

 If (map.map[XmapPos, YmapPos] > 0) then {we have hit a wall !! :) }
  begin
    wallfound := true;
    Xray := map.map[XmapPos, YmapPos]; {texture number of hit}
    XHit := Xpos;         {X-world coordinate of hit - for distance calc.}
    YHit := Round(Ypos);  {Y-world coordinate of hit - for distance calc.}

    if (angle > ANG_90) and (angle < ANG_270) then
      Texcol := 128-(Yhit + Yhit - ((YmapPos-1) shl 7))
    else
      TexCol := Yhit + Yhit - ((YmapPos-1) shl 7);
   end;

   {this ought to be explained I guess... TexCol is the X coordinate of the}
   {texture sliver we want to use. This is basicly our Yposition in the }
   {cell we hit. If the angle is between 90 and 270 we look to the left}
   {and need to flip the XTexture coodinate - otherwise textures would }
   {always have the same orientation - not cool if a door when seen from}
   {two different sides have the handle in the same side :)             }
   {The reason why I do the Yhit + Yhit is that my textures are 128 X 128 - }
   {and the cells are only 64 units... If you use 64 X 64 textures dont do }
   {this add.}



   Inc(Xpos,Xnext);
   Ypos := Ypos + Ynext;  {advance the ray one step on the map.}


until (wallfound) or (Xpos<0) or (Xpos > WORLD_UNIT_SIZE) or (Ypos <0) or
       (Ypos > WORLD_UNIT_SIZE);

 If not(wallfound) then Xray := 0;
{repeat until we have found a wall - or is outside the world}
end;



{This functions scans through the map to find Y-walls where an Y-wall is}
{defined as the sides of the cells pictured below :                     }
{                                                                       }
{                      | an Y-wall                                      }
{                   ___V___                                             }
{                  |       |                                            }
{                  |       |                                            }
{                  |-------|                                            }
{                                                                      }
{                      | an Y-wall                                      }

FUNCTION Yray(x,y : integer; angle : integer;var Xhit : word;
              var Yhit : word; var texcol : byte) : byte;
{Not commented.... Check the comments for Xray - basicly the same...    }
{only difference is that we move in fixed Yvalues and check for Ywalls  }

VAR
 Ynext, Ypos, Ybeg : integer;
 Xnext, Xpos : real;
 XmapPos, YmapPos : integer;
 wallfound : boolean;

BEGIN
 wallfound := false;
 Ybeg := Y shr 6 shl 6;

 if (angle = ANG_90 ) or (angle = ANG_270) then
 begin
  Xnext := 0
 end
  else
 begin
  Xnext := XnextTable^[angle];
 end;

 If (angle < ANG_180) then
  begin
   Ypos := Ybeg + GRID_SIZE;
   Ynext := GRID_SIZE;
  end
   else
  begin
   Ypos := Ybeg;
   Ynext := - GRID_SIZE;
   Xnext := -Xnext;
  end;

if (angle = ANG_90) or (angle = ANG_270) then
  Xpos := x
 else
  Xpos := (Ypos-y) / TanTable^[angle] + x;

If (Xpos > WORLD_UNIT_SIZE) or (Xpos < 0 ) then Xpos := 0;

repeat
    XmapPos := Round(Xpos) shr 6 + 1;
    YmapPos := Ypos shr 6;
    if (angle < ANG_180) then inc(YmapPos);


  If (map.map[XmapPos, YmapPos] > 0) then
    begin
     wallfound := true;
     Yray := map.map[XmapPos, YmapPos];
     XHit := Round(Xpos);
     YHit := Ypos;

      if (angle > ANG_180) and (angle < ANG_360) then
        TexCol :=Xhit + Xhit  - ((XmapPos-1) shl 7)
      else
        TexCol := 128 - (Xhit + Xhit  - ((XmapPos-1) shl 7));
    end;

   Inc(Ypos,Ynext);
   Xpos := Xpos + Xnext;

 until (wallfound) or (Xpos<0) or (Xpos > WORLD_UNIT_SIZE) or (Ypos <0) or
       (Ypos > WORLD_UNIT_SIZE);

 If not(wallfound) then Yray := 0;
END;




{WHOA!!  Now you have reached the heart of the engine - the calcview proc.}
{This procedure cast the rays, calculates the distance to the walls and draw}
{them using linear texturemapping - but with correct perspective because of}
{the exact XTexture position found by the ray-casting routines}
PROCEDURE CalcView(x,y : integer; PlayerA : integer);
Var
 ViewAngle : integer;
 i : integer;
 XrayXhit, XrayYhit, YrayXhit, YrayYhit : word;
 xdist, ydist : real;
 Xnr,Ynr : byte;
 XTexCol, YTexCol : byte;  {the Xpos in texture returned by the rays}
 height : integer;
 Ytop : integer;
 ScaleStep : word;
 Texpos : word;            {starting Ypos in texture}

BEGIN
ViewAngle := PlayerA - ANG_30; {start looking 30 degrees left from player}
If (ViewAngle < ANG_0) then ViewAngle := viewangle + ANG_360;

for i:=0 to 319 do    {cast 320 rays...}
 begin

 xdist := 9050;  {set xdistance to a ridiculous length}
 ydist := 9050;  {set Ydistance to a ridiculous length}
                 {9050 is max. dist in a 100 X 100 world of 64 X 64 cells}

 if(ViewAngle <> ANG_90) and (ViewAngle <> ANG_270) then
   begin {only fire X-ray if X wall can be found}
    Xnr := Xray(x,y,ViewAngle,XrayXhit,XrayYhit,XtexCol);
    if (Xnr <> 0) then
      Xdist := SQRT((XrayXhit - X)*(XrayXhit - X) + (XrayYhit - Y)*(XrayYhit - Y));
      {now - this is precise, but rather slow... hope to find a better way}
      {of calculating the distance}
   end;

  if(ViewAngle <> ANG_0) and (ViewAngle <> ANG_180) and (ViewAngle <> ANG_360) then
   begin {only fire Y-ray if Ywall can be found}
    Ynr := Yray(x,y,ViewAngle,YrayXhit, YrayYhit,YTexCol);
    if (Ynr <> 0) then
    Ydist := SQRT((YrayXhit - X)*(YrayXhit - X) + (YrayYhit - Y)*(YrayYhit - Y));
    {as said with the Xray - slow but precise..}
   end;


   if (ydist < xdist) then
    begin     {y-wall is closest}

     Faddr := TexAddr[Ynr];
     ydist := ydist * ScaleTable[i];  {use this table to get rid of the }
                                      {fish-eye effect comming from casting}
                                      {from a fixed point..}

     Height := HeightTable^[Round(ydist)]; {Get height of wall-sliver}

     ScaleStep := 16384 DIV height;       {step in 7.9 fixed-point}
     ScaleStep := ScaleStep + ScaleStep;  {step in 8.8 fixed-point}

     Ytop := HORIZON - height shr 1;  {find top Yvalue of wall-sliver}
                                      {this is just half the height above}
                                      {the horizon}


      {here we clip the texture if height is greater than screensize      }
      {this is the point where 50% of the wolfenstein engines out there   }
      {have the most serious flaw !! If they clip the wall-sliver height  }
      {BEFORE calculating the stepvalue in the texture they get a VERY    }
      {ugly effect : When a line is clipped before the step value is      }
      {calculated all clipped lines gets the same step-value - which      }
      {makes it look like the part of the wall that is clipped is viewed  }
      {from the front ! Even though we perhaps see the rest of the wall   }
      {from some angle :)  *SHIVER* VEEEEERY ugly... and VEEEEERY stupid  }
      {done of the programers 8) - but heck! Even Ultima Underwold 1      }
      {suffers from this effect to some degree :)                         }
      {When you - rightly - calculate the step before clipping just       }
      {remember to calculate the right starting Ypos in the texture       }
      {on-screen.                                                         }

      if (Ytop < 0) then
      begin
        TexPos := (0-Ytop * ScaleStep) shr 8; {shr 8 because Scalestep is}
                                              {in 8.8 fixed point        }
        Ytop := 0;
        height := 200;
      end
       else
        TexPos := 0;

     {Here we do the texturemap - it's in assembler but don't worry - }
     {there are PLENTY of coments in the code 8)                      }

     asm
      push ds              {push the data segment - don't forget 8) }

      mov al,YTexCol
      cmp al,0           {is the texture Xpos < 0 - then we clip it to 0 }
      ja @OK1
      mov YTexCol,0
    @OK1:
      cmp al, 128        {is the texture Xpos > 128 - then we clip to 128}
      jb @OK2
      mov YTexCol,128
    @OK2:

      mov bx,vaddr
      mov es,bx          {es = our virtual screen = where to draw        }
      mov bx, Faddr
      mov ds,bx          {ds = the frame page = where to read the texture}

      mov bx, [Ytop]
      mov di, bx
      shl bx,8           {bx = Ytop * 256                              }
      shl di,6           {di = Ytop * 64                               }
      add di,bx          {di = Ytop * 256 + Ytop * 64 = Ytop * 320     }
      add di,[i]         {di = Ytop * 320 + screenX = screenoffset     }

      mov bx, [TexPos]   {bx = texture starting Ypos                   }
      shl bx,7           {bx = texture starting Ypos * 128             }
      add bl, [YTexCol]  {bx = YTexPos * 128 + TexXpos = texture offset}
      mov si,bx          {si = texture offset                          }

      xor bx,bx          {clear bx register}
      mov bx,[TexPos]    {load bx with starting YTexPos                }
      shl bx, 8          {covert the starting YTexPos to 8.8 fixed-p   }
                         {this is because we wanna add a 8.8 fixed-p   }
                         {step value to this register -  things has to }
                         {fit together :)                              }
      mov cx, [height]   {cx = loop register - we loop until height is }
                         {reached}
     @again:
      mov al, ds:[si]    {load the color from the texture into al          }
      mov es:[di], al    {and draw it to the screen                        }
      add di,320         {go 1 pixel down on the screen - add 320 to offset}
      add bx, [ScaleStep]{add scalestep (8.8 FP) to the Ypos in the texture}
      xor dx,dx          {clear dx reg                                     }
      mov dl,bh          {bh = bx / 256 = actual value of Ypos in texture  }
                         {this is just a faster way of doing :             }
                         {        mov dx,bx                                }
                         {        shr dx,8                                 }

      shl dx,7           {dx = Ypos * 128                                  }
      add dl,[YTexCol]   {add The Xpos in the texture found by Yray        }
      mov si,dx          {si = new offset in texture                       }

      dec cx             {decrease or counter register                     }
      cmp cx,0           {has it reaced zero yet ?                         }
      jne @again         {if not jump to the @again label and do another   }
                         {pixel                                            }

      pop ds             {when we're done remember to restore ds           }
     end;
    end
     else
    begin    {X-wall is closest}
      {this part is not commented as it's almost identical to the part }
      {dealing with the Y-walls!                                       }


     Faddr := TexAddr[Xnr];
     Xdist := Xdist * ScaleTable[i];

     height := HeightTable^[Round(Xdist)];
     ScaleStep := 16384 DIV height;          {step in 7.9 fixed-point}
     ScaleStep := ScaleStep + ScaleStep;     {step in 8.8 fixed-point}

     Ytop := HORIZON - height shr 1;
     if (Ytop < 0) then
      begin
        TexPos := (0-Ytop * ScaleStep) shr 8;
        Ytop := 0;
        height := 200;
      end
       else
        TexPos := 0;

     asm
      push ds               {texturemap the sucker...}

      mov al,XTexCol
      cmp al,0
      ja @OK1
      mov XTexCol,0
    @OK1:
      cmp al, 128
      jb @OK2
      mov XTexCol,128
    @OK2:

      mov bx,vaddr
      mov es,bx
      mov bx, Faddr
      mov ds,bx

      mov bx, [Ytop]
      mov di, bx
      shl bx,8
      shl di,6
      add di,bx
      add di,[i]

      mov bx, [TexPos]
      shr bx,1
      add bl, [XTexCol]
      mov si,bx

      xor bx,bx
      mov bx,[TexPos]
      mov cx, [height]
     @again:
      mov al, ds:[si]
      mov es:[di], al
      add di,320
      add bx, [ScaleStep]
      xor dx,dx
      mov dl,bh
      add dx,[TexPos]
      shl dx,7
      add dl,[XTexCol]
      mov si,dx
      dec cx
      cmp cx,0
      jne @again
      pop ds
     end;
    end;


    Inc(ViewAngle); {OK.. one ray is done - and one sliver of wall has been }
                    {drawn. We advance our ray 0.1875 degrees = 1 unit in   }
                    {OUR angle-system and fire another two rays             }
    If (ViewAngle > ANG_360) then ViewAngle := ViewAngle - ANG_360;
  end;
 {WHOA!! We're done with this screen - lets flip it to the VGA and have a   }
 {look - I bet you can hardly wait !! 8) - I could'nt when I first made this}
END;



{************************************************************************}
{*                          MAIN PROGRAM                                *}
{************************************************************************}

begin
ClrScr;
quit := false;
CalcTables;     {calculate fisheye-, Ystep-, Xstep-,Tan- and Height-table}
Writeln('      ****************************************************************');
Writeln('      *                                                              *');
Writeln('      *                 3D ENGINE - WOLFENSTEIN STYLE                *');
Writeln('      *                        by : Telemachos                       *');
Writeln('      *                                                              *');
Writeln('      ****************************************************************');
Writeln;
Writeln('      Hiya!');
Writeln('      Welcome to the Peroxide Programming Tips #7');
Writeln('      This one is on raycasting - the WOLFENSTEIN style.');
Writeln('      Not much to be said about this program. Move around using the');
Writeln('      arrow keys and quit by pressing ESC.');
Writeln;
Writeln('      In this tutorial I have given you a little homework - nice ehh :)');
Writeln('      There are two small errors in the engine I have left for you to');
Writeln('      fix! First : If you look at some corners you see through the wall');
Writeln('      and sees the wall BEHIND the corner - fix it. I''ll give you a ');
Writeln('      little hint - precicion when you hit a border of a cell in the ');
Writeln('      raycasting procedure. Second error : If you walk at a certain angle');
Writeln('      towards a corner the game does''nt clip right - fix it! Hint : ');
Writeln('      What if both DeltaX AND DeltaY gets outside the current cell ??');
Writeln('      Which two cells do you check then ?? ');
Writeln;
Writeln('      Anyway - have fun..... Telemachos                  Press a key...');
readkey;


Assign(levelfile,'pxdtut7.map');
Reset(levelfile);
Read(levelfile,map);
Close(levelfile);

PlayerAng := ANG_270;     {we start looking directly to the north}
PlayerX := 416;
PlayerY := 352;           {set the initial player position }
turn_value := 0;          {we are NOT turning now :)...    }
move_dir := 0;            {...and NOT moving...            }


GetIntVec(9, @OLDKbdHandler);     {save the old BIOS keyboard handler }
SetIntVec(9, Addr(MyKbdHandler)); {and set up our own customized one..}

asm
 mov ax,13h
 int 10h
end;                      { switch to VGA-mode          }

GetMem (Scr2,64000);
vaddr := seg(Scr2^);      { set up our virtual screen   }

GetMem(Tex1,16384);
TexAddr[1] := Seg(Tex1^);
GetMem(Tex2,16384);
TexAddr[2] := Seg(Tex2^);
GetMem(Tex3,16384);
TexAddr[3] := Seg(Tex3^);
GetMem(Tex4,16384);
TexAddr[4] := Seg(Tex4^); {Set up our addresses for the 4 textures}



Loadpal('pxdtut7.pal');   { Load the game palette       }
SetPal(255,0,0,0);        { black out palette entry 255 }

 For i:=1 to 4 DO
    If map.tilename[i] <> '' THEN
        LoadTexture(map.tilename[i],i);  {Load the textures}


{**************************************************************}
{*               HERE IS THE INNER LOOP                       *}
{**************************************************************}

repeat

DoBackGround;                        { draw the floor and sky      }
CalcView(PlayerX,PlayerY,PlayerAng); { calculate and draw the view }
Flip(vaddr,VGA);                     { flip it to VGA              }


{This is the nice part of using a keyboard handler... we can now move in }
{multiple directions AT THE SAME TIME !!                                 }
{The flag turn_value shows us if we are turning currently - and will not }
{be erased before we release the turn-key                                }
{The Move_dir shows us if we are moving and in what dir.. if we stand    }
{still move_dir = 0 and dx and dy will be 0 too - making us to stay in   }
{current position.                                                       }
{The speed_add flag shows us if we are running. If we are a greater      }
{distance will be moved.                                                 }

PlayerAng := PlayerAng + turn_value;
if (PlayerAng < ANG_0) then inc(PlayerAng,ANG_360);
if (PlayerAng > ANG_360) then dec(PlayerAng,ANG_360);

dx := Move_dir * Round(cos(6.28 * PlayerAng / ANG_360)*8);
dy := Move_dir * Round(sin(6.28 * PlayerAng / ANG_360)*8);

XMapPos := (PlayerX) shr 6 + 1;
YMapPos := (PlayerY) shr 6 + 1;    {where on Map is player ?}

PlayerX := PlayerX + dx;
PlayerY := PlayerY + dy;


{Clip player position to the walls and the CLOSEST_WALL constant }
{The idea is to check in the direction we are moving.. If we gets}
{too close to a wall - don't allow that move.                    }


 if (dx > 0) then {walking to the right}
   begin
     if ( map.map[(PlayerX + CLOSEST_WALL) shr 6 + 1][YmapPos] <> 0)
       then
        begin
          PlayerX := XmapPos shl 6 - CLOSEST_WALL;
        end;
   end;

 if (dx < 0) then {walking to the left}
  begin
    if (map.map[(PlayerX - CLOSEST_WALL) shr 6 + 1][YmapPos] <> 0)
     then
      begin
       PlayerX := (XmapPos-1) shl 6 + CLOSEST_WALL;
      end;
  end;


 if (dy > 0) then {walking down on map}
   begin
   if ( map.map[XmapPos][(PlayerY+CLOSEST_WALL) shr 6 + 1] <> 0)
     then
      begin
       PlayerY := YMapPos shl 6 - CLOSEST_WALL;
      end;
   end;

 if (dy < 0) then {walking up on map}
   begin
    if ( map.map[XMapPos][(PlayerY-CLOSEST_WALL) shr 6 + 1] <> 0) then
     begin
      PlayerY := (YmapPos-1) shl 6 + CLOSEST_WALL;
     end;
   end;

until quit;  {repeat until quit is set from the keyboard handler}

asm
 mov ax,03h
 int 10h
end;


SetIntVec(9, @OLDKbdHandler);  {restore the original keyboard handler}

Dispose(YnextTable);
Dispose(XnextTable);
Dispose(TanTable);
Dispose(Heighttable);
FreeMem (Scr2,64000);  {release the memory we have allocated}

Writeln('All done... ');
Writeln('CU in my next tutorial - Telemachos^PXD');
end.