
program CreateCharSet;

uses CharSet;

const fn = 'charset1.chr';

var info : TCharSetInfo;
    f : file of TCharSetInfo;
    x, y : word;
    c : char;

begin
     fillchar(info, sizeof(info), 0);

     info.charmap := 'charset1.pcx';
     info.SizeX := 32;
     info.SizeY := 32;

     for c := '0' to '9' do
     begin
          x := (ord(c) - ord('0')) * 32;
          info.Chars[c].x := x;
          info.Chars[c].y := 128;
     end;

     for c := 'A' to 'Z' do
     begin
          y := ((ord(c) - ord('A')) div 10 + 1) * 32;
          x := ((ord(c) - ord('A')) mod 10) * 32;
          info.Chars[c].x := x;
          info.Chars[c].y := y;
     end;

     for c := ' ' to '''' do
     begin
          x := (ord(c) - ord(' ')) * 32;
          info.Chars[c].x := x;
          info.Chars[c].y := 0;
     end;

     for c := ',' to '.' do
     begin
          x := (ord(c) - ord(',')) * 32;
          info.Chars[c].x := x;
          info.Chars[c].y := 160;
     end;

     for c := ':' to '?' do
     begin
          x := (ord(c) - ord(':') + 3) * 32;
          info.Chars[c].x := x;
          info.Chars[c].y := 160;
     end;

     assign(f, fn);
     rewrite(f);
     write(f, info);
     close(f);
end.

