
program Circulos;
{ Programa que muestra el algoritmo para dibujar crculos }
{ DO NOT COPY & PASTE IT IN YOUR OWN PROGRAM.... }

{ Copyright (C) 2001 FAC }


uses Mode_13, Crt;


type Tabla = array[0..1440] of real;  { tablas trigonomtricas }
     PTabla = ^Tabla;       { apuntador a tabla }

{ Las tablas tienen valores para los ngulos que sean mltiplos
  de 0.25 grados, desde 0 hasta 360 grados.

  Para obtener el valor correcto, utilizar:

       Tabla[angulo*4]
}


var Seno, Coseno : PTabla; { Apuntadores a tablas de senos y cosenos }


procedure GeneraTablas;
{ Este procedimiento reserva memoria para las tablas de senos y cosenos
  y calcula los valores para los ngulos de 0 a 360 grados, con incrementos
  de 0.25 grados }

var ang : real;
    i : integer;
begin
     Seno := new(PTabla); { Reserva memoria para las tablas. }
     Coseno := new(PTabla);
     { No se pueden usar las tablas hasta que se haya reservado la memoria }

     ang := 0; { Angulo inicial }
     i := 0;   { Primer ndice en la tabla }
     while ang <= 360.0 do  { Hacemos un ciclo de 0 a 360 grados }
     begin
          Seno^[i] := sin(ang * 3.14159265 / 180); { calculamos el seno }
          Coseno^[i] := cos(ang * 3.14159265 / 180); { y el coseno }

          ang := ang + 0.25; { Incrementamos el ngulo }
          inc(i); { Incrementamos el ndice }
     end;
end;

procedure Circulo(cx, cy : integer; radio : word; color : byte);
{ Este procedimiento ...... que demonios creen que hace? }

{ (cx, cy) son las coordenadas del centro del crculo }
{ radio y color son .... }

var x, y, i : integer;
begin
     for i := 0 to 1440 do { Hacemos un ciclo de 0 a 360 grados
                             (0 a 1440 segn nuestras tablas }
     begin
          x := cx + round(radio * Coseno^[i]); { coordenada X de un punto }
          y := cy + round(radio * Seno^[i]);   { coordenada Y .... }

          if (x >= 0) and (y >= 0) and (x < 320) and (y < 200)
             then PutPixel(x, y, color);
          { Si el punto est dentro de los lmites de la pantalla,
            entonces lo dibujamos }
     end;
end;

{ empieza el programa principal }

var pal : TPalette; { Aqu vamos a guardar nuestra paleta }
    i : word;
    r0, g0, b0 : byte; { variables auxiliares usadas en la rotacin de paleta }

begin
     clrscr;
     writeln;
     writeln('Ejemplo del algoritmo de crculos y de cmo usar las tablas');
     writeln('precalculadas.');
     writeln;
     writeln('El programa dibuja cuatro crculos rellenos con un degradado');
     writeln('de colores y luego hace una rotacin de la paleta completa para');
     writeln('obtener un efecto psicodlico... muy bonito para una discoteque.');
     writeln;
     writeln('Ya saben que hacer... opriman un tecla...');
     readkey;

     clrscr;
     writeln;
     writeln('Generando tablas trigonomtricas...');
     GeneraTablas;


{ El siguiente ciclo prepara la paleta de colores que se va a usar }
     for i := 0 to 63 do
     begin
          pal[i, 0] := i;  { Hacemos un degradado de magenta en los }
          pal[i, 1] := 0;  { colores del 0 al 63 }
          pal[i, 2] := i;

          pal[i+64, 0] := 0; { Hacemos un degradado de verde en los }
          pal[i+64, 1] := i; { colores del 64 al 127 }
          pal[i+64, 2] := 16;

          pal[i+128, 0] := i; { Hacemos un degradado de amarillo en los }
          pal[i+128, 1] := i; { colores del 128 al 191 }
          pal[i+128, 2] := 0;

          pal[i+192, 0] := 0; { Hacemos un degradado de azul cielo en los }
          pal[i+192, 1] := i; { colores del 192 al 255 }
          pal[i+192, 2] := i;
     end;

     SetMode13;  { Iniciar el modo de video }
     SetPalette(pal); { Activar la paleta }

     for i := 0 to 63 do Circulo(100, 50, 63 - i, i);
     { Dibuja crculos concntricos con centro en (100, 50) y con un
       degradado de colores (de 0 a 63) }
     for i := 0 to 63 do Circulo(220, 150, 63 - i, i + 64);
     { Lo mismo que el ciclo anterior, pero los crculos tienen centro
       en (220, 150) y los colores del 64 al 127 }
     for i := 0 to 63 do Circulo(220, 50, 63 - i, i + 128);
     { Otro ms... }
     for i := 0 to 63 do Circulo(100, 150, 63 - i, i + 192);
     { y otro... }

     readkey; { Espera una tecla }

     while not keypressed do
     begin
          r0 := pal[0, 0];  { Guarda los valores r, g, b del primer color }
          g0 := pal[0, 1];  { en la paleta, para hacer la rotacin }
          b0 := pal[0, 2];

     { El siguiente ciclo desplaza hacia atrs los colores del 0 al 254 }
          for i := 0 to 254 do
          begin
               pal[i, 0] := pal[i+1, 0];
               pal[i, 1] := pal[i+1, 1];
               pal[i, 2] := pal[i+1, 2];
          end;

          pal[255, 0] := r0;  { Pone en el color 255 los valores que }
          pal[255, 1] := g0;  { tena el color 0 anteriormente }
          pal[255, 2] := b0;

          VRetrace;  { Espera al retrazo vertical }
          SetPalette(pal); { y activa la nueva paleta }
     end;

     readkey; { Si se presion una tecla, la lee }

     dispose(Seno); { Libera la memoria ocupada por las tablas }
     dispose(Coseno);

     SetTextMode; { y regresa al modo de texto }
     clrscr;
end.

