
program LlamasAMi;

{ Llamas en resolucin de 160 * 100. Mucho ms rpido que LLAMAS1.PAS
  y an 100% en Pascal. }

uses mode13, crt;

const ColorSemilla = 255;  { Color de los "puntos calientes" }

{ Ahora, en lugar de usar dos pantallas virtuales, usaremos
  dos arreglos de 160 * 100 para generar las llamas. Esto tambin
  ahorra MUCHA memoria (como 90 Kb) }
type PTArreglo = ^TArreglo;
     TArreglo = array[0..99] of array[0..159] of byte;

var Destino, Origen : PTArreglo;  { arreglos Destino y Origen }
    pal : TPalette;


{ Generamos la misma paleta que en LLAMAS1.PAS, pero con humo azul }
procedure GeneraPaleta;
var i : byte;
begin
     for i := 0 to 15 do
     begin
          pal[i][0] := 0;       { nada de rojo }
          pal[i][1] := 0;       { nada de verde }
          pal[i][2] := i;       { aumentamos un poco el azul (humo) }
     end;
     for i := 0 to 15 do
     begin
          pal[i + 16][0] := 0;          { nada de rojo }
          pal[i + 16][1] := 0;          { nada de verde }
          pal[i + 16][2] := 15 - i;     { disminumos el azul (humo) }
     end;
     for i := 0 to 63 do
     begin
          pal[i + 32][0] := i;  { aumentamos el rojo }
          pal[i + 32][1] := 0;  { nada de verde }
          pal[i + 32][2] := 0;  { nada de azul }
     end;
     for i := 0 to 63 do
     begin
          pal[i + 96][0] := 63; { el rojo al mximo }
          pal[i + 96][1] := i;  { aumentamos el verde para formar amarillo }
          pal[i + 96][2] := 0;  { nada de azul }
     end;
     for i := 0 to 63 do
     begin
          pal[i + 160][0] := 63;  { el rojo al mximo }
          pal[i + 160][1] := 63;  { el verde al mximo }
          pal[i + 160][2] := i;   { aumentamos el azul para obtener blanco }
     end;
     for i := 0 to 31 do
     begin
          pal[i + 224][0] := 63;   { disminumos el blanco en }
          pal[i + 224][1] := 63;   { una escala de grises }
          pal[i + 224][2] := 63;   { hasta llegar al negro }
     end;
end;


{ Aqu inicializamos los arreglos origen y Destino, y ponemos algunos
  "puntos calientes" en la ltima lnea del arreglo origen }
procedure IniciaLlamas;
var x : word;
begin
     { Reservamos memoria para los arreglos }
     Destino := new(PTArreglo);
     Origen := new(PTArreglo);

     { Llenamos los arreglos con ceros }
     FillChar(Destino^, 16000, 0);
     FillChar(Origen^, 16000, 0);

     { Generamos la ltima lnea del arreglo origen }
     for x := 0 to 159 do Origen^[99][x] := random(2) * ColorSemilla;
end;


{ Este procedimiento realiza el efecto }
procedure MueveLlamas;
var x, y : word;
    color : integer;
begin
     { El recorrido se hace ahora dentro de los lmites de los arreglos }
     for y := 0 to 97 do
         for x := 1 to 158 do
         begin
              { Tomamos la suma de los cuatro colores adyacentes }
              color := Origen^[y][x] + Origen^[y+2][x] +
                       Origen^[y+1][x-1] + Origen^[y+1][x+1];

              { Dividimos entre cuatro y disminumos en 1 }
              color := (color shr 2) - 1;

              { Comprobamos que color no sea negativo }
              if color < 0 then color := 0;

              { Y almacenamos el color en el arreglo destino }
              Destino^[y][x] := color;
         end;

     { Copiamos el arreglo destino al origen }
     move(Destino^, Origen^, 16000);

     { Y generamos nuevos "puntos calientes" en la lnea inferior }
     for x := 0 to 159 do Origen^[98][x] := random(2) * ColorSemilla;

     { Generamos una pequea "explosin" dibujando una regin caliente }
{
     x := random(157);
     Origen^[94][x] := 255; Origen^[94][x+1] := 255; Origen^[94][x+2] := 255;
     Origen^[95][x] := 255; Origen^[95][x+1] := 255; Origen^[95][x+2] := 255;
     Origen^[96][x] := 255; Origen^[96][x+1] := 255; Origen^[96][x+2] := 255;
}
end;


{ Puesto que los arreglos origen y destino NO son pantallas virtuales,
  no podemos hacer algo como CopyScreen(Destino, VGA); sino que tenemos
  que implementar un procedimiento que dibuje las llamas en VGA a partir
  del arreglo destino. Recuerden que cada punto en el arreglo destino
  representa un bloque de 2 * 2 pxels en la pantalla. }
procedure Destino_A_VGA;
var off, x, y, color : word;
begin
     off := 0;  { Offset inicial en la pantalla VGA }

     { La razn por la que y no va de 0 a 99 es porque las ltimas lneas
       del arreglo destino estn llenas con muchos "puntos calientes" al
       azar y no tienen una forma consistente, por lo tanto, no las dibujamos }
     for y := 0 to 95 do
     begin
          for x := 0 to 159 do
          begin
               { Movemos el color del punto a los bytes superior e
                 inferior de la variable color }
               color := word(Destino^[y][x]) shl 8 + Destino^[y][x];
               { Dibujamos 2 pxels utilizando MemW }
               memw[VGA:off] := color;
               { Dibujamos los 2 pxels en la lnea siguiente }
               memw[VGA:off+320] := color;
               inc(off, 2); { Incrementamos el offset en 2 }
          end;
          inc(off, 320); { Y nos "brincamos" una lnea }
     end;
end;


{ Programa principal }
begin
     clrscr;
     writeln;
     writeln(' Efecto de llamas utilizando una resolucin menor (160 * 100)');
     writeln(' para lograr mayor velocidad.');
     writeln;
     writeln('...');
     readkey;

     randomize;  { Generamos una nueva semilla para los nmeros aleatorios }
     GeneraPaleta; { Generamos la paleta }
     SetMode13; { Iniciamos el modo grfico }
     SetPalette(pal); { Activamos la paleta }
     IniciaLlamas; { Inicializamos las llamas }

     { Hacemos el efecto hasta que se oprima una tecla }
     while not keypressed do
     begin
          MueveLlamas;
{          VRetrace; }  { Des-comentar esta lnea en caso de parpadeos }
          Destino_A_VGA;
     end;

     readkey; { Leemos la tecla oprimida }
     SetTextMode; { Regresamos al modo texto }
     dispose(Origen); { Y liberamos la memoria de los arreglos }
     dispose(Destino);
end.