uses crt;

procedure setcol (nr, r, g, b: byte); assembler;
asm
  mov dx, 3c8h
  mov al, nr
  out dx, al
  inc dx
  mov al, r
  out dx, al
  mov al, g
  out dx, al
  mov al, b
  out dx, al
end;

var x, y: word;
    z, r, g, b: byte;
    buf: array [0..319, 1..3] of byte;
    f: file;

procedure init13h_320x200xtruepal;
{ initialize mode }
begin
  asm
    mov ax, 13h
    int 10h
  end;
  for x := 0 to 255 do begin
    z := x;
    r := (z shr 5) * 9;
    g := (z shr 2 and 7) * 9;
    b := (z and 3) * 21;
    setcol (z, r, g, b);
  end;
end;

procedure pixel (x, y: word; r, g, b: byte);
{ read, green and blue values may range between 0 and 255 }
begin
  mem [$a000: y * 320 + x] :=
    (r div 32 shl 5) + (g div 32 shl 2) + (b div 64);
end;

begin
  init13h_320x200xtruepal;
  assign (f, 'train.tga');
  reset (f, 1);
  blockread (f, buf, 18);
  for y := 199 downto 99 do begin
    blockread (f, buf, sizeof (buf));
    for x := 0 to 319 do
      pixel (x, y, buf [x, 3], buf [x, 2], buf [x, 1]);
  end;
  for y := 98 downto 0 do begin
    blockread (f, buf, sizeof (buf));
    for x := 0 to 319 do begin
      if buf [x, 3] < 191 then inc (buf [x, 3], 64) else buf [x, 3] := 255;
      if buf [x, 2] < 191 then inc (buf [x, 2], 64) else buf [x, 2] := 255;
      if buf [x, 1] < 191 then inc (buf [x, 1], 64) else buf [x, 1] := 255;
      pixel (x, y, buf [x, 3], buf [x, 2], buf [x, 1]);
    end;
  end;
  close (f);
  asm
    mov ah, 0
    int 16h
    mov ax, 3
    int 10h
  end;
end.