program ColorCyclePlasma;

uses crt;

var n       : byte;
    Palette : array[0..767] of byte;

function newcol(mc,n,dvd:integer) : byte;
begin
  newcol := ((mc+n-random(n)) div dvd) mod 192;
end;

procedure subdivide(x1,y1,x2,y2:word);
var x,y,dxy,n1,n2,n3,n4 : word;

begin
  if (x2-x1 < 2) and (y2-y1 < 2) then exit;
  x := (x2+x1) div 2;
  y := (y2+y1) div 2;
  n1 := mem[$A000:320*y1+x1];
  n2 := mem[$A000:320*y2+x1];
  n3 := mem[$A000:320*y1+x2];
  n4 := mem[$A000:320*y2+x2];
  dxy := 5 * (x2-x1+y2-y1) div 3;
  if mem[$A000:320*y1+x] = 0 then mem[$A000:320*y1+x] := newcol(n1+n3,dxy,2);
  if mem[$A000:320*y+x1] = 0 then mem[$A000:320*y+x1] := newcol(n1+n2,dxy,2);
  if mem[$A000:320*y+x2] = 0 then mem[$A000:320*y+x2] := newcol(n3+n4,dxy,2);
  if mem[$A000:320*y2+x] = 0 then mem[$A000:320*y2+x] := newcol(n2+n4,dxy,2);
  mem[$A000:320*y+x] := newcol(n1+n2+n3+n4,dxy,4);
  subdivide(x1,y1,x,y);
  subdivide(x,y1,x2,y);
  subdivide(x1,y,x,y2);
  subdivide(x,y,x2,y2);
end;

procedure SetPal(col,r,g,b:byte);
begin
  port[$3C8] := col;
  port[$3C9] := r;
  port[$3C9] := g;
  port[$3C9] := b;
end;

procedure RotatePalette;
var Temp : array[0..2] of byte;

begin
  repeat
    move(Palette,Temp,3);
    move(Palette[3],Palette[0],765);
    move(Temp,Palette[765],3);
    for n := 0 to 255 do setpal(n,Palette[n*3],Palette[n*3+1],Palette[n*3+2]);
  until keypressed;
end;


begin
  randomize;
  asm mov ax,13h; int 10h end;  { In Mode 13h schalten }
  fillchar(Palette,768,0);      { Palette erstellen }
  for n := 0 to 255 do begin
    Palette[n*3+1] := n div 2;
    Palette[n*3+2] := n;
    setpal(n,0,n div 2,n);
  end;
  subdivide(0,0,319,199);       { Plasma aufbauen }
  RotatePalette;                { Palette rotieren }
  readkey;
  asm mov ax,3; int 10h end;    { Zurck zum Textmodus }
end.
