//
// File        : TEST2.C
// Description : Vesa Bios Extention 2.0 test2 file
// Notes       : Brought to you by Vertigo. If you use this, or have
//               learned from this, send us an email and/or Greet us
//               In your demo =).
//
//

#include "STDIO.H"
#include "STDLIB.H"
#include "CONIO.H"
#include "VGOVBE20.H"

VBESURFACE * myScreen;

//
// Main entry point
//
void main(void)
{
  VBEINFO *vbeInfo;
  unsigned short * lfb;
  int i,scanWidth;
  long x,y;

  // Detect the VBE bios

  if( (vbeInfo = vbeDetect()) == NULL )
  {
    printf("Can't find VESA bios extentions\n");
    exit(0);
  }

  // Check for VBE 2.0

  if( vbeInfo->VbeVersion < 0x200 )
  {
    printf("VESA bios extention 2.0 or better needed\n");
    exit(0);
  }

  // Try a nice simple resolution,
  // we won't scan the mode list as this
  // is just a simple test

  myScreen = vbeOpen(320,240,16);

  if(myScreen == NULL)
  {
    printf("Could not set 320x240 16bpp mode\n");
    exit(0);
  }

  // Randomly fill the whole of gfx mem with dots

  lfb = (unsigned short *)myScreen->lfb;

  for(i=0;i< (vbeInfo->TotalMemory*64000)/2 ;i++)
    ((short *)lfb)[i] = i&31;


  // Do a little scroll test

  x=0,y=0;
  scanWidth = (vbeInfo->TotalMemory*64000) / (200*2);

  vbeSetScanWidth( scanWidth );

  while( !kbhit() )
  {
    vbeSetDisplayStart(x,y);
    x++;
    vbeVr(); //wait for Vretrace so this doesnt ZOOOOOM
    if( x >= scanWidth ) x=0;
  }


  vbeClose( myScreen ); 
  printf("Nice crappy little example of using VESA 2.0. Enjoy! \n");
}

