
*********************************************************
*                                                       *
*  txtmode, ymode and xmode : three useful routines to  *
*    enable X and Y modes, and get back to a text one   *
*       (c)oderight LCA/Infiny and Jedi/Sector One      *
*                                                       *
*********************************************************

* Back to the 80x25/16 mode

txtmode push a
        move #3,a
        trap #$10
        pop a
        rts

* Y-mode : 320x200/256 - 4 pages

ymode   push a
        push d

        bsr vsync

        move #$13,a
        trap #$10

        move #$3c4,d
        move.b #4,a
        out.b a,d
        inc.b d
        in.b d,a
        and.b #255-8,a
        or.b #4,a
        out.b a,d

        move #$3ce,d
        move.b #6,a
        out.b a,d
        inc.b d
        in.b d,a
        and.b #255-2,a
        out.b a,d

        move #$3d4,d
        move.b #$14,a
        out.b a,d
        inc.b d
        in.b d,a
        and.b #255-64,a
        out.b a,d

        dec.b d
        move.b #$17,a
        out.b a,d
        inc.b d
        in.b d,a
        or.b #64,a
        out.b a,d

        pop d
        pop a
        rts

* X-Mode: 320x240/256 - 4 pages

xmode   push a
        push d
        bsr ymode

        move #$3c4,d
        move #$100,a
        out a,d

        move #$3c2,d
        move.b #%11100011,a
        out.b a,d

        move #$3d4,d
        move #$300,a
        out a,d

        move #$3d4,d
        move.b #$11,a
        out.b a,d
        inc d
        in.b d,a
        and.b #%01111111,a
        out.b a,d
        dec d
        move #$d06,a
        out a,d
        move #$3e07,a
        out a,d
        move #$4109,a
        out a,d
        move #$ea10,a
        out a,d
        move #$ac11,a
        out a,d
        move #$df12,a
        out a,d
        move #$e715,a
        out a,d
        move #$616,a
        out a,d

        pop d
        pop a
        rts

* Wait for the vertical frame

vsync   push a
        push d
        move #$3da,d
.vswait in.b d,a
        test.b #8,a
        beq.s .vswait
        pop d
        pop a
        rts
