#ifndef __DOS_H__
#define __DOS_H__

#include <stddef.h>

extern void int86(byte i,union REGS *rin,union REGS *rout);
extern void int86x(byte i,union REGS *rin,union REGS *rout,struct SREGS *sreg);
extern void int386(byte i,union REGS *rin,union REGS *rout);
extern void int386x(byte i,union REGS *rin,union REGS *rout,struct SREGS *sreg);

extern word errno;

extern sword open(byte *strg,word acc);
extern void close(word hand);
extern word creat(byte *strg,word attr);
extern sdword read(word hand,void* buf,dword len);
extern sdword write(word hand,void* buf,dword len);
extern sdword lseek(word hand,dword pos,byte typ);
extern tell(word hand);
extern filelength(word hand);
extern eof(word hand);
extern unlink(byte * strg);
extern getdisk();
extern setdisk(byte drv);
extern mkdir(byte * strg);
extern chdir(byte * strg);
extern rmdir(byte * strg);
extern rename(byte * old,byte * new);
extern getcwd(byte * buf);
extern getdcwd(byte drv,byte * buf);
extern findfirst(byte* str1,word attr,void * ffb);
extern findnext(void* ffb);

extern void gettime(struct time*);
extern void settime(struct time*);
extern void getdate(struct date*);
extern void setdate(struct date*);

#ifndef SEEK_SET

#define SEEK_SET 0   // Seeks from beginning of file
#define SEEK_CUR 1   // Seeks from current position
#define SEEK_END 2   // Seeks from end of file

#define S_IWRITE 0x080     // owner may write  (ignored by QLIB - always writable)

#define O_NOINHERIT 0x80
#define O_DENYALL   0x10
#define O_DENYWRITE 0x20
#define O_DENYREAD  0x30
#define O_DENYNONE  0x40

#define O_BINARY   0        // Binary mode
#define O_RDONLY   0        // Read only                                   
#define O_WRONLY   1        // Write only                                  
#define O_RDWR     2        // Read and write                              

#define O_CREAT     0x0100  /* create and open file */
#define O_TRUNC     0x0200  /* open with truncation */
#define O_EXCL      0x0400  /* exclusive open */
#define O_APPEND    0x0800  /* to end of file */

#define FA_NORMAL   0x00        /* Normal file, no attributes */
#define FA_RDONLY   0x01        /* Read only attribute */
#define FA_HIDDEN   0x02        /* Hidden file */
#define FA_SYSTEM   0x04        /* System file */
#define FA_LABEL    0x08        /* Volume label */
#define FA_DIREC    0x10        /* Directory */
#define FA_ARCH     0x20        /* Archive */

#endif  //SEEK_SET

struct BYTEREGS  {
  byte  al, ah;  word _1;
  byte  bl, bh;  word _2;
  byte  cl, ch;  word _3;
  byte  dl, dh;  word _4;
};

struct WORDREGS  {
  word  ax,_1;
  word  bx,_2;
  word  cx,_3;
  word  dx,_4;
  word  si,_5;
  word  di,_6;
  word  cflag,_7;
};

struct DWORDREGS  {
  dword  eax, ebx, ecx, edx;
  dword  esi, edi, cflag;
};

union REGS {
  struct  DWORDREGS  x;
  struct  WORDREGS  w;
  struct  BYTEREGS  h;
};

// NOTE: int86x() & int386x() ignores ss,cs
struct SREGS {
  word  es;
  word  cs;
  word  ss;
  word  ds;
  word  fs;
  word  gd;
};

struct ffblk {
  byte ff_reserved[21]; /* reserved by DOS */
  byte ff_attrib;       /* attribute found */
  word ff_ftime;        /* file time */
  word ff_fdate;        /* file date */
  dword ff_fsize;        /* file size */
  byte ff_name[13];     /* found file name */
};

struct time {
  byte ti_min;   /* minutes */
  byte ti_hour;  /* hours */
  byte ti_hund;  /* hundredths of seconds */
  byte ti_sec;   /* seconds */
};

struct date {
  word da_year;     /* current year */
  byte da_day;     /* day of the month */
  byte da_mon;     /* month (1 = Jan) */
};

#endif
