.data
  ust mouse_user <>
.code
;this proc is called every time the mouse moves or a button is pressed/released
;NOTE:this is called in an IRQ!!  (so don't do any file IO, ok? - just
;don't do anything that calls DOS)
user_text proc
  mov ax,ust.x
  mov bx,ust.y
  mov cx,ust.but
;the following changes the mouse ptr if it's in the BOX
;Here the screen is 0-640 and (0-200 or 0-400)
;so I must change Cell Numbers into Pixel Numbers by mult by 8
  .if (ax>12*8-1) && (ax<24*8) && (bx>12*8-1) && (bx<24*8)
    callp mouse_setcursor_text,(4 shl 4)  ;red
  .else
    callp mouse_setcursor_text,(1 shl 4)  ;blue
  .endif
  ret
user_text endp

text_test proc
  call clrscr
top:
  callp printf,"Text Mode Tests\n\n"
  callp printf," 1) 80x25\n"
  callp printf," 2) 80x50\n"
  callp printf," Q) Quit to main\n:>"
@@:
  call getch
  callp toupper,al
  .if al=='1'
    callp t_setmode,80,25
    mov x,80
    mov y,25
    call do_text
    jmp top
  .endif
  .if al=='2'
    callp t_setmode,80,50
    mov x,80
    mov y,50
    call do_text
    jmp top
  .endif
  .if al=='Q'
    ret
  .endif
  jmp @b
text_test endp

do_text proc
  callp gotoxy,1,13
  callp printf,"            +----------+\n"
  callp printf,"            | User     |\n"
  callp printf,"            | Defined  |\n"
  callp printf,"            | Area     |\n"
  callp printf,"            |          |\n"
  callp printf,"            |          |\n"
  callp printf,"            |          |\n"
  callp printf,"            |          |\n"
  callp printf,"            |          |\n"
  callp printf,"            |          |\n"
  callp printf,"            |          |\n"
  callp printf,"            +----------+"
  callp gotoxy,1,1
  callp mouse_setuser,offset user_text,offset ust

  callp mouse_setcursor_text,(1 shl 4)  ;blue

  callp printf,"Video Mode %dx%d %dbit\n",x,y,bpp

  callp printf,"Press keys to move on...\n"
  callp printf,"Mouse Window : (50,50)-(100,100)\n"

  callp mouse_setwin,50,50,100,100  ;must reset size before mouse_on
  callp mouse_setspd,1,1
  call mouse_on
  call sleep

  callp printf,"Full Window\n"
  mov ebx,x
  mov ecx,y
  shl ebx,3    ;x/y is in cells so I must convert to Pixels (*8)
  shl ecx,3
  dec ebx
  dec ecx
  callp mouse_setwin,0,0,ebx,ecx
  call sleep

  callp printf,"Half Speed\n"
  callp mouse_setspd,2,2
  call sleep

  callp printf,"Move mouse to (100,100)\n"
  callp mouse_setpos,100,100
  call sleep

  callp printf,"Hold in buttons to change color:\n"
  callp printf,"Press a key to quit\n"
  mov ccol,63
  .repeat
    mov cx,ust.but
    .if (cl & 1)
      inc ccol
    .endif
    .if (cl & 2)
      dec ccol
    .endif
    .if ccol==64
      mov ccol,0
    .elseif ccol==255
      mov ccol,63
    .endif
    callp g_setcol,1,0,0,ccol    ;change blue color
    callp g_setcol,4,ccol,0,0    ;change red color
    call kbhit
  .until al
  call getch
done:
  call mouse_off
  callp t_setmode,80,25
  ret
do_text endp

