{$A+,B-,D+,E+,F-,G+,I-,L+,N+,O-,R-,S-,V-,X+}
{$M 16384,0,655360}
(* ------------------------------- GFV.PAS ---------------------------- *)
(* Bye Jare/Iguana. Want more comments? Write'em! :-)                   *)
(* This is quite a big shit! Really! But cracks data like a beast!      *)

USES
   Crt, Objects;

TYPE
   TVGAScr = ARRAY [0..199,0..319] OF BYTE;
VAR
   VGAScr : TVGAScr ABSOLUTE $A000:0000;


TYPE
   TPal = ARRAY[1..768] OF BYTE;
VAR
   fpal : FILE OF TPal;
   pal  : TPal;
   thereIsPal : BOOLEAN;

PROCEDURE DumpPal(VAR p: TPal); ASSEMBLER;
   ASM
      MOV DX,3C8h
      XOR AX,AX
      OUT DX,AL
      INC DX
      MOV CX,768
      PUSH DS
      LDS SI,p
   @@l:
       OUTSB
       LOOP @@l
      POP DS
   END;

PROCEDURE SetVMode;
   BEGIN
      ASM
           MOV     AX,13h
           INT     10h

           MOV     DX,3C8h
           XOR     AX,AX
           OUT     DX,AL
           INC     DX
           MOV     CX,64
         @@l1:
           OUT     DX,AL
           OUT     DX,AL
           OUT     DX,AL
           INC     AL
           LOOP    @@l1

           XOR     AX,AX
           MOV     CX,64
         @@l2:
           MOV     AL,AH
           OUT     DX,AL
           XOR     AL,AL
           OUT     DX,AL
           OUT     DX,AL
           INC     AH
           LOOP    @@l2

           XOR     AX,AX
           MOV     CX,64
         @@l3:
           XOR     AL,AL
           OUT     DX,AL
           MOV     AL,AH
           OUT     DX,AL
           XOR     AL,AL
           OUT     DX,AL
           INC     AH
           LOOP    @@l3

           XOR     AX,AX
           MOV     CX,64
         @@l4:
           XOR     AL,AL
           OUT     DX,AL
           OUT     DX,AL
           MOV     AL,AH
           OUT     DX,AL
           INC     AH
           LOOP    @@l4
      END;
      IF thereIsPal THEN
         DumpPal(pal)
   END;


PROCEDURE Prompt(VAR s: STRING; VAR v : INTEGER);
   LABEL
      SkipKeyb;
   BEGIN
      REPEAT
         ASM
            MOV AX,3
            INT 10h
         END;
         Write(s);
         ASM
          @@c:
            MOV AH,1
            INT 16h
            JZ  @@c
            CMP AL,13
            JNZ @@c1
            XOR AX,AX
            INT 16h
            JMP SkipKeyb
          @@c1:
         END;
         ReadLn(v);
SkipKeyb:
      UNTIL v > 0;
   END;

PROCEDURE PromptLong(VAR s: STRING; VAR v : LONGINT);
   LABEL
      SkipKeyb;
   BEGIN
      REPEAT
         ASM
            MOV AX,3
            INT 10h
         END;
         Write(s);
         ASM
          @@c:
            MOV AH,1
            INT 16h
            JZ  @@c
            CMP AL,13
            JNZ @@c1
            XOR AX,AX
            INT 16h
            JMP SkipKeyb
          @@c1:
         END;
         ReadLn(v);
SkipKeyb:
      UNTIL v >= 0;
   END;

{ -------------------------------------------------- }

TYPE
   BUF = ARRAY [1..64000] OF BYTE;
VAR
   bye : BOOLEAN;
   key : CHAR;
   p   : ^BUF;
   scr : BUF ABSOLUTE $a000:0000;
   f   : TDosStream;
   pos, oldp, len : LONGINT;
   olds, step : INTEGER;
   oldh, hsiz : INTEGER;
   i : INTEGER;
   s, pr : STRING;


PROCEDURE DoSavingProc;
   VAR
      len : LONGINT;
      fn  : STRING;
      fd  : TDosStream;
   BEGIN
      f.Reset;
      f.Seek(pos);
      len := 0;
      pr := 'Enter number of bytes to save into GFVDUMP.BIN: ';
      PromptLong(pr, len);
      IF len > 0 THEN BEGIN
         fd.Init('GFVDUMP.BIN', stCreate);
         REPEAT
            IF len > 64000 THEN BEGIN
               FillChar(p^, 64000, #0);
               f.Read(p^, 64000);
               fd.Write(p^, 64000);
               len := len - 64000
            END ELSE BEGIN
               f.Read(p^, len);
               fd.Write(p^, len);
               len := 0
            END
         UNTIL len = 0;
         fd.Done
      END;
      oldh := 0;                { Force redraw. }
      SetVMode
   END;


PROCEDURE ShowPage;
   VAR
      off : WORD;
      shs : WORD;
      i, j : INTEGER;
      post : LONGINT;
   BEGIN
      f.Reset;
      f.Seek(pos);
      post := pos;
      off := 32768+1;
      IF hsiz > 320 THEN
         shs := 320
      ELSE
         shs := hsiz;
      FOR i := 0 TO 199 DO BEGIN
         IF KeyPressed THEN
            EXIT;
         FOR j := 0 TO shs-1 DO BEGIN
            IF off > 32768 THEN BEGIN
               FillChar(p^, 32768, #0);
               IF (len - post) >= 32768 THEN BEGIN
                  f.Read(p^, 32768);
                  post := post + 32768
               END ELSE BEGIN
                  f.Read(p^, len - post);
                  post := len
               END;
               off := off - 32768
            END;
            VGAScr[i,j] := p^[off];
            off := off + step;
         END;
         IF shs < 320 THEN
            FOR j := shs TO 319 DO
               VGAScr[i,j] := 0;
         IF hsiz > 320 THEN
            off := off + step*(hsiz-320)
      END
   END;


PROCEDURE Usage;
   BEGIN
      WriteLn(#13#10,
              'Graphical File Viewer v2.01 bye Jare/Iguana'#13#10,
              'Views a file in mode 13h. Useful for finding graphic data, etc.'#13#10,
              #13#10,
              '   Usage: GFV <file.ext> [palette file]'#13#10,
              '          If not given, palette is set to 64 shades of Gray,'#13#10,
              '             then Red, Green and Blue.'#13#10,
              #13#10,
              '   Browse with movement keys.'#13#10,
              '   ''<'', ''>'' & ''5'' - set horizontal shift.'#13#10,
              '   ''-'' & ''+''      - change byte step in file (for word data etc).'#13#10,
              '   ''O''            - get/set new file offset.'#13#10,
              '   ''S''            - save a portion of the file to GFVDUMP.BIN.'#13#10,
              '   Space          - Redraw the screen.')
   END;

BEGIN
   IF ParamCount < 1 THEN BEGIN
      Usage;
      HALT(1)
   END;
   s := ParamStr(1);
   IF (s[1] IN ['-','/', '?']) OR
      (s[2] IN ['-','/', '?']) THEN BEGIN
       Usage;
       HALT(1)
   END;
   f.Init(s, stOpenRead);
   IF f.Status <> stOk THEN BEGIN
      Usage;
      WriteLn(#13#10'ORROR: file ', s, ' not found!');
      HALT(1)
   END;

   NEW(p);
   oldp := 0;
   pos  := 0;
   len  := f.GetSize;
   olds := 0;
   step := 1;
   oldh := 0;
   hsiz := 320;

   thereIsPal := FALSE;
   IF ParamCount > 1 THEN BEGIN
      Assign(fpal, ParamStr(2));
      Reset(fpal);
      IF IOResult = 0 THEN BEGIN
         Read(fpal, pal);
         IF IOResult = 0 THEN
            thereIsPal := TRUE;
         Close(fpal)
      END
   END;

   SetVMode;

   bye := FALSE;
   REPEAT
      IF (hsiz <> oldh) OR (pos <> oldp) OR (step <> olds) THEN BEGIN
         ShowPage;
         oldp := pos;
         oldh := hsiz;
         olds := step
      END;
      key := ReadKey;
      IF key = #0 THEN BEGIN
         key := ReadKey;
         CASE key OF
             #80 : key := '2';
             #75 : key := '4';
             #77 : key := '6';
             #72 : key := '8';
             #79 : key := '1';
             #71 : key := '7';
             #82 : key := '0';
             #83 : key := '.';
             #81 : key := '3';
             #73 : key := '9'
             ELSE
                key := #0
         END
      END;
      CASE UpCase(key) OF
         '9': BEGIN
                 DEC(pos,LONGINT(step)*200*hsiz);
                 IF pos < 0 THEN
                    pos := 0
              END;
         '3': IF pos < len THEN INC(pos,LONGINT(step)*200*hsiz);
         '7': pos := 0;
         '1': BEGIN
                 pos := len - LONGINT(step)*200*hsiz;
                 IF pos < 0 THEN
                    pos := 0
              END;
         '4': BEGIN
                 DEC(pos,step);
                 IF pos < 0 THEN
                    pos := 0
              END;
         '6': IF pos < len THEN INC(pos, step);
         '8': BEGIN
                 DEC(pos,LONGINT(hsiz)*step);
                 IF pos < 0 THEN
                    pos := 0
              END;
         '2': IF pos < len THEN INC(pos, LONGINT(hsiz)*step);

         '0', '<': IF hsiz > 1 THEN
                  DEC(hsiz);
         '.', '>': IF pos < len THEN INC(hsiz);

         '-': IF step > 1 THEN DEC(step);
         '+': INC(step);
         '5': BEGIN
                 Str(hsiz, pr);
                 pr := 'Enter desired horizontal shift (normal = 320, current = '
                       + pr + '): ';
                 Prompt(pr, hsiz);
                 oldh := 0;     { Force redraw. }
                 SetVMode
              END;

         #27: bye := TRUE;

         'O': BEGIN
                 Str(pos, pr);
                 pr := 'Enter new file position, current = '
                       + pr + '): ';
                 PromptLong(pr, pos);
                 oldh := 0;     { Force redraw. }
                 SetVMode
              END;

         'S': DoSavingProc;

         ' ': oldh := 0         { Force redraw. }

         ELSE BEGIN
            sound(1000);
            ASM
               MOV  CX,10000
              @@w:
               LOOP @@w
            END;
            nosound
         END
      END
   UNTIL bye;

   f.Done;
   ASM
        MOV     AX,3
        INT     10h
   END;
   WriteLn('Your situation at exit was the following:');
   WriteLn('    File:      ', ParamStr(1));
   WriteLn('    Position:  ', pos);
   WriteLn('    Width:     ', hsiz);
   WriteLn('    Byte step: ', step);
   WriteLn;
   WriteLn('Did you see something interesting?')
END.

(* -------------------------- End of GFV.PAS -------------------------- *)
