;ͻ
; Program      : VFIXPPSL.ASM                                               
; Author       : Sebastian Schuberth                                        
; Description  : Adjusts pixels per scan line to match the x resolution     
;Ķ
; Created on   : 11.06.1998                                                 
; Last revised : 11.06.1998                                                 
;ͼ

                 .MODEL TINY
                 .CODE

                 ORG    0100h

Start:           jmp    Main

Signature        DW     'VF'                          ; The signature.

SetModeFlag      DB     0                             ; Indicates a "mode set".

CallHandler      PROC   NEAR                          ; Call the old handler.
                 pushf
                 DB     9Ah
BIOSHandler      DD     ?
                 ret
CallHandler      ENDP

VESAHandler      PROC   FAR
                 cmp    ax,4F02h                      ; Is this a VESA mode set
                 jne    NotSetMode                    ; call? No -> skip!

                 mov    cs:[SetModeFlag],1            ; Set flag for later use.

                 push   ax es di cx
                 dec    ax                            ; Get mode information.
                 mov    cx,bx
                 push   cs
                 pop    es
                 mov    di,OFFSET ModeInfoBlock
                 call   CallHandler
                 pop    cx di es ax

NotSetMode:      call   CallHandler                   ; Call the old handler.

                 shr    cs:[SetModeFlag],1            ; Evaluate & delete flag.
                 jnc    Done

                 push   ax bx cx
                 mov    ax,4F06h                      ; Set pixels per scan
                 xor    bl,bl                         ; line.
                 mov    cx,cs:[ModeInfoBlock+18]
                 call   CallHandler
                 pop    cx bx ax

Done:            iret
VESAHandler      ENDP

ModeInfoBlock    LABEL  WORD

InfoMsg          DB     'VFIXPPSL 1.00 by Sebastian Schuberth, compiled on JUN 11 1998.',0Dh,0Ah,'$'
InstallMsg       DB     'VFIXPPSL has been installed to memory. Execute again to remove it.',0Dh,0Ah,'$'
RemoveMsg        DB     'VFIXPPSL has been removed from memory. Thanks for using it.',0Dh,0Ah,'$'

Main:            mov    ah,09h                        ; Print InfoMsg.
                 mov    dx,OFFSET InfoMsg
                 int    21h

                 mov    ax,3510h                      ; Get current handler.
                 int    21h
                 cmp    es:[Signature],'VF'           ; Already installed?
                 je     Remove                        ; Yes -> remove it!

                 mov    WORD PTR [BIOSHandler],bx     ; Save current handler.
                 mov    WORD PTR [BIOSHandler+2],es

                 mov    ax,2510h                      ; Set our new handler.
                 mov    dx,OFFSET VESAHandler
                 int    21h

                 mov    ah,49h                        ; Free environment block
                 mov    es,ds:[002Ch]                 ; to save some bytes.
                 int    21h

                 mov    ah,09h                        ; Print InstallMsg.
                 mov    dx,OFFSET InstallMsg
                 int    21h

                 mov    dx,OFFSET ModeInfoBlock+256   ; Go resident and reserve
                 int    27h                           ; extra memory for MIB.

Remove:          push   ds
                 mov    ax,2510h                      ; Restore old handler.
                 lds    dx,es:[BIOSHandler]
                 int    21h
                 pop    ds

                 mov    ah,49h                        ; Free memory used by
                 int    21h                           ; our TSR.

                 mov    ah,09h                        ; Print RemoveMsg.
                 mov    dx,OFFSET RemoveMsg
                 int    21h
                 ret
                 END    Start