/* Graphics routines for initialization */

#include "draw.h"
#include "svga.h"
#include <i86.h>
#include <stdlib.h>
#include <stdio.h>

UsedModeInfo usedmode;
unsigned int lastbank;

int InitGraphics(unsigned short mode)
{
  union REGS inregs,outregs;
  VBE_modeInfo minfo;

  if (mode == grmode_320x200) { /* MCGA */
     /* Init graphics mode: */
     inregs.w.ax=0x13;
     int386(0x10, &inregs, &outregs);
     /* Save information: */
     usedmode.linear = True;
     usedmode.linwindow = 0xA0000;
     usedmode.width = 320;
     usedmode.height = 200;
     return 0; /* No errors */
  } else { /* SVGA */
    SV_Init();
    if (!VBE_getModeInfo(mode,&minfo))
      return 1; /* Mode does not exist */
    else {
      usedmode.linear = ((minfo.ModeAttributes & vbeMdLinear) == vbeMdLinear);
      if (usedmode.linear) {
        usedmode.linwindow = minfo.PhysBasePtr;
        SV_SetMode(mode | vbeLinearBuffer);
      } else SV_SetMode(mode);
      usedmode.width = minfo.XResolution;
      usedmode.height = minfo.YResolution;
      return 0; /* No errors */
    }
  }
}

void disable(void);
void enable(void);
#pragma aux disable =  "cli"
#pragma aux enable =   "sti"

void SetColor(unsigned char c,unsigned char r,unsigned char g,unsigned char b)
{
  disable();
  outp(0x3c8,c);
  inp(0x80);
  outp(0x3c9,r);
  inp(0x80);
  outp(0x3c9,g);
  inp(0x80);
  outp(0x3c9,b);
  enable();
}

void TextMode(void)
{ /* Enter textmode co80 */
 union REGS inregs,outregs;

 inregs.w.ax=0x3;
 int386(0x10, &inregs, &outregs);
}
