; Keyboard INT 9 replacement vector by Patch - hamell@cs.pdx.edu
; Taken from my source KBDHANDx.ZIP ... this is from an older version

.model small

.code
PUBLIC          _keys
                _keys           db      256 dup(0)
PUBLIC          _keynumpress
                _keynumpress    db      0
oldint9         dd      0
e0flag          db      0

                        PUBLIC  _Set_New_Int9
_Set_New_Int9           PROC    
                push    ds
                push    si
                cli

                mov     ax,3509h                ; get old INT 9
                int     21h
                mov     si,offset oldint9
                mov     word ptr cs:[si],bx        ; save offset
                mov     word ptr cs:[si + 2],es    ; save segment

                mov     ax,2509h                ; set new INT 9
                mov     dx,seg _New_Int9
                mov     ds,dx
                mov     dx,offset _New_Int9
                int     21h

                sti
                pop     si
                pop     ds
                ret
_Set_New_Int9           ENDP

                        PUBLIC  _Set_Old_Int9
_Set_Old_Int9           PROC    
                push    ds
                push    si
                cli

                mov     si,offset oldint9
                mov     dx,word ptr cs:[si]        ; load offset
                mov     ds,word ptr cs:[si + 2]    ; load segment
                mov     ax,2509h                ; set new INT 9
                int     21h

                sti
                pop     si
                pop     ds
                ret
_Set_Old_Int9           ENDP

_New_Int9       PROC    FAR
                push    ax
                push    bx

                in      al,60h
                
                cmp     al,0E0h         ; was it an E0 key?
                jne     setscancode

; E0 key routine
                mov     cs:[e0flag],128
                
                mov     al,20h          ; Send generic EOI to PIC
                out     20h,al          ; 001 00 000
                                        ; |   |  | 
                                        ; |   |  +---- INT request level
                                        ; |   +------- OCW2
                                        ; +----------- non-specific EOI command
                pop     bx
                pop     ax
                iret

setscancode:    mov     bl,al                   ; save scan code
                and     bl,01111111b
                add     bl,cs:[e0flag]
                xor     bh,bh                   ; clear for index use
                and     al,10000000b            ; keep break bit, if set
                xor     al,10000000b            ; flip bit - 1 means pressed
                                                ;          - 0 means released
                rol     al,1                    ; put it in bit 0
                mov     cs:_keys[bx],al            ; set index for key
                mov     cs:[e0flag],0              ; set E0 to 0
                shl     al,1                    ; set to 2 or 0
                dec     al                      ; 1 = press, -1 = release
                add     cs:[_keynumpress],al       ; inc or dec keypress

                mov     al,20h          ; Send generic EOI to PIC
                out     20h,al          ; 001 00 000
                                        ; |   |  | 
                                        ; |   |  +---- INT request level
                                        ; |   +------- OCW2
                                        ; +----------- non-specific EOI command
                pop     bx
                pop     ax
                iret
_New_Int9       ENDP

                END
