#include <alloc.h>
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <math.h>
#include <mem.h>
#include <sound.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <wgt4.h>
#include <wgt3d.h>

extern color pal1[256];
extern color pal2[256];
extern color blackpal[256];
extern int i,x,y,j;
extern block virt, virt2, virt3;
extern int sortlist[50];
extern block data;
extern int ctr;
extern int music_on;

typedef struct {	 /* Used to keep track what portion of the */
  int x1,y1,x2,y2;	 /* screen has been changed, so we can update */
  } rect;		 /* the least amount of video memory */
extern rect lastrect,thisrect;


void draw_land_plasma(void);

/* Landscape Engine - written by Chris Egerter */

#define SCREEN_WIDTH 256
#define HSCREEN_WIDTH 128
#define SCREEN_HEIGHT 30

block gum;
block landscape;

int posx,posy;  /* Player's location */

char c;
float hgt;

block texture;

int ox[320];
unsigned char oc[320];
 

int pspy[50];
long ff[50];
int dxy[50];
int dxx[320];

void gen_plasma(void);
void draw_plasma(void);
extern float teller;
extern int plasmatype;

extern long memleft;

void showmem(void)
{
 wsetmode(3);
 printf("%lu",farcoreleft());
 getch();
 vga256();
}

void calc_tables(void)
{
int i;
long x,y,z;

for (i=1; i<SCREEN_HEIGHT; i++)
 {
  pspy[i] = (long)5900/(SCREEN_HEIGHT-i+15)-20;
  ff[i] = (long)20024/(SCREEN_HEIGHT-i+15);
  dxy[i] = (int)(i+30);
 }

for (i=0; i<SCREEN_WIDTH; i++)
   dxx[i] = (long)(i-160) * 1510 / 100;
}


void wvline(int x, int y, int y2, unsigned char col)
{
block temp;
int length;

if (y < ty) y = ty;
else if (y > by) y = by;
if (y2 < ty) y2 = ty;
else if (y2 > by) y2 = by;
temp = abuf + y*320 + x;
length = y2 - y + 1;

asm {
  push ds
  mov cx,length
  lds si, temp
  mov al, col
  }
vlineloop:
;
asm {
  mov [ds:si],al
  add si,320
  loop vlineloop
  pop ds
  }
}


void generate_table(void)
{
unsigned int x,y;
unsigned int dsx;
unsigned int dx;
int *gumptr;
int *gumptr2;

int ofs;

/*
ofs = 0;

for (y = 1; y < SCREEN_HEIGHT; y++)
 {
  for (x = 0; x < SCREEN_WIDTH; x++)
  {
   dx = dxx[x] / dxy[y] - 55;

   dsx = y*320+dx;
   memcpy(&gum[ofs], &dsx, 2);
   ofs += 2;
  }
 }

gumptr = &gum[0];
gumptr2= &gum[2];
*gumptr = *gumptr2;
gumptr++;
gumptr2++;

for (y = 1; y < SCREEN_HEIGHT; y++)
  for (x = 0; x < SCREEN_WIDTH; x++)
  {
   *gumptr = *gumptr2 - *gumptr;
   gumptr++;
   gumptr2++;
  }

 /* Writes the land data to disk */
 landdata = fopen ("gn.004", "wb");
 fwrite (gum, SCREEN_WIDTH * SCREEN_HEIGHT * 2, 1, landdata);
 fclose (landdata);
 */

 /* Reads the land data into memory. */
 gum = lib2buf("gn.004");
}




void draw_rays (void)
{
int startx, starty;
int x, y;
long perspy;
long f;
int colr;
int dx;
int nx;
int *gumptr;
block mapptr;

wsetscreen(virt);
for (y = 0; y < 200; y++)
 {
  wsetcolor(y+128);
  wline(0,y,SCREEN_WIDTH,y);
 }

for (x = 0; x < SCREEN_WIDTH; x++)
  ox[x] = 199;

gumptr = gum;

mapptr = landscape + 4 + posy*320 + posx;

for (y = 1; y < SCREEN_HEIGHT; y++)
 {
 perspy = pspy[y] - y * hgt;
 f = ff[y];
 for (x = 0; x < SCREEN_WIDTH; x++)
  {
   mapptr+= *gumptr++;
   colr = *mapptr;

   nx = perspy - ((long)colr * f>>10);
   if (nx > ox[x])
     wvline (x, ox[x], nx, colr);
   ox[x] = nx;
  }
 }

wcopyscreen (0, 0, SCREEN_WIDTH-2, 198, virt, 32, 0, NULL);
}

extern MS *m;			/* Music Structure */


void draw_volumebars (void)
{
int curvol;

    wsetscreen (landscape);
    for(i = 0; i < 8; i++)	/* For every channel in song */
    {
      m = mGetMS (i);			/* Get music structure */
      curvol = m->DecVolume+5;
      wsetcolor (curvol);
      wbar (120 + i * 10, 100, 120 + i * 10 + 10, 105);
    }
}



void start_landscape(void)
{
int xdir, ydir;
int fadectr;
int ctr;

wnormscreen();
wcls(0);
wloadpalette("lands.pal",pal1);
wsetrgb(0,0,0,0,pal1);
landscape = wloadpak("lands.pak");
calc_tables();
virt = wnewblock (0,0, 319,199);
wtextcolor(1);

posx = 225;
posy = 94;
xdir = -1;
ydir = -1;
fadectr = 0;
ctr = 0;

//gum = farmalloc(SCREEN_WIDTH * SCREEN_HEIGHT * 2);
generate_table();

fadectr = 64;
if (!music_on)
  ctr = 200;

do
 {
  if (music_on)
    draw_volumebars ();

  if (ctr > 200)
  {
  posx += xdir;
  if (posx > 320)
    xdir = -1;
  if (posx < 0)
    xdir = 1;

  posy += ydir;
  if (posy > 170)
    ydir = -1;
  if (posy < 60)
    ydir = 1;
  }

  draw_rays ();

 if ((kbhit()) || (ctr == 432))
   {
    while (kbhit()) getch();
    fadectr = -64;
    for (i=0; i<256; i++)
     wsetrgb(i,0,0,0,blackpal);
    wreadpalette(0,255,pal1);
   }
 if (fadectr > 0)
  {
   wfade_between_once (0, 255, blackpal, pal1);
   wsetpalette(0,255,blackpal);
   fadectr--;
  }

 if (fadectr < 0)
  {
   wfade_between_once (0, 255, pal1, blackpal);
   wsetpalette(0,255,pal1);
   fadectr++;
   if (fadectr == 0)
     ctr = 500;
  }
 ctr++;
 } while (ctr < 500);


  posx = 140;
  posy = 0;
  ctr = 0;
  hgt = -2.5;

  fadectr = 64;
  wloadpalette("ocean.pal",pal1);
  wfreeblock (landscape);
  landscape = wnewblock(0,0,319,30);
  gen_plasma();

 if (farcoreleft () < memleft)
   memleft = farcoreleft ();
  
do
 {
  draw_land_plasma();
  draw_rays ();
//  wnormscreen();
//  wputblock(0,0,landscape,0);

 if ((kbhit()) || (ctr == 232))
  {
   while (kbhit()) getch();
   fadectr = -64;
   for (i=0; i<256; i++)
    wsetrgb(i,0,0,0,blackpal);
   wreadpalette(0,255,pal1);
  }

 if (fadectr > 0)
  {
   wfade_between_once (0, 255, blackpal, pal1);
   wsetpalette(0,255,blackpal);
   fadectr--;
  }

 if (fadectr < 0)
  {
   wfade_between_once (0, 255, pal1, blackpal);
   wsetpalette(0,255,pal1);
   fadectr++;
   if (fadectr == 0)
     ctr = 300;
  }
 ctr++;

 } while (ctr < 300);
while (kbhit()) getch();

wfreeblock (gum);
wfreeblock (virt);
wfreeblock (landscape);
farfree(data);
}

void gen_plasma(void)
{
 FILE *plasmadata;

 randomize();
/* data = (unsigned char*)farmalloc(65535l);
 if (!data)
  {
    printf("Not enough free memory.\n\n");
    exit(1);
  }*/
    wtextcolor(15);

 /*
 for (x=1; x<256; x++)
  for (y=0; y<256; y++)
   data[x+256*y]=(unsigned char)(16*(3+(cos(0.32*sqrt((x-128)*(x-128)+(y-128)*(y-128))))+
       cos(x/11.0)+cos(y/26.0)));

 /* Writes the plasma data to disk */
 plasmadata = fopen ("gn.003", "wb");
 fwrite (data, 65535L, 1, plasmadata);
 fclose (plasmadata);
 */

 /* Reads the plasma data into memory. */
 data = lib2buf("gn.003");
}

void draw_land_plasma(void)
{
int pl1, pl2;

teller++;

if (teller > 30000) teller = 0;

pl1=48+cos(teller/37)*47.0+256*(int)(48+47*(sin(teller/31)));
pl2=48+sin(teller/84)*47.0+256*(int)(48+47*(cos(teller/19)))-pl1;
                asm .386
                asm les di,landscape
                asm add di,4
		asm push ds
		asm lds si,data
		asm add si,pl1
		asm mov bx,pl2
		asm mov cl,30
l1: asm mov dx,160
l2: asm lodsb
		asm add al,[si+bx]
                asm mov ah, al
		asm stosw
		asm dec dx
		asm jnz l2
		asm add si,256-160
		asm dec cl
		asm jnz l1
		asm pop ds

}

int px[4] = {0, 319, 319, 0};
int py[4] = {0,   0, 199, 199};
/* Original source points */

int rx[4], ry[4];
/* Source points after rotation and sin wave warping */
long lsin[360], lcos[360];

void lcalc_sin(void)
{
int i;
 for (i = 0; i < 360; i++)
 {
  lsin[i] = sin(3.1415 * ((double)i / 180.0)) * 1024;
  lcos[i] = cos(3.1415 * ((double)i / 180.0)) * 1024;
 }
} 


void rotatepoly(int centx, int centy, int rot)
/* Rotates the 4 corners of the texture source points, given the center of
   rotation and the rotational amount. */
{
 int i;
 int x, y;
 int x2, y2;

 for (i = 0; i <= 3; i++)
  {
   x = px[i] - centx;	/* Subtract the centers */
   y = py[i] - centy;  /* so coordinates are based around (0,0) */
                                         
   x2 = ((long)x * lcos[rot] - (long)y * lsin[rot]) >> 10;
   y2 = ((long)x * lsin[rot] + (long)y * lcos[rot]) >> 10;
   /* Apply the 2D rotation */

   rx[i] = x2 + centx;
   ry[i] = y2 + centy;
   /* Add the centers back on */
  }
}

/*
ͻ
 Fire Cube  by Chris Egerter, March 18, 1994                     
 --------------------------------------------------------------- 
 This is a simple piece of code that uses the 3D library from    
 WGT to rotate a cube.  The cube is drawn in three ways:         
 1.  Flat shaded (using filled polygons)                         
 2.  Flat shaded on a background screen, then used this screen   
     as a texture for each of the sides.                         
 3.  Fire is drawn on the background screen, and again texture   
     mapping is used.                                            
                                                                 
 Since only 3 sides of the square can be seen at any time, we    
 draw the 3 closest sides only.  This dramatically speeds up     
 the animation.                                                  
                                                                 
 Each face has a center reference point which is used for        
 sorting.  This point is located in the center of each face.     
 When sorting the facing from back to front, we sort by these    
 reference points.  This eliminates the need to find the average 
 Z coordinate of the face each frame (for sorting).              
ͼ
*/

#define CUBE_SIZE 50

point3d firecube[8] = {
	  {-50, -50, 50}, {50, -50, 50}, {50, 50, 50}, {-50, 50, 50},
	  {-50, -50, -50}, {50, -50, -50}, {50, 50, -50}, {-50, 50, -50}};
/* Contains the original points of the cube */

point3d firerotated[8];
/* Contains the points after they are rotated */

point3d normref[6] = {
          {0, 0, 50}, {0, 0, -50}, {-50, 0, 0}, {50, 0, 0},
          {0, -50, 0}, {0, 50, 0}};
/* Center reference point for each face of the cube */

point3d rotref[6];
/* Contains the reference points after rotation */

//int sortlist[6];

int facelist[6][4] = { {0,1,2,3}, {4,5,6,7}, 
                       {0,3,7,4}, {1,2,6,5},
		       {0,1,5,4}, {2,3,7,6}};
/* List of faces, made up of 4 vertices */

tpolypoint mypoly[4];
/* A polygon structure for holding 4 vertices */

extern int curx, cury, curz;

block fireblock;
int e;

int firebuffer[56][80];
int *fireptr;

unsigned int k,l;
int delta;
char ch;

void clear_lastfire (void)
/* Clear out the last area defined by the dirty rectangle */
{
 /* Do clipping for smallest area update */
 if (lastrect.x1 < 0)
     lastrect.x1 = 0;
 if (lastrect.x2 > 319)
     lastrect.x2 = 319;
 if (lastrect.y1 < 0)
     lastrect.y1 = 0;
 if (lastrect.y2 > 199)
     lastrect.y2 = 199;
 wsetcolor (0);
 wbar (lastrect.x1, lastrect.y1, lastrect.x2, lastrect.y2);
 /* Clear out the area that was drawn in last frame */
}

void update_screenfire (void)
{
 /* Copy the area defined by the dirty rectangle to the visual screen */
 if (lastrect.x1 > thisrect.x1)
     lastrect.x1 = thisrect.x1;
 if (lastrect.x2 < thisrect.x2)
     lastrect.x2 = thisrect.x2;
 if (lastrect.y1 > thisrect.y1)
     lastrect.y1 = thisrect.y1;
 if (lastrect.y2 < thisrect.y2)
     lastrect.y2 = thisrect.y2;
 /* See if the previous frame was larger in any direction. If it is, enlarge
    the area so it will copy black over the previous frame. */

 /* Do clipping */
 if (lastrect.x1 < 0)
     lastrect.x1 = 0;
 if (lastrect.x2 > 319)
     lastrect.x2 = 319;
 if (lastrect.y1 < 0)
     lastrect.y1 = 0;
 if (lastrect.y2 > 199)
     lastrect.y2 = 199;

 wcopyscreen (lastrect.x1, lastrect.y1, lastrect.x2, lastrect.y2, virt,
	      lastrect.x1, lastrect.y1, NULL);
 /* Copy from our second page to the visual page. */

 lastrect.x1 = thisrect.x1;
 lastrect.y1 = thisrect.y1;
 lastrect.x2 = thisrect.x2;
 lastrect.y2 = thisrect.y2;
 /* Make the last rectangle = current rectangle */
}

int fire_sort_function (const void *a, const void *b)
/* Sort the faces based on the center reference point (after rotation) */
{
  if (rotref[*(int *)a].z < rotref[*(int *)b].z)
     return -1;
  else return 1;
}

unsigned char transparentfire=1;

void do_fire (void)   
/* Changes the animating fire pattern */
{
     // transform the current buffer
     asm mov cx,4399;
     _DI = (unsigned int)&firebuffer[0][0];
     asm xor ax,ax
     asm add di,160
D1:
     asm mov ax,ds:[di-2]
     asm add ax,ds:[di]
     asm add ax,ds:[di+2]
     asm add ax,ds:[di+160]
     asm shr ax,2
     asm jz D2

     asm sub ax,1
     asm jz D2
     asm sub ax,1
     asm jz D2
     asm sub ax,1

D2:
     asm add al, transparentfire	
     asm mov word ptr ds:[di-160],ax
     asm add di,2
     asm dec cx
     asm jnz D1;

     // Set new bottom line with random white or black color
     delta = 0;
     for(j=0;j<80;j++)   // {set new bottom line}
	{
        if (transparentfire == 0)
   	 {
	  if(random(60) < 710-ctr)
	    delta=random(2)*255;
          else
            delta = 0;
          }
        else
	  if(random(10) < 5)
	    delta=random(2)*255;

	firebuffer[54][j]=delta;
	firebuffer[55][j]=delta;
	}

     // Write the buffer to the screen
     _SI=(unsigned int)&firebuffer[0][0];
     asm les di, fireblock
     asm add di, 4
     asm mov dx,50
F2:
;
     asm mov cx,80
F1:
;
     asm mov al,[ds:si]
     asm stosb
     asm inc si
     asm inc si
     asm loop F1
     asm dec dx
     asm jnz F2
}


void firerotate_loop (void)
/* Rotation loop for the flat shaded cube */
{
int i;
int x, y, z;
int sorted;

 wsetscreen (virt);

 ctr = 0;
 do 
  {
   ctr++;
   if (ctr < 126)	/* Zoom in */
     origin_z += 32;

   if (ctr > 200)	/* Increase the rotation a little */
    {
     curx += 1;
     cury += 2;
    }
   if (ctr > 350)	/* Increase the rotation some more */
    {
     cury++;
     curz+=3;
    }
   if ((ctr > 450) && (ctr < 530))	/* Zoom out */
     origin_z -= 50;
     
   if (curx > 359) curx -= 360;	/* Wrap around rotations */
   if (cury > 359) cury -= 360;
   if (curz > 359) curz -= 360;

   thisrect.x1 = 319; thisrect.y1 = 199; thisrect.x2 = 0; thisrect.y2 = 0;
   clear_lastfire ();

   wsetrotation (curx, cury, curz);
   wrotatepoints (firecube, firerotated, 8);
   wrotatepoints (normref, rotref, 6);

   for (i = 0; i < 6; i++)
     sortlist[i] = i;
   qsort ((int *)sortlist, 6, 2, fire_sort_function);

   for (i = 3; i < 6; i++)
    { 
     sorted = sortlist[i];
     for (e = 0; e < 4; e++)
      {
       x = firerotated[facelist[sorted][e]].x;
       y = firerotated[facelist[sorted][e]].y;
       z = firerotated[facelist[sorted][e]].z;

       if (x < thisrect.x1)
	 thisrect.x1 = x;
       if (x > thisrect.x2)
	 thisrect.x2 = x;

       if (y < thisrect.y1)
	 thisrect.y1 = y;
       if (y > thisrect.y2)
	 thisrect.y2 = y;
       /* See if the polygon is larger than the current area to update.
	  If it is, enlarge the area so all polygons fit inside. */
       mypoly[e].x = x;
       mypoly[e].y = y;
       mypoly[e].sx = ((z - origin_z) * 2 + 70);
      }

//     wsetcolor ((rotref[sorted].z - origin_z) * 3 + 40);
//     /* Get a color based on the distance */
//     wsolidpoly (mypoly, 4, 0, 0, NULL);
     wgouraudpoly (mypoly, 4, 0, 0);
    }

   wretrace ();
   update_screenfire ();
   if (kbhit ())
    ctr = 754;
  } while (ctr < 754);

 while (kbhit ()) getch ();
}


void firerotate_loop2 (void)
/* Rotation loop for the texture mapped fire cube */
{
int *fp;
int *fp2;
int i;
int x, y, z;
int sorted;

 wsetscreen (virt);

 mypoly[0].sx = 0;	/* Set up the texture source points */
 mypoly[0].sy = 0;
 mypoly[1].sx = 79;
 mypoly[1].sy = 0;
 mypoly[2].sx = 79;
 mypoly[2].sy = 49;
 mypoly[3].sx = 0;
 mypoly[3].sy = 49;

 ctr = 0;

 do
  {
   do_fire ();

   ctr++;
   if (ctr < 126)
     origin_z += 32;
 
   if (ctr > 200)
     cury += 3;
   if (ctr > 350)
    {
     curx += 3;
     cury++;
     curz += 5;
    }
   if ((ctr > 650) && (ctr < 730))
    {
     transparentfire = 0;
     origin_z += 3;
    }
//    origin_z -= 50;

   if (curx > 359) curx -= 360;
   if (cury > 359) cury -= 360;
   if (curz > 359) curz -= 360;

   thisrect.x1 = 319; thisrect.y1 = 199; thisrect.x2 = 0; thisrect.y2 = 0;
   clear_lastfire ();

   wsetrotation (curx, cury, curz);
   wrotatepoints (firecube, firerotated, 8);
   wrotatepoints (normref, rotref, 6);

   for (i = 0; i < 6; i++)
     sortlist[i] = i;
   qsort ((int *)sortlist, 6, 2, fire_sort_function);

   for (i = transparentfire*3; i < 6; i++)
    { 
     sorted = sortlist[i];
     for (e = 0; e < 4; e++)
      {
       x = firerotated[facelist[sorted][e]].x;
       y = firerotated[facelist[sorted][e]].y;

       if (x < thisrect.x1)
	 thisrect.x1 = x;
       if (x > thisrect.x2)
	 thisrect.x2 = x;

       if (y < thisrect.y1)
	 thisrect.y1 = y;
       if (y > thisrect.y2)
	 thisrect.y2 = y;
       /* See if the polygon is larger than the current area to update.
	  If it is, enlarge the area so all polygons fit inside. */
       mypoly[e].x = x;
       mypoly[e].y = y;
      }
     wtexturedpoly (mypoly, 4, 0, 0, fireblock, !transparentfire);
    }

   wretrace ();
   update_screenfire ();
   if ((kbhit ()) && (ctr < 650))
     ctr = 650;
  } while (ctr < 730);
 
 while (kbhit ()) getch ();
}


void firerotate_loop3(void)
/* Rotation loop for the flat shaded and texture mapped cube */
{
int i;
int x, y, z;
int sorted;
int textrot=0;
int clloop,cldir;

 wsetscreen (virt);
 lcalc_sin();

 /* set up the texture source points */
 px[0] = 110;
 py[0] = 40;
 px[1] = 209;
 py[1] = 40;
 px[2] = 209;
 py[2] = 158;
 px[3] = 110;
 py[3] = 158;

 ctr = 0;

 wsetscreen (virt2);
 clloop = 3;
 cldir = 8;
 for (i = 0; i <= 199; i++)	/* Draw a shaded background */
  {
   wsetcolor (clloop);
   clloop+=cldir;
   if (clloop > 64)
      cldir = -4;
   if (clloop < 4)
      cldir = 4;
   whline (0, 319, i);
  }
 wsetscreen (virt);
 wcls (0);

 do 
  {
   ctr++;
   if (ctr < 126)
     origin_z += 32;

   if (ctr > 200)
     cury+=3;
   if (ctr > 350)
    {
     curx += 3;
     cury++;
     curz += 5;
     textrot+=2;
    }
   if ((ctr > 650) && (ctr < 954))
     origin_z -= 50;
 
   textrot+=2;
   if (textrot > 359) textrot -= 360;

   if (curx > 359) curx -= 360;
   if (cury > 359) cury -= 360;
   if (curz > 359) curz -= 360;

   rotatepoly(160,100,textrot);
   for (i=0; i<4; i++)
     {
      mypoly[i].sx = rx[i];	/* set up the texture source points */
      mypoly[i].sy = ry[i];
     }

   thisrect.x1 = 319; thisrect.y1 = 199; thisrect.x2 = 0; thisrect.y2 = 0;
   clear_lastfire ();

   wsetrotation (curx, cury, curz);
   wrotatepoints (firecube, firerotated, 8);
   wrotatepoints (normref, rotref, 6);

   for (i = 0; i < 6; i++)
     sortlist[i] = i;
   qsort ((int *)sortlist, 6, 2, fire_sort_function);

   wsetscreen (virt2);
   clloop = 3;
   cldir = 8;
 for (i = 0; i <= 199; i++)	/* Draw a shaded background */
   {
     /* Clear out the last dirty rectangle */
     wsetcolor (clloop);
     clloop+=cldir;
     if (clloop > 64)
      cldir = -4;
     if (clloop < 4)
      cldir = 4;
   if ((i >= lastrect.y1) && (i <= lastrect.y2))
     whline (lastrect.x1, lastrect.x2, i);
   }

   for (i = 3; i < 6; i++)
    { 
     sorted = sortlist[i];
     for (e = 0; e < 4; e++)
      {
       x = firerotated[facelist[sorted][e]].x;
       y = firerotated[facelist[sorted][e]].y;
  
       if (x < thisrect.x1)
	  thisrect.x1 = x;
       if (x > thisrect.x2)
	  thisrect.x2 = x;
 
       if (y < thisrect.y1)
	  thisrect.y1 = y;
       if (y > thisrect.y2)
	  thisrect.y2 = y;
       /* See if the polygon is larger than the current area to update.
	  If it is, enlarge the area so all polygons fit inside. */
       mypoly[e].x = ((x - 160)/2)+160;
       mypoly[e].y = ((y - 100)/2)+100;
      }

     wsetcolor ((rotref[sorted].z - origin_z) * 3 + 40);
     wsolidpoly (mypoly, 4, 0, 0, NULL);
    }
  wsetscreen (virt);
  for (i = 3; i < 6; i++)
   { 
    sorted = sortlist[i];
    for (e = 0; e < 4; e++)
     {
      x = firerotated[facelist[sorted][e]].x;
      y = firerotated[facelist[sorted][e]].y;

      if (x < thisrect.x1)
	thisrect.x1 = x;
      if (x > thisrect.x2)
	thisrect.x2 = x;
 
      if (y < thisrect.y1)
	thisrect.y1 = y;
      if (y > thisrect.y2)
	thisrect.y2 = y;
      /* See if the polygon is larger than the current area to update.
	 If it is, enlarge the area so all polygons fit inside. */
      mypoly[e].x = x;
      mypoly[e].y = y;
     }

    wtexturedpoly (mypoly, 4, 0, 0, virt2, 0);
   }

   wretrace ();
   update_screenfire ();
   if (kbhit ())
     ctr = 954;
  } while (ctr < 954);

while (kbhit ()) getch ();
}


void start_firecube (void)
/* Begin the main routine for the rotating cubes */
{
 int rr,gg,bb;

 wnormscreen ();
 wclip (0, 0, 319, 199);
 wcls (0);

 // firebuffer = farmalloc (59*85*2);
 /* Used to hold the fire image */

 wloadpalette ("firecube.pal", pal1);
 for (i = 0; i < 256; i++)
   wsetrgb (i, 0, 0, 0, blackpal);
 for (i = 0; i < 64; i++)
  {
   wfade_between_once (0, 255, blackpal, pal1);
   wsetpalette (0, 255, blackpal);
   for (j = 0; j < 100; j++);
  }
 for (i = 0; i < 256; i++)
   wsetrgb (i, 0, 0, 0, blackpal);

 virt  = wnewblock (0, 0, 319, 199);
 wsetscreen (virt);
 wcls (0);
 wnormscreen ();

 virt2 = wnewblock (0, 0, 319, 199);
 fireblock = wnewblock (0, 0, 79, 49);
 randomize ();

 fireptr = firebuffer;

 for (i = 0; i < 56; i++)
  for (j = 0; j < 80; j++)
    *fireptr++ = 1;

 winit3d ();    
 move_x = 0;
 origin_x = 0;
 move_y = 0;
 origin_y = 0;
 move_z = 0;
 
 curx = 0;
 cury = 0;
 curz = 0;
 origin_z = -4500;
 firerotate_loop ();

 curx = 0;
 cury = 0;
 curz = 0;
 origin_z = -4500;
 wsetpalette (0, 255, pal1);
 firerotate_loop3 ();

 curx = 0;
 cury = 0;
 curz = 0;
 origin_z = -4500;
 wloadpalette ("firecube.pal", pal1);
 wsetpalette (0, 255, pal1);
 firerotate_loop2 ();

 if (farcoreleft () < memleft)
   memleft = farcoreleft ();

 wfreeblock (fireblock);
 wfreeblock (virt2);
 wfreeblock (virt);

 rr = pal1[0].r;
 gg = pal1[0].g;
 bb = pal1[0].b;

 wnormscreen ();
 wsetrgb (14, rr, gg, bb, pal1);
 wsetpalette (14, 14, pal1);
 wcls (14);
 wsetrgb (0, 0, 0, 0, pal1);
 wsetpalette (0, 0, pal1);

 wsetcolor (0);
 for (i = 0; i < 200; i+=5)
  {
   wbar (0, i, 79, i+4);
   wretrace ();
  }
 for (i = 0; i < 200; i+=5)
  {
   wbar (80, i, 159, i+4);
   wretrace ();
  }
 for (i = 0; i < 200; i+=5)
  {
   wbar (160, i, 239, i+4);
   wretrace ();
  }
 for (i = 0; i < 200; i+=5)
  {
   wbar (240, i, 319, i+4);
   wretrace ();
  }

// farfree (firebuffer);
}



/*
ͻ
 Texture Warper  by Chris Egerter, April 16, 1994                
 --------------------------------------------------------------- 
 This code is like the Demon code from Future Crew's Second      
 Reality.  It draws a rectangular polygon which always fills the 
 screen, and has the texture source points rotating.  This is    
 a little bit different than the normal texture mapping where    
 you would keep the source points the same and rotate the        
 polygon vertices.   The source points start out as (0,0,319,199)
 and grow outwards.  The math automatically wraps around the     
 source points within one segment, so when it zooms out the      
 texture image is repeated a number of times.  In addition to    
 rotating the bitmap, a sin wave is added to the x source points 
 to create a warping effect.                                     
ͼ
*/

#define LEFTSIDE 0
#define RIGHTSIDE 1
/* Defines the sides of the screen being interpolated */

struct {
   int startx;		/* The first X coord */
   int endx;		/* The last X coord */
   int x1;		/* First pixel coord out of texture */
   int y1;
   int x2;              /* Last pixel coord out of texture */
   int y2;
   } texturepoint[100];  /* One for each scan line (320x200x256) */
/* This structure holds the texture information for each scan line.
   The pixels in this part are larger (2x2) to help increase the speed,
   which is why there is only 100 elements. 

   Startx will always be 0 and endx will always be 159, in this demo's case.
   Each scan line has a beginning texture coordinate and an ending texture
   coordinate.   We first calculate these coordinates based on the rotating
   and warping of the image, and then we simply interpolate between these
   values for each scan line down. */


int dist = 0;
/* Distance in pixels to add to expand each of the source points. */

block texture;  /* Our texture image */

block wgttexture; /* Used by wtexturepoly */
extern tx, ty, bx, by; /* WGT's clipping variables */

int currot = 0;
int leftcoord = 0;    /* Dimensions of texture mapped polygon */
int rightcoord = 159;


/* Draws one scanline of the textured polygon. */
/* Where:
     x1 is the first x coordinate
     x2 is the second x coordinate
     y is the scanline to draw the line on
     sxn is the x coordinate on the texture relating to (x1,y)
     syn is the y coordinate on the texture relating to (x1,y)
     dxn is the x coordinate on the texture relating to (x2,y)
     dyn is the y coordinate on the texture relating to (x2,y)
*/
void wtextline (int x1, int x2, int y, int sxn, int syn, int dxn, int dyn)
{
int t; /* Temporary for swap */
long xincr; /* X offset into texture, amount to increase every pixel */
long yincr; /* Y offset into texture, amount to increase every pixel */
int xofs, xwhole;
int yofs, ywhole;
unsigned char xpart, ypart;
int len;
int xincone, yincone;
int width;

int distx;

block temp;
block textr;
block blackwhite;

 textr = wgttexture;
 width = 320;
 temp  = abuf;
 temp  += y * 320 + x1*2;
 blackwhite = virt + y*320 + 4;

 xofs = sxn;
 yofs = syn;


 distx = x2 - x1;

 xincr = ((long)(dxn-sxn)<<8) / (long)distx;
 yincr = ((long)(dyn-syn)<<8) / (long)distx;

 xwhole = xincr / 256;
 ywhole = yincr / 256;
 xpart = abs(xincr - xwhole * 256);
 ypart = abs(yincr - ywhole * 256);

 if (xincr > 0) xincone = 1; else xincone = -1;		
 /* Amount to add if x fractional amount wraps */

 if (yincr > 0) yincone = width; else yincone = -width;
 /* Amount to add if y fractional amount wraps */

 ywhole *= width;
 /* Change y distance into number of bytes to add */

 len = distx + 1;
 /* Get the number of pixels to draw */

 textr += xofs + yofs * width;
 /* Move to the first pixel in the texture image */
 y /= 2;

 asm {
    .386
    push ds
    les di,temp			/* ES:DI contains a ptr to the screen */
    lds si,textr                /* DS:SI contains a ptr to the texture */
    lgs bx, blackwhite          /* Load gs:bx with ptr to data table */
    mov cl,0			/* Make fractional part = 0 */
    mov dl,0
    }
 textloop:
 ;
 asm {
    mov al,ds:si		/* Get a pixel from the texture */
    mov ah,gs:bx		/* Get a pixel from the black/white screen */

    cmp ah, 1
    jne nosolid
    mov al, y
    }
nosolid:
;
asm {
    mov es:di,al		/* Put the pixel on the screen */
    mov byte ptr es:[di+1],al
    inc di			/* Go to next pixel */
    inc di			/* Go to next pixel */
    inc bx

    add si,word ptr xwhole	/* Add the whole amount */
    add cl, byte ptr xpart	/* Add fractional amount to bl */
    jnc noxcarry		/* See if it went over 256 */
    sub cx,256			/* Subtract the extra */
    add si,word ptr xincone	/* Add one more pixel */
    }
 noxcarry:;
 asm {
    add si,word ptr ywhole	/* Add the whole amount (y) */
    add dl, byte ptr ypart	/* Add fractional amount to dl */
    jnc noycarry		/* See if it went over 256 */
    sub dx,256			/* Subtract the extra */
    add si,word ptr yincone	/* Add one more pixel up or down */
    }
 noycarry:;
 asm dec word ptr len
 asm cmp word ptr len, 0
 asm jne textloop
 asm pop ds
}




/* Calculates the beginning and ending texture coordinate for each */
/* scan line, where:
     side is the side of the screen to calculate (LEFTSIDE or RIGHTSIDE)
     (x1,y1) is the first coordinate of the edge
     (sxn,syn) is the texture source point of the first coordinate
     (x2,y2) is the second coordinate of the edge
     (dxn,dyn) is the texture source point of the second coordinate
 The texture source point is interpolated for each scan line down along
 the edge. 
*/
void wtextpolyline (int side, int x1, int y1, int sxn, int syn, int x2, 
		    int y2, int dxn, int dyn)
{
 int y;
 long x,m;

 long xcoord,  xcoord_inc;	/* Source points to interpolate */
 long ycoord, ycoord_inc;
 int disty;

 wsetcolor (15);
 x = (long)x1<<8;		/* Use a fixed point number */

 disty = y2 - y1;		/* Find the number of lines down */

 m = ((long)(x2-x1)<<8) / (long)disty;
 /* This finds the value to increment the x coordinate for every y 
    coordinate down */

 xcoord = (long)sxn<<8;
 xcoord_inc = ((long)(dxn-sxn)<<8) / (long)disty;

 ycoord = (long)syn<<8;
 ycoord_inc = ((long)(dyn-syn)<<8) / (long)disty;
 x += m;
 y1++;

 for (y = y1; y <= y2; y++)
   {
    if (side == LEFTSIDE)
      {
       texturepoint[y].startx = x>>8;
       texturepoint[y].x1 = xcoord>>8;	/* Set the left edge values */
       texturepoint[y].y1 = ycoord>>8;
      }
    else
      {
       texturepoint[y].endx = x>>8;
       texturepoint[y].x2 = xcoord>>8;	/* Set the right edge values */
       texturepoint[y].y2 = ycoord>>8;
      }
    x += m;		/* Increase the x by the fractional amount */
    xcoord += xcoord_inc;	/* Increase the source points */
    ycoord += ycoord_inc;
   }
}


void texturemap (void)
/* Main routine to find the texture values for both edges, alter them by
   adding a sine wave, and drawing the screen. */
{
int i;
int warp, warp2;
int ctr2;

 wtextpolyline (LEFTSIDE,   leftcoord, 0, rx[0], ry[0],  leftcoord, 99, rx[3], ry[3]);
 wtextpolyline (RIGHTSIDE,  rightcoord, 0, rx[1], ry[1],  rightcoord, 99, rx[2], ry[2]);
 /* Calculate the texture coordinates for each edge.  After this is called
    we have the beginning and ending texture point for each scan line of the
    polygon. */

 /* Used to copy the preceding line down one, for 2x2 pixels */

 for (i = 1; i < 100; i ++)	/* Half the screen */
  {
    ctr2 = ctr*2;
    if (ctr2 > 400) 
       ctr2 = 400;
    warp = texturepoint[i].x1 - (isin[i *3]*ctr)/1024;
    warp2 = texturepoint[i].x2 + (isin[i *3]*ctr)/1024;
    /* Add a sine wave to the texture points, increasing in amplitude as
       more frames have been drawn. */


     /* Draw one scan line of the polygon */
     wtextline (texturepoint[i].startx, texturepoint[i].endx, i,
	       warp, texturepoint[i].y1,
	       warp2, texturepoint[i].y2);
  }
}





void doubleheightmode(void)
/* Makes the screen update faster since pixels look bigger */
{
 asm {   mov dx,3d4h   
    mov al,9
    out dx,al
    inc dx
    in al,dx
    and al,0e0h
    add al,3
    out dx,al
  }
}


void start_warper (void)
/* Starts the texture warper part */
{
 int ct, i;
 char c;
 int logox=30, logoxdir=2, logoy=0, logoydir=2;
 int logosize = 4, logosizedir = 2;

 lcalc_sin();
 texture = wloadcel ("gntitle.cel", pal2);
 wsetpalette(0,255,pal2);

 ct=0;  /* Used to call wretrace 1 out of every 2 times */
 for (i = 0; i < 320; i++)
  {
   wwipe(0, 100, i, 0, texture);
   ct = !ct;
   if (ct)
    wretrace ();
  }
 for (i = 0; i < 200; i++)
  {
   wwipe(0, 100, 319, i, texture);
   ct = !ct;
   if (ct)
   wretrace ();
  }
 for (i = 319; i >= 0; i--)
  {
   wwipe(0, 100, i, 199, texture);
   ct = !ct;
   if (ct)
   wretrace ();
  }

 wreadpalette(0,255,pal1);

 wgttexture = farmalloc (65535L);
 memset (wgttexture, 0, 65535L);
 memcpy (wgttexture, &texture[4], 64000);
 /* Allocates a whole segment and fills it with black, then copies the
    texture picture into it.  This allows us you wrap around the texture
    without having a bunch of junk at the bottom. */

 wfreeblock (texture);
 virt = wnewblock (0, 0, 319, 199);
 wsetscreen (virt);
 wcls (0);
 virt2 = wloadpak ("skpbw.pak");
 wnormscreen ();

 for (i = 0; i < 256; i++)
  wsetrgb (i, 63, 63, 63, pal1);

 wsetpalette (0, 255, pal2);
 for (i = 0; i < 180; i++)
   wretrace ();
 /* Wait a bit to show the title */

 for (i = 0; i < 4; i++)
  {
   rx[i] = px[i];
   ry[i] = py[i];
  }

 wsetpalette (0, 255, pal1);
 doubleheightmode();
 wcls (0);
 noclick ();
 texturemap ();
 for (i = 0; i < 64; i++)
  {
   wfade_between_once (0, 255, pal1, pal2);
   wsetpalette (0, 255, pal1);
   wretrace ();
  }

 ctr = 0;
 do {

  ctr++;
  if (ctr < 50)			/* Adjust the zoom distance in different */
    dist+=20;			/* ways depending on the frame counter */
  if ((ctr > 100) && (ctr < 300))
    dist-=3;
  if ((ctr > 350) && (ctr < 500))
    dist -= 18;
  if ((ctr > 421) && (ctr < 500))
   {
    wsetcolor (0);
    wbar (leftcoord * 2, 0, leftcoord * 2 + 1, 199);
    wbar (rightcoord * 2, 0, rightcoord * 2 + 1, 199);
    leftcoord++;
    rightcoord--;  
   }

  wsetscreen (virt);
  wsetcolor (0);
  wbar (0, 0, 159, 99);
  wresize (logox-logosize, logoy-logosize, logox+logosize, logoy+logosize, virt2, 0);
  wnormscreen ();

  logosize += logosizedir;
  if (logosize > 100)
     logosizedir = -2;
  if (logosize < 10)
     logosizedir = 2;

  logox += logoxdir;
  if (logox > 140) logoxdir = -2;
  else if (logox < 20) logoxdir = 2;

  logoy += logoydir;
  if (logoy > 80) logoydir = -2;
  else if (logoy < 20) logoydir = 2;

  /* Set up the x source point coordinates before rotation */
  px[0] = -dist;
  px[1] = 320+dist;
  px[2] = 320+dist;
  px[3] = -dist;

  /* Set up the y source point coordinates before rotation */
  py[0] = -dist;
  py[1] = -dist;
  py[2] = 200+dist;
  py[3] = 200+dist;

  /* Increase the amount of rotation */
  currot-=2;
  if (currot < 0)
      currot += 360;

 rotatepoly (160, 100, currot);
 /* Rotate the source points */

 texturemap ();
 /* Draw the texture mapped screen */

 } while (!kbhit() && (ctr <500));

while (kbhit ()) getch ();
wfreeblock (virt2);
wfreeblock (virt);
wfreeblock (wgttexture);
fade_out (0, 255, 3, pal2);
vga256(); /* Get out of double height mode */
}



/*  Shadebob scrollers
    Written by Chris Egerter - April 1994 */

unsigned char col[8]={0,2,34,98,66,130,162,194};
unsigned char colref[256];

char message[140]="GREETINGS GO OUT TO      WITAN  FUTURE CREW  TRITON  SURPRISE  AVALANCHE  CASCADA ";
char message2[99]="                           CC CATCH  PURPLE MOTION  SKAVEN  KLF  VANGELISTEAM";
char message3[160]="                                                CYBERSTRIKE  CHORUS AND SID  LEINAD  JARE  TRAN";
char message4[150]="                                                        WREAM   ARJAN   LIZARDKING  ZODIAK ";

long maxletters[8];
long scrx[8];
long t;

int yofs[320];
int yofs2[320];
int yofs3[200];
int yofs4[200];

block letters[101];
typedef struct {
  int x,y;
  } location;

typedef struct {
  location onx[80];
  location offx[80];  
  int numon,numoff;
  } shadebobletter;

shadebobletter *shadeletter;
shadebobletter *shadeletter2;

int width,height;
int state;
int count,count2;
int currentletter=0;
int done = 0;
int colr;

block pict;
extern int bx,by,tx,ty;

void showmessage(void);
void showmessage2(void);
void showmessage3(void);
void showmessage4(void);
void showmessage5(void);

void findmaxletter2(int f)
{
char *t;

maxletters[f]=0;
if (f==0)
  t=message;
else if (f==1)
  t=message2;
else if (f==2)
   t=message3;
else if (f==3) 
   t=message4;
 while (*t !='\0') { t++; maxletters[f]++; }

}


void waddpixel(int x,int y,int i,int u)
{
unsigned char c;
block tempb;

 tempb = abuf + y*320 + x;

 c = colref[*tempb];
 if (!(c & i)) 
    c+=i;
 *tempb = col[c]+u;
}

void wsubpixel(int x,int y,int i)
{
unsigned char c;
block tempb;

 tempb = abuf + y*320 + x;

 c=colref[*tempb];
 if (c & i) c-=i;
 *tempb = col[c];

}


void start_greets (void)
{
wnormscreen ();
wcls (0);
wloadsprites (pal1, "redlet.spr", letters, 0, 100);

shadeletter = farmalloc (sizeof (shadebobletter) * 26);
shadeletter2 = farmalloc (sizeof (shadebobletter) * 26);

for (i=0; i<7; i++)
 findmaxletter2 (i);

// make colour references
for (i=2; i<34; i++) // red
 colref[i]=1;
for (i=34; i<66; i++) // blue
 colref[i]=2;
for (i=66; i<98; i++) // green
 colref[i]=4;
for (i=98; i<130; i++) // red+blue
 colref[i]=3;
for (i=130; i<162; i++) // red+green
 colref[i]=5;
for (i=162; i<194; i++) // blue+green
 colref[i]=6;
for (i=194; i<226; i++) // all
 colref[i]=7;

wloadpalette("stext.pal",pal1);
for (i = 0; i < 256; i++)
 wsetrgb (i, 0, 0, 0, blackpal);
wsetpalette(0,255,blackpal);

for (i=0; i<320; i++)
  yofs[i]=50+sin(3.1415*((float)i/(float)180))*50+5;

for (i=0; i<320; i++)
  yofs2[i]=50+sin(3.1415*((float)i*2/(float)180))*20+10;

for (i=0; i<200; i++)
  yofs3[i]=50+sin(3.1415*((float)i/(float)180))*50;

for (i=0; i<200; i++)
  yofs4[i]=200+sin(3.1415*((float)i/(float)130))*30;

for (i=0; i<26; i++)
 {
 wcls(0);
 wputblock(0,0,letters[i],0);
 width=wgetblockwidth(letters[i])+2;
 height=wgetblockheight(letters[i])+2;

count=0;
count2=0;

for (y=0; y<height; y++)
 for (x=0; x<width; x++)
    {
    colr=wgetpixel(x,y);
    if ((colr>0) & (state==0))
      {
      shadeletter[i].onx[count].x=x;
      shadeletter[i].onx[count].y=y;
      state=1;
      count++;
      }
    if ((colr==0) & (state==1))
      {
      shadeletter[i].offx[count2].x=x;
      shadeletter[i].offx[count2].y=y;
      state=0;
      count2++;
      }

    }
 shadeletter[i].numon=count;
 shadeletter[i].numoff=count2;

count=0;
count2=0;

for (x=0; x<width; x++)
 for (y=0; y<height; y++)
    {
    colr=wgetpixel(x,y);
    if ((colr>0) & (state==0))
      {
      shadeletter2[i].onx[count].x=x;
      shadeletter2[i].onx[count].y=y;
      state=1;
      count++;
      }
    if ((colr==0) & (state==1))
      {
      shadeletter2[i].offx[count2].x=x;
      shadeletter2[i].offx[count2].y=y;
      state=0;
      count2++;
      }

    }
 shadeletter2[i].numon=count;
 shadeletter2[i].numoff=count2;
}

wcls(0);
wsetpalette(0,255,pal1);

scrx[0]=-319;
scrx[1]=-319;
scrx[2]=-200;
scrx[3]=-200;
scrx[4]=-320;
scrx[5]=-320;

showmessage();
wcls(0);
wfreeblock(pict);
wfreesprites(letters,0, 100);
farfree (shadeletter);
farfree (shadeletter2);
wsetpalette (0, 255, blackpal);
}


void showmessage1(void)
{
int c;
int xcoord,ycoord;
shadebobletter *shd;

scrx[0]++;
if (scrx[0]>(long)maxletters[0]*35)
  {
  scrx[0]=-319;
  done = 1;
  }
for (i=0; i<maxletters[0]; i++)
   {

   t=i*(long)35-(long)scrx[0];
   if ((t>-35) & (t<319) & (message[i] !=' '))
     {
      c=message[i]-65;
      wsetcolor(128);
      shd = &shadeletter[c];

      for (x = 0; x < shd->numon; x++)
	 {
	 xcoord = shd->onx[x].x + t;
	 if ((xcoord < 320) && (xcoord >= 0))
	  {
	   ycoord = shd->onx[x].y+yofs[xcoord];
	   waddpixel (xcoord,ycoord,1,shd->offx[x].y);
	  }
         }
      for (x = 0; x < shd->numoff; x++)
	 {
	 xcoord = shd->offx[x].x+t;
	 if ((xcoord < 320) && (xcoord >= 0))
	  {
	   ycoord=shd->offx[x].y+yofs[xcoord];
	   wsubpixel(xcoord,ycoord,1);
	  }
         }
     }
   if (t>318)
      i=5000;
  }
}

void showmessage2(void)
{
int c;
int xcoord,ycoord;
shadebobletter *shd;

scrx[1]++;
if (scrx[1]>(long)maxletters[1]*35)
  scrx[1]=-319;
for (i=0; i<maxletters[1]; i++)
   {

   t=i*(long)35-(long)scrx[1];
   if ((t>-35) & (t<319) & (message2[i] !=' '))
     {
      c=message2[i]-65;
      wsetcolor(128);
      shd = &shadeletter[c];

      for (x =0; x < shd->numon; x++)
	 {
	 xcoord = shd->onx[x].x + t;
	 if ((xcoord < 320) && (xcoord >= 0))
	  {
	   ycoord = shd->onx[x].y + yofs2[xcoord];
	   waddpixel (xcoord, ycoord, 2, shd->offx[x].y);
	  }
         }
      for (x = 0; x < shd->numoff; x++)
	 {
	  xcoord = shd->offx[x].x+t;
	  if ((xcoord < 320) && (xcoord >= 0))
	  {
	   ycoord = shd->offx[x].y + yofs2[xcoord];
	   wsubpixel (xcoord, ycoord, 2);
	  }
         }
     }
   if (t>318)
      i=5000;
  }
}

void showmessage3(void)
{
int c;
int xcoord,ycoord;
shadebobletter *shd;

scrx[2]++;
if (scrx[2]>(long)maxletters[2]*40)
  scrx[2]=-200;
for (i=0; i<maxletters[2]; i++)
   {

   t=i*(long)30-(long)scrx[2];
   if ((t>-30) & (t<200) & (message3[i] !=' '))
     {
      c=message3[i]-65;
      wsetcolor(128);
      shd = &shadeletter2[c];
      for (x = 0; x < shd->numon; x++)
	 {
	 ycoord = shd->onx[x].y+t;
	 if ((ycoord < 200) && (ycoord >= 0))
	  {
	   xcoord = shd->onx[x].x+yofs3[ycoord];
	   waddpixel (xcoord, ycoord,4, shd->offx[x].x);
	  }
	 }
      for (x = 0; x < shd->numoff; x++)
	 {
	 ycoord = shd->offx[x].y+t;
	 if ((ycoord < 200) && (ycoord >= 0))
	  {
	  xcoord = shd->offx[x].x+yofs3[ycoord];
	  wsubpixel (xcoord, ycoord, 4);
	  }
         }


     }
   if (t>200)
      i=5000;

  }
}

void showmessage4(void)
{
int c;
int xcoord,ycoord;

scrx[3]++;
if (scrx[3]>(long)maxletters[3]*40)
  scrx[3]=-200;
for (i=0; i<maxletters[3]; i++)
   {

   t=i*(long)30-(long)scrx[3];
   if ((t>-30) & (t<200) & (message4[i] !=' '))
     {
      c=message4[i]-65;
      wsetcolor(128);
      for (x=0; x<shadeletter2[c].numon; x++)
         {
	 ycoord=shadeletter2[c].onx[x].y+t;
         if ((ycoord<200) & (ycoord>=0))
          {
	  xcoord=shadeletter2[c].onx[x].x+yofs4[ycoord];
          waddpixel(xcoord,ycoord,2,shadeletter2[c].offx[x].x);
	  }
         }
      for (x=0; x<shadeletter2[c].numoff; x++)
         {
         ycoord=shadeletter2[c].offx[x].y+t;
         if ((ycoord<200) & (ycoord>=0))
          {
	  xcoord=shadeletter2[c].offx[x].x+yofs4[ycoord];
	  wsubpixel(xcoord,ycoord,2);
	  }
         }
     }
   if (t>200)
      i=5000;

  }
}



void showmessage(void)
{
while (kbhit()) getch ();

do {

showmessage1 ();
showmessage2 ();
showmessage3 ();
showmessage4 ();
wretrace ();
if (kbhit ())
 done = 1;
} while (!done);
while (kbhit ()) getch ();
}



/*
ͻ
 Lightshaded Texture Cube:  Written by Chris Egerter on June 1/94
 --------------------------------------------------------------- 
 This part uses the WGT 3D library to rotate a cube around the   
 z axis.  The 'texture mapping' is much easier to implement since
 we can use a horizontal line scaler.  A resize table is         
 precalculated for extremely fast resizing.  The only downfall   
 is you can only handle bitmaps with a width of 128 and can      
 only resize smaller than this (at least the way it exists now). 
 The shading is done by linearly interpolating the z coordinate  
 of the top vertex to the bottom, and uses a formula to calculate
 the light value depending on the z coordinate.  This gives      
 each resized line a light value between 0 and 31.  The palette  
 is set up so the colors 0, 32, 64, 96, 128, 160, 192, 224       
 hold the original colors.   This means we have 8 colors to draw 
 the texture image with, and the rest are shades of the original 
 colors.  For example. 0-31 are shades of blue, with 0 being the 
 brightest and 31 being black.  After the light value has been   
 found, we simply add the value to each pixel plotted in the     
 resize line routine to create shades.                           
 Again, a dirty rectangle method is used to update the screen.   
ͼ
*/
block pic;
block picptr;
block endpic;

block resize_table;
#define MAX_SIZE 128

int rotinc;
int rotdir=1;
int rotctr=0;

long ishade;

#define CUBE_SIZE 50

int lfacelist[4][4] = { {0,1,2,3}, {7,6,5,4},
		       {4,5,1,0}, {2,3,7,6}};


int e;
int light=70;

char ch;

void wstretchpoly(tpolypoint *vertexlist, int numvertex, block pic, int zinc);


void clear_lastlighted (void)
{
/* Do clipping for smallest area update */
if (lastrect.x1 < 0)
   lastrect.x1 = 0;
if (lastrect.x2 > 319)
   lastrect.x2 = 319;
if (lastrect.y1 < 0)
   lastrect.y1 = 0;
if (lastrect.y2 > 199)
   lastrect.y2 = 199;
  wsetcolor (31);
  wbar(lastrect.x1,lastrect.y1,lastrect.x2,lastrect.y2);
  /* Clear out the area that was drawn in last frame */
}

void update_screenlighted(void)
{
if (lastrect.x1 > thisrect.x1)
   lastrect.x1 = thisrect.x1;
if (lastrect.x2 < thisrect.x2)
   lastrect.x2 = thisrect.x2;
if (lastrect.y1 > thisrect.y1)
   lastrect.y1 = thisrect.y1;
if (lastrect.y2 < thisrect.y2)
   lastrect.y2 = thisrect.y2;
/* See if the previous frame was larger in any direction. If it is, enlarge
the area so it will copy black over the previous frame. */

/* Do clipping */
if (lastrect.x1 < 0)
   lastrect.x1 = 0;
if (lastrect.x2 > 319)
   lastrect.x2 = 319;
if (lastrect.y1 < 0)
   lastrect.y1 = 0;
if (lastrect.y2 > 199)
   lastrect.y2 = 199;

wcopyscreen (lastrect.x1, lastrect.y1, lastrect.x2, lastrect.y2, virt,
	     lastrect.x1, lastrect.y1, NULL);
/* Copy from our second page to the visual page. */

lastrect.x1 = thisrect.x1;
lastrect.y1 = thisrect.y1;
lastrect.x2 = thisrect.x2;
lastrect.y2 = thisrect.y2;
/* Make the last rectangle = current rectangle */

}


void lightedrotate_loop(void)
{
int circlepos=180,circlepos2=145,circlepos3=0;
long drawxofs = 0;
long drawyofs = 0;
int i;
int x, y, z;
int sorted;
long zinc, ydist;
long highesty, lowesty, highestz, lowestz;
char ch;

ctr = 0;
wsetscreen(virt);
lastrect.x1=0; lastrect.y1=0; lastrect.x2=1; lastrect.y2=1;

do {
  if (kbhit())
   ctr = 1200;

  ctr++;
  if (ctr < 200)
     origin_z+=10;
  else if (ctr < 1200)
  {
    circlepos3+=3;
    if (circlepos3 > 359)
      circlepos3 -= 360;
    origin_z=-800L+lcos[circlepos3]*400L/1024L;
   }
  else
   origin_z-=10;

    light = (-origin_z)/13;
    if (light < 70) 
        light = 70;
  
  circlepos+=2;
  if (circlepos > 359)
    circlepos -= 360;
  drawxofs = lcos[circlepos]*50/1024;

  circlepos2+=2;
  if (circlepos2 > 359)
    circlepos2 -= 360;
  drawyofs = lcos[circlepos2]*20/1024;


  curz += rotinc;
  if (curz>359) 
      curz -= 360;
  if (curz< 0)
      curz += 360;

  rotinc+=rotdir;
  if (rotinc > 4)
      rotinc = 4;
  else 
  if (rotinc < -4)
      rotinc = -4;

  rotctr--;
  if (rotctr < 0)
  {
   rotdir = -rotdir;
   rotctr = random(200)+50;
  }
 


thisrect.x1=319; thisrect.y1=199; thisrect.x2=0; thisrect.y2=0;
clear_lastlighted();

wsetrotation(curx,cury,curz);
wrotatepoints(firecube, firerotated, 8);
wrotatepoints(normref, rotref, 4);

for (i = 0; i < 4; i++)
  sortlist[i] = i;
qsort((int *)sortlist, 4, 2, fire_sort_function);


for (i = 2; i <= 3; i++)
 {
  sorted = sortlist[i];

  y = firerotated[lfacelist[sorted][0]].y + drawyofs;
  highesty = y;
  lowesty = y;

  for (e = 0; e < 4; e++)
   {
    x = firerotated[lfacelist[sorted][e]].x + drawxofs;
    y = firerotated[lfacelist[sorted][e]].y + drawyofs;
    z = firerotated[lfacelist[sorted][e]].z;

    if (y <= lowesty)
    {
      lowesty = y;
      lowestz = z-origin_z;
    }
    if (y >= highesty)
    {
      highesty = y;
      highestz = z-origin_z;
    }


    if (x < thisrect.x1)
      thisrect.x1 = x;
    if (x > thisrect.x2)
      thisrect.x2 = x;

    if (y < thisrect.y1)
      thisrect.y1 = y;
    if (y > thisrect.y2)
      thisrect.y2 = y;
    /* See if the polygon is larger than the current area to update.
       If it is, enlarge the area so all polygons fit inside. */
   mypoly[e].x = x;
   mypoly[e].y = y;
   }

   ydist = highesty - lowesty;
   if (ydist == 0)
     ydist = 1;


   zinc= ((highestz - lowestz) << 8) / ydist;
   ishade = lowestz<<8;

    wsetcolor(1);
    wstretchpoly(mypoly, 4, picptr, zinc);
//    whollowpoly(mypoly, 4, 0,0, CLOSED_POLY);
  }

wretrace();
update_screenlighted();

} while (origin_z > -2500);
while (kbhit()) getch();
}


void calc_resize_table (void)
{
int finalwidth;
int origwidth;
unsigned int whole;
unsigned char step;
long stepper;
block tptr;  /* Pointer into the table */
int diff;
int span;
int xpart;

  origwidth = MAX_SIZE;
  resize_table = farmalloc (MAX_SIZE * MAX_SIZE);
  memset (resize_table, 0, MAX_SIZE * MAX_SIZE);
     
  for (finalwidth = 1; finalwidth <= MAX_SIZE; finalwidth++)
   {
    stepper = ((long)(origwidth) << 8) / ((long)(finalwidth));
    /* Calculate the amount to add to the source bitmap for every pixel 
       across.  This is done using a fixed point number by multiplying it 
       by 256 (<<8) and using 0-255 as a fractional amount. */
  
    whole = stepper / 256;               /* Keep the whole amount */
    step = stepper - whole*256;
    /* and the fractional amount (1/256th of a pixel) */

    tptr = &resize_table[finalwidth * MAX_SIZE];

    xpart = 0;
    for (span = 0; span < finalwidth; span++)
     {
      diff = whole;
      xpart += step;
      if (xpart > 256)
       {
        xpart -= 256;
        diff++;
       }
      *tptr++ = diff;   /* Store the difference in the table */
     }
   }
}

void free_resize_table (void)
{
 farfree (resize_table);
}



void resize_line (int x1, int x2, int y1, block bitmap, char shade)
{
block dest;
int length;
block res_ptr;
int tmp;

if ((y1 >=0) && (y1 <=199))
{
if (x1 > x2)
 {
  tmp = x1;
  x1 = x2;
  x2 = tmp;
 }

x1++;
x2--;
if (x2 > 319)
  x2 = 319;
if (x1 < 0)
  x1 = 0;

length = x2 - x1 + 1;

if (length > 0)
{
dest = abuf + x1 + y1 * 320;

res_ptr = resize_table;         /* Make a ptr to our data table */
res_ptr += length * MAX_SIZE;


asm {
  .386
  push ds
  mov cx, length                /* Loop length */ 
  lds si, bitmap                /* Load ds:si with ptr to source */
  les di, dest                  /* Load es:di with ptr to dest */
  lgs bx, res_ptr               /* Load gs:bx with ptr to data table */
  xor ah, ah
  }
resloop:
;
asm {
  mov al, [ds:si]            /* Get pixel color from source */
  add al, shade
  mov es:di,al               /* Move it into dest */
  inc di;                    /* Increase destination pixel */
  mov al, [gs:bx]            /* Get byte from table */
  add si, ax                 /* Add to source offset */
  inc bx                     /* Go to next byte in table */
  loop resloop
  pop ds
  }
 }
}
}


int sstartx[200];
int sendx[200];
int sinten1[200];

void wspolyline (int x1, int y1, int n1, int x2, int y2, int n2)
{
int tmx, tmy, y;
long x, m;
long col, colinc;

 if (y2 != y1)
 {
   if (y2 < y1)
   {
      tmy = y1;
      y1 = y2;
      y2 = tmy;
      tmx = x1;
      x1 = x2;
      x2 = tmx;

      tmx = n1;
      n1 = n2;
      n2 = tmx;
   }

 wsetcolor (15);
 x = (long)x1<<8;
 m = ((long)(x2-x1)<<8)/((long)(y2-y1));
 col = (long)n1<<8;
 colinc = ((long)(n2-n1)<<8)/((long)(y2-y1));
 x++;
 y1++;

 for (y = y1; y <= y2; y++)
   {
  if ((y >= 0) & (y < 200))
    if (sstartx[y] == -16000)
      {
      sstartx[y] = x>>8;
      sinten1[y] = col>>8;
      }
    else
      {
      sendx[y]=x>>8;
      }
   x+=m;
   col+=colinc;
   }

 }
}


void wstretchpoly(tpolypoint *vertexlist, int numvertex, block pic, int zinc)
{
int i;
tpolypoint *curpt,*nextpt;
char shade;
curpt=vertexlist;
nextpt=vertexlist+1;

for (i=0; i<200; i++)
 {
  sstartx[i]=-16000;
  sendx[i]=-16000;
 }

for (i=0; i<numvertex-1; i++)
  {
  wspolyline(curpt->x,curpt->y,0,nextpt->x,nextpt->y,127);
  curpt+=1;
  nextpt+=1;
  }

nextpt=vertexlist;
  wspolyline(curpt->x,curpt->y,0,nextpt->x,nextpt->y,127);


for (i=0; i<200; i++)
  {
  if (sstartx[i] != -16000)
    {
     ishade += zinc;
     shade = (light-(ishade >> 8))/3;
     if (shade < 0) shade = 0;
     if (shade > 31) shade = 31;
     if (sendx[i]==-16000)
	sendx[i]=sstartx[i];
     resize_line (sstartx[i], sendx[i], i, pic+sinten1[i]*320,shade);
    }
  }
}





void start_lightedcube (void)
{
int i;

wnormscreen();
wcls(31);

wclip(0,0,319,199);

normref[2].x = 0;
normref[2].y = -50;
normref[2].z = 0;

normref[3].x = 0;
normref[3].y = 50;
normref[3].z = 0;

endpic = wloadcel("death.cel",pal1);
wsetpalette(0,255,blackpal);
wputblock(0,0,endpic,0);
wfreeblock(endpic);
pic = wnewblock(0,0,319,199);
picptr = &pic[4];
calc_resize_table ();

virt  = wnewblock (0, 0, 319, 199);
wsetscreen (virt);
wcls (31);
wnormscreen ();
wcls (31);
fade_in(0,255,1,pal1);

winit3d ();
lcalc_sin();
move_x=0;
origin_x=0;
move_y=0;
origin_y=0;
move_z=0;

origin_z = -2400;
curx = 0;
cury = 0;
curz = 45;
lightedrotate_loop ();

fade_out(0,255,1,pal1);

wfreeblock(virt);
free_resize_table ();
wfreeblock (pic);
}

