/*
    NSLENS.CPP.
   C 䥪 .
   H室 䠩:
                     VGA.DRV - pp VGA p
                     FIRE.COL - p 
   Copyright (C) 1995 by D.J. Wolf/Nimbus Studio Labs, Moscow, Russia.
   All rights reserved.
   tel.(095) 941-5065 (ask Andrew).
*/

#include <mtools.hpp>        // 䠩  襩 ⥪ Multimedia Toolkits v1.0.
#include <graphics.hpp>      //     cc⢥(c 
                             //y c c ;)
#include <mtfile.hpp>
#include <psts4.hpp>
#include <gif.hpp>

#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <sys/stat.h>
#include <mem.h>
#include <dos.h>
#include <alloc.h>

#include "nsdemo.hpp"

// 䠩   .
#define LENDAT01 "lendat01.dat"

// 䮭 p.
#define LENPIC01 "mouse.gif"

//p .
#define LENS_D 140

//p      .
#define LENS_BLOCK_SIZE LENS_D*LENS_D

//Hp c( 䮭p).
#define MAGIC_VALUE 27.0

//p楤yp p樨   .
// c뢠c  䠩 c  LENDAT01.
//p p:
//             TRUE -  訡,
//             FALSE - 訡.
int GenLensData()
   {
    //C 䠩..
    MTFile *file=new MTFile(LENDAT01);
    if (file->Error()!=MTFILE_NO_ERROR)
       {
	CloseGraph();
	printf("\nCan't create file %s !",LENDAT01);
	delete file;
	return FALSE;
       }

    //뤥塞    .
    char huge *data;
    if ((data=(char*)farmalloc((long)LENS_BLOCK_SIZE*sizeof(int)))==NULL)
	{
	 CloseGraph();
	 printf("Not enough free memory.\n\n");
	 delete file;
	 return FALSE;
	}

    //c .
    int d,r;                   //p  pyc .
    int a,b;                   //p X,Y pc⨢ p樨.
    double z,m;                //p Z cp  p c.
    double s;
    int x,y;                   //p X,Y 窨  cp.
    int *LensPtr;              //⥫  cc .

    d=LENS_D;
    r=d/2;
    m=MAGIC_VALUE;

    s=sqrt((double)r*r-m*m);

    LensPtr=(int *)data;

    for(y=-r; y<-r+d; y++)       //  窨 Y  cp.
       {
	for(x=-r; x<-r+d; x++)   //  窨 X  cp.
	   {
	    if ((long)x*x+(long)y*y>=(long)s*s)
	       {
		a=x;
		b=y;
		*LensPtr=(long)(y+r)*d+(x+r);
		LensPtr++;
	       }
	    else
	       {
		//c塞 p 窨  cp.
		z=sqrt((long)r*r-(long)x*x-(long)y*y);

		//믮塞 pc⨢ pp.
		a=((x*m)/z+0.5);
		b=((y*m)/z+0.5);

		*LensPtr=(long)(b+r)*d+(a+r);
		LensPtr++;
	       }
	   }
       }

    //c뢠 䠩.
    MemoryBlock TmpBlk;
    TmpBlk.lpMemBlock=TmpBlk.lpRealAddress=(char huge*)data;
    TmpBlk.wHandle=0;
    TmpBlk.dwSize=(long)LENS_BLOCK_SIZE*sizeof(int);

    if (!file->Write(&TmpBlk,(unsigned long)0l,(unsigned long)TmpBlk.dwSize/2))
       {
	CloseGraph();
	printf("\nCan't write file %s !",LENDAT01);
	delete file;
	farfree(data);
	return FALSE;
       }

    if (!file->Write(&TmpBlk,(unsigned long)TmpBlk.dwSize/2,(unsigned long)TmpBlk.dwSize/2+1))
       {
	CloseGraph();
	printf("\nCan't write file %s !",LENDAT01);
	delete file;
	farfree(data);
	return FALSE;
       }
    delete file;
    farfree(data);

    return TRUE;
   }

//p楤yp pc .
//pp:
//          x - p X  p孥 y ,
//          y - p Y  p孥 y ,
//          lpLensData - y⥫  cc ,
//          lpImage -   pp c y,
//          lpScr - y⥫  py p.
void DrawLens(int x,int y,int *lpLensData,char far *lpImage,
	      char far *lpScr)
   {
    char far *lpScreen;

    lpScreen=lpScr+320*y+x;

    _AX=FP_SEG(lpLensData);
    _BX=FP_OFF(lpLensData);

    asm {
	 push bp
	 push es
	 push ds

	 db 08eh                       //mov gs,ax
	 db 0e8h                       //gs:bx - y⥫  lpLensData

	 les di,dword ptr lpScreen     //es:di - y⥫  
	 lds si,dword ptr lpImage      //ds:si - y⥫  p.
	 mov dx,si                     // p孨 y p.

	 mov cx,LENS_D                 //cx- cp p.
	 mov bp,LENS_D                 //bp-c p.
	};
    DrawLensL1:
    asm {
	 push cx
	};
    DrawLensL2:
    asm {
	 db 065h                       //mov ax,word ptr gs:[bx]
	 db 08bh                       //ax-c饭 ⭮c⥫쭮 
	 db 007h                       //p孥 y p.

	 add ax,dx
	 mov si,ax                     //si-pc c  p.

	 mov al,byte ptr ds:[si]       //al-c.

	 mov es:[di],al                //c뢠 c  .

	 inc di

	 add bx,2

	 dec cx
	 jnz DrawLensL2                //  c c  cp.
	 pop cx

	 add di,320-LENS_D

	 dec bp
	 jnz DrawLensL1                //  c cp.

	 pop ds
	 pop es
	 pop bp
	};
   }

//y, c뢠     p.
void LensRules(int &x,int &y)
   {
    static int X=0;
    static int Y=0;
    static int DeltaCounter=0;
    static int XDeltaCounter=0;
    static int DeltaFlag=-1;
    static int Delta=3;
    static int NewDelta=8;
    static int XDeltaFlag=-1;
    static int XDelta=3;
    static int XNewDelta=5;
    DeltaCounter++;
    XDeltaCounter++;
    if(DeltaFlag==-1)
    {
     if(DeltaCounter>=4)
     {
      Delta+=1;
      DeltaCounter=0;
     }
    }
    else
    {
     if(DeltaCounter>=3)
     {
      Delta-=1;
      DeltaCounter=0;
     }
    }
    Y+=2*Delta*(-DeltaFlag);

    if(Delta<=0)
    {
     DeltaFlag=-1;
     Delta=0;
    }

    if(Y<0)
    {
     Y=0;
     DeltaFlag=-1;
    }
    if(Y>60)
    {
     Y=60;
     DeltaFlag=1;
     Delta--;
     DeltaCounter=0;
     if(Delta<=0)
     {
      Delta=0;
     }
    }
    if((Delta==0)&&(Y==60))
    {
     DeltaFlag=1;
     Delta=NewDelta++;
     if(NewDelta>14)
     {
      NewDelta=8;
     }
    }
    if(XDeltaFlag==-1)
    {
     if(XDeltaCounter>=4)
     {
      XDelta+=1;
      XDeltaCounter=0;
     }
    }
    else
    {
     if(XDeltaCounter>=3)
     {
      XDelta-=1;
      XDeltaCounter=0;
     }
    }
    X+=5*XDelta*(-XDeltaFlag);

    if(XDelta<=0)
    {
     XDeltaFlag=-1;
     XDelta=0;
    }

    if(X<0)
    {
     X=0;
     XDeltaFlag=-1;
    }
    if(X>180)
    {
     X=180;
     XDeltaFlag=1;
     XDelta--;
     XDeltaCounter=0;
     if(XDelta<=0)
     {
      XDelta=0;
     }
    }
    if((XDelta==0)&&(X==180))
    {
     XDeltaFlag=1;
     XDelta=XNewDelta;
    }
    if(Delta+XDelta<4)
    {
//     Delta+=1;
     XDelta+=2;
    }
    x=X;
    y=Y;
   }

//p楤yp p 䥪 .
// pyc  ⮬ c  nsfirst.vol.
//p p:
//             TRUE -  訡,
//             FALSE - 訡.
int LensEffect()
  {
   char byColorMap[768];                 //⥫  py.

   //뤥塞   py p.
   if (!MakeVirtualScreen(&Scr,320,200,MEM_STANDARD))
       {
	CloseGraph();
	printf("\nNot enough memory!");
	return FALSE;
       }

   //뤥塞   py p.
   if (!MakeVirtualScreen(&WorkScr,320,200,MEM_STANDARD))
       {
	CloseGraph();
        DeleteVirtualScreen(&Scr);
	printf("\nNot enough memory!");
	return FALSE;
       }

   //樠 pc p.
   InitGraph("vga.drv",0);
   if (GraphResult()!=GRAPH_NO_ERROR)
       {
	CloseGraph();
	DeleteVirtualScreen(&Scr);
	DeleteVirtualScreen(&WorkScr);
	printf("\nCan't setup video mode or can't find driver 'vga.drv'!");
	return FALSE;
       }

    //py 䮭 p.
    SetActiveScreen(VIRTUAL_SCREEN,&Scr);
    GIFFile *gif=new GIFFile(LENPIC01);
    if (gif->Error()!=GIF_NO_ERROR)
       {
	//H p 䠩.
	CloseGraph();
	printf("\nCan't open file %s !",LENPIC01);
	DeleteVirtualScreen(&Scr);
	DeleteVirtualScreen(&WorkScr);
	return FALSE;
       }
    gif->LoadScreen();

    delete gif;

    //p뢠 䠩.
    MTFile *file=new MTFile(LENDAT01,MT_READ_ONLY);
    if (file->Error()!=MTFILE_NO_ERROR)
       {
	CloseGraph();
	printf("\nCan't open file %s !",LENDAT01);
	delete file;
	DeleteVirtualScreen(&Scr);
	DeleteVirtualScreen(&WorkScr);
	return FALSE;
       }

    //뤥塞    .
    char huge *data;
    if ((data=(char*)farmalloc((long)LENS_BLOCK_SIZE*sizeof(int)))==NULL)
	{
	 CloseGraph();
	 printf("Not enough free memory.\n\n");
	 delete file;
	 DeleteVirtualScreen(&Scr);
	 DeleteVirtualScreen(&WorkScr);
	 return FALSE;
	}

    //⠥ 䠩.
    MemoryBlock TmpBlk;
    TmpBlk.lpMemBlock=TmpBlk.lpRealAddress=(char huge*)data;
    TmpBlk.wHandle=0;
    TmpBlk.dwSize=(long)LENS_BLOCK_SIZE*sizeof(int);

    if (!file->Read(&TmpBlk,(unsigned long)0l,(unsigned long)LENS_BLOCK_SIZE*sizeof(int)))
       {
	CloseGraph();
	printf("\nCan't read file %s !",LENDAT01);
	delete file;
	DeleteVirtualScreen(&Scr);
	DeleteVirtualScreen(&WorkScr);
	farfree(data);
	return FALSE;
       }
    delete file;

    //뤥塞    p.
    char huge *lpImage;
    if ((lpImage=(char*)farmalloc((long)LENS_BLOCK_SIZE*sizeof(int)))==NULL)
	{
	 CloseGraph();
	 printf("Not enough free memory.\n\n");
	 DeleteVirtualScreen(&Scr);
	 DeleteVirtualScreen(&WorkScr);
	 farfree(data);
	 return FALSE;
	}

    //y砥 py.
    GetColorMap(byColorMap);

    SetActiveScreen(DISPLAY);

    //c⠭ py.
    SetColorMap(byColorMap);

    //p  p孥 y 
    int xc,yc;

    unsigned long dwVal;

    dwVal=0;

    do
      {
       //py p쭮 p.
       ScreenToScreen(&WorkScr,&Scr,0,0,320,200,0,0,COPY_PUT);

       //c塞 p .
       LensRules(xc,yc);

       //y砥 cp.
       SetActiveScreen(VIRTUAL_SCREEN,&Scr);
       GetImage(xc,yc,xc+LENS_D,yc+LENS_D,(char far*)lpImage);

       //cy y.
       SetActiveScreen(VIRTUAL_SCREEN,&WorkScr);
       DrawLens(xc,yc,(int *)data,(char far*)lpImage+4,(char far*)WorkScr.RasterData.lpRealAddress);

       //뢮 p.
       ScreenToDisplay(&WorkScr,0,0,320,200,0,0,COPY_PUT);
       dwVal++;
       if (dwP5!=1) DPause(14,18);
      }
    while(!kbhit() && dwVal<400l);

    DeleteVirtualScreen(&Scr);
    DeleteVirtualScreen(&WorkScr);
    farfree(data);
    farfree(lpImage);
    return TRUE;
   }