{$A+,B-,D-,E-,F-,G+,I-,L-,N-,O-,P-,Q-,R-,S-,T-,V-,X+,Y-}
{$M 8192,0,655360}

{ tabstep = 4 }

CONST
	FontSignature: ARRAY[1..10] OF CHAR = 'FONTDATA11';
	TextString = 'THIS IS A TEST OF TEXT OUTPUT ROUTINE FOR VGA... @#$%^&*()1234567890_+-=\|~`';
	TextString866 = '--- ;)    -. ,   :)';

TYPE
	TFontCharacter = RECORD
		Width: BYTE;
		Height: BYTE;
		Offsety: INTEGER;
		LeftSpace: INTEGER;
		RightSpace: INTEGER;
	END;


{ warning: this example font printing routine is designed only for fonts less than 64k in size }
{ so, be warned about this limitation }

{ ScreenAddress - output buffer where to put text (PTR($A000,0) for actual screen }
{ ScreenW - width of buffer in bytes (320 for actual screen) }
{ FontData - pointer to correct font (warning: no checks for validity are performed) }
{ Text - text to output }
{ BaseColour - base colour }
{ x,y - coordinates within output buffer }
{ wx1,wy1,wx2,wy2 - clipping bounds }
PROCEDURE FontStringPrint(ScreenAddress: POINTER; ScreenW: WORD; FontData: POINTER;
	Text: STRING; BaseColour:BYTE; x,y: INTEGER; wx1,wy1,wx2,wy2: WORD);
ASSEMBLER;
VAR
	xtOffs: WORD;
	xtIncr: WORD;
	DIIncrement: WORD;
	Newx: WORD;
	Currenty: WORD;
	CurrentChar: WORD;
	Character: BYTE;
ASM
	PUSH DS

	CLD

	MOV AX,[x]
	MOV [Newx],AX

	MOV [CurrentChar],0

@@CharOutput:
	LDS SI,[Text]
	MOV AL,[DS:SI]
	XOR AH,AH
	CMP AX,[CurrentChar]
	JBE @@Done

	ADD SI,[CurrentChar]
	MOV AL,[DS:SI+1]
	MOV [Character],AL

	LDS SI,[FontData]
	MOV AL,[Character]
	XOR AH,AH
	SHL AX,2
	ADD SI,AX
	MOV SI,[DS:SI]
	CMP SI,0
	JE @@DoneChar

	ADD SI,[WORD PTR FontData]

	MOV AX,[x]
	SUB AX,[DS:SI+TFontCharacter.LeftSpace]
	MOV [x],AX
	MOV BL,[DS:SI+TFontCharacter.Width]
	XOR BH,BH
	ADD AX,BX
	ADD AX,[DS:SI+TFontCharacter.RightSpace]
	MOV [Newx],AX

	MOV DX,BX
	CMP DX,0
	JE @@DoneChar

	MOV AX,[x]
	CMP AX,[wx2]
	JG @@DoneChar

	ADD AX,DX
	DEC AX
	CMP AX,[wx1]
	JL @@DoneChar

	MOV [xtIncr],0
	CMP AX,[wx2]
	JLE @@NoRightClip

	SUB AX,[wx2]
	SUB DX,AX
	ADD [xtIncr],AX

@@NoRightClip:
	MOV [xtOffs],0
	MOV AX,[x]
	CMP AX,[wx1]
	JGE @@NoLeftClip

	MOV BX,[wx1]
	SUB BX,AX
	SUB DX,BX
	ADD AX,BX
	MOV [xtOffs],BX
	ADD [xtIncr],BX

@@NoLeftClip:
	MOV [x],AX

	MOV CL,[DS:SI+TFontCharacter.Height]
	XOR CH,CH
	JCXZ @@DoneChar

	MOV AX,[y]
	ADD AX,[DS:SI+TFontCharacter.Offsety]
	MOV [Currenty],AX
	CMP AX,[wy2]
	JG @@DoneChar

	ADD AX,CX
	DEC AX
	CMP AX,[wy1]
	JL @@DoneChar

	CMP AX,[wy2]
	JLE @@NoBottomClip

	SUB AX,[wy2]
	SUB CX,AX

@@NoBottomClip:
	XOR BX,BX
	MOV AX,[Currenty]
	CMP AX,[wy1]
	JGE @@NoTopClip

	MOV BX,[wy1]
	SUB BX,AX
	SUB CX,BX
	ADD AX,BX

@@NoTopClip:
	PUSH DX

	MOV DX,[ScreenW]
	MUL DX
	ADD AX,[x]
	LES DI,[ScreenAddress]
	ADD DI,AX

	MOV AL,[DS:SI+TFontCharacter.Width]
	XOR AH,AH
	MUL BX
	ADD SI,AX
	ADD SI,[xtOffs]
	ADD SI,TYPE TFontCharacter
	MOV AH,[BaseColour]
	DEC AH

	POP DX

	MOV BX,[ScreenW]
	SUB BX,DX
	MOV [DIIncrement],BX

@@FillLoopy:
	MOV BX,DX

@@FillLoopx:
	LODSB
	INC DI
	CMP AL,0
	JE @@NoFill

	ADD AL,AH
	MOV [ES:DI-1],AL

@@NoFill:
	DEC BX
	JNZ @@FillLoopx

	ADD SI,[xtIncr]
	ADD DI,[DIIncrement]
	LOOP @@FillLoopy

@@DoneChar:
	MOV AX,[Newx]
	MOV [x],AX
	INC [CurrentChar]
	JMP @@CharOutput

@@Done:
	POP DS
END;

PROCEDURE PaletteElementSet(Colour: BYTE; RedValue, GreenValue, BlueValue: BYTE);
ASSEMBLER;
ASM
	MOV DX,3C8H
	MOV AL,Colour
	OUT DX,AL

	CLI
	MOV DX,3C9H
	MOV AL,RedValue
	OUT DX,AL
	MOV AL,GreenValue
	OUT DX,AL
	MOV AL,BlueValue
	OUT DX,AL
	STI
END;

FUNCTION Readkey: WORD;
ASSEMBLER;
ASM
	XOR AH,AH
	INT 16H
END;

FUNCTION Keypressed: BOOLEAN;
ASSEMBLER;
ASM
	XOR BX,BX
	MOV AH,01H
	INT 16H
	JZ @Done

	MOV BX,-1

@Done:
	MOV AX,BX
END;

PROCEDURE VerticalRetraceWait;
ASSEMBLER;
ASM
	MOV DX,3DAH

@@WaitForVRetrace:
	IN AL,DX
	TEST AL,8
	JZ @@WaitForVRetrace
END;

PROCEDURE DataFillByte(Buffer: POINTER; Count: WORD; Value: BYTE; BufferOffset: WORD);
ASSEMBLER;
ASM
	CLD

	LES DI,[Buffer]
	ADD DI,[BufferOffset]

	MOV AL,[Value]
	MOV AH,AL

	MOV CX,[Count]
	SHR CX,1
	JNC @@FillWords

	STOSB

@@FillWords:
	REP STOSW
END;

PROCEDURE DataMove(Source, Destination: POINTER; Count: WORD; SourceOffset, DestinationOffset: WORD);
ASSEMBLER;
ASM
	CLD

	MOV DX,DS

	LDS SI,[Source]
	ADD SI,[SourceOffset]
	LES DI,[Destination]
	ADD DI,[DestinationOffset]

	MOV CX,[Count]
	SHR CX,1
	JNC @@MoveWords

	MOVSB

@@MoveWords:
	REP MOVSW

	MOV DS,DX
END;

VAR
	InFile: FILE; { filehandle }
	FontBuffer: POINTER; { buffer for font }
	Buffer1,Buffer2: POINTER; { pair of buffers for screen output }
	CheckSignature: ARRAY[1..SIZEOF(FontSignature)] OF CHAR; { signature hold }
	ScrollDirection: INTEGER;
	Currentx,i: INTEGER;
	CurrentTime: LONGINT;

BEGIN
	FileMode:=0; {open file in read-only mode}
	ASSIGN(InFile,'EXAMPLE.FNT');
	RESET(InFile,1);

	IF IORESULT<>0 THEN
		BEGIN
			WRITELN('Cannot open EXAMPLE.FNT file!');
			HALT;
		END;

	IF FILESIZE(InFile)>$FFFF THEN
		BEGIN
			WRITELN('Cannot handle font bigger than 64k!');
			HALT;
		END;

	BLOCKREAD(InFile,CheckSignature,SIZEOF(FontSignature)); {load signature}

	IF IORESULT<>0 THEN
		HALT;

	IF CheckSignature<>FontSignature THEN
		BEGIN
			WRITELN('Invalid fontfile!');
			HALT;
		END;

	GETMEM(FontBuffer,FILESIZE(InFile)-10); {allocate buffer for font}
	BLOCKREAD(InFile,FontBuffer^,FILESIZE(InFile)-10); {load font}
	CLOSE(InFile); {close file}

	ASM MOV AX,13H; INT 10H; END; {set video mode}

	{setup palette}
	PaletteElementSet(10,10,10,10);
	PaletteElementSet(11,16,16,16);
	PaletteElementSet(12,30,30,30);
	PaletteElementSet(13,63,63,63);

	PaletteElementSet(14,10,0,0);
	PaletteElementSet(15,16,0,0);
	PaletteElementSet(16,30,0,0);
	PaletteElementSet(17,63,0,0);

	PaletteElementSet(18,4,4,0);
	PaletteElementSet(19,8,8,0);
	PaletteElementSet(20,10,10,0);
	PaletteElementSet(21,20,20,0);

	Currentx:=330;
	ScrollDirection:=-1;

	GETMEM(Buffer1,64000); { background buffer }
	GETMEM(Buffer2,64000); { virtual screen }
	DataFillByte(Buffer1,64000,0,0);

	FOR i:=0 TO 14 DO
		FontStringPrint(Buffer1,320,FontBuffer,'THE FONT EDITOR     THE FONT EDITOR',18,i*10-100,i*17-10,0,0,319,199);

	REPEAT
		DataMove(Buffer1,Buffer2,64000,0,0);
		FontStringPrint(Buffer2,320,FontBuffer,TextString,10,Currentx,TRUNC(92+SIN(Currentx*3.1416/180)*110),0,0,319,199);
		FontStringPrint(Buffer2,320,FontBuffer,TextString866,10,-600-Currentx,TRUNC(92-SIN(Currentx*3.1416/180)*110),0,0,319,199);
		FontStringPrint(Buffer2,320,FontBuffer,'PRESS ANY KEY TO EXIT',14,4,180,0,0,319,199);
		VerticalRetraceWait; {wait for vertical retrace}
		DataMove(Buffer2,PTR($A000,0),64000,0,0);
		Currentx:=Currentx+ScrollDirection;

		IF (Currentx>330) OR (Currentx<-790) THEN
			ScrollDirection:=-ScrollDirection;
	UNTIL Keypressed; {loop until key was pressed}

	Readkey; {flush keyboard buffer}
	ASM MOV AX,3H; INT 10H; END; {set text mode}
END.