/*
  rotating program example by Richard Nichols (tiberius). This source is
  submitted to the public domain. It may not be sold for profit or claimed
  as the work of another.

  other than that enjoy ! =) I wrote this late at night in about 15 minutes
  so things are fairly messy. You're here to see the application of math not
  how to code though =)

  The picture is drawn by me and was my first attempt at a hand drawn gfx...
  Why am I using turbo c++? Because not everyone has watcom and not everyone
  likes djgpp... turbo c++ is the stable alternative.

  later! -tiberius (tiberius@mailhost.net)

  (compiles in turbo c++ 3.1)
*/
#include <dos.h>      // MK_FP, geninterrupt()
#include <io.h>
#include <stdlib.h>
#include <alloc.h>
#include <stdio.h>
#include <conio.h>    // clrscr(), getch(), kbhit()
#include <stdlib.h>   // calloc(), exit(), free()
#include <math.h>
#include <mem.h>
#include <fcntl.h>
#include <string.h>
#include <dir.h>
#include <SYS\STAT.H>

#define UINT	unsinged int
#define UCHAR	unsigned char
#define ULONG	unsigned long

UCHAR picture[141][181];
UCHAR palette[768];

void loaddata(void)
{
  FILE *f;

  f = fopen("marine.raw", "rb");
  fread(picture, 1, sizeof(picture), f);
  fclose(f);
  f = fopen("marine.col", "rb");
  fread(palette, 1, 768, f);
  fclose(f);
}

void initialise(void)
{
  int loop;

  asm {
    mov ax, 0x13
    int 0x10
    push es
    mov ax, 0xA000
    mov es, ax
    xor di, di
    xor ax, ax
    mov cx, 32000
    rep stosw
    pop es
  }
  outp(0x3c8, 0);
  for (loop=0; loop<768; loop++)
    outp(0x3c9, palette[loop]);
}

void putpixel(int x, int y, UCHAR col)
{
  asm {
    mov ax, 0xA000
    mov es, ax
    mov ah, byte ptr y
    mov di, ax
    shr ax, 2
    add di, ax
    add di, x
    mov al, col
    mov es:[di], al
  }
}

void rotateuntilkey(void)
{
  float sinl[360];
  float cosl[360];
  int   angle;
  int   loop, x, y, tx, ty;

  angle = 0;

  for (loop=0; loop<360; loop++)
  {
    sinl[loop] = sin(loop*3.1415/180);
    cosl[loop] = cos(loop*3.1415/180);
  }

  do
  {
    if (angle>359)
      angle = angle-360;

    for (y=-99; y<101; y++)
    {
      for (x=-114; x<116; x++)
      {
	 tx = (int)(x*cosl[angle] - y*sinl[angle])+90;
	 ty = (int)(x*sinl[angle] + y*cosl[angle])+70;
	 if (ty<141&&ty>=0&&tx<181&&tx>=0)
	   putpixel(x+160, y+100, picture[ty][tx]);
      }
    }

    angle += 3;

  } while (!kbhit());
}

void main(void)
{
  loaddata();
  initialise();
  rotateuntilkey();
  asm {
    mov ax, 3
    int 0x10
  }
  printf("amazing wasn't it? - Tiberius/IM\n");
}

