{$R-,S-,I+}

{
16-color Crossfading example by Trixter / Hornet
for "VGA Hardware Tricks" series in DemoNews (10/25/95)

This is not optimized for speed--just clarity.
This compiles under Protected mode as well.  :-)

email:  trixter@mcs.com
}

Program xfade_16;

Type
  {palette types}
  tpaltype=Array[0..255,0..2] Of Byte;
  {buffer types}
  tbuftype=Array [0..(320*200)-1] Of Byte;
  pbuftype=^tbuftype;
  
Var
  buf1,buf2:pbuftype;
  pal1,pal2:tpaltype;
  
Function ReadKey : Word; Assembler;
Asm
  MOV AH, 10h
  Int 16h
End;

Function KeyPressed : Boolean; Assembler;
Asm
  MOV AH, 11h
  Int 16h
  MOV AX, 0
  JZ @NoKey
  Inc AX
  @NoKey:
End;

Procedure Pal(Col,R,G,B : Byte); Assembler;
{This sets the Red, Green and Blue values of a certain palette index}
Asm
  mov    DX,3c8h
  mov    AL,[col]
  out    DX,AL
  Inc    DX
  mov    AL,[r]
  out    DX,AL
  mov    AL,[g]
  out    DX,AL
  mov    AL,[b]
  out    DX,AL
End;

Procedure WaitForRetrace;Assembler;
Asm
  MOV   DX,3DAh
  @Wait:
  In    AL,DX
  Test  AL,08h
  JZ    @Wait
  @Retr:
  In    AL,DX
  Test  AL,08h
  JNZ   @Retr
End;

Procedure fadepalette(oldpal,newpal:tpaltype);
{fade from one palette to another}
Const
  startc=0;
  endc=255;
  
Var
  loop1,loop2:Byte;

Begin
  For loop1:=0 To 63 Do Begin
    {wait for vertical retrace twice for an adequate delay}
    For loop2:=0 To 1 Do WaitForRetrace;
    For loop2:=startc To endc Do Begin
      If OldPal[loop2,0]<NewPal[loop2,0] Then Inc (OldPal[loop2,0]);
      If OldPal[loop2,0]>NewPal[loop2,0] Then Dec (OldPal[loop2,0]);

      If OldPal[loop2,1]<NewPal[loop2,1] Then Inc (OldPal[loop2,1]);
      If OldPal[loop2,1]>NewPal[loop2,1] Then Dec (OldPal[loop2,1]);

      If OldPal[loop2,2]<NewPal[loop2,2] Then Inc (OldPal[loop2,2]);
      If OldPal[loop2,2]>NewPal[loop2,2] Then Dec (OldPal[loop2,2]);

      pal(loop2,OldPal[loop2,0],OldPal[loop2,1],OldPal[loop2,2]);
    End;
  End;
End;

Procedure initfade;
Var
  f1,f2:File;
Begin
  {enter mode 13h -- 320x200x256 colors}
  Asm
    XOr AX,AX
    mov AL,$13
    Int 10h
  End;
  {load pictures;
   "SCX" file format is created by ColoRIX (320x200) and Image Alchemy's -R option}
  GetMem(buf1,320*200);
  Assign(f1,'picture1.scx');
  Reset(f1,1);
  Seek(f1,10);
  BlockRead(f1,pal1,16*3); {only loading first 16 colors}
  Seek(f1,778);
  BlockRead(f1,buf1^,320*200);
  Close(f1);

  GetMem(buf2,320*200);
  Assign(f2,'picture2.scx');
  Reset(f2,1);
  Seek(f2,10);
  BlockRead(f2,pal2,16*3); {only loading first 16 colors}
  Seek(f2,778);
  BlockRead(f2,buf2^,320*200);
  Close(f2);
End;

Procedure dofade;
Var
  screen:pbuftype;
  loop:Word;

Begin
  {massage first picture's palette to the correct format}
  For loop:=0 To 256-1 Do Begin
    pal1[loop,0]:=pal1[loop Mod 16,0];
    pal1[loop,1]:=pal1[loop Mod 16,1];
    pal1[loop,2]:=pal1[loop Mod 16,2];
  End;
  {massage second picture's palette to the correct format (CAREFUL: NOT THE SAME as what we just did)}
  For loop:=256-1 Downto 0 Do Begin
    pal2[loop,0]:=pal2[loop Div 16,0];
    pal2[loop,1]:=pal2[loop Div 16,1];
    pal2[loop,2]:=pal2[loop Div 16,2];
  End;
  {put first picture's palette onto screen}
  For loop:=0 To 256-1 Do
    pal(loop,pal1[loop,0],pal1[loop,1],pal1[loop,2]);
  {plot composite onto screen -- first picture will show up because that's
   the palette we have up right now}
  screen:=Ptr(SegA000,0);
  For loop:=0 To 64000-1 Do
    screen^[loop]:=buf1^[loop] Or (buf2^[loop] ShL 4);
  {wait for keypress}
  ReadKey;
  Repeat
    {fade from one to the other}
    fadepalette(pal1,pal2);
    {wait a second (70 retraces a second)}
    For loop:=1 To 70 Do WaitForRetrace;
    {fade from the other to one}
    fadepalette(pal2,pal1);
    {wait a second (70 retraces a second)}
    For loop:=1 To 70 Do WaitForRetrace;
  Until KeyPressed;
  {absorb the keypress}
  ReadKey;
End;

Procedure donefade;
Begin
  {free the memory}
  FreeMem(buf1,320*200);
  FreeMem(buf2,320*200);
  {go back to text mode}
  Asm
    XOr AX,AX
    mov AL,$3
    Int 10h
  End;
End;

Begin
  Initfade;
  dofade;
  donefade;
End.