;***************************************************************************
;*	Ce fichier contient les dfinitions des structures et des variables
;*	permettant la communication entre le driver et le player
;*
;* Programm par Sbastien Granjoux
;* Commenc le 04/01/95
;* Modification le 04/01/95

IDEAL

STRUC DEVICE
	id	DW 0
	detect	DB 30 DUP (0)
	set	DW 0
	init	DW 0
	start	DW 0
	stop	DW 0
	make	DW 0
	setbpm	DW 0
	getbyte DW 0
	mem	DW 0
	port	DW 0
	irq	DB 0
	dma	DB 0
	hdma	DB 0
		DB 0
ENDS

STRUC VOICE
	endadr  DD 0
	replen	DD 0
	sampadr DD 0
	volume	DB 0
	type	DB 0
	adrseg	DW 0
		DW 0
	frac	DW 0
	vocadr	DD 0
	play    DW 0		; note jou
	oldnote DW 0		; note prcdente (portamento)
	effet   DW 0
	note1   DW 0
	note2   DW 0
	amplit	DB 0
	vitesse	DB 0
	sinpos  DB 0
	compte	DB 0
	inst	DB 0
	gusinf	DB 0	;bit 3 new vol,2 nul vol,1 change adr,0 new inst
	extra	DB 0
	mute	DB 0    ;0=voix coup,255 voix normal
	looppos DW 0
	effnb	DB 0
	oldvib	DB 0
	oldtrem DB 0
	oldport DB 0
	oldslid	DB 0
	altdata DD 0
ENDS

BUF_LEN		EQU	8192
VOL_TAB_LEN	EQU	65*256

;** Donnes du player utiliser par les drivers

GLOBAL	Voice1:VOICE
GLOBAL	SoundBuf:BYTE:BUF_LEN
GLOBAL	SoundPage:WORD
GLOBAL	SoundPtr:WORD
GLOBAL	VoicesLen:WORD
GLOBAL  VolumeSeg:WORD
GLOBAL	NbVoice:BYTE
GLOBAL	MasterVol:BYTE
GLOBAL	MixRate:WORD
GLOBAL	Notes:WORD
GLOBAL	Frame:BYTE
GLOBAL	OldIrq:DWORD
GLOBAL	EmsSeg:WORD
;** Fonctions utilitaires utilisable par les drivers

GLOBAL	USEDEVICE:NEAR
GLOBAL	calvoltab:NEAR
GLOBAL	caloptvoltab:NEAR
GLOBAL	setautoeoi:NEAR
GLOBAL	reseteoi:NEAR
GLOBAL	defbpm:NEAR
GLOBAL	peekdef:NEAR
GLOBAL	setirq:NEAR
GLOBAL	getirq:NEAR
GLOBAL	switch_makemod:NEAR
GLOBAL  IMAKEMOD:NEAR
GLOBAL	Ampli8:BYTE
GLOBAL  DevMem:DWORD

;***************************************************************************
;*	macro de prparation d'une voix avant le calcul

MACRO	MAKEVOICE
	LOCAL @@next_seg,@@one_seg,@@adjust,@@no_overflow,@@load_note,@@conv_mem,@@one_page,@@frm_mem

	mov     dx,[(VOICE ptr ds:di).effet]
	call    dx

	mov	esi,[(VOICE ptr ds:di).vocadr]
	mov	ecx,[(VOICE ptr ds:di).endadr]
	cmp	esi,ecx
	jbe	@@no_overflow
	mov	edx,[(VOICE PTR ds:di).replen]
@@adjust:
	sub	esi,edx
	cmp	esi,ecx
	jae	@@adjust
	mov	[(VOICE ptr ds:di).vocadr],esi
@@no_overflow:
	test	[(VOICE ptr ds:di).type],1
	jz	@@conv_mem
	ror	esi,14
	mov	bx,si
	mov	dx,[(VOICE ptr ds:di).adrseg]
	mov	ax,4400h
	int	67h
	rol	esi,14
	and	esi,3FFFh
	cmp	si,11264
	jbe	@@one_page
	mov	ax,4401h
	inc	bx
	int	67h
@@one_page:
	mov	cx,[(VOICE ptr ds:di).frac]
	mov     es,[EmsSeg]
	jmp     @@load_note


@@conv_mem:
	ror	esi,4
	mov	es,si
	rol	esi,4
	and	esi,0Fh
	mov	cx,[(VOICE ptr ds:di).frac]

@@load_note:
	mov	bx,[(VOICE ptr ds:di).play]
	shl	bx,1
	xor	edx,edx
	mov	dx,[word ptr ds:bx+OFFSET Notes]
	shr	dx,2
	mov	cl,dl
	shr	dx,8

	xor	bx,bx
	mov	al,[MasterVol]
	and	al,[(VOICE PTR ds:di).mute]
	mul	[(VOICE PTR ds:di).volume]
	add	bh,ah


ENDM

MACRO	MAKEVOICE16
	LOCAL @@next_seg,@@one_seg,@@adjust,@@no_overflow,@@load_note,@@conv_mem,@@one_page,@@frm_mem

	mov     dx,[(VOICE ptr ds:di).effet]
	call    dx

	mov	esi,[(VOICE ptr ds:di).vocadr]
	mov	ecx,[(VOICE ptr ds:di).endadr]
	cmp	esi,ecx
	jbe	@@no_overflow
	mov	edx,[(VOICE PTR ds:di).replen]
@@adjust:
	sub	esi,edx
	cmp	esi,ecx
	jae	@@adjust
	mov	[(VOICE ptr ds:di).vocadr],esi
@@no_overflow:
	test	[(VOICE ptr ds:di).type],1
	jz	@@conv_mem
	ror	esi,14
	mov	bx,si
	mov	dx,[(VOICE ptr ds:di).adrseg]
	mov	ax,4400h
	int	67h
	rol	esi,14
        and	esi,3FFFh
	cmp	si,11264
	jbe	@@one_page
	mov	ax,4401h
	inc	bx
	int	67h
@@one_page:
	mov	cx,[(VOICE ptr ds:di).frac]
	mov     es,[EmsSeg]
	jmp     @@load_note


@@conv_mem:
	ror	esi,4
	mov	es,si
	rol	esi,4
	and	esi,0Fh
	mov	cx,[(VOICE ptr ds:di).frac]

@@load_note:
	mov	bx,[(VOICE ptr ds:di).play]
	shl	bx,1
	xor	edx,edx
	mov	dx,[word ptr ds:bx+OFFSET Notes]
	shr	dx,2
	mov	cl,dl
	shr	dx,8

	xor	ebx,ebx
	mov	al,[MasterVol]
	and	al,[(VOICE PTR ds:di).mute]
	mul	[(VOICE PTR ds:di).volume]
	add	bh,ah
	add	bh,ah
	xor	eax,eax

ENDM

;*************************************************************************
;*	macro pour sauvegarder le nouvel etat de la voix

MACRO SAVEVOICE
	LOCAL @@conv_mem,@@next_voice,@@frm_mem

	test	[(VOICE ptr ds:di).type],1
	jz	@@conv_mem
	and	[(word ptr (VOICE ptr ds:di).vocadr)],0C000h
	add	[(VOICE ptr ds:di).vocadr],esi
	mov	[(VOICE ptr ds:di).frac],cx
	jmp	@@next_voice


@@conv_mem:
	and	[(byte ptr (VOICE ptr ds:di).vocadr)],0F0h
	add	[(VOICE ptr ds:di).vocadr],esi
	mov	[(VOICE ptr ds:di).frac],cx
@@next_voice:

ENDM
