;***************************************************************************
;*	Driver pour le PC speaker
;*
;* Programm par Sbastien Granjoux
;* Commenc le 07/01/95
;* Modification le 07/01/95

IDEAL
P386N

INCLUDE "CRYSERR.INC"
INCLUDE "CRYSDEV.INC"

PUBLIC	USESPK
PUBLIC	setspk
PUBLIC	startspk
PUBLIC	makespk
PUBLIC	stopspk
PUBLIC	defbpmspk

SEGMENT CODE PARA PUBLIC USE16 'CODE'

ASSUME cs:CODE,ds:CODE

;*************************************************************************
;*	Fonction de detection du driver

PROC	USESPK

	call	USEDEVICE
	DEVICE <01h,'$',OFFSET setspk,OFFSET initspk,OFFSET startspk,OFFSET stopspk,OFFSET makespk,OFFSET defbpmspk,OFFSET peekdef,0,0,0,0,0>

ENDP

Counter         DD      0
Count           DD      0
OtherCount      DW      0

;***************************************************************************
;*	Routine d'initialisation du speaker

PROC	setspk

	mov	[(DEVICE PTR ds:si).irq],0
	shr	[MixRate],1

	clc
	ret

ENDP

;***************************************************************************
;*	routine permettant d'initialiser le speaker

PROC	initspk

	mov	cl,[NbVoice]
	call	calvoltab
	ret
ENDP

;***************************************************************************
;*	routine permettant de dmarrer l'envoit du son sur le speaker

PROC	startspk

	cli
	push	ds
	mov	ax,0FFFFh
	mov	ds,ax
	cmp	[byte ptr ds:0Eh],0F8h
	pop	ds
	mov     ax,OFFSET soundspk
	jne	@@no_ps2
	mov	ax,OFFSET soundspkps2
@@no_ps2:
	mov     dx,cs
	xor	bl,bl
	call	setirq

	mov	al,00110110b
	out     43h,al
	jmp	$+2
	jmp	$+2

	mov	dx,12h
	mov	ax,034Dch
	div	[ds:MixRate]
	shr	ax,1

	out     40h,al
	jmp	$+2
	jmp	$+2
	rol     ax,8
	out     40h,al
	jmp	$+2
	jmp	$+2
	rol	ax,8

	movzx	ecx,ax
	mov	eax,80000000h
	xor	edx,edx
	div	ecx

	add	eax,eax
	mov     [ds:Counter],eax
        shr     eax,16
        mov     [ds:OtherCount],ax
	mov     ax,[ds:VoicesLen]
	sub     [ds:OtherCount],ax
	mov     [ds:Count],1

	mov	al,10010000b
	out     43h,al
	jmp	$+2
	jmp	$+2
	in      al,61h
	jmp	$+2
	jmp	$+2
	or      al,11b
	out     61h,al
	jmp	$+2
	jmp	$+2

;	call	setautoeoi
	sti

	ret

ENDP

;**************************************************************************
;*	cette procdure est en fait un bloc que l'on doit mettre 
;*	l'adresse Voices

PROC	makespk

	mov	cl,[NbVoice]
	sub	cl,2
	push	cx

	mov	di,OFFSET Voice1
	MAKEVOICE

	mov	di,[ds:OFFSET SoundPage]

	push	ebp
@@voix1:
	add	ch,cl
	adc     esi,edx
	mov	al,[byte ptr es:esi]
	xlat	[fs:bx]
	mov	ah,al
	add	ch,cl
	adc	esi,edx
	mov	al,[byte ptr es:esi]
	xlat	[fs:bx]
	mov	[ds:di+OFFSET SoundBuf],ax
	add	di,4

	cmp	di,bp
	jne	@@voix1
	rol	ebp,16
	xor	di,di
	cmp	bp,BUF_LEN
	jne	@@voix1
	pop	ebp

	mov	di,OFFSET Voice1
	SAVEVOICE

	pop	cx
	add	di,SIZE VOICE
@@next_voice:
	push	cx

	MAKEVOICE

	push	di
	push	ebp
	mov	di,[ds:OFFSET SoundPage]
@@voix2:
	add	ch,cl
	adc     esi,edx
	mov     al,[byte ptr es:esi]
	xlat	[fs:bx]
	mov	ah,al
	add	ch,cl
	adc	esi,edx
	mov	al,[byte ptr es:esi]
	xlat	[fs:bx]
	add     [ds:di+OFFSET SoundBuf],al
	add	[ds:di+OFFSET SoundBuf+1],ah
	add	di,4

	cmp	di,bp
	jne	@@voix2
	rol	ebp,16
	xor	di,di
	cmp	bp,BUF_LEN
	jne	@@voix2
	pop	ebp

	pop	di
	SAVEVOICE
	add	di,SIZE VOICE

	pop	cx
	dec	cl
	jne	@@next_voice


	MAKEVOICE

	push	di
	mov	di,[ds:OFFSET SoundPage]

@@voix4:
	add	ch,cl
	adc     esi,edx
	mov     al,[byte ptr es:esi]
	xlat	[fs:bx]
	mov	ah,al
	add	ch,cl
	adc	esi,edx
	mov	al,[byte ptr es:esi]
	xlat	[fs:bx]
	add     al,[ds:di+OFFSET SoundBuf]
	add	ah,[ds:di+OFFSET SoundBuf+1]
	mov	[ds:di+OFFSET SoundBuf],ah
	mov	[ds:di+OFFSET SoundBuf+1],ah
	mov	ah,al
	mov	[ds:di+OFFSET SoundBuf+2],ax
	add	di,4

	cmp	di,bp
	jne	@@voix4
	rol	ebp,16
	xor	di,di
	cmp	bp,BUF_LEN
	jne	@@voix4

	pop	di
	SAVEVOICE

@@fin4voix:

	shr	ebp,16
	and	bp,65535-BUF_LEN
	mov	[word ptr ds:OFFSET SoundPage],bp

	ret

ENDP

;***************************************************************************
;*      interruption 8 permettant d'envoyer le son sur le speaker

PROC    soundspk

	push      ax
	push      bx

	mov	bx,[cs:OFFSET SoundPtr]
	inc	bx
	and	bx,65535-BUF_LEN
	mov	[cs:OFFSET SoundPtr],bx
	mov	al,[cs:bx+OFFSET SoundBuf]

	mov	bx,OFFSET AMPLI8
	xlat	[cs:bx]
	out	42h,al

	pop	bx

	dec	[word cs:OFFSET Count+2]
irq_switch:
	jle	@@imakemod

	mov	al,20h
	out	20h,al

	pop	ax
	iret

@@int08:
	mov     ax,[word ptr cs:OFFSET Counter+2]
	xchg    ax,[cs:OtherCount]
	add     [cs:OFFSET Count+2],ax
	sub     [cs:OtherCount],ax
	add     [byte ptr cs:OFFSET irq_switch+1],OFFSET @@imakemod - OFFSET @@int08

	pop     ax
	jmp	[dword ptr cs:OldIrq]

@@imakemod:

	mov	al,60h
	out	20h,al

	mov     ax,[cs:VoicesLen]
	cmp     ax,[cs:OtherCount]
	jb      @@next_make
	push	eax
	xchg    ax,[cs:OtherCount]
	sub     [cs:OtherCount],ax
	shl     eax,16
	mov     ax,[word ptr cs:Counter]
	add     [cs:OFFSET Count],eax
	sub     [byte ptr cs:OFFSET irq_switch+1],OFFSET @@imakemod - OFFSET @@int08
	pop     eax
	pop	ax

	jmp     IMAKEMOD

@@next_make:
	sub     [cs:OtherCount],ax
	add     [word ptr cs:OFFSET Count+2],ax
	pop     ax

	jmp     IMAKEMOD

ENDP

;***************************************************************************
;*      interruption 8 permettant d'envoyer le son sur le speaker
;*	 (spcial PS2)

PROC    soundspkps2

	push      ax
	push      bx

	mov	bx,[cs:OFFSET SoundPtr]
	inc	bx
	and	bx,65535-BUF_LEN
	mov	[cs:OFFSET SoundPtr],bx
	mov	al,[cs:bx+OFFSET SoundBuf]

	mov	bx,OFFSET AMPLI8
	xlat	[cs:bx]
	out	42h,al

	pop	bx

	dec	[word cs:OFFSET Count+2]
irq_switch2:
	jle	@@imakemod

	mov	al,20h
	out	20h,al

	in	al,61h
	mov	ah,al
	or	al,80h
	out	61h,al
	mov	al,ah
	and	al,7Fh
	out	61h,al

	pop	ax
	iret

@@int08:
	mov     ax,[word ptr cs:OFFSET Counter+2]
	xchg    ax,[cs:OtherCount]
	add     [cs:OFFSET Count+2],ax
	sub     [cs:OtherCount],ax
	add     [byte ptr cs:OFFSET irq_switch2+1],OFFSET @@imakemod - OFFSET @@int08

	pop     ax
	jmp	[dword ptr cs:OldIrq]

@@imakemod:

	mov	al,60h
	out	20h,al

	in	al,61h
	mov	ah,al
	or	al,80h
	out	61h,al
	mov	al,ah
	and	al,7Fh
	out	61h,al

	mov     ax,[cs:VoicesLen]
	cmp     ax,[cs:OtherCount]
	jb      @@next_make
	push	eax
	xchg    ax,[cs:OtherCount]
	sub     [cs:OtherCount],ax
	shl     eax,16
	mov     ax,[word ptr cs:Counter]
	add     [cs:OFFSET Count],eax
	sub     [byte ptr cs:OFFSET irq_switch2+1],OFFSET @@imakemod - OFFSET @@int08
	pop     eax
	pop	ax

	jmp     IMAKEMOD

@@next_make:
	sub     [cs:OtherCount],ax
	add     [word ptr cs:OFFSET Count+2],ax
	pop     ax

	jmp     IMAKEMOD

ENDP

;***************************************************************************
;*	cette routine permet d'arreter l'envoit du son sur le speaker

PROC	stopspk

	in	al,61h
	and     al,11111100b
	out	61h,al

	cli
	mov     al,00110110b
	out     43h,al
	xor	al,al
	jmp	$+2
	jmp	$+2
	out     40h,al
	jmp	$+2
	jmp	$+2
	out     40h,al

	ret

ENDP

;***************************************************************************
;*	Change la vitesse en BPM
;*
;* Entre:
;*	AL	nouvelle vitesse

PROC	defbpmspk

	movzx	cx,al
	lea	cx,[ecx*4+ecx]
	add	cx,cx
	mov	ax,[MixRate]
	mov	dx,25
	mul	dx
	div	cx
	inc	ax
	and	ax,0fffch
	shl	ax,1
	mov	[VoicesLen],ax
	ret

ENDP

ENDS

END
