/* mixvars.h */
/*
     PLAY_ITW.EXE v0.02b : Player for Impulse Tracker modules files
     Copyright (C) 1997  Olivier AUMAGE
     E-mail : Olivier.Aumage@ens-lyon.fr
     Web : http://www.ens-lyon.fr/~oaumage/

     This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
     the Free Software Foundation; either version 2 of the License, or
     any later version.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with this program; if not, write to the Free Software
     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef __MIXVARS_H_
#define __MIXVARS_H_
#include "mixtypes.h"

extern p_module pointer_on_current_module ;

extern int new_note_actions_activated ;

extern double mixing_volume ;
extern unsigned char global_volume ;
extern unsigned char global_volume_slide_on ;
extern unsigned char global_volume_slide_value ;
extern unsigned char last_global_volume_slide_parameter ;

extern unsigned char current_order ;
extern unsigned char current_pattern ;
extern unsigned char current_line ;
extern unsigned char current_frame ;
extern unsigned long current_sample ;

extern unsigned long samples_per_frame ;
extern unsigned char frames_per_line ;
extern unsigned char beats_per_minute ;
extern unsigned long samples_per_minutes ;
extern unsigned long frames_per_beats ;

extern p_pattern pointer_on_current_pattern ;
extern unsigned char *pointer_on_current_pattern_byte ;

extern p_virtual_channel virtual_channels[256] ;
extern unsigned short number_of_virtual_channels_allocated ; /* 0 -> 256 */
extern unsigned short max_number_of_virtual_channels_allocated ; /* 0 -> 256 */

extern real_channel real_channels[64] ; /* this array is an array of structures
                                           whereas the 'virtual_channels' array
                                           is an array of pointers
                                        */

extern double precalculated_notes_table [16384] ;
/*extern unsigned char precalculated_note_shift_value ;*/
extern char last_pattern ;
extern char last_line ;
extern char last_frame ;
extern unsigned short volume_ramp_length ;
extern int volume_ramp_on_off ;
extern int loop_allowed ;
#endif

