// Play_ITwDlg.h : header file
//
/*
PLAY_ITW.EXE v0.03a : Player for Impulse Tracker modules files
Copyright (C) 1998  Olivier AUMAGE
E-mail : Olivier.Aumage@ens-lyon.fr
Web : http://www.ens-lyon.fr/~oaumage/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.
  
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#if !defined(AFX_PLAY_ITWDLG_H__EDB4C8FF_2ACF_11D1_B35E_DCE971BF2962__INCLUDED_)
#define AFX_PLAY_ITWDLG_H__EDB4C8FF_2ACF_11D1_B35E_DCE971BF2962__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

class CPlay_ITwDlgAutoProxy;

/////////////////////////////////////////////////////////////////////////////
// CPlay_ITwDlg dialog

class CPlay_ITwDlg : public CDialog
{
	DECLARE_DYNAMIC(CPlay_ITwDlg);
	friend class CPlay_ITwDlgAutoProxy;

// Construction
public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	CPlay_ITwDlg(char *module, CWnd* pParent = NULL);	// standard constructor
	virtual ~CPlay_ITwDlg();

// Dialog Data
	//{{AFX_DATA(CPlay_ITwDlg)
	enum { IDD = IDD_PLAY_ITW_DIALOG };
	CSliderCtrl	m_latency;
	CSliderCtrl	m_slider_balance_4;
	CSliderCtrl	m_slider_balance_3;
	CSliderCtrl	m_slider_balance_2;
	CSliderCtrl	m_slider_balance_1;
	CSliderCtrl	m_slider_panning_4;
	CSliderCtrl	m_slider_panning_3;
	CSliderCtrl	m_slider_panning_2;
	CSliderCtrl	m_slider_panning_1;
	CSliderCtrl	m_slider_main_volume;
	CSliderCtrl	m_slider_fb_volume;
	CSliderCtrl	m_slider_fb_delay;
	CEdit	m_edit_4;
	CEdit	m_edit_3;
	CEdit	m_edit_2;
	CEdit	m_edit_1;
	CSliderCtrl m_slider_4;
	CSliderCtrl m_slider_3;
	CSliderCtrl m_slider_2;
	CSliderCtrl m_slider_1;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CPlay_ITwDlg)
	public:
	virtual BOOL Create();
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual void PostNcDestroy();
	//}}AFX_VIRTUAL

// Implementation
protected:
	OnToolTipNotify( UINT id, NMHDR * pNMHDR, LRESULT * pResult) ;
	CToolTipCtrl m_tooltip;
	HICON m_hSmallIcon;
	CPlay_ITwDlgAutoProxy* m_pAutoProxy;
	HICON m_hIcon;

	BOOL CanExit();
	signed long load(signed long previous);

	// Generated message map functions
	//{{AFX_MSG(CPlay_ITwDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnDestroy();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnClose();
	virtual void OnOK();
	virtual void OnCancel();
	afx_msg void OnButtonAbout();
	afx_msg void OnButtonPlay();
	afx_msg void OnButtonStop();
	afx_msg void OnMainLoad1();
	afx_msg void OnMainLoad2();
	afx_msg void OnMainLoad3();
	afx_msg void OnMainLoad4();
	afx_msg void OnMainPlay1();
	afx_msg void OnMainPlay2();
	afx_msg void OnMainPlay3();
	afx_msg void OnMainPlay4();
	afx_msg void OnMainRewind1();
	afx_msg void OnMainRewind2();
	afx_msg void OnMainRewind3();
	afx_msg void OnMainRewind4();
	afx_msg void OnMainStop1();
	afx_msg void OnMainStop2();
	afx_msg void OnMainStop3();
	afx_msg void OnMainStop4();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnMainRewind();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
private:
	void update_volume(signed long num);
	signed long m_module_handles[4];
	bool m_play_at_startup ;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_PLAY_ITWDLG_H__EDB4C8FF_2ACF_11D1_B35E_DCE971BF2962__INCLUDED_)
