// c_module_inline.h: implementation of the c_module class.
//
//////////////////////////////////////////////////////////////////////
/*
PLAY_ITW.EXE v0.03a : Player for Impulse Tracker modules files
Copyright (C) 1998  Olivier AUMAGE
E-mail : Olivier.Aumage@ens-lyon.fr
Web : http://www.ens-lyon.fr/~oaumage/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.
  
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#if !defined(AFX_C_MODULE_INLINE_H__2691C106_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_)
#define AFX_C_MODULE_INLINE_H__2691C106_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

c_module::c_module(FILE *module_file)
{
	// buffers
	unsigned char uc ;
	unsigned short us ;
	
	{		
		/* Verification of the IT module marker 'IMPM' */
		
		char buffer [5] ;
		size_t return_value ;
		
		return_value = fread (buffer, (size_t) 1, (size_t) 4, module_file) ;
		/*		if (return_value == (size_t) -1)
		{
		error ("Cannot read the module") ;
	}*/
		
		if (strncmp ("IMPM", buffer, 4) != 0)
		{
			/* the file isn't a normal IT file */
			/* it may be a compressed IT file, but I don't support them. */
			
			//	error ("Bad module marker") ;
		}
	}
	
	/* Now we can assume (at least for now) that we
	have a regular IT module */
	
	/* Reading of the main module parameters */
	
	/* module name */
	(void) fread (m_name, (size_t) 1, (size_t) 26, module_file) ;
	
	/* jumping over the 2 bytes padding */
	(void) fseek (module_file, 2L, SEEK_CUR) ;
	
	/* number of orders */
	(void) fread (&us, (size_t) 2, (size_t) 1, module_file) ;
	m_number_of_orders = (signed long) us ;
	
	/* number of instruments */
	(void) fread (&us, (size_t) 2, (size_t) 1, module_file) ;
	m_number_of_instruments = (signed long) us ;
	
	/* number of samples */
	(void) fread (&us, (size_t) 2, (size_t) 1, module_file) ;
	m_number_of_samples = (signed long) us ;
	
	/* number of patterns */
	(void) fread (&us, (size_t) 2, (size_t) 1, module_file) ;
	m_number_of_patterns = (signed long) us ;
	
	/* jumping over the 4 bytes of tracker versions fields */
	(void) fseek (module_file, 4L, SEEK_CUR) ;
	
	
	(void) fread (&us, (size_t) 2, (size_t) 1, module_file) ;
	
	m_is_stereo = (us & 1) > 0 ;
	
	m_use_instruments = (us & 4) > 0 ;
	
	m_type_of_slides = (us & 8) > 0 ;
	
	m_old_effects = (us & 16) > 0 ;		
	
	m_g_effect = (us & 32) > 0 ;
	
	
	(void) fread (&us, (size_t) 2, (size_t) 1, module_file) ;
	
	m_has_a_message = (us & 1) > 0 ;
	
	/* global volume */
	(void) fread (&uc, (size_t) 1, (size_t) 1, module_file) ;
	m_global_volume = (signed long) uc ;
	
	/* mixing volume */
	(void) fread (&uc, (size_t) 1, (size_t) 1, module_file) ;
	m_mixing_volume = (signed long) uc ;
	
	/* initial speed */
	(void) fread (&uc, (size_t) 1, (size_t) 1, module_file) ;
	m_initial_speed = (signed long) uc ; 
	
	/* initial tempo */
	(void) fread (&uc, (size_t) 1, (size_t) 1, module_file) ;
	m_initial_tempo = (signed long) uc ; 
	
	/* panning separation */
	(void) fread (&uc, (size_t) 1, (size_t) 1, module_file) ;
	m_panning_separation = (signed long) uc ; 
	
	/* jumping over the 1 byte padding */
	(void) fseek (module_file, 1L, SEEK_CUR) ;
	
	if (m_has_a_message)
	{
		unsigned short message_length ;
		
		unsigned long message_offset ;
		
		/* message length */
		(void) fread (&message_length, (size_t) 2, (size_t) 1, module_file) ;
		
		/* message offset from the beginning of the file */
		(void) fread (&message_offset, (size_t) 4, (size_t) 1, module_file) ;
		
		long current_position = ftell(module_file) ;
		
		/* positionning the file pointer to the beginning of the module message */
		(void) fseek (module_file, message_offset, SEEK_SET) ;
		
		/* allocating memory for the module message */
		m_message = new char[message_length + 1] ;
		if ((void *)m_message == NULL)
		{
			exit (1) ;
		}
		
		/* reading the message */
		(void) fread (m_message, (size_t) 1, (size_t) message_length, module_file) ;
		
		/* making sure that the message string is terminated */
		m_message[message_length] = (char) 0 ;
		
		/* resuming the file pointer */
		(void) fseek (module_file, current_position + 4, SEEK_SET) ;
	}	
	else
	{
		/* jumping over the 10 bytes padding */
		(void) fseek (module_file, 10L, SEEK_CUR) ;
	}
	
	{
		/* reading channels pannings */
		for (signed long counter = 0 ; counter < 64 ; counter ++)
		{
			(void) fread (&uc, (size_t) 1, (size_t) 1, module_file) ;
			m_channels_pannings[counter] = (signed long) uc ;
		}
	}
	
	{
		/* reading channels volumes */
		for (signed long counter = 0 ; counter < 64 ; counter ++)
		{
			(void) fread (&uc, (size_t) 1, (size_t) 1, module_file) ;
			m_channels_volumes[counter] = (signed long)uc ;
		}
	}
	
	
	/* allocating memory for orders list */
	m_orders = new signed long[m_number_of_orders] ;
	/*	if ((void *)m_orders == NULL)
	{
	error("Not enough memory to load the order list");
	}*/
	
	/* reading orders */
	for (signed long counter = 0 ; counter < m_number_of_orders ; counter ++)
	{
		(void) fread (&uc, (size_t) 1, (size_t) 1, module_file) ;
		m_orders[counter] = (signed long)uc ;
	}
	
	if ((m_use_instruments) || (m_number_of_instruments > 0))
	{
		for (signed long i = 0 ; i < m_number_of_instruments ; i ++)
		{
			long current_file_position ;			
			long instrument_offset ;
			
			/* reading the instrument offset */
			(void) fread (&instrument_offset, (size_t) 4, (size_t) 1, module_file) ;
			
			/* saving the current file pointer position */
			current_file_position = ftell (module_file) ;
			
			/* going to the start point of the instrument in the module file */
			(void) fseek (module_file, instrument_offset, SEEK_SET) ;
			
			/* allocating memory for the instrument */
			m_instruments[i] = new c_instrument(module_file) ;
			/*			if ((void *)m_instruments[i] == NULL)
			{
			error("Not enough memory to load an instrument") ;
		}*/
			
			/* return to previous position (next instrument offset) in the file */
			(void) fseek (module_file, current_file_position, SEEK_SET) ;
			
		}
	}
	else
	{ 
		/* sample mode module */
		m_number_of_instruments = m_number_of_samples ;
		
		for (signed long counter = 0 ; counter < m_number_of_samples ; counter++)
		{
			m_instruments[counter] = new c_instrument(counter) ;
		}
	}		
	
	for (signed long i = 0 ; i < m_number_of_samples ; i ++)
	{
		long current_file_position ;
		long sample_offset ;
		
		/* reading the sample offset */
		(void) fread (&sample_offset, (size_t) 4, (size_t) 1, module_file) ;
		
		/* saving the current file pointer position */
		current_file_position = ftell (module_file) ;
		
		/* going to the start point of the sample in the module file */
		(void) fseek (module_file, sample_offset, SEEK_SET) ;
		
		/* allocating memory for the sample */
		m_samples[i] = new c_sample(module_file) ;
		/*		if ((void *)m_samples[i] == NULL)
		{
		error("Not enough memory to load a sample") ;
	}			*/
		
		/* return to previous position (next sample offset) in the file */
		(void) fseek (module_file, current_file_position, SEEK_SET) ;
	}
	
	for (i = 0 ; i < m_number_of_patterns ; i ++)
	{
		long current_file_position ;			
		long pattern_offset ;
		
		/* reading the pattern offset */
		(void) fread (&pattern_offset, (size_t) 4, (size_t) 1, module_file) ;
		
		/* saving the current file pointer position */
		current_file_position = ftell (module_file) ;
		
		/* going to the start point of the pattern in the module file */
		(void) fseek (module_file, pattern_offset, SEEK_SET) ;
		
		/* allocating memory for the pattern */
		m_patterns[i] = new c_pattern(module_file) ;
		/*		if ((void *)m_patterns[i] == NULL)
		{
		error("Not enough memory to load a pattern") ;
	}			*/
		
		(void) fseek (module_file, current_file_position, SEEK_SET) ;
		/* return to previous position (next pattern offset) in the file */
		
	}
}

c_module::c_module(istream &is, int format, bool linear_interpolation)
{
	if (format == 1)
	{
		IT_istream_loader(is, linear_interpolation) ;
	}
	else if (format == 2)
	{
		RTM_istream_loader(is) ;
	}
	else
	{
	}
}

void c_module::RTM_istream_loader(istream &is)
{
	// RTM loader  /
	///////////////
	
	/* RTM format data structures */

	struct ObjectHeader
	{
        char id[4];             // "RTMM", "RTND", "RTIN" or "RTSM"
        char rc;                // 0x20
        char name[32];          // object name
        char eof;               // '\x1A'
        WORD version;           // version of the format (actual : 0x112)
        WORD headerSize;        // object header size
	};
	
	struct RTMMHeader               // Real Tracker Music Module
	{
        char software[20];      // software used for saving the module
        char composer[32];
        WORD flags;             // song flags
		// bit 0 : linear table, bit 1 : track names present
        BYTE ntrack;            // number of tracks
        BYTE ninstr;            // number of instruments
        WORD nposition;         // number of positions
        WORD npattern;          // number of patterns
        BYTE speed;             // initial speed
        BYTE tempo;             // initial tempo
        char panning[32];       // initial pannings (for S3M compatibility)
        DWORD extraDataSize;    // length of data after the header
        char originalName[32];  // Original name of the module
	};
	
	// Reads : Object Header
	ObjectHeader object_header ;

	is.read((char*)&object_header, sizeof (struct ObjectHeader));
	if (strncmp(object_header.id, "RTMM", 4))
	{
		// Bad marker
	}

	// Reads : Real Tracker Music Module
	RTMMHeader rtmm_header ;
	if (object_header.headerSize == sizeof(RTMMHeader))
	{
		// Header size is right
		is.read((char*)&rtmm_header, object_header.headerSize);
	}
	else if (object_header.headerSize < sizeof(RTMMHeader))
	{
		memset(&rtmm_header, 0, sizeof(RTMMHeader)) ;
		is.read((char*)&rtmm_header, object_header.headerSize);
	}
	else // object_header.headerSize > sizeof(RTMMHeader)
	{
		is.read((char*)&rtmm_header, sizeof(RTMMHeader));
		is.seekg((streamoff)(object_header.headerSize - sizeof(RTMMHeader)), ios::cur) ;
	}

	// Decodes : Real Tracker Music Module structure
	// Flags:
	m_type_of_slides = ((rtmm_header.flags & 1) > 0) ;

	// Instruments
	m_number_of_instruments = rtmm_header.ninstr ;

	// Orders
	m_number_of_orders = rtmm_header.nposition ;

	// Patterns
	m_number_of_patterns = rtmm_header.npattern ;

	// Initial speed
	m_initial_speed = rtmm_header.speed ;

	// Initial tempo
	m_initial_tempo = rtmm_header.tempo ;

	// Initial panning

	/*- nothing for now -*/

	// Module name
	strncpy (m_name, rtmm_header.originalName, 32) ;
	m_name[32] = '\0' ; // to be sure that the string has an end

	// saves : the current position in the file
	streampos current_file_position = is.tellg() ;

	// Loads : Orders
	m_orders = new signed long[m_number_of_orders] ;

	for (int i = 0 ; i < m_number_of_orders ; i++)
	{
		unsigned short word ;

		is.read((char*)&word, 2) ;
		m_orders[i] = (signed long)word ;
	}

	// Goes to : patterns
	is.seekg((streampos)(current_file_position + rtmm_header.extraDataSize)) ;

	// Reads : patterns
	for (i = 0 ; i < m_number_of_patterns ; i++)
	{
		m_patterns[i] = new c_pattern(is, 2) ; // 2 = RTM module
	}

	// Reads : intruments
	m_number_of_samples = 0 ;
	for (i = 0 ; i < m_number_of_instruments ; i++)
	{
		m_instruments[i] = new c_instrument(is, 2) ; // 2 = RTM module
	}

}

void c_module::IT_istream_loader(istream &is, bool linear_interpolation)
{
	// IT module loader	 /
	/////////////////////
	// buffers
	unsigned char uc ;
	unsigned short us ;
	
	{		
		/* Verification of the IT module marker 'IMPM' */
		
		char buffer [5] ;
		
		is.read(buffer, 4) ;
		
		if (strncmp ("IMPM", buffer, 4) != 0)
		{
			/* the file isn't a normal IT file */
			/* it may be a compressed IT file, but I don't support them. */
			
			/*			error ("Bad module marker") ;*/
		}
	}
	
	/* Now we can assume (at least for now) that we
	have a regular IT module */
	
	/* Reading of the main module parameters */
	
	/* module name */
	is.read(m_name, 26) ;
	
	/* jumping over the 2 bytes padding */
	is.seekg((streamoff) 2, ios::cur) ;
	
	/* number of orders */
	is.read((char*)&us, 2) ;
	m_number_of_orders = (signed long) us ;
	
	/* number of instruments */
	is.read((char*)&us, 2) ;
	m_number_of_instruments = (signed long) us ;
	
	/* number of samples */
	is.read((char*)&us, 2) ;
	m_number_of_samples = (signed long) us ;
	
	/* number of patterns */
	is.read((char*)&us, 2) ;
	m_number_of_patterns = (signed long) us ;
	
	/* created with tracker Y.XX = 0x0YXX */
	is.read((char*)&us, 2) ;
	m_cwt = (signed long) us ;

	/* compatible with tracker greater than Y.XX = 0x0YXX */
	is.read((char*)&us, 2) ;
	m_cmwt = (signed long) us ;
	
	is.read((char*)&us, 2) ;
	m_is_stereo = (us & 1) > 0 ;
	m_use_instruments = (us & 4) > 0 ;
	m_type_of_slides = (us & 8) > 0 ;
	m_old_effects = (us & 16) > 0 ;		
	m_g_effect = (us & 32) > 0 ;
	
	
	is.read((char*)&us, 2) ;
	m_has_a_message = (us & 1) > 0 ;
	
	/* global volume */
	is.read((char *)&uc, 1);
	m_global_volume = (signed long) uc ;
	
	/* mixing volume */
	is.read((char *)&uc, 1);
	m_mixing_volume = (signed long) uc ;
	
	/* initial speed */
	is.read((char *)&uc, 1);
	m_initial_speed = (signed long) uc ; 
	
	/* initial tempo */
	is.read((char *)&uc, 1);
	m_initial_tempo = (signed long) uc ; 
	
	/* panning separation */
	is.read((char *)&uc, 1);
	m_panning_separation = (signed long) uc ; 
	
	/* jumping over the 1 byte padding */
	is.seekg((streamoff) 1, ios::cur) ;	
	
	if (m_has_a_message)
	{
		signed long sl ;
		
		is.read((char*)&us, 2) ;
		unsigned short message_length = us ;
		is.read((char*)&sl, 4) ;
		streampos message_offset = (streampos) sl;
		
		streampos current_position = is.tellg() ;
		
		/* positionning the file pointer to the beginning of the module message */
		is.seekg(message_offset) ;
		
		/* allocating memory for the module message */
		m_message = new char[message_length + 1] ;
		/*		if ((void *)m_message == NULL)
		{
		error ("Not enough memory to load the song message") ;
	}*/
		
		/* reading the message */
		is.read (m_message, message_length) ;
		
		/* making sure that the message string is terminated */
		m_message[message_length] = (char) 0 ;
		
		/* resuming the file pointer */
		is.seekg(current_position + (streamoff) 4) ;
	}	
	else
	{
		/* jumping over the 10 bytes padding */
		is.seekg((streamoff)10, ios::cur) ;
	}
	
	/* reading channels pannings */
	for (signed long counter = 0 ; counter < 64 ; counter ++)
	{
		is.read((char *)&uc, 1);
		m_channels_pannings[counter] = (signed long) uc ;
	}
	
	/* reading channels volumes */
	for (counter = 0 ; counter < 64 ; counter ++)
	{
		is.read((char *)&uc, 1);
		m_channels_volumes[counter] = (signed long)uc ;
	}
	
	
	/* allocating memory for orders list */
	m_orders = new signed long[m_number_of_orders] ;
	/*	if ((void *)m_orders == NULL)
	{
	error("Not enough memory to load the order list");
	}*/
	
	/* reading orders */
	for (counter = 0 ; counter < m_number_of_orders ; counter ++)
	{
		is.read((char *)&uc, 1);
		m_orders[counter] = (signed long)uc ;
	}
	
	if ((m_use_instruments) || (m_number_of_instruments > 0))
	{
		for (signed long i = 0 ; i < m_number_of_instruments ; i ++)
		{
			long sl ;
			
			/* reading the instrument offset */
			is.read((char *)&sl, 4) ;
			streampos instrument_offset = (streampos) sl ;
			
			/* saving the current file pointer position */
			streampos current_file_position = is.tellg() ;
			
			/* going to the start point of the instrument in the module file */
			is.seekg(instrument_offset) ;
			
			/* allocating memory for the instrument */
			m_instruments[i] = new c_instrument(is, 1) ;
			/*			if ((void *)m_instruments[i] == NULL)
			{
			error("Not enough memory to load an instrument") ;
		}*/
			
			/* return to previous position (next instrument offset) in the file */
			is.seekg(current_file_position) ;			
		}
	}
	else
	{ 
		/* sample mode module */
		m_number_of_instruments = m_number_of_samples ;
		
		for (signed long counter = 0 ; counter < m_number_of_samples ; counter++)
		{
			m_instruments[counter] = new c_instrument(counter) ;
		}
	}		
	
	for (signed long i = 0 ; i < m_number_of_samples ; i ++)
	{
		long sl ;
		
		/* reading the sample offset */
		is.read((char *)&sl, 4);
		streampos sample_offset = (streampos) sl ;
		
		/* saving the current file pointer position */
		streampos current_file_position = is.tellg () ;
		
		/* going to the start point of the sample in the module file */
		is.seekg(sample_offset) ;
		
		/* loading the sample */
		/* if ((m_cwt >= 0x214) && (m_cmwt >= 0x214) && (m_cmwt <= 0x216))
		{
			m_samples[i] = new c_sample(is, linear_interpolation, 1) ;
		}
		else
		{
			m_samples[i] = new c_sample(is, linear_interpolation, 0) ;
		} */
		m_samples[i] = new c_sample(is, linear_interpolation) ;

		/*		if ((void *)m_samples[i] == NULL)
		{
		error("Not enough memory to load a sample") ;
	}			*/
		
		/* return to previous position (next sample offset) in the file */
		is.seekg(current_file_position) ;
	}
	
	for (i = 0 ; i < m_number_of_patterns ; i ++)
	{
		long sl ;		
		
		/* reading the pattern offset */
		is.read((char *)&sl, 4);
		streampos pattern_offset = (streampos) sl ;
		
		/* saving the current file pointer position */
		streampos current_file_position = is.tellg () ;
		
		/* going to the start point of the pattern in the module file */
		is.seekg(pattern_offset) ;		
		
		/* allocating memory for the pattern */
		m_patterns[i] = new c_pattern(is, 1) ;
		/*		if ((void *)m_patterns[i] == NULL)
		{
		error("Not enough memory to load a pattern") ;
	}			*/
		
		/* return to previous position (next pattern offset) in the file */
		is.seekg(current_file_position) ;
	}
}

c_module::~c_module()
{
	if (m_has_a_message && (m_message != (char *)NULL))
	{
		delete[] m_message ;
	}
	
	if (m_orders != (signed long *)NULL)
	{
		delete[] m_orders ;
	}
	
	for (signed long i = 0 ; i < m_number_of_instruments ; i ++)
	{
		if (m_instruments[i] != (p_instrument)NULL)
		{
			delete m_instruments[i] ;
		}
	}
	
	for (i = 0 ; i < m_number_of_samples ; i ++)
	{
		if (m_samples[i] != (p_sample)NULL)
		{
			delete m_samples[i] ;
		}
	}
	
	for (i = 0 ; i < m_number_of_patterns ; i ++)
	{
		if (m_patterns[i] != (p_pattern)NULL)
		{
			delete m_patterns[i] ;
		}
	}
}

const char *c_module::get_name()
{
	return m_name ;
}

signed long c_module::get_number_of_orders()
{
	return m_number_of_orders ;
}

signed long c_module::get_number_of_instruments()
{
	return m_number_of_instruments ;
}

signed long c_module::get_number_of_samples()
{
	return m_number_of_samples ;
}

signed long c_module::get_number_of_patterns()
{
	return m_number_of_patterns ;
}

bool c_module::is_stereo()
{
	return m_is_stereo ;
}

bool c_module::use_instruments()
{
	return m_use_instruments ;
}

bool c_module::use_linear_slides()
{
	return m_type_of_slides ;
}

bool c_module::use_old_effects()
{
	return m_old_effects ;
}

bool c_module::use_compatible_g()
{
	return m_g_effect ;
}

bool c_module::has_a_message()
{
	return m_has_a_message ;
}

const char *c_module::get_message()
{
	return m_message ;
}

signed long c_module::get_global_volume()
{
	return m_global_volume ;
}

signed long c_module::get_mixing_volume()
{
	return m_mixing_volume ;
}

signed long c_module::get_initial_speed()
{
	return m_initial_speed ;
}

signed long c_module::get_initial_tempo()
{
	return m_initial_tempo ;
}

signed long c_module::get_panning_separation()
{
	return m_panning_separation ;
}

signed long c_module::get_channel_volume(signed long channel)
{
	if ((channel >= 0) && (channel < 64))
	{
		return m_channels_volumes[channel] ;
	}
	else
	{
		return -1 ;
	}
}

signed long c_module::get_channel_panning(signed long channel)
{
	if ((channel >= 0) && (channel < 64))
	{
		return m_channels_pannings[channel] ;
	}
	else
	{
		return -1 ;
	}
}

signed long c_module::get_order (signed long order)
{
	if ((order >= 0) && (order < m_number_of_orders))
	{
		return m_orders[order] ;
	}
	else
	{
		return -1 ;
	}
}

p_instrument c_module::get_instrument (signed long instrument)
{
	instrument-- ;
	if ((instrument >= 0) && (instrument < m_number_of_instruments))
	{
		return m_instruments[instrument] ;
	}
	else
	{
		return (p_instrument)NULL ;
	}
}

p_sample c_module::get_sample (signed long sample)
{
	sample-- ;
	if ((sample >= 0) && (sample < m_number_of_samples) && (m_samples[sample]->is_on()))
	{
		return m_samples[sample] ;
	}
	else
	{
		return (p_sample)NULL ;
	}
}

p_pattern c_module::get_pattern (signed long pattern)
{
	if ((pattern >= 0) && (pattern < m_number_of_patterns))
	{
		return m_patterns[pattern] ;
	}
	else
	{
		return (p_pattern)NULL ;
	}
}

p_pattern c_module::get_order_pattern (signed long order)
{
	if ((order >= 0) && (order < m_number_of_orders))
	{
		if (m_orders[order] < m_number_of_patterns)
		{
			return m_patterns[m_orders[order]] ;
		}
		else
		{
			return (p_pattern) NULL ;
		}
	}
	else
	{
		return (p_pattern) NULL ;
	}
}

#endif AFX_C_MODULE_INLINE_H__2691C106_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_
