// c_note_sample_inline.h: implementation of the c_note_sample class.
//
//////////////////////////////////////////////////////////////////////
/*
PLAY_ITW.EXE v0.03a : Player for Impulse Tracker modules files
Copyright (C) 1998  Olivier AUMAGE
E-mail : Olivier.Aumage@ens-lyon.fr
Web : http://www.ens-lyon.fr/~oaumage/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.
  
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#if !defined(AFX_C_NOTE_SAMPLE_INLINE_H__2691C101_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_)
#define AFX_C_NOTE_SAMPLE_INLINE_H__2691C101_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

c_note_sample::c_note_sample(signed long note, signed long sample)
{
	if ((note >= 0) && (note <= 119))
	{
		m_note = note ;
		m_sample = sample ;
	}
	else
	{
		// Bad note
//		error ("Note out of bounds") ;
		m_note = -1 ;
		m_sample = -1 ;
	}
}

c_note_sample::c_note_sample(FILE *module_file)
{
	unsigned char note ;
	unsigned char sample ;
	
	/* note */
	(void) fread (&note, (size_t) 1, (size_t) 1, module_file) ;
	
	/* corresponding sample */
	(void) fread (&sample, (size_t) 1, (size_t) 1, module_file) ;    
	
	m_note = (signed long)note ;
	m_sample = (signed long)sample ;
}

c_note_sample::c_note_sample(istream &is)
{
	unsigned char uc ;
	
	is.read((char *)&uc, 1) ;
	m_note = (signed long)uc ;
	is.read((char *)&uc, 1) ;
	m_sample = (signed long)uc ;
}

c_note_sample::~c_note_sample()
{
	// Nothing to be done here : no dynamic data
}

signed long c_note_sample::get_note ()
{
	return m_note ;
}

signed long c_note_sample::get_sample ()
{
	return m_sample ;
}

#endif // AFX_C_NOTE_SAMPLE_INLINE_H__2691C101_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_