// c_pattern_inline.h: implementation of the c_pattern class.
//
//////////////////////////////////////////////////////////////////////
/*
PLAY_ITW.EXE v0.03a : Player for Impulse Tracker modules files
Copyright (C) 1998  Olivier AUMAGE
E-mail : Olivier.Aumage@ens-lyon.fr
Web : http://www.ens-lyon.fr/~oaumage/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.
  
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	  You should have received a copy of the GNU General Public License
	  along with this program; if not, write to the Free Software
	  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#if !defined(AFX_C_PATTERN_INLINE_H__2691C107_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_)
#define AFX_C_PATTERN_INLINE_H__2691C107_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

c_pattern::c_pattern(FILE *module_file)
{
	// buffers
	unsigned char uc ;
	unsigned short us ;			
	
	(void) fread (&us, (size_t) 2, (size_t) 1, module_file) ;
	m_length = (signed long)us ;
	
	(void) fread (&us, (size_t) 2, (size_t) 1, module_file) ;
	m_number_of_rows = (signed long) us ;
	
	/* jumping over the 4 bytes padding */
	(void) fseek (module_file, 4L, SEEK_CUR) ;
	
	m_packed_pattern_data = new signed long[m_length] ;
	
/*	if ((void *)m_packed_pattern_data == NULL)
	{
		error ("Not enough memory to store packed pattern data") ;
	}*/
	
	for (signed long counter = 0 ; counter < m_length ; counter ++)
	{
		(void) fread (&uc, (size_t) 1, (size_t) 1, module_file) ;
		m_packed_pattern_data[counter] = (signed long) uc ;
	}
}

c_pattern::c_pattern(istream &is, int format)
{
	// buffers
	unsigned char uc ;
	unsigned short us ;			
	
	is.read((char *)&us, 2) ;
	m_length = (signed long)us ;
	
	is.read((char *)&us, 2) ;
	m_number_of_rows = (signed long) us ;
	
	/* jumping over the 4 bytes padding */
	is.seekg((streamoff) 4, ios::cur) ;
	
	m_packed_pattern_data = new signed long[m_length] ;
	
/*	if ((void *)m_packed_pattern_data == NULL)
	{
		error ("Not enough memory to store packed pattern data") ;
	}*/
	
	for (signed long counter = 0 ; counter < m_length ; counter ++)
	{
		is.read((char *)&uc, 1) ;
		m_packed_pattern_data[counter] = (signed long) uc ;
	}
}

c_pattern::~c_pattern()
{
	delete[] m_packed_pattern_data ;
}

signed long c_pattern::get_length()
{
	return m_length ;
}

signed long c_pattern::get_number_of_rows()
{
	return m_number_of_rows ;
}

signed long c_pattern::get_data(signed long position)
{
	if ((position >= 0) && (position < m_length))
	{
		return m_packed_pattern_data[position] ;
	}
	else
	{
		//			error ("Out of bounds pattern data requested") ;
		return -1 ;
	}
}

#endif AFX_C_PATTERN_INLINE_H__2691C107_1FD0_11D1_B35E_DCE971BF2962__INCLUDED_
