;=1.08c=;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; FunkTracker - By Super Real Darwin!                                      ;
;               Designed & Coded By Jason Nunn (JsNO)                      ;
;                                                                          ;
; Thanks go to Tom Verbeure/Synergy as he composed a faster frequency      ;
; transformer, making my DAC routines alot tighter. On ya mate :).         ;
; ...and Adam's little fix ups etc. Thanks to Scott Mackenzie for his      ;
; modifications :)                                                         ;
;                                                                          ;
; Snail: 32 Rothdale Road, Moil, Darwin, NT, 0810, Australia               ;
; Email: root@superr.apana.org.au                                          ;
;      : jsno@turtle.apana.org.au                                          ;
;      : jsno@amigar.apana.org.au (no longer used)                         ;
; BBS  :  Amiga Retreat BBS                                               ;
;          (089)451516  (3:850/105)                                        ;
;                                                                          ;
; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=;
; RUNNING IN PROTECTED MODE USING DOS32 By Adam Seychell                   ;
; Snail: 16 Avion Place, Westmeadows, VIC, 3049, AUSTRALIA                 ;
; Email: s921880@minyos.xx.rmit.edu.au                                     ;
; =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=;
;                                                                          ;
; This code is a byproduct of our productions, and have given it to the    ;
; public domain condition free. Please fill free to use it in your         ;
; productions.                                                             ;
;                                                                          ;
;=====================================================================     ;
; EDITOR CODE                                                              ;
;                                                                          ;
; At the application level, this is the editor of funktracker. It does     ;
; everything accept (physically) play the music :).                        ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ideal
p386
model flat
stack 2048
codeseg

extrn debug            : near
Zero_Addr              dd ?
Environment_Address    dd ?
PSP_Address            dd ?
_0B8000h               dd ?

include "funklite.asm"

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; editor data                                                              ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

kb_up                 = 4800h  ;just keyboards equates.
kb_down               = 5000h
kb_left               = 4B00h
kb_right              = 4D00h
kb_home               = 4700h
kb_end                = 4F00h
kb_f1                 = 3B00h
kb_f2                 = 3C00h
kb_f3                 = 3D00h
kb_f4                 = 3E00h
kb_f5                 = 3F00h
kb_altf5              = 6c00h
kb_f6                 = 4000h
kb_altf6              = 6d00h
kb_f7                 = 4100h
kb_f8                 = 4200h
kb_f9                 = 4300h
kb_f10                = 4400h
kb_pageup             = 4900h
kb_pagedn             = 5100h
kb_insert             = 5200h
kb_delete             = 5300h
kb_altc               = 2e00h
kb_altv               = 2f00h
kb_altb               = 3000h
kb_alte               = 1200h
kb_altx               = 2d00h
kb_altn               = 3100h
kb_altm               = 3200h
kb_alto               = 1800h
kb_altz               = 2c00h
kb_alts               = 1f00h
kb_altd               = 2000h
kb_altk               = 2500h
kb_altq               = 1000h
kb_alth               = 2300h
kb_altt               = 1400h

nibble_display        db "0123456789ABCDEF"
note_display          db "C-1C#1D-1D#1E-1F-1F#1G-1G#1A-1A#1B-1"
                      db "C-2C#2D-2D#2E-2F-2F#2G-2G#2A-2A#2B-2"
                      db "C-3C#3D-3D#3E-3F-3F#3G-3G#3A-3A#3B-3"
                      db "C-4C#4D-4D#4E-4F-4F#4G-4G#4A-4A#4B-4"
                      db "C-5C#5D-5D#5E-5F-5F#5G-5G#5A-5A#5B-5"
                      db "???RLO   "
file_search_all       db "*.*",0
file_search_funk      db "*.FNK",0
file_search_wav       db "*.WAV",0
file_search_snd       db "*.SND",0
file_temp             db "\{funky}.tmp"
numread               dd ?
file_handle_funk      dd ?
file_handle_funk2     dd ?

edit_mode             db 0
pat_number            db 0
pat_real              db 0
pat_hl                db 0
pat_chan              db 0
pat_old_hl            db 0
pat_old_chan          db 0
;;;;;;
sel_flag              db 0
sel_area_pattern      dw 0
sel_area_chan1        db 0
sel_area_chan2        db 0
sel_area_trek1        db 0
sel_area_trek2        db 0
temp_pattern          db 600h dup(?)
copied_flag           db 0
copied_area_chan1     db 0
copied_area_chan2     db 0
copied_area_trek1     db 0
copied_area_trek2     db 0
;;;;;;
sam_real              db 0
sam_hl                db 0
sam_col               db 0
note                  db 0
octave                db 0
MIDI_quantise         db 0
seq_real              db 0
seq_hl                db 0
fdir_real             dw 0
fdir_hl               db 0
fdir_length           dw 0
song_name             db "NEW_SONG.FNK",0
initial_dir           db 80 dup(0)
song_dir              db 80 dup(0)
sample_dir            db 80 dup(0)
trakplay_type         db ?

key1_map              db 0,160,160,160,160,160,255
key2_map              db 2,160,160,160,255
key3_map              db 4,160,160,160,158,2,158,2,255
key4_map              db 6,160,160,160,255
key5_map              db 8,160,160,160,158,2,158,2,255
key6_map              db 10,160,160,160,160,160,255
key7_map              db 12,160,160,160,255
key8_map              db 14,160,160,160,158,2,158,2,255
key9_map              db 16,160,160,160,255
keya_map              db 18,160,160,160,158,2,158,2,255
keyb_map              db 20,160,160,160,255
keyc_map              db 22,160,160,160,158,2,158,2,255

dis_keyboard_map:     dd  key1_map, key2_map, key3_map, key4_map, key5_map
                      dd  key6_map, key7_map, key8_map, key9_map, keya_map
                      dd  keyb_map, keyc_map

main_screen:
include "main_sc.asm"
main_screen_size      = $-main_screen

pe_screen:
include "mode_pe.asm"
pe_screen_size        = $-pe_screen

se_screen:
include "mode_se.asm"
se_screen_size        = $-se_screen

trakd_screen:
include "mode_d.asm"
trakd_screen_size     = $-trakd_screen

trakp_screen:
include "mode_ply.asm"
trakp_screen_size     = $-trakp_screen

modefile_screen:
include "modefile.asm"
modefile_screen_size  = $-modefile_screen

comms_screen:
include "comms.asm"
comms_screen_size     = $-comms_screen

help_screen:
include "help.asm"
help_screen_size      = $-help_screen

end_screen:
include "end.asm"
end_screen_size       = $-end_screen

splash_screen:
include "splash.asm"

resample_window:
include "resample.asm"

font_data:
include "funkfont.asm"

struc tdta
  reserved            db 21 dup(?)
  attr                db ?
  time                dw ?
  date                dw ?
  filesize            dd ?
  fname               db 13 dup(?)
ends

struc tfdirectory
  attr                db ?
  fname               db 13 dup(?)
ends
fdir_max_length       = 3000
fdirectory_buffer     dd ?
funk_dma_buffer_addr  dd ?
fade_palette_buf      db 64*3 dup(?)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc key_pressed2
  push   esi
  mov    esi,[Zero_Addr]
  add    esi,41ah
  mov    ax,[esi]
  cmp    ax,[word esi+2]
  jne    @@l
  pop    esi
  clc
  ret
@@l:
  movzx  eax,ax
  add    eax,400h
  add    eax,[Zero_Addr]
  mov    ax,[word eax]
  pop    esi
  stc
  ret
endp

proc get_key
@@l:
  call   key_pressed2
  jnc    @@l
  mov    eax,0
  int    16h
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
MACRO @WaitVert
LOCAL    @@VR
  mov    edx,3dah
@@VR:
  in     al,dx
  test   al,8
  jz     @@VR
ENDM

MACRO @WaitVertEnd
LOCAL    @@NVR
  mov    edx,3dah
@@NVR:
  in     al,dx
  test   al,8
  jnz    @@NVR
ENDM

;esi = offset to palette
;ecx = number of color values to write
;al  = starting palette register
proc WritePalette
  cli
  mov    edx,03c8h
  out    dx,al
  inc    dx
  cld
  rep    outsb
  sti
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; cx = scroll factor
proc scroll_sc
  cli
  mov    eax,ecx
  mov    bl,80
  mul    bl
  mov    ebx,eax
  mov    edx,3d4h
  mov    al,0ch
  mov    ah,bh      ;write the HIGH byte
  out    dx,ax
  mov    edx,3d4h
  mov    al,0dh
  mov    ah,bl      ;write the LOW byte
  out    dx,ax
  sti
  ret
endp

proc help_sc1
  mov    edi,[_0b8000h]
  add    edi,(50*160)
  push   edi ecx
  mov    ecx,(160*50)/4
  xor    eax,eax
  rep    stosd
  pop    ecx edi
  call   uncrush_text
  xor    ecx,ecx
@@sd:
  @WaitVertEnd
  call   scroll_sc
  @WaitVert
  inc    ecx
  cmp    ecx,50
  jbe    @@sd
  ret
endp

proc help_sc2
  mov    ecx,50
@@sd2:
  @WaitVertEnd
  call   scroll_sc
  @WaitVert
  dec    ecx
  jnz    @@sd2
  call   scroll_sc
  ret
endp

proc help_scroll
  call   help_sc1
  call   get_key
  call   help_sc2
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc text_ded_pfout
  XOR    AL,AL                                          ;fade screen
  MOV    ecx,(64*3)
  lea    edi,[fade_palette_buf]
  cli
  MOV    eDX,3c7h
  OUT    DX,AL
  ADD    eDX,2
  rep    insb
  sti
  mov    ecx,64
@@fade_out_loop:
  push   ecx
  lea    edi,[fade_palette_buf]
  mov    ecx,(64*3)
@@fade_loop:
  mov    al,[byte edi]
  or     al,al
  jz     @@dont_dec
  dec    [byte edi]
@@dont_dec:
  inc    edi
  dec    ecx
  jnz    @@fade_loop
  xor    al,al
  mov    ecx,64*3
  lea    esi,[fade_palette_buf]
  call   WritePalette
  @WaitVertEnd
  @WaitVert
  pop    ecx
  dec    ecx
  jnz    @@fade_out_loop
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc dis_sbar
  xor    al,al
@@write_entry:
  push   edi ecx eax
  cmp    al,dl
  je     @@hle
  jmp    @@hlne
@@hle:
  mov    al,bh
  jmp    @@write_lin
@@hlne:
  mov    al,bl
@@write_lin:
  stosb
  inc    edi
  dec    ecx
  jnz    @@write_lin
  pop    eax ecx edi
  add    edi,160
  inc    al
  cmp    al,dh
  jb     @@write_entry
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; SETUP_SCREEN PROC: Modified By Adam Seychell 14/03/94  in V1.02          ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc setup_screen
  mov    eax,3
  int    10h

        mov     bl,00h                 ;  goto Text Mode 80x50
        mov     ah,11h
        mov     al,12h
        int     10h


    ; set up registers to accsess one Bit plane  only
    ; set for sequentual memory addressing
        mov dx,3C4h             ; sequencer reg group
        mov al,4
        mov ah,0111b
        out dx,ax

        mov dx,3CEh             ; The Graphics Controller reg group
        mov al,5                ; Mode Register
        mov ah,00000000b
        out dx,ax

        mov dx,3ceh             ; The Graphics Controller reg group
    	mov al,6                ; Misellaneous Register
        mov ah,1100b
        out dx,ax

      ; set Map Mask Register
        mov dx,3c4h             ; sequencer reg group
    	mov al,2
        mov ah,0100b            ; to write to bit plane 2 ( font memory )
        out dx,ax

     ; can now fill up the video font memory

        mov     edi,[_0b8000h]
        xor     edx,edx
@@fill_font:
        mov     eax,[Dword PTR font_data+EDX]
        mov     [edi],eax
        mov     eax,[Dword PTR font_data+EDX+4]
        mov     [edi+4],eax
        add     edi,32
        add     edx,8
        cmp     edx,255*8
        jb      @@fill_font



  ;      set up registers to accsess one Bit plane 0 and 1 chained together
  ; i.e return to it's normal write mode.
  ;
        mov dx,3C4h             ; sequencer reg group
        mov al,4
        mov ah,00011b           ; Chain four enabled
        out dx,ax

        mov dx,3CEh             ; The Graphics Controller reg group
        mov al,5                ; Mode Register
        mov ah,00010000b
        out dx,ax

        mov al,6                ; Miscellaneous Register
        mov ah,1110b
        out dx,ax

     ; set Map Mask Register
        mov dx,3c4h             ; sequencer reg group
    	mov al,2
        mov ah,0011b            ; to write to bit plane 0 and 1
        out dx,ax

    ;------- end of font filling code --------------------

  mov    ah,02h
  xor    bh,bh
  mov    edx,6400h
  int    10h
  mov    al,1
  mov    ecx,3
  lea    esi,[@@colour]
  call   WritePalette
  mov    al,5
  mov    ecx,3
  lea    esi,[@@colour+3]
  call   WritePalette
  mov    al,3ah
  mov    ecx,3
  lea    esi,[@@colour+6]
  call   WritePalette
  mov    al,3bh
  mov    ecx,3
  lea    esi,[@@colour+9]
  call   WritePalette
  mov    al,3dh
  mov    ecx,3
  lea    esi,[@@colour+12]
  call   WritePalette
  mov    al,3eh
  mov    ecx,3
  lea    esi,[@@colour+15]
  call   WritePalette
  ret
@@colour:
  db     12h,13h,1bh   ;01
  db     0ch,12h,29h   ;05
  db     1ch,38h,26h   ;3a
  db     08h,3fh,38h   ;3b
  db     00h,20h,2fh   ;3d
  db     31h,31h,00h   ;3e
endp


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; ch = size of edit                                                        ;
; dl = x, dh = y                                                           ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc get_input
  movzx  edi,dh
  mov    eax,edi
  shl    edi,7
  shl    eax,5
  add    edi,eax
  movzx  eax,dl
  shl    eax,1
  add    edi,eax
  add    edi,[_0b8000h]
  push   edi
  push   edi
  mov    cl,ch
  mov    eax,6f20h
@@set_bound:
  stosw
  dec    cl
  jnz    @@set_bound
  pop    edi
@@get_input:
  cmp    cl,ch
  ja     @@exit
  jae    @@ign
  mov    ah,02h
  xor    bh,bh
  int    10h
@@ign:
  call   get_key
  cmp    al,27
  je     @@abort
  cmp    al,13
  je     @@exit
  cmp    al,8
  je     @@back_space
  cmp    al,31
  jbe    @@get_input
  cmp    cl,ch
  jae    @@ignore_write
  mov    ah,6fh
  stosw
@@ignore_write:
  inc    cl
  inc    dl
  jmp    @@get_input
@@back_space:
  or     cl,cl
  jz     @@get_input
  dec    cl
  dec    dl
  sub    edi,2
  mov    [word edi],6f20h
  jmp    @@get_input
@@exit:
  mov    ah,02h
  xor    bh,bh
  mov    edx,1900h
  int    10h
  pop    edi
  clc
  ret
@@abort:
  mov    ah,02h
  xor    bh,bh
  mov    edx,6400h
  int    10h
  pop    edi
  stc
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; edi = screen pos, returns al                                             ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc get_vnib
  xor    ebx,ebx
@@find_com_loop:
  mov    al,[byte ebx+nibble_display]
  cmp    al,[byte edi]
  je     @@num_found
  mov    al,[byte ebx+@@nibble_display2]
  cmp    al,[byte edi]
  je     @@num_found
  inc    ebx
  cmp    ebx,16
  jb     @@find_com_loop
  xor    bl,bl
@@num_found:
  add    edi,1
  ret
@@nibble_display2:
  db     "0123456789abcdef"
endp

proc get_vbyte
  call   get_vnib
  push   ebx
  call   get_vnib
  pop    eax
  shl    al,4
  and    bl,1111b
  or     al,bl
  ret
endp

proc get_vdword
  call   get_vbyte
  shl    eax,24
  mov    ebx,eax
  push   ebx
  call   get_vbyte
  pop    ebx
  shl    eax,16
  and    eax,00FF0000h
  or     ebx,eax
  push   ebx
  call   get_vbyte
  pop    ebx
  shl    eax,8
  and    eax,0000FF00h
  or     ebx,eax
  push   ebx
  call   get_vbyte
  pop    ebx
  and    eax,000000FFh
  or     ebx,eax
  ret
endp
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc get_inib
  xor    ebx,ebx
@@find_com_loop:
  mov    al,[byte ebx+nibble_display]
  cmp    al,[byte edi]
  je     @@num_found
  mov    al,[byte ebx+@@nibble_display2]
  cmp    al,[byte edi]
  je     @@num_found
  inc    ebx
  cmp    ebx,16
  jb     @@find_com_loop
  xor    bl,bl
@@num_found:
  add    edi,2
  ret
@@nibble_display2:
  db     "0123456789abcdef"
endp

proc get_ibyte
  call   get_inib
  push   ebx
  call   get_inib
  pop    eax
  shl    al,4
  and    bl,1111b
  or     al,bl
  ret
endp

proc get_idword
  call   get_ibyte
  shl    eax,24
  mov    ebx,eax
  push   ebx
  call   get_ibyte
  pop    ebx
  shl    eax,16
  and    eax,00FF0000h
  or     ebx,eax
  push   ebx
  call   get_ibyte
  pop    ebx
  shl    eax,8
  and    eax,0000FF00h
  or     ebx,eax
  push   ebx
  call   get_ibyte
  pop    ebx
  and    eax,000000FFh
  or     ebx,eax
  ret
endp
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; cl = size of string; returns esi of string data
proc get_string
@@sg_loop:
  mov    al,[byte edi]
  mov    [byte esi],al
  inc    esi
  add    edi,2
  dec    cl
  jnz    @@sg_loop
  ret
endp

;esi  Crunched image source pointer.
;edi  screen
;ecx  Length of crunched image source data.
proc uncrush_text
  MOV    edx,edi
  XOR    EAX,EAX
@@LOOPA:
  LODSB
  CMP    AL,32
  JC     @@ForeGround
  STOSW
@@Next:
  dec    ecx
  jnz    @@LOOPA
  JMP    @@Done
@@ForeGround:
  CMP    AL,16
  JNC    @@BackGround
  AND    AH,0F0H
  OR     AH,AL
  JMP    @@Next
@@BackGround:
  CMP    AL,24
  JZ     @@NextLine
  JNC    @@FlashBitToggle
  SUB    AL,16
  ADD    AL,AL
  ADD    AL,AL
  ADD    AL,AL
  ADD    AL,AL
  AND    AH,8FH
  OR     AH,AL
  JMP    @@Next
@@NextLine:
  ADD    edx,160
  MOV    edi,edx
  JMP    @@Next
@@FlashBitToggle:
  CMP    AL,27
  JC     @@MultiOutput
  JNZ    @@Next
  XOR    AH,128
  JMP    @@Next
@@MultiOutput:
  CMP    AL,25
  MOV    ebx,ecx
  LODSB
  MOV    CL,AL
  MOV    AL,32
  JZ     @@StartOutput
  LODSB
  DEC    ebx
@@StartOutput:
  XOR    CH,CH
  inc    ecx
  REP STOSW
  MOV    ecx,ebx
  dec    ecx
  LOOPNZ @@LOOPA
@@Done:
  ret
endp

proc DecSizeSet
  mov    ecx,eax
@@dec83:
  mov    eax,ecx
  xor    edx,edx
  div    [dword esi+@@Dec_divider]
  mov    ecx,edx
  add    al,'0'
  mov    [edi],al
  add    edi,2
  sub    esi,4
  jge    @@dec83
  ret
@@dec_divider:
  dd 1,10,100,1000,10000,100000,1000000,10000000,100000000,1000000000
endp

proc print_decn1
  add    edi,[_0b8000h]
  and    eax,0ffh
  mov    esi,4*1
  call   DecSizeSet
  ret
endp

proc print_decn3
  add    edi,[_0b8000h]
  and    eax,03fffh
  mov    esi,4*3
  call   DecSizeSet
  ret
endp

proc print_decn5
  add    edi,[_0b8000h]
  mov    esi,4*4
  call	 DecSizeSet
  ret
endp

proc print_decn9
  add    edi,[_0b8000h]
  mov    esi,4*9
  call	 DecSizeSet
  ret
endp

; edi = position (x * (y*160))
; bl  = number
; ah  = colour
proc display_nibble
  add    edi,[_0b8000h]
  and    ebx,1111b
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  ret
endp

; edi = position (x * (y*160))
; bl  = number
; ah  = colour
proc display_byte
  add    edi,[_0b8000h]
proc display_byte_f
  push   ebx
  and    ebx,11110000b
  shr    bl,4
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  pop    ebx
  and    ebx,00001111b
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  ret
endp
endp

; edi = position (x * (y*160))
; ecx = number
; ah  = colour
proc display_word
  and    ecx,0ffffh
  add    edi,[_0b8000h]
  mov    ebx,ecx
  shr    ebx,12
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  mov    ebx,ecx
  shr    ebx,8
  and    ebx,1111b
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  mov    ebx,ecx
  shr    ebx,4
  and    ebx,1111b
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  mov    ebx,ecx
  and    ebx,1111b
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  ret
endp

; edi = position (x * (y*160))
; ecx = number
; ah  = colour
proc display_dword
  add    edi,[_0b8000h]
  mov    ebx,ecx
  shr    ebx,28
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  mov    ebx,ecx
  shr    ebx,24
  and    ebx,1111b
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  mov    ebx,ecx
  shr    ebx,20
  and    ebx,1111b
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  mov    ebx,ecx
  shr    ebx,16
  and    ebx,1111b
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  mov    ebx,ecx
  shr    ebx,12
  and    ebx,1111b
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  mov    ebx,ecx
  shr    ebx,8
  and    ebx,1111b
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  mov    ebx,ecx
  shr    ebx,4
  and    ebx,1111b
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  mov    ebx,ecx
  and    ebx,1111b
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  ret
endp

; edi = position (x * (y*160))
; bx  = number    value(hi):command(lo)
; ah  = colour
proc display_command
  add    edi,[_0b8000h]
proc display_command_f
  cmp    bl,0fh
  je     @@blank
  mov    al,"a"
  add    al,bl
  mov    [edi],ax
  add    edi,2
  push   ebx
  and    ebx,1111000000000000b
  shr    ebx,12
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  pop    ebx
  and    ebx,0000111100000000b
  shr    ebx,8
  mov    al,[byte ebx+nibble_display]
  mov    [edi],ax
  add    edi,2
  ret
@@blank:
  mov    al,"-"
  mov    [edi],ax
  add    edi,2
  mov    [edi],ax
  add    edi,2
  mov    [edi],ax
  add    edi,2
  ret
endp
endp

; edi = position (x * (y*160))
; ah  = colour
proc display_note
  add    edi,[_0b8000h]
proc display_note_f
  lea    ebx,[ebx*2+ebx]
  mov    al,[byte ebx+note_display]
  mov    [edi],ax
  add    edi,2
  mov    al,[byte ebx+note_display+1]
  mov    [edi],ax
  add    edi,2
  mov    al,[byte ebx+note_display+2]
  mov    [edi],ax
  add    edi,2
  ret
endp
endp

; byte_write1: esi = string addr  null terminated
;              edi = position
;              cl = len
;              ah  = colour
proc byte_write1
  add    edi,[_0b8000h]
@@str_copy_loop:
  mov    al,[esi]
  inc    esi
  or     al,al
  jz     @@paint_nulls
  cmp    al,"."
  je     @@paint_nulls
  stosw
  dec    cl
  jnz    @@str_copy_loop
@@paint_nulls:
  xor    al,al
@@paint_nl:
  or     cl,cl
  jz     @@exit
  mov    [edi],ax
  add    edi,2
  dec    cl
  jmp    @@paint_nl
@@exit:
  ret
endp

; byte_write2: esi = string addr  null terminated
;              edi = position
;              cl = len
;              ah  = colour
proc byte_write2
  add    edi,[_0b8000h]
@@str_copy_loop:
  mov    al,[esi]
  inc    esi
  mov    [edi],ax
  add    edi,2
  dec    cl
  jnz    @@str_copy_loop
  ret
endp

; esi = ANSIIZ
proc display_bm
  mov    edi,(49*160)
  mov    cl,80
  mov    ah,8eh
  call   byte_write1
  ret
endp

proc clear_bm
  mov    edi,[_0b8000h]
  add    edi,(49*160)
  xor    eax,eax
  mov    ecx,160/4
  rep    stosd
  ret
endp

macro @error_mess string
local @@tttext, @@skip
  jmp    @@skip
  ifb    <string>
@@tttext:
  db     " - Hit any key",0
  else
@@tttext:
  db     string, " - Hit any key",0
  endif
@@skip:
  push   edi esi ecx
  lea    esi,[@@tttext]
  call   display_bm
  call   get_key
  call   clear_bm
  pop    ecx esi edi
endm

macro @splash_on_sm string
local @@tttext, @@skip
  jmp    @@skip
  ifb    <string>
@@tttext:
  db     0
  else
@@tttext:
  db     string, 0
  endif
@@skip:
  push   edi esi ecx
  lea    esi,[@@tttext]
  call   display_bm
  pop    ecx esi edi
endm

macro @splash_off_sm string
local @@tttext, @@skip
  push   edi esi ecx
  call   clear_bm
  pop    ecx esi edi
endm

;esi = source buffer
;edi = video buffer
;dl = height
;ebx = width
proc paint_window
@@splash_loop:
  mov    ecx,ebx
  rep    movsw
  mov    eax,80
  sub    eax,ebx
  lea    eax,[eax*2]
  add    edi,eax
  dec    dl
  jnz    @@splash_loop
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc scroll_display32
  mov    edi,[_0b8000h]
  add    edi,(78*2)+(2*160)
  xor    cl,cl
@@clear_scroll:
  mov    al,""
  cmp    cl,dl
  jne    @@cont2
  mov    al,17
@@cont2:
  stosb
  add    edi,159
  inc    cl
  cmp    cl,32
  jb     @@clear_scroll
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;display keyboard                                                          ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; cl = channel to play                                                     ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc play_keynote
  cli
  mov    al,size tfunk_chan
  mul    cl                                         ;[byte pat_chan]
  movzx  edi,ax
  add    edi,offset funk_chan1
  mov    al,[byte sam_hl]
  add    al,[byte sam_real]
  mov    [byte edi+tfunk_chan.sample],al
  movzx  eax,al
  shl    eax,5
  add    eax,[funk_hr_ptr]
  add    eax,offset (tfunk_hr).funk_sb
  cmp    [dword eax+tfunk_sb.length],0
  je     @@endendend
  mov    [byte edi+tfunk_chan.funkctrl],10b       ; set funkctrl
  mov    ebx,[dword eax+tfunk_sb.start]
  cmp    ebx,0ffffffffh
  je     @@dont_loop
  mov    [byte edi+tfunk_chan.funkctrl],11b       ; set funkctrl
@@dont_loop:
  mov    [dword edi+tfunk_chan.start],ebx
  mov    ebx,[dword eax+tfunk_sb.length]
  mov    [dword edi+tfunk_chan.length],ebx
  mov    bl,[byte eax+tfunk_sb.balance]
  mov    [byte edi+tfunk_chan.balance],bl
  mov    bl,[byte eax+tfunk_sb.pt_and_sop]        ; get both port type and sample ofs parm
  mov    dl,bl
  shr    bl,4
  and    dl,1111b
  mov    [byte edi+tfunk_chan.port_type],bl
  mov    [byte edi+tfunk_chan.sample_ofs_parm],dl
  mov    bl,[byte eax+tfunk_sb.vv_waveform]       ; get both vibrato wf & tremola wf
  mov    dl,bl
  shr    bl,4
  and    dl,1111b
  mov    [byte edi+tfunk_chan.vib_waveform],bl
  mov    [byte edi+tfunk_chan.vol_vib_waveform],dl
  mov    bl,[byte eax+tfunk_sb.rl_and_as]         ; get both retrig speed & arp speed
  mov    dl,bl
  shr    bl,4
  and    dl,1111b
  mov    [byte edi+tfunk_chan.retrig_limit],bl
  mov    [byte edi+tfunk_chan.arp_speed],dl
  mov    bl,[byte eax+tfunk_sb.volume]
  mov    [byte edi+tfunk_chan.volume],bl
  call   vol_to_realvol
  call   [dword CARD_volume_convert]
  mov    al,[byte octave]
  mov    bl,al
  shl    al,3
  shl    bl,2
  add    bl,al
  add    bl,[byte note]
  mov    [byte edi+tfunk_chan.note],bl
  @note_2_ifreq
  mov    [word edi+tfunk_chan.ifreq],bx
  call   ifreq_to_rfreq
  mov    [dword edi+tfunk_chan.rfreq],eax
  call   [dword CARD_freq_convert]
  movzx  esi,[byte edi+tfunk_chan.sample]
  lea    esi,[esi*4]
  mov    eax,[dword esi+funk_info.sample_ptrs]
  add    [dword edi+tfunk_chan.start],eax
  add    [dword edi+tfunk_chan.length],eax
  mov    [dword edi+tfunk_chan.CARD_sample_ptr],eax
@@endendend:
  sti
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc clr_keyboard
  mov    edi,[_0b8000h]
  add    edi,((1*2)+(42*160))+1
  mov    ch,6
@@clr_row:
  mov    cl,(12)*5
@@clr_line:
  mov    [byte edi],07h
  add    edi,2
  dec    cl
  jnz    @@clr_line
  add    edi,160-((12*2)*5)
  dec    ch
  jnz    @@clr_row
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc dis_keyboard
  call   clr_keyboard
proc dis_keyboard2
  movzx  ebx,[byte note]
  lea    ebx,[ebx*4]
  mov    esi,[dword ebx+dis_keyboard_map]

  mov    edi,[_0b8000h]
  add    edi,((1*2)+(42*160))+1
  movzx  eax,[byte octave]
  mov    ebx,eax
  shl    eax,4
  shl    ebx,3
  add    edi,eax
  add    edi,ebx
@@map_key:
  lodsb
  cmp    al,255
  je     @@done
  movzx  eax,al
  add    edi,eax
  mov    [byte edi],22h
  jmp    @@map_key
@@done:
  ret
endp
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc mus_kb_input
  cmp    al,"z"
  je     @@key1
  cmp    al,"Z"
  je     @@key1
  cmp    al,"s"
  je     @@key2
  cmp    al,"S"
  je     @@key2
  cmp    al,"x"
  je     @@key3
  cmp    al,"X"
  je     @@key3
  cmp    al,"d"
  je     @@key4
  cmp    al,"D"
  je     @@key4
  cmp    al,"c"
  je     @@key5
  cmp    al,"C"
  je     @@key5
  cmp    al,"v"
  je     @@key6
  cmp    al,"V"
  je     @@key6
  cmp    al,"g"
  je     @@key7
  cmp    al,"G"
  je     @@key7
  cmp    al,"b"
  je     @@key8
  cmp    al,"B"
  je     @@key8
  cmp    al,"h"
  je     @@key9
  cmp    al,"H"
  je     @@key9
  cmp    al,"n"
  je     @@key10
  cmp    al,"N"
  je     @@key10
  cmp    al,"j"
  je     @@key11
  cmp    al,"J"
  je     @@key11
  cmp    al,"m"
  je     @@key12
  cmp    al,"M"
  je     @@key12
  ret
@@key1:
  mov    [byte note],0
  call   enter_slot
  call   dis_keyboard
  mov    cl,[byte pat_chan]
  call   play_keynote
  jmp    @@cont
@@key2:
  mov    [byte note],1
  call   enter_slot
  call   dis_keyboard
  mov    cl,[byte pat_chan]
  call   play_keynote
  jmp    @@cont
@@key3:
  mov    [byte note],2
  call   enter_slot
  call   dis_keyboard
  mov    cl,[byte pat_chan]
  call   play_keynote
  jmp    @@cont
@@key4:
  mov    [byte note],3
  call   enter_slot
  call   dis_keyboard
  mov    cl,[byte pat_chan]
  call   play_keynote
  jmp    @@cont
@@key5:
  mov    [byte note],4
  call   enter_slot
  call   dis_keyboard
  mov    cl,[byte pat_chan]
  call   play_keynote
  jmp    @@cont
@@key6:
  mov    [byte note],5
  call   enter_slot
  call   dis_keyboard
  mov    cl,[byte pat_chan]
  call   play_keynote
  jmp    @@cont
@@key7:
  mov    [byte note],6
  call   enter_slot
  call   dis_keyboard
  mov    cl,[byte pat_chan]
  call   play_keynote
  jmp    @@cont
@@key8:
  mov    [byte note],7
  call   enter_slot
  call   dis_keyboard
  mov    cl,[byte pat_chan]
  call   play_keynote
  jmp    @@cont
@@key9:
  mov    [byte note],8
  call   enter_slot
  call   dis_keyboard
  mov    cl,[byte pat_chan]
  call   play_keynote
  jmp    @@cont
@@key10:
  mov    [byte note],9
  call   enter_slot
  call   dis_keyboard
  mov    cl,[byte pat_chan]
  call   play_keynote
  jmp    @@cont
@@key11:
  mov    [byte note],10
  call   enter_slot
  call   dis_keyboard
  mov    cl,[byte pat_chan]
  call   play_keynote
  jmp    @@cont
@@key12:
  mov    [byte note],11
  call   enter_slot
  call   dis_keyboard
  mov    cl,[byte pat_chan]
  call   play_keynote
@@cont:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc update_octave
  mov    edi,[_0b8000h]
  mov    [byte edi+((06*2)+(41*160))+1],1eh
  mov    [byte edi+((06*2)+(41*160))+3],1eh
  mov    [byte edi+((18*2)+(41*160))+1],1eh
  mov    [byte edi+((18*2)+(41*160))+3],1eh
  mov    [byte edi+((30*2)+(41*160))+1],1eh
  mov    [byte edi+((30*2)+(41*160))+3],1eh
  mov    [byte edi+((42*2)+(41*160))+1],1eh
  mov    [byte edi+((42*2)+(41*160))+3],1eh
  mov    [byte edi+((54*2)+(41*160))+1],1eh
  mov    [byte edi+((54*2)+(41*160))+3],1eh
  cmp    [byte octave],0
  je     @@oct1
  cmp    [byte octave],1
  je     @@oct2
  cmp    [byte octave],2
  je     @@oct3
  cmp    [byte octave],3
  je     @@oct4
  cmp    [byte octave],4
  je     @@oct5
  ret
@@oct1:
  mov    [byte edi+((06*2)+(41*160))+1],1fh
  mov    [byte edi+((06*2)+(41*160))+3],1fh
  ret
@@oct2:
  mov    [byte edi+((18*2)+(41*160))+1],1fh
  mov    [byte edi+((18*2)+(41*160))+3],1fh
  ret
@@oct3:
  mov    [byte edi+((30*2)+(41*160))+1],1fh
  mov    [byte edi+((30*2)+(41*160))+3],1fh
  ret
@@oct4:
  mov    [byte edi+((42*2)+(41*160))+1],1fh
  mov    [byte edi+((42*2)+(41*160))+3],1fh
  ret
@@oct5:
  mov    [byte edi+((54*2)+(41*160))+1],1fh
  mov    [byte edi+((54*2)+(41*160))+3],1fh
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; file operations                                                          ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc get_directory
  mov    [byte esi],"a"
  mov    [byte esi+1],":"
  mov    [byte esi+2],"\"
  mov    [byte esi+3],0
  mov    ah,19h
  int    21h
  add    [byte esi],al
  add    esi,3
  mov    ah,47h
  xor    dl,dl
  int    21h
  ret
endp

; edx = pointer to buffer
proc set_directory
  mov    ah,3bh
  push   ds
  pop    es
  int    21h
  ret
endp

; ecx <- eax
proc intel_2_motorola
  mov    cl,al
  shl    ecx,8
  shr    eax,8

  mov    cl,al
  shl    ecx,8
  shr    eax,8

  mov    cl,al
  shl    ecx,8
  shr    eax,8

  mov    cl,al
  ret
endp

; bl = 1 - get directory
proc load_fset
  xor    ebp,ebp
  mov    edi,[fdirectory_buffer]
@@l:
  cmp    [byte edi+tfdirectory.attr],0ffh
  je     @@end
  add    edi,size tfdirectory
  inc    ebp
@@end:
  mov    [@@base_entry],ebp

  mov    ah,4eh
  mov    ecx,10h
  int    21h
  jnc    @@load_next
  ret
@@load_next:
  mov    esi,[dword PSP_address]
  add    esi,80h
  or     bl,bl
  jz     @@aas
  cmp    [byte esi+tdta.attr],10h
  je     @@readln
  jmp    @@next_DTA
@@aas:
  cmp    [byte esi+tdta.attr],10h
  je     @@next_DTA
@@readln:
  mov    eax,ebp
  mov    ecx,size tfdirectory
  mul    ecx
  mov    edi,[fdirectory_buffer]
  add    edi,eax

  mov    eax,[dword esi+tdta.fname]
  call   intel_2_motorola
  mov    edx,ecx
  mov    eax,[dword edi+tfdirectory.fname]
  call   intel_2_motorola
  cmp    edx,ecx
  ja     @@next_line
;;;INSERT SPACE and add;;;;;;;;;;;
  mov    ecx,fdir_max_length-1
  sub    ecx,ebp
  js     @@dont_shift
  jz     @@dont_shift

  push   esi edi
  mov    edi,[fdirectory_buffer]
  add    edi,(size tfdirectory)*fdir_max_length
  mov    esi,edi
  sub    esi,(size tfdirectory)
  mov    eax,(size tfdirectory)
  mul    ecx
  mov    ecx,eax
  inc    ecx
  std
  rep    movsb
  cld
  pop    edi esi

@@dont_shift:
  mov    al,[byte esi+tdta.attr]
  mov    [byte edi+tfdirectory.attr],al
  lea    esi,[esi+tdta.fname]
  lea    edi,[edi+tfdirectory.fname]
  mov    ecx,13
  rep    movsb
  mov    ebp,[@@base_entry]
  inc    [word fdir_length]
  cmp    [word fdir_length],fdir_max_length
  jbe    @@next_DTA
  ret
;;;NEXT LINE;;;;;;;;;;;;;;;;;;;;;;
@@next_line:
  inc    ebp
  jmp    @@load_next
@@next_DTA:
  mov    ah,4fh
  int    21h
  jnc    @@load_next
  ret
@@base_entry          dd ?
endp

proc load_fdirectory
  push   edx
  mov    edi,[fdirectory_buffer]
  mov    ecx,(size tfdirectory)*(fdir_max_length)
  mov    al,0ffh
  rep    stosb
  mov    [word fdir_real],0
  mov    [byte fdir_hl],0
  mov    [word fdir_length],0
  mov    bl,1
  lea    edx,[file_search_all]
  call   load_fset
  xor    bl,bl
  pop    edx
  call   load_fset
  ret
endp

proc display_fdir
  cmp    [word fdir_length],0
  jne    @@cont
  ret
@@cont:
  mov    dl,[byte fdir_hl]
  call   scroll_display32
  mov    eax,size tfdirectory
  mul    [word fdir_real]
  movzx  esi,ax
  add    esi,[dword fdirectory_buffer]
  mov    edi,[_0b8000h]
  add    edi,(3*2)+(2*160)
  movzx  edx,[word fdir_real]
  xor    bl,bl
@@display_loop:
  push   esi edi
  mov    ecx,19
  mov    ah,0fh
  cmp    dx,[word fdir_length]
  jae    @@paint_blank
  cmp    [byte esi+tfdirectory.attr],10h
  jne    @@dont_dd
  mov    ah,0eh
@@dont_dd:
  cmp    bl,[byte fdir_hl]
  jne    @@dont_dd2
  add    ah,70h
@@dont_dd2:
  lea    esi,[esi+tfdirectory.fname]
@@dis_name:
  lodsb
  or     al,al
  jz     @@exit_fn
  stosw
  dec    cl
  jnz    @@dis_name
  jmp    @@exit_fn
@@paint_blank:
  xor    al,al
@@exit_fn:
  rep    stosw
  pop    edi esi
  add    esi,size tfdirectory
  add    edi,160
  inc    edx
  inc    bl
  cmp    bl,32
  jb     @@display_loop
  ret
endp

proc goto_end_str
  xor    ebx,ebx
@@get_str_len:
  cmp    [byte edi+ebx],0
  je     @@e_get_str_len
  inc    ebx
  jmp    @@get_str_len
@@e_get_str_len:
  ret
endp

proc mini_trans_str
@@copy_str:
  mov    al,[byte esi]
  mov    [byte edi+ebx],al
  or     al,al
  je     @@e_copy_str
  inc    ebx
  inc    esi
  jmp    @@copy_str
@@e_copy_str:
  ret
endp

proc fdir_scroll_up
  cmp    [byte fdir_hl],0
  je     @@adj_real_bk
  dec    [byte fdir_hl]
  ret
@@adj_real_bk:
  cmp    [word fdir_real],0
  je     @@end
  dec    [word fdir_real]
@@end:
  ret
endp

proc fdir_scroll_dn
  movzx  ax,[byte fdir_hl]
  inc    ax
  cmp    [byte fdir_hl],31
  je     @@adj_real_fd
  cmp    ax,[word fdir_length]
  je     @@end
  inc    [byte fdir_hl]
  ret
@@adj_real_fd:
  add    ax,[word fdir_real]
  cmp    ax,[word fdir_length]
  je     @@end
  inc    [word fdir_real]
@@end:
  ret
endp

proc fdir_scroll_pageup
  mov    cl,16
@@sl:
  call   fdir_scroll_up
  dec    cl
  jnz    @@sl
  ret
endp

proc fdir_scroll_pagedn
  mov    cl,16
@@sl:
  call   fdir_scroll_dn
  dec    cl
  jnz    @@sl
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; pattern editor                                                           ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
macro @mini_clear_slot
  mov    [byte esi],0fch
  mov    [byte esi+1],0fh
  mov    [byte esi+2],0
endm

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; esi = pattern number, dl = chan, dh = real + hl                          ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc calc_data
  mov    eax,esi                                  ; bx * 600h
  shl    eax,10
  shl    esi,9
  add    esi,eax
  movzx  eax,dh
  mov    ebx,eax
  shl    eax,4
  shl    ebx,3
  add    esi,eax
  add    esi,ebx
  movzx  eax,dl                                   ; [byte pe.chan]
  lea    eax,[eax*2+eax]
  add    esi,eax
  add    esi,[dword funk_hr_ptr]
  add    esi,size tfunk_hr
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; esi = pattern numebr, dl = chan, dh = real + hl, ch = hl                 ;
; cl  = colour ofs                                                         ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc display_slot_f
  cmp    [byte sel_flag],0
  je     @@paint_slot
  cmp    dl,[sel_area_chan1]
  jae    @@pass1
  jmp    @@paint_slot
@@pass1:
  cmp    dl,[sel_area_chan2]
  jbe    @@pass2
  jmp    @@paint_slot
@@pass2:
  cmp    dh,[sel_area_trek1]
  jae    @@pass3
  jmp    @@paint_slot
@@pass3:
  cmp    dh,[sel_area_trek2]
  jbe    @@pass4
  jmp    @@paint_slot
@@pass4:
  cmp    si,[word sel_area_pattern]
  je     @@pass5
  jmp    @@paint_slot
@@pass5:
  add    cl,50h
@@paint_slot:
  call   calc_data
  mov    edi,[_0b8000h]                           ; calc ofs
  add    edi,(4*2)+(2*160)
  xor    eax,eax
  mov    eax,160
  mul    ch
  add    edi,eax
  mov    eax,18
  mul    dl
  add    edi,eax
  mov    al,[byte esi]
  shr    al,2
  push   eax
  cmp    al,3Fh                                   ;IF FULL SLOT or SAMPLE
  je     @@display_nullslot
  mov    bx,[word esi]                            ; display sample no
  xchg   bl,bh
  shr    bx,4
  and    bl,03fh
  mov    ah,10
  add    ah,cl
  call   display_byte_f
  jmp    @@cont
@@display_nullslot:
  mov    ah,cl
  mov    al," "
  stosw
  stosw
@@cont:
  pop    ebx
  and    ebx,03fh                                 ; display note
  mov    ah,11
  add    ah,cl
  call   display_note_f
  mov    bx,[word esi+1]
  and    bl,1111b
  mov    ah,12
  add    ah,cl
  call   display_command_f
  ret
endp

; cl = colour offset
proc display_slot
  push   ecx
  movzx  esi,[byte pat_number]
  mov    dl,[byte pat_old_chan]
  mov    dh,[byte pat_real]
  mov    ch,[byte pat_old_hl]
  add    dh,ch
  xor    cl,cl
  call   display_slot_f
  pop    ecx
  movzx  esi,[byte pat_number]
  mov    dl,[byte pat_chan]
  mov    dh,[byte pat_real]
  mov    ch,[byte pat_hl]
  add    dh,ch
  call   display_slot_f
  mov    ax,[word pat_hl]
  mov    [word pat_old_hl],ax
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; esi = pattern number, dh = pattern real position                         ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc display_pattern
  mov    edi,[_0b8000h]
  add    edi,(1*2)+(2*160)
  xor    ch,ch
@@paint_treks:
  push   edi
  mov    ah,7
  mov    ebx,[funk_hr_ptr]
  mov    al,[byte esi+ebx+tfunk_hr.break_list]
  mov    bl,dh
  cmp    al,bl
  jne    @@pbbb
  mov    ah,14
@@pbbb:
  call   display_byte_f
  xor    dl,dl
@@paint_slots:
  push   esi
  xor    cl,cl
  call   display_slot_f
  pop    esi
  inc    dl
  cmp    dl,8
  jb     @@paint_slots
  pop    edi
  add    edi,160
  inc    dh
  inc    ch
  cmp    ch,32
  jb     @@paint_treks
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc pat_scroll_up
  cmp    [byte pat_hl],0
  je     @@adj_real_bk
  dec    [byte pat_hl]
  jmp    @@end
@@adj_real_bk:
  cmp    [byte pat_real],0
  je     @@end
  dec    [byte pat_real]
  movzx  esi,[byte pat_number]
  mov    dh,[byte pat_real]
  call   display_pattern
@@end:
  mov    cl,20h
  call   display_slot
  ret
endp

proc pat_scroll_dn
  cmp    [byte pat_hl],31
  je     @@adj_real_fd
  inc    [byte pat_hl]
  jmp    @@end
@@adj_real_fd:
  cmp    [byte pat_real],(64-32)                  ; 32
  je     @@end
  inc    [byte pat_real]
  movzx  esi,[byte pat_number]
  mov    dh,[byte pat_real]
  call   display_pattern
@@end:
  mov    cl,20h
  call   display_slot
  ret
endp

proc pat_pageup
  mov    cl,16
@@scl:
  cmp    [byte pat_hl],0
  je     @@adj_real_bk
  dec    [byte pat_hl]
  jmp    @@end
@@adj_real_bk:
  cmp    [byte pat_real],0
  je     @@end
  dec    [byte pat_real]
@@end:
  dec    cl
  jnz    @@scl
  movzx  esi,[byte pat_number]
  mov    dh,[byte byte pat_real]
  call   display_pattern
  mov    cl,20h
  call   display_slot
  ret
endp

proc pat_pagedn
  mov    cl,16
@@scl:
  cmp    [byte pat_hl],31
  je     @@adj_real_fd
  inc    [byte pat_hl]
  jmp    @@end
@@adj_real_fd:
  cmp    [byte pat_real],(64-32)                  ; 32
  je     @@end
  inc    [byte pat_real]
@@end:
  dec    cl
  jnz    @@scl
  movzx  esi,[byte pat_number]
  mov    dh,[byte pat_real]
  call   display_pattern
  mov    cl,20h
  call   display_slot
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc set_select_start
  mov    [byte sel_flag],1
  mov    al,[byte pat_number]
  mov    [byte sel_area_pattern],al
  mov    al,[byte pat_chan]
  mov    [byte sel_area_chan1],al
  mov    [byte sel_area_chan2],al
  mov    al,[byte pat_real]
  add    al,[byte pat_hl]
  mov    [byte sel_area_trek1],al
  mov    [byte sel_area_trek2],al
  movzx  esi,[byte pat_number]
  mov    dh,[byte pat_real]
  call   display_pattern
  mov    cl,20h
  call   display_slot
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc set_select_end
  cmp    [byte sel_flag],0
  je     @@end
  mov    al,[byte pat_number]
  mov    [byte sel_area_pattern],al
  mov    al,[byte pat_chan]
  mov    [byte sel_area_chan2],al
  mov    al,[byte pat_real]
  add    al,[byte pat_hl]
  mov    [byte sel_area_trek2],al
  mov    al,[byte sel_area_chan1]
  cmp    al,[byte sel_area_chan2]
  jbe    @@test1
  xchg   al,[byte sel_area_chan2]
  mov    [byte sel_area_chan1],al
@@test1:
  mov    al,[byte sel_area_trek1]
  cmp    al,[byte sel_area_trek2]
  jbe    @@test2
  xchg   al,[byte sel_area_trek2]
  mov    [byte sel_area_trek1],al
@@test2:
  movzx  esi,[byte pat_number]
  mov    dh,[byte pat_real]
  call   display_pattern
  mov    cl,20h
  call   display_slot
@@end:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc copy_select
  cmp    [byte sel_flag],0
  je     @@end
  mov    [byte sel_flag],0
  mov    [byte copied_flag],1
  mov    eax,[dword sel_area_chan1]
  mov    [dword copied_area_chan1],eax
  movzx  esi,[byte pat_number]
  mov    eax,esi                                  ; bx * 600h
  shl    eax,10
  shl    esi,9
  add    esi,eax
  add    esi,[dword funk_hr_ptr]
  add    esi,size tfunk_hr
  lea    edi,[temp_pattern]
  mov    ecx,600h
  rep    movsb
  movzx  esi,[byte pat_number]
  mov    dh,[byte pat_real]
  call   display_pattern
  mov    cl,20h
  call   display_slot
@@end:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc paste_select
  cmp    [byte copied_flag],0
  je     @@end
  mov    dh,[byte copied_area_trek1]
@@copy_trek:
  mov    dl,[byte copied_area_chan1]
@@copy_slot:
  push   edx
  lea    edi,[temp_pattern]
  movzx  eax,dh
  mov    ebx,eax
  shl    eax,4
  shl    ebx,3
  add    edi,eax
  add    edi,ebx
  movzx  eax,dl
  lea    eax,[eax*2+eax]
  add    edi,eax
  sub    dh,[byte copied_area_trek1]
  sub    dl,[byte copied_area_chan1]
  add    dh,[byte pat_real]
  add    dh,[byte pat_hl]
  add    dl,[byte pat_chan]
  cmp    dl,7
  ja     @@ignore_paste
  cmp    dh,03fh
  ja     @@ignore_paste
  movzx  esi,[byte pat_number]
  call   calc_data
  mov    ax,[word edi]
  mov    bl,[byte edi+2]
  mov    [word esi],ax
  mov    [byte esi+2],bl
@@ignore_paste:
  pop    edx
  inc    dl
  cmp    dl,[copied_area_chan2]
  jbe    @@copy_slot
  inc    dh
  cmp    dh,[byte copied_area_trek2]
  jbe    @@copy_trek
  movzx  esi,[byte pat_number]
  mov    dh,[byte pat_real]
  call   display_pattern
  mov    cl,20h
  call   display_slot
@@end:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc clear_select
  cmp    [byte sel_flag],0
  je     @@end
  mov    [byte sel_flag],0
  mov    dh,[byte sel_area_trek1]
@@copy_trek:
  mov    dl,[byte sel_area_chan1]
@@copy_slot:
  push   edx
  movzx  esi,[byte pat_number]
  call   calc_data
  @mini_clear_slot
@@ignore_paste:
  pop    edx
  inc    dl
  cmp    dl,[sel_area_chan2]
  jbe    @@copy_slot
  inc    dh
  cmp    dh,[byte sel_area_trek2]
  jbe    @@copy_trek
  movzx  esi,[byte pat_number]
  mov    dh,[byte pat_real]
  call   display_pattern
  mov    cl,20h
  call   display_slot
@@end:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; dl = [byte pat_chan]
proc enter_slot_data
  movzx  esi,[byte pat_number]
  mov    dh,[byte pat_real]
  add    dh,[byte pat_hl]
  call   calc_data
  mov    al,[byte octave]
  mov    bl,al
  shl    al,3
  shl    bl,2
  add    al,bl
  add    al,[byte note]
  mov    [byte esi],al
  shl    [byte esi],2
  mov    al,[byte sam_real]
  add    al,[byte sam_hl]
  push   eax
  shr    al,4
  or     [byte esi],al
  pop    eax
  shl    al,4
  or     al,0fh
  mov    [byte esi+1],al
  mov    [byte esi+2],0
  ret
endp

proc quat_slot
  cmp    [MIDI.midi_status],PLAY
  je     @@end
  cmp    [byte MIDI_quantise],0
  je     @@end
  mov    al,8
@@nl:
  push   eax
  inc    [byte pat_chan]
  and    [byte pat_chan],7
  xor    ecx,ecx
  mov    cl,[byte pat_chan]
  mov    eax,size tfunk_chan
  mul    ecx
  mov    ecx,eax
  add    ecx,offset funk_chan1

  pop    eax
  cmp    [byte ecx+tfunk_chan.channel_kill],PLAY
  je     @@end
  dec    al
  jnz    @@nl
@@end:
  ret
endp

proc enter_slot
  cmp    [byte edit_mode],1
  je     @@pe
  call   quat_slot
  ret
@@pe:
  mov    dl,[byte pat_chan]
  call   enter_slot_data
  call   quat_slot
  call   pat_scroll_dn
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc erase_slot
  movzx  esi,[byte pat_number]
  mov    dl,[byte pat_chan]
  mov    dh,[byte pat_real]
  add    dh,[byte pat_hl]
  call   calc_data
  @mini_clear_slot
  call   pat_scroll_dn
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc insert_slot
  mov    dh,[byte pat_real]
  add    dh,[byte pat_hl]
  cmp    dh,03fh
  je     @@dont_ad
  movzx  esi,[byte pat_number]
  mov    dl,[byte pat_chan]
  mov    ch,dh
  mov    dh,03fh
  call   calc_data
@@add_loop:
  mov    ax,[word esi-24]
  mov    [word esi],ax
  mov    al,[byte esi-22]
  mov    [byte esi+2],al
  dec    dh
  sub    esi,24
  cmp    dh,ch
  ja     @@add_loop
@@dont_ad:
  movzx  esi,[byte pat_number]
  mov    dl,[byte pat_chan]
  mov    dh,[byte pat_real]
  add    dh,[byte pat_hl]
  call   calc_data
  @mini_clear_slot
  movzx  esi,[byte pat_number]
  mov    dh,[byte pat_real]
  call   display_pattern
  mov    cl,20h
  call   display_slot
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc delete_slot
  movzx  esi,[byte pat_number]
  mov    dl,[byte pat_chan]
  mov    dh,[byte pat_real]
  add    dh,[byte pat_hl]
  call   calc_data
  cmp    dh,03fh
  je     @@dont_ad
@@del_loop:
  mov    ax,[word esi+24]
  mov    [word esi],ax
  mov    al,[byte esi+26]
  mov    [byte esi+2],al
  inc    dh
  add    esi,24
  cmp    dh,3fh
  jb     @@del_loop
@@dont_ad:
  @mini_clear_slot
  movzx  esi,[byte pat_number]
  mov    dh,[byte pat_real]
  call   display_pattern
  mov    cl,20h
  call   display_slot
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc setto_ReLOad_slot
  movzx  esi,[byte pat_number]
  mov    dl,[byte pat_chan]
  mov    dh,[byte pat_real]
  add    dh,[byte pat_hl]
  call   calc_data
  @mini_clear_slot
  mov    [byte esi],0f4h
  call   pat_scroll_dn
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc enter_sample
  mov    ch,2
  mov    dh,[byte pat_hl]
  add    dh,2
  mov    dl,[byte pat_chan]
  shl    dl,3
  add    dl,[byte pat_chan]
  add    dl,4
  call   get_input
  jc     @@abort
  movzx  esi,[byte pat_number]
  mov    dl,[byte pat_chan]
  mov    dh,[byte pat_real]
  add    dh,[byte pat_hl]
  call   calc_data
  call   get_ibyte
  cmp    al,40h
  jb     @@ovs
  xor    al,al
@@ovs:
  mov    bl,[byte esi]
  shr    bl,2
  cmp    bl,3fh
  je     @@con_sample_only
  and    [byte esi],11111100b
  jmp    @@set_sample
@@con_sample_only:
  mov    [byte esi],0f8h
@@set_sample:
  mov    bl,al
  shr    bl,4
  shl    al,4
  or     [byte esi],bl
  and    [byte esi+1],1111b
  or     [byte esi+1],al
@@abort:
  mov    cl,20h
  call   display_slot
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc enter_command
@@repeat:
  mov    ch,3
  mov    dh,[byte pat_hl]
  add    dh,2
  mov    dl,[byte pat_chan]
  shl    dl,3
  add    dl,[byte pat_chan]
  add    dl,9
  call   get_input
  jc     @@abort
  movzx  esi,[byte pat_number]
  mov    dl,[byte pat_chan]
  mov    dh,[byte pat_real]
  add    dh,[byte pat_hl]
  call   calc_data
  cmp    [byte edi],"?"                                ; help function
  je     @@help
  jmp    @@cont
@@help:
  mov    ecx,comms_screen_size
  lea    esi,[comms_screen]
  call   help_scroll
  jmp    @@repeat
@@cont:
  xor    ebx,ebx
@@find_com_loop:
  mov    al,[byte ebx+@@coms_test1]
  cmp    al,[byte edi]
  je     @@com_found
  add    al,("a"-"A")
  cmp    al,[byte edi]
  je     @@com_found
  inc    ebx
  cmp    ebx,15
  jb     @@find_com_loop
  and    [byte esi+1],11110000b
  or     [byte esi+1],00001111b
  mov    [byte esi+2],0
  jmp    @@abort
@@com_found:
  and    [byte esi+1],11110000b
  or     [byte esi+1],bl
  add    edi,2
  call   get_ibyte
  mov    [byte esi+2],al
@@abort:
  mov    cl,20h
  call   display_slot
  ret
@@coms_test1:
  db     "ABCDEFGHIJKLMNO"
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc display_seqlist
  mov    dl,[byte seq_real]
  add    dl,[byte seq_hl]
  shr    dl,3
  call   scroll_display32
  mov    edi,[_0b8000h]
  add    edi,(76*2)+(2*160)
  mov    esi,[funk_hr_ptr]
  xor    cl,cl
@@display_seq:
  push   edi
  mov    ah,7
  cmp    cl,[byte seq_hl]
  jne    @@pbbb
  mov    ah,14
@@pbbb:
  mov    bl,cl
  add    bl,[byte seq_real]
  cmp    bl,[byte esi+tfunk_hr.loop_order]
  jne    @@pbbb2
  dec    ah
@@pbbb2:
  xor    ebx,ebx
  mov    bl,[byte seq_real]
  add    bl,cl
  mov    bl,[byte ebx+esi+tfunk_hr.order_list]
  cmp    bl,0ffh
  je     @@display_null
  call   display_byte_f
  jmp    @@cont
@@display_null:
  mov    al,"-"
  stosw
  stosw
@@cont:
  pop    edi
  add    edi,160
  inc    cl
  cmp    cl,32
  jb     @@display_seq
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc seq_scroll_up
  cmp    [byte seq_hl],0
  je     @@adj_real_bk
  dec    [byte seq_hl]
  jmp    @@end
@@adj_real_bk:
  cmp    [byte seq_real],0
  je     @@end
  dec    [byte seq_real]
@@end:
  call   display_seqlist
  ret
endp

proc seq_scroll_dn
  cmp    [byte seq_hl],31
  je     @@adj_real_fd
  inc    [byte seq_hl]
  jmp    @@end
@@adj_real_fd:
  cmp    [byte seq_real],(256-32)
  je     @@end
  inc    [byte seq_real]
@@end:
  call   display_seqlist
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc seq_add
  mov    esi,[funk_hr_ptr]
  xor    edx,edx
  mov    dl,[byte seq_real]
  add    dl,[byte seq_hl]
  cmp    dl,0ffh
  je     @@dont_ad
  mov    ebx,0ffh
@@add_loop:
  mov    al,[byte esi+ebx+(offset(tfunk_hr).order_list-1)]
  mov    [byte esi+ebx+tfunk_hr.order_list],al
  dec    ebx
  cmp    ebx,edx
  ja     @@add_loop
@@dont_ad:
  mov    al,[byte pat_number]
  mov    [byte esi+edx+tfunk_hr.order_list],al
  call   seq_scroll_dn
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc seq_del
  call   seq_scroll_up
  mov    esi,[funk_hr_ptr]
  xor    ebx,ebx
  mov    bl,[byte seq_real]
  add    bl,[byte seq_hl]
  cmp    bl,0ffh
  je     @@dont_ad
@@del_loop:
  mov    al,[byte esi+ebx+(offset (tfunk_hr).order_list+1)]
  mov    [byte esi+ebx+tfunk_hr.order_list],al
  inc    ebx
  cmp    ebx,0ffh
  jb     @@del_loop
@@dont_ad:
  mov    [byte esi+ebx+tfunk_hr.order_list],0ffh
  call   display_seqlist
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc dis_sample_name
  mov    edi,(17*2)+(36*160)
  mov    bl,[byte sam_hl]
  add    bl,[byte sam_real]
  mov    ah,13h
  call   display_byte
  mov    al,[byte sam_hl]
  add    al,[byte sam_real]
  movzx  esi,al
  shl    esi,5
  add    esi,[funk_hr_ptr]
  add    esi,offset (tfunk_hr).funk_sb
  mov    edi,(20*2)+(36*160)
  mov    cl,19
  mov    ah,13h
  call   byte_write2
endp

proc dis_pattern_no
  mov    edi,(55*2)+(36*160)
  mov    bl,[byte pat_number]
  mov    ah,13h
  call   display_byte
  mov    edi,(1*2)+(1*160)
  mov    bl,[byte pat_number]
  mov    ah,0fh
  call   display_byte
  ret
endp

proc dis_order_loop
  mov    edi,(17*2)+(37*160)
  mov    eax,[funk_hr_ptr]
  mov    bl,[byte eax+tfunk_hr.loop_order]
  mov    ah,13h
  call   display_byte
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc edit_order_loop
  mov    al,[byte seq_real]
  add    al,[byte seq_hl]
  mov    ebx,[funk_hr_ptr]
  mov    [byte ebx+tfunk_hr.loop_order],al
  call   display_seqlist
  call   dis_order_loop
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc dis_chan_status
  mov    edi,[_0b8000h]
  add    edi,(7*2)+(1*160)+1

  lea    esi,[funk_chan1]
  mov    cl,8
@@discs:
  mov    al,07h
  cmp    [byte esi+tfunk_chan.channel_kill],PLAY
  jne    @@dont_ad
  mov    al,0ch
@@dont_ad:
  mov    [byte edi],al
  mov    [byte edi+2],al
  add    esi,size tfunk_chan
  add    edi,9*2
  dec    cl
  jnz    @@discs
  ret
endp

proc channel_toggle
  cmp    al,"1"
  je     @@toggle1
  cmp    al,"2"
  je     @@toggle2
  cmp    al,"3"
  je     @@toggle3
  cmp    al,"4"
  je     @@toggle4
  cmp    al,"5"
  je     @@toggle5
  cmp    al,"6"
  je     @@toggle6
  cmp    al,"7"
  je     @@toggle7
  cmp    al,"8"
  je     @@toggle8
  ret
@@toggle1:
  xor    [byte funk_chan1.channel_kill],PLAY
  mov    edi,offset funk_chan1
  call   [dword CARD_volume_convert]
  call   dis_chan_status
  ret
@@toggle2:
  xor    [byte funk_chan2.channel_kill],PLAY
  mov    edi,offset funk_chan2
  call   [dword CARD_volume_convert]
  call   dis_chan_status
  ret
@@toggle3:
  xor    [byte funk_chan3.channel_kill],PLAY
  mov    edi,offset funk_chan3
  call   [dword CARD_volume_convert]
  call   dis_chan_status
  ret
@@toggle4:
  xor    [byte funk_chan4.channel_kill],PLAY
  mov    edi,offset funk_chan4
  call   [dword CARD_volume_convert]
  call   dis_chan_status
  ret
@@toggle5:
  xor    [byte funk_chan5.channel_kill],PLAY
  mov    edi,offset funk_chan5
  call   [dword CARD_volume_convert]
  call   dis_chan_status
  ret
@@toggle6:
  xor    [byte funk_chan6.channel_kill],PLAY
  mov    edi,offset funk_chan6
  call   [dword CARD_volume_convert]
  call   dis_chan_status
  ret
@@toggle7:
  xor    [byte funk_chan7.channel_kill],PLAY
  mov    edi,offset funk_chan7
  call   [dword CARD_volume_convert]
  call   dis_chan_status
  ret
@@toggle8:
  xor    [byte funk_chan8.channel_kill],PLAY
  mov    edi,offset funk_chan8
  call   [dword CARD_volume_convert]
  call   dis_chan_status
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc pe_handle
  cmp    ax,kb_up
  je     @@hkb_up
  cmp    ax,kb_down
  je     @@hkb_down
  cmp    ax,kb_left
  je     @@hkb_left
  cmp    ax,kb_right
  je     @@hkb_right
  push   eax
  call   mus_kb_input
  pop    eax
  cmp    ax,kb_altb
  je     @@select_start
  cmp    ax,kb_alte
  je     @@select_end
  cmp    ax,kb_altc
  je     @@copy_sel
  cmp    ax,kb_alto
  je     @@paste_sel
  cmp    ax,kb_altz
  je     @@clear_sel
  cmp    al," "
  je     @@erase_slot
  cmp    al,"/"
  je     @@dec_oct
  cmp    al,"*"
  je     @@inc_oct
  cmp    al,"-"
  je     @@dec_pat
  cmp    al,"+"
  je     @@inc_pat
  cmp    al,13
  je     @@set_bp
  cmp    al,"'"
  je     @@set_RLO
  cmp    al,"["
  je     @@edits
  cmp    al,"]"
  je     @@editc
  cmp    ax,kb_home
  je     @@hkb_home
  cmp    ax,kb_end
  je     @@hkb_end
  cmp    al,"9"
  je     @@seqadd
  cmp    al,"0"
  je     @@seqdel
  cmp    ax,kb_pageup
  je     @@hkb_pageup
  cmp    ax,kb_pagedn
  je     @@hkb_pagedn
  cmp    ax,kb_insert
  je     @@insert_slot
  cmp    ax,kb_delete
  je     @@delete_slot
  cmp    al,'p'
  je     @@inc_sam
  cmp    al,'o'
  je     @@dec_sam
  cmp    ax,kb_alts
  je     @@edit_ol
  call   channel_toggle
  jmp    @@input_loop
@@hkb_up:
  call   pat_scroll_up
  jmp    @@input_loop
@@hkb_down:
  call   pat_scroll_dn
  jmp    @@input_loop
@@hkb_left:
  cmp    [byte pat_chan],0
  je     @@input_loop
  dec    [byte pat_chan]
  mov    cl,20h
  call   display_slot
  jmp    @@input_loop
@@hkb_right:
  cmp    [byte pat_chan],7
  je     @@input_loop
  inc    [byte pat_chan]
  mov    cl,20h
  call   display_slot
  jmp    @@input_loop
@@select_start:
  call   set_select_start
  jmp    @@input_loop
@@select_end:
  call   set_select_end
  jmp    @@input_loop
@@copy_sel:
  call   copy_select
  jmp    @@input_loop
@@paste_sel:
  call   paste_select
  jmp    @@input_loop
@@clear_sel:
  call   clear_select
  jmp    @@input_loop
@@erase_slot:
  call   erase_slot
  jmp    @@input_loop
@@dec_oct:
  cmp    [byte octave],0
  je     @@input_loop
  dec    [byte octave]
  call   update_octave
  jmp    @@input_loop
@@inc_oct:
  cmp    [byte octave],4
  je     @@input_loop
  inc    [byte octave]
  call   update_octave
  jmp    @@input_loop
@@dec_pat:
  cmp    [byte pat_number],0
  je     @@input_loop
  dec    [byte pat_number]
  call   dis_pattern_no
  movzx  esi,[byte pat_number]
  mov    dh,[byte pat_real]
  call   display_pattern
  mov    cl,20h
  call   display_slot
  jmp    @@input_loop
@@inc_pat:
  mov    al,[funk_info.funk_pd_size]
  dec    al
  cmp    [byte pat_number],al
  je     @@input_loop
  inc    [byte pat_number]
  call   dis_pattern_no
  movzx  esi,[byte pat_number]
  mov    dh,[byte pat_real]
  call   display_pattern
  mov    cl,20h
  call   display_slot
  jmp    @@input_loop
@@set_bp:
  mov    al,[byte pat_real]
  add    al,[byte pat_hl]
  xor    ebx,ebx
  mov    bl,[byte pat_number]
  add    ebx,[funk_hr_ptr]
  mov    [byte ebx+tfunk_hr.break_list],al
  movzx  esi,[byte pat_number]
  mov    dh,[byte pat_real]
  call   display_pattern
  mov    cl,20h
  call   display_slot
  jmp    @@input_loop
@@set_RLO:
  call   setto_ReLOad_slot
  jmp    @@input_loop
@@edits:
  call   enter_sample
  jmp    @@input_loop
@@editc:
  call   enter_command
  jmp    @@input_loop
@@hkb_home:
  call   seq_scroll_up
  jmp    @@input_loop
@@hkb_end:
  call   seq_scroll_dn
  jmp    @@input_loop
@@seqadd:
  call   seq_add
  jmp    @@input_loop
@@seqdel:
  call   seq_del
  jmp    @@input_loop
@@hkb_pageup:
  call   pat_pageup
  jmp    @@input_loop
@@hkb_pagedn:
  call   pat_pagedn
  jmp    @@input_loop
@@insert_slot:
  call   insert_slot
  jmp    @@input_loop
@@delete_slot:
  call   delete_slot
  jmp    @@input_loop
@@inc_sam:
  call   sam_scroll_dn
  call   dis_sample_name
  jmp    @@input_loop
@@dec_sam:
  call   sam_scroll_up
  call   dis_sample_name
  jmp    @@input_loop
@@edit_ol:
  call   edit_order_loop
@@input_loop:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
macro @hl_field n
local @@dont_hl
  mov    ah,03h
  mov    cl,[byte @@line]
  cmp    cl,[byte sam_hl]
  jne    @@dont_hl
  mov    ah,03bh
  cmp    [byte sam_col],n
  jne    @@dont_hl
  add    ah,11h
@@dont_hl:
endm

proc display_samples
  mov    dl,[byte sam_real]
  add    dl,[byte sam_hl]
  shr    dl,1
  call   scroll_display32
  mov    [byte @@line],0
  xor    edx,edx
  movzx  esi,[byte sam_real]
  shl    esi,5
  add    esi,[funk_hr_ptr]
  add    esi,offset (tfunk_hr).funk_sb
@@display_treks:
  mov    ah,03h
  mov    cl,[byte @@line]
  cmp    cl,[byte sam_hl]
  jne    @@dont_hl
  mov    ah,03bh
@@dont_hl:
  mov    edi,(3*2)+(2*160)
  add    edi,edx
  mov    bl,[byte @@line]
  add    bl,[byte sam_real]
  call   display_byte
  @hl_field 0
  push   esi
  mov    edi,(8*2)+(2*160)
  add    edi,edx
  add    edi,[_0b8000h]
  mov    ch,19
  lea    esi,[esi+tfunk_sb.sname]
@@dis_sname:
  lodsb
  stosw
  dec    ch
  jnz    @@dis_sname
  pop    esi
  @hl_field 1
  mov    edi,(29*2)+(2*160)
  add    edi,edx
  mov    ecx,[dword esi+tfunk_sb.start]
  call   display_dword
  mov    edi,(39*2)+(2*160)
  add    edi,edx
  mov    ecx,[dword esi+tfunk_sb.length]
  call   display_dword
  @hl_field 2
  mov    edi,(49*2)+(2*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_sb.volume]
  call   display_byte
  @hl_field 3
  mov    edi,(53*2)+(2*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_sb.balance]
  call   display_byte
  @hl_field 4
  mov    edi,(57*2)+(2*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_sb.pt_and_sop]
  shr    bl,4
  call   display_nibble
  @hl_field 5
  mov    edi,(60*2)+(2*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_sb.pt_and_sop]
  call   display_nibble
  @hl_field 6
  mov    edi,(63*2)+(2*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_sb.vv_waveform]
  shr    bl,4
  call   display_nibble
  @hl_field 7
  mov    edi,(66*2)+(2*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_sb.vv_waveform]
  call   display_nibble
  @hl_field 8
  mov    edi,(69*2)+(2*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_sb.rl_and_as]
  shr    bl,4
  call   display_nibble
  @hl_field 9
  mov    edi,(72*2)+(2*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_sb.rl_and_as]
  call   display_nibble
  add    esi,size tfunk_sb
  add    edx,160
  inc    [byte @@line]
  cmp    [byte @@line],32
  jb     @@display_treks
  ret
@@line:
  db     ?
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc sam_scroll_up
  cmp    [byte sam_hl],0
  je     @@adj_real_bk
  dec    [byte sam_hl]
  jmp    @@end
@@adj_real_bk:
  cmp    [byte sam_real],0
  je     @@end
  dec    [byte sam_real]
@@end:
  ret
endp

proc sam_scroll_dn
  cmp    [byte sam_hl],31
  je     @@adj_real_fd
  inc    [byte sam_hl]
  jmp    @@end
@@adj_real_fd:
  cmp    [byte sam_real],(64-32)
  je     @@end
  inc    [byte sam_real]
@@end:
  ret
endp

proc sam_pageup
  mov    cl,16
@@sp:
  call   sam_scroll_up
  dec    cl
  jnz    @@sp
  ret
endp

proc sam_pagedn
  mov    cl,16
@@sp:
  call   sam_scroll_dn
  dec    cl
  jnz    @@sp
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc sam_ins_nd
  mov    dl,[byte sam_real]
  add    dl,[byte sam_hl]
  movzx  edx,dl
  cmp    edx,3fh
  je     @@dont_ad
  mov    edi,03fh
@@add_loop:
  push   edi
  shl    edi,5
  add    edi,[funk_hr_ptr]
  add    edi,offset (tfunk_hr).funk_sb
  mov    esi,edi
  sub    esi,size tfunk_sb
  mov    ecx,size tfunk_sb
  rep    movsb
  pop    edi
  dec    edi
  cmp    edi,edx
  ja     @@add_loop
@@dont_ad:
  mov    edi,edx
  shl    edi,5
  add    edi,[funk_hr_ptr]
  add    edi,offset (tfunk_hr).funk_sb
  mov    al,20h
  mov    ecx,19
  rep    stosb
  sub    edi,19
  mov    [dword edi+tfunk_sb.start],0ffffffffh
  mov    [dword edi+tfunk_sb.length],0
  mov    [byte edi+tfunk_sb.balance],80h
  mov    [byte edi+tfunk_sb.volume],0ffh
  mov    [byte edi+tfunk_sb.pt_and_sop],08h
  mov    [byte edi+tfunk_sb.vv_waveform],0
  mov    [byte edi+tfunk_sb.rl_and_as],43h
  mov    bl,[byte sam_real]
  add    bl,[byte sam_hl]
  movzx  ebx,dl
  lea    ebx,[ebx*2]
  mov    [dword ebx+funk_info.sample_ptrs],0
  call   resync_sample_ptrs
  ret
endp

proc sam_ins
  call   stop_all_voices
  @splash_on_sm  "Rearranging memory, please wait"
  call   sam_ins_nd
  call   display_samples
  call   display_s_info
  @splash_off_sm
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc del_sample
  mov    dl,[byte sam_real]
  add    dl,[byte sam_hl]
  movzx  edx,dl
  mov    ebx,edx
  lea    ebx,[ebx*4]
  shl    edx,5
  add    edx,[funk_hr_ptr]
  add    edx,offset (tfunk_hr).funk_sb
  mov    ecx,[dword funk_info.sample_block_size]
  sub    ecx,[dword edx+tfunk_sb.length]
  sub    ecx,[dword ebx+funk_info.sample_ptrs]
  inc    ecx
  mov    edi,[dword ebx+funk_info.sample_ptrs]
  mov    esi,edi
  add    esi,[dword edx+tfunk_sb.length]
  mov    al,[byte init_settings.card_type]
  cmp    al,SB_CARD
  je     @@DAC_CARD
  cmp    al,SBPRO_CARD
  je     @@DAC_CARD
  cmp    al,GUS_VARB_CARD
  je     @@GUS_CARD
  cmp    al,SB15EM_CARD
  je     @@DAC_CARD
  cmp    al,SB16_CARD
  je     @@DAC_CARD
  cmp    al,GUS_FIXB_CARD
  je     @@GUS_CARD
  cmp    al,PAS16_CARD
  je     @@DAC_CARD
  ret
@@DAC_CARD:
  rep    movsb
  ret
@@GUS_CARD:
  push   esi edi ecx
  call   GUS_reset
  pop    ecx edi esi
@@GUS_loop:
  call   GUS_mem_in
  call   GUS_mem_out
  inc    esi
  inc    edi
  dec    ecx
  jnz    @@GUS_loop
  call   GUS_reset
  call   GUS_intready
  ret
endp

proc sam_del_nd
  call   del_sample
  mov    dl,[byte sam_real]
  add    dl,[byte sam_hl]
  movzx  edi,dl
  cmp    edi,3fh
  je     @@dont_ad
@@del_loop:
  push   edi
  shl    edi,5
  add    edi,[funk_hr_ptr]
  add    edi,offset (tfunk_hr).funk_sb
  mov    esi,edi
  add    esi,size tfunk_sb
  mov    ecx,size tfunk_sb
  rep    movsb
  pop    edi
  inc    edi
  cmp    edi,3fh
  jb     @@del_loop
@@dont_ad:
  shl    edi,5
  add    edi,[funk_hr_ptr]
  add    edi,offset (tfunk_hr).funk_sb
  mov    al,20h
  mov    ecx,19
  rep    stosb
  sub    edi,19
  mov    [dword edi+tfunk_sb.start],0ffffffffh
  mov    [dword edi+tfunk_sb.length],0
  mov    [byte edi+tfunk_sb.balance],80h
  mov    [byte edi+tfunk_sb.volume],0ffh
  mov    [byte edi+tfunk_sb.pt_and_sop],08h
  mov    [byte edi+tfunk_sb.vv_waveform],0
  mov    [byte edi+tfunk_sb.rl_and_as],43h
  call   resync_sample_ptrs
  ret
endp

proc sam_del
  call   stop_all_voices
  @splash_on_sm  "Rearranging memory, please wait"
  call   sam_del_nd
  call   display_samples
  call   display_s_info
  @splash_off_sm
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc edit_sname
  mov    ch,19
  mov    dh,[byte sam_hl]
  add    dh,2
  mov    dl,8
  call   get_input
  jc     @@abort
  mov    al,[byte sam_real]
  add    al,[byte sam_hl]
  movzx  esi,al
  shl    esi,5
  add    esi,[funk_hr_ptr]
  add    esi,offset (tfunk_hr).funk_sb
  mov    cl,19
  call   get_string
@@abort:
  call   display_samples
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc edit_sstart
  mov    ch,8
  mov    dh,[byte sam_hl]
  add    dh,2
  mov    dl,29
  call   get_input
  jc     @@abort
  call   get_idword
  mov    al,[byte sam_real]
  add    al,[byte sam_hl]
  movzx  esi,al
  shl    esi,5
  add    esi,[funk_hr_ptr]
  add    esi,offset (tfunk_hr).funk_sb
  mov    [dword esi+tfunk_sb.start],ebx
@@abort:
  call   display_samples
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc edit_svolume
  mov    ch,2
  mov    dh,[byte sam_hl]
  add    dh,2
  mov    dl,49
  call   get_input
  jc     @@abort
  call   get_ibyte
  mov    bl,[byte sam_real]
  add    bl,[byte sam_hl]
  movzx  esi,bl
  shl    esi,5
  add    esi,[funk_hr_ptr]
  add    esi,offset (tfunk_hr).funk_sb
  mov    [byte esi+tfunk_sb.volume],al
@@abort:
  call   display_samples
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc edit_sbalance
  mov    ch,2
  mov    dh,[byte sam_hl]
  add    dh,2
  mov    dl,53
  call   get_input
  jc     @@abort
  call   get_ibyte
  mov    bl,[byte sam_real]
  add    bl,[byte sam_hl]
  movzx  esi,bl
  shl    esi,5
  add    esi,[funk_hr_ptr]
  add    esi,offset (tfunk_hr).funk_sb
  mov    [byte esi+tfunk_sb.balance],al
@@abort:
  call   display_samples
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc edit_port_type
  mov    ch,1
  mov    dh,[byte sam_hl]
  add    dh,2
  mov    dl,57
  call   get_input
  jc     @@abort
  call   get_inib
  cmp    bl,1
  jbe    @@dont_adjust
  mov    bl,1
@@dont_adjust:
  mov    al,[byte sam_real]
  add    al,[byte sam_hl]
  movzx  esi,al
  shl    esi,5
  add    esi,[funk_hr_ptr]
  add    esi,offset (tfunk_hr).funk_sb
  shl    bl,4
  and    [byte esi+tfunk_sb.pt_and_sop],1111b
  or     [byte esi+tfunk_sb.pt_and_sop],bl
@@abort:
  call   display_samples
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc edit_ssample_op
  mov    ch,1
  mov    dh,[byte sam_hl]
  add    dh,2
  mov    dl,60
  call   get_input
  jc     @@abort
  call   get_inib
  mov    al,[byte sam_real]
  add    al,[byte sam_hl]
  movzx  esi,al
  shl    esi,5
  add    esi,[funk_hr_ptr]
  add    esi,offset (tfunk_hr).funk_sb
  and    [byte esi+tfunk_sb.pt_and_sop],11110000b
  or     [byte esi+tfunk_sb.pt_and_sop],bl
@@abort:
  call   display_samples
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc edit_svwt
  mov    ch,1
  mov    dh,[byte sam_hl]
  add    dh,2
  mov    dl,63
  call   get_input
  jc     @@abort
  call   get_inib
  cmp    bl,4
  jbe    @@dont_adjust
  mov    bl,4
@@dont_adjust:
  mov    al,[byte sam_real]
  add    al,[byte sam_hl]
  movzx  esi,al
  shl    esi,5
  add    esi,[funk_hr_ptr]
  add    esi,offset (tfunk_hr).funk_sb
  shl    bl,4
  and    [byte esi+tfunk_sb.vv_waveform],1111b
  or     [byte esi+tfunk_sb.vv_waveform],bl
@@abort:
  call   display_samples
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc edit_svvwt
  mov    ch,1
  mov    dh,[byte sam_hl]
  add    dh,2
  mov    dl,66
  call   get_input
  jc     @@abort
  call   get_inib
  cmp    bl,4
  jbe    @@dont_adjust
  mov    bl,4
@@dont_adjust:
  mov    al,[byte sam_real]
  add    al,[byte sam_hl]
  movzx  esi,al
  shl    esi,5
  add    esi,[funk_hr_ptr]
  add    esi,offset (tfunk_hr).funk_sb
  and    [byte esi+tfunk_sb.vv_waveform],11110000b
  or     [byte esi+tfunk_sb.vv_waveform],bl
@@abort:
  call   display_samples
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc edit_retriglim
  mov    ch,1
  mov    dh,[byte sam_hl]
  add    dh,2
  mov    dl,69
  call   get_input
  jc     @@abort
  call   get_inib
  mov    al,[byte sam_real]
  add    al,[byte sam_hl]
  movzx  esi,al
  shl    esi,5
  add    esi,[funk_hr_ptr]
  add    esi,offset (tfunk_hr).funk_sb
  shl    bl,4
  and    [byte esi+tfunk_sb.rl_and_as],1111b
  or     [byte esi+tfunk_sb.rl_and_as],bl
@@abort:
  call   display_samples
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc edit_arpspeed
  mov    ch,1
  mov    dh,[byte sam_hl]
  add    dh,2
  mov    dl,72
  call   get_input
  jc     @@abort
  call   get_inib
  mov    al,[byte sam_real]
  add    al,[byte sam_hl]
  movzx  esi,al
  shl    esi,5
  add    esi,[funk_hr_ptr]
  add    esi,offset (tfunk_hr).funk_sb
  and    [byte esi+tfunk_sb.rl_and_as],11110000b
  or     [byte esi+tfunk_sb.rl_and_as],bl
@@abort:
  call   display_samples
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc insert_space
  mov    dl,[byte sam_real]
  add    dl,[byte sam_hl]
  movzx  edx,dl
  mov    ebx,edx
  shl    edx,5
  lea    ebx,[ebx*4]
  add    edx,[funk_hr_ptr]
  add    edx,offset (tfunk_hr).funk_sb
  mov    ecx,[dword funk_info.sample_block_size]
  sub    ecx,[dword edx+tfunk_sb.length]
  sub    ecx,[dword ebx+funk_info.sample_ptrs]
  inc    ecx
  mov    edi,[dword funk_info.sample_block_size]
  mov    esi,edi
  sub    esi,[dword edx+tfunk_sb.length]
  mov    al,[byte init_settings.card_type]
  cmp    al,SB_CARD
  je     @@DAC_CARD
  cmp    al,SBPRO_CARD
  je     @@DAC_CARD
  cmp    al,GUS_VARB_CARD
  je     @@GUS_CARD
  cmp    al,SB15EM_CARD
  je     @@DAC_CARD
  cmp    al,SB16_CARD
  je     @@DAC_CARD
  cmp    al,GUS_FIXB_CARD
  je     @@GUS_CARD
  cmp    al,PAS16_CARD
  je     @@DAC_CARD
  ret
@@DAC_CARD:
  std
  rep    movsb
  cld
  ret
@@GUS_CARD:
  push   esi edi ecx
  call   GUS_reset
  pop    ecx edi esi
@@gus_loop:
  call   GUS_mem_in
  call   GUS_mem_out
  dec    esi
  dec    edi
  dec    ecx
  jnz    @@gus_loop
  call   GUS_reset
  call   GUS_intready
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; edx = ptr to sample block info                                           ;
; ebx = ptr to sample ptrs                                                 ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;eax = length
proc convert_sine
  push   edx eax
@@cs:
  xor    [byte edx],80h
  inc    edx
  dec    eax
  jnz    @@cs
  pop    eax edx
  ret
endp

proc load_sample
  mov    al,[byte init_settings.card_type]
  cmp    al,SB_CARD
  je     @@DAC_CARD
  cmp    al,SBPRO_CARD
  je     @@DAC_CARD
  cmp    al,GUS_VARB_CARD
  je     @@GUS_CARD
  cmp    al,SB15EM_CARD
  je     @@DAC_CARD
  cmp    al,SB16_CARD
  je     @@DAC_CARD
  cmp    al,GUS_FIXB_CARD
  je     @@GUS_CARD
  cmp    al,PAS16_CARD
  je     @@DAC_CARD
  ret
@@DAC_CARD:
  mov    esi,[dword edx+tfunk_sb.length]
  mov    edx,[dword ebx+funk_info.sample_ptrs]
  mov    ebx,[dword file_handle_funk]
@@SB_load_sample_loop:
  mov    ah,3fh
  mov    ecx,40000
  cmp    ecx,esi
  jbe    @@SB_dont_adjust
  mov    ecx,esi
@@SB_dont_adjust:
  int    21h
  call   convert_sine
  add    edx,eax
  sub    esi,eax
  jnz    @@SB_load_sample_loop
  ret
@@GUS_CARD:
  push   edx ebx
  call   GUS_reset
  pop    ebx edx
  mov    ebp,[dword edx+tfunk_sb.length]
  mov    edi,[dword ebx+funk_info.sample_ptrs]
  mov    ebx,[dword file_handle_funk]
@@GUS_load_sample_loop:
  mov    ah,3fh
  mov    edx,[dword fdirectory_buffer]
  mov    ecx,40000
  cmp    ecx,ebp
  jbe    @@GUS_dont_adjust
  mov    ecx,ebp
@@GUS_dont_adjust:
  int    21h
  call   convert_sine
  mov    esi,[dword fdirectory_buffer]
  push   eax
  call   gus_upload
  pop    eax
  sub    ebp,eax
  jnz    @@GUS_load_sample_loop
  call   GUS_reset
  call   GUS_intready
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc dis_resamwin
  lea    esi,[resample_window]
  mov    edi,[_0b8000h]
  add    edi,(((78-25)/2)*2)+(((40-12)/2)*160)
  mov    ebx,25
  mov    dl,12
  call   paint_window

  xor    ecx,ecx
  xor    edx,edx
@@select_src:
  push   ecx edx
  mov    dh,04h                          ; no of entries
  mov    ebx,2f07h                       ; colour of hl
  mov    edi,[_0b8000h]
  add    edi,((((78-25)/2)+1)*2)+((((40-12)/2)+5)*160)+1
  mov    ecx,9                           ; length
  call   dis_sbar
  pop    edx ecx
@@again:
  call   get_key
  cmp    al,27
  je     @@finish
  cmp    al,13
  je     @@select_tar
  cmp    ax,kb_up
  je     @@up
  cmp    ax,kb_down
  je     @@dn
  jmp    @@again
@@up:
  cmp    dl,0
  je     @@again
  dec    dl
  jmp    @@select_src
@@dn:
  cmp    dl,3
  je     @@again
  inc    dl
  jmp    @@select_src
@@select_tar:
  cmp    dl,0
  je     @@sr_8000
  cmp    dl,1
  je     @@sr_11025
  cmp    dl,2
  je     @@sr_22050
  cmp    dl,3
  je     @@sr_44100
@@sr_8000:
  mov    ecx,8000
  jmp    @@sr_cont
@@sr_11025:
  mov    ecx,11025
  jmp    @@sr_cont
@@sr_22050:
  mov    ecx,22050
  jmp    @@sr_cont
@@sr_44100:
  mov    ecx,44100
@@sr_cont:
  mov    edx,ecx
@@tar_l:
  push   ecx edx
  mov    eax,edx
  mov    edi,((((78-25)/2)+13)*2)+((((40-12)/2)+6)*160)
  call   print_decn5
  pop    edx ecx
@@tar_again:
  call   get_key
  cmp    al,27
  je     @@finish
  cmp    al,13
  je     @@finish
  cmp    ax,kb_up
  je     @@tar_up
  cmp    ax,kb_down
  je     @@tar_dn
  cmp    ax,kb_pageup
  je     @@tar_pdup
  cmp    ax,kb_pagedn
  je     @@tar_pddn
  jmp    @@tar_again
@@tar_up:
  cmp    edx,0
  je     @@tar_again
  dec    edx
  jmp    @@tar_l
@@tar_dn:
  cmp    edx,88200
  je     @@tar_again
  inc    edx
  jmp    @@tar_l
@@tar_pdup:
  sub    edx,100
  cmp    edx,0
  jge    @@tar_l
  mov    edx,0
  jmp    @@tar_l
@@tar_pddn:
  add    edx,100
  cmp    edx,88200
  jle    @@tar_l
  mov    edx,88200
  jmp    @@tar_l
@@finish:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
FTRANS_INB_SIZE       = 2048
FTRANS_OUTB_SIZE      = 2048
ftrans_scr_len        dd ?
LS_src_freq           dd ?
LS_dst_freq           dd ?
LS_length             dd ?

proc ftrans_read
  push   edx
  mov    ecx,FTRANS_INB_SIZE
  cmp    ecx,[ftrans_scr_len]
  jbe    @@cont
  mov    ecx,[ftrans_scr_len]
@@cont:
  mov    ebx,[dword file_handle_funk]
  mov    edx,[fdirectory_buffer]
  mov    ah,3fh
  int    21h
  mov    [numread],eax
  sub    [ftrans_scr_len],eax
  pop    edx
  xor    esi,esi
  ret
endp

proc ftrans_write
  push   edx
  mov    ecx,edi
  mov    ebx,[dword file_handle_funk2]
  mov    edx,[fdirectory_buffer]
  add    edx,FTRANS_INB_SIZE
  mov    ah,40h
  int    21h
  pop    edx
  xor    edi,edi
  ret
endp

;eax = target freq
;ebx = source freq
;ecx = scr len
proc ftrans_buffer
  mov    [@@target_freq],eax
  mov    [@@source_freq],ebx
  mov    [ftrans_scr_len],ecx
  mov    eax,[@@target_freq]
  mov    edx,eax
  shl    eax,16
  shr    edx,16
  div    [dword @@source_freq]
  mov    edx,eax
  mov    ebp,edx
  shl    edx,16
  shr    ebp,16
  xor    esi,esi
  xor    edi,edi
  call   ftrans_read
  jc     @@error_trans
  cmp    [dword numread],0
  je     @@done
@@mix_loop:
  mov    ebx,[fdirectory_buffer]
  mov    al,[esi+ebx]
  mov    ebx,[fdirectory_buffer]
  mov    [edi+ebx+FTRANS_INB_SIZE],al
  inc    edi
  add    [dword @@freq_attract],edx
  adc    esi,ebp
  cmp    esi,[numread]
  jb     @@cont
  call   ftrans_read
  jc     @@error_trans
  cmp    [dword numread],0
  je     @@done
@@cont:
  cmp    edi,FTRANS_OUTB_SIZE
  jb     @@mix_loop
  call   ftrans_write
  jc     @@error_trans
  jmp    @@mix_loop
@@error_trans:
  @error_mess "Error: Can not transform sample"
  stc
  ret
@@done:
  cmp    edi,0
  je     @@cont2
  call   ftrans_write
@@cont2:
  clc
  ret
@@freq_attract        dd 0
@@target_freq         dd ?
@@source_freq         dd ?
endp

macro @LS_CONFREQ
  mov    edx,offset file_temp
  mov    eax,3c00h
  xor    ecx,ecx
  int    21h
  jc     @@mess2
  mov    [dword file_handle_funk2],eax

  mov    eax,[LS_src_freq]
  mov    ebx,[LS_dst_freq]
  mov    ecx,[LS_length]
  call   ftrans_buffer
  jnc    @@no_ftrans_error
  mov    ebx,[dword file_handle_funk2]
  mov    ah,3eh
  int    21h
  jmp    @@closef
@@no_ftrans_error:
  mov    ebx,[dword file_handle_funk]
  mov    ah,3eh
  int    21h
  mov    eax,[dword file_handle_funk2]
  mov    [dword file_handle_funk],eax

  mov    ebx,[dword file_handle_funk]
  mov    eax,4202h
  xor    edx,edx
  int    21h
  push   eax
  mov    ebx,[dword file_handle_funk]
  mov    eax,4200h
  xor    edx,edx
  int    21h
  pop    eax
endm

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; WAV loader                                                               ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
struc triff_hr
  rID                 dd ?      ; Contains the characters "RIFF"
  rLen                dd ?      ; The length of the data in the next chunk
ends

struc twaveformat
  wID                 dd ?      ; Contains the characters "WAVE"
  fId                 dd ?      ; Contains the characters "fmt"
  fLen                dd ?      ; Length of data in the format chunk
  wFormatTag          dw ?      ; *
  nChannels           dw ?      ; Number of channels, 1=mono, 2=stereo
  nSamplesPerSec      dw ?      ; Playback frequency
  nAvgBytesPerSec     dw ?      ; **
  nBlockAlign         dw ?      ; ***
  FormatSpecific      dw ?      ; Format specific data area
  blank               dd ?
ends

struc twavedata
  dId                 dd ?      ; Contains the characters "data"
  dLen                dd ?      ; Length of data in the dData field
ends

riff_hr               triff_hr <>
waveformat            twaveformat <>
wavedata              twavedata <>

proc load_single_WAV
  call   dis_resamwin
  mov    [LS_src_freq],ecx
  mov    [LS_dst_freq],edx
  @splash_on_sm  "Loading WAV, please wait"
  mov    dl,[byte sam_real]
  add    dl,[byte sam_hl]
  movzx  edx,dl
  shl    edx,5
  add    edx,[funk_hr_ptr]
  add    edx,offset (tfunk_hr).funk_sb
  mov    eax,3d00h
  int    21h
  jc     @@mess1
  mov    [dword file_handle_funk],eax
  mov    ebx,eax
  mov    ah,3fh                                         ; load riff header
  lea    edx,[riff_hr]
  mov    ecx,size triff_hr
  int    21h
  cmp    [dword riff_hr.rID],"FFIR"
  jne    @@not_wave_mess
  mov    ah,3fh                                         ; load wave header
  lea    edx,[waveformat]
  mov    ecx,size twaveformat
  int    21h
  cmp    [dword waveformat.wID],"EVAW"
  jne    @@not_wave_mess
  cmp    [dword waveformat.fId]," tmf"
  jne    @@not_wave_mess
  mov    ah,3fh                                         ; load data header
  lea    edx,[wavedata]
  mov    ecx,size twavedata
  int    21h
  cmp    [dword wavedata.dId],"atad"
  jne    @@not_wave_mess
  cmp    [dword wavedata.dLen],0
  je     @@closef
  mov    eax,[LS_src_freq]
  cmp    eax,[LS_dst_freq]
  je     @@load_normal
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  mov    eax,[dword wavedata.dLen]
  mov    [LS_length],eax
  @LS_CONFREQ
  jmp    @@load_data
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@load_normal:
  mov    eax,[dword wavedata.dLen]
@@load_data:
  xor    edx,edx
  mov    dl,[byte sam_real]
  add    dl,[byte sam_hl]
  shl    edx,5
  add    edx,[funk_hr_ptr]
  add    edx,offset (tfunk_hr).funk_sb
  mov    ebx,[dword funk_info.sample_memory_lim]
  mov    ecx,[dword funk_info.sample_block_size]
  sub    ecx,[dword funk_info.sample_ptrs]
  sub    ebx,ecx
  cmp    eax,ebx
  ja     @@out_of_mem
  mov    [dword edx+tfunk_sb.length],eax
  call   resync_sample_ptrs
  call   insert_space
  mov    dl,[byte sam_real]
  add    dl,[byte sam_hl]
  movzx  edx,dl
  mov    ebx,edx
  shl    edx,5
  lea    ebx,[ebx*4]
  add    edx,[funk_hr_ptr]
  add    edx,offset (tfunk_hr).funk_sb
  call   load_sample
  mov    ebx,[dword file_handle_funk]
  mov    ah,3eh                                         ; close
  int    21h
  @splash_off_sm
  ret
@@mess1:
  @error_mess "Error: Can not load WAV"
  ret
@@mess2:
  @error_mess "Error: Can not load WAV"
  jmp    @@closef
@@out_of_mem:
  @error_mess "Error: Out of sample memory; Can not load WAV"
  jmp    @@closef
@@not_wave_mess:
  @error_mess "Error: Not a recognised Windows WAV"
  jmp    @@closef
@@closef:
  mov    ebx,[dword file_handle_funk]
  mov    ah,3eh                                   ; close
  int    21h
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; SND loader                                                               ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc load_single_SMP
  call   dis_resamwin
  mov    [LS_src_freq],ecx
  mov    [LS_dst_freq],edx
  @splash_on_sm  "Loading SMP, please wait"
  xor    edx,edx
  mov    dl,[byte sam_real]
  add    dl,[byte sam_hl]
  shl    edx,5
  add    edx,[funk_hr_ptr]
  add    edx,offset (tfunk_hr).funk_sb
  mov    eax,3d00h
  int    21h
  jc     @@mess1
  mov    [dword file_handle_funk],eax
  mov    ebx,eax

  mov    eax,4202h
  xor    edx,edx
  int    21h
  push   eax
  mov    eax,4200h
  xor    edx,edx
  int    21h
  pop    [dword LS_length]
  mov    eax,[LS_src_freq]
  cmp    eax,[LS_dst_freq]
  je     @@load_normal
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  @LS_CONFREQ
  jmp    @@load_data
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@load_normal:
  mov    eax,[dword LS_length]
@@load_data:
  xor    edx,edx
  mov    dl,[byte sam_real]
  add    dl,[byte sam_hl]
  shl    edx,5
  add    edx,[funk_hr_ptr]
  add    edx,offset (tfunk_hr).funk_sb
  mov    ebx,[dword funk_info.sample_memory_lim]
  mov    ecx,[dword funk_info.sample_block_size]
  sub    ecx,[dword funk_info.sample_ptrs]
  sub    ebx,ecx
  cmp    eax,ebx
  ja     @@out_of_mem
  mov    [dword edx+tfunk_sb.length],eax
  call   resync_sample_ptrs
  call   insert_space
  xor    edx,edx
  mov    dl,[byte sam_real]
  add    dl,[byte sam_hl]
  mov    ebx,edx
  shl    edx,5
  lea    ebx,[ebx*4]
  add    edx,[funk_hr_ptr]
  add    edx,offset (tfunk_hr).funk_sb
  call   load_sample
  mov    ebx,[dword file_handle_funk]
  mov    ah,3eh                                         ; close
  int    21h
  @splash_off_sm
  ret
@@mess1:
  @error_mess "Error: Can not load SND"
  ret
@@mess2:
  @error_mess "Error: Can not load SND"
  jmp    @@closef
@@out_of_mem:
  @error_mess "Error: Out of sample memory; Can not load SND"
  jmp    @@closef
@@closef:
  mov    ebx,[dword file_handle_funk]
  mov    ah,3eh                                   ; close
  int    21h
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc select_sample_file
  call   stop_all_voices
  lea    edx,[sample_dir]
  call   set_directory
  mov    ecx,modefile_screen_size
  lea    esi,[modefile_screen]
  mov    edi,[_0b8000h]
  call   uncrush_text
  lea    edx,[file_search_wav]
  call   load_fdirectory
  xor    bl,bl
  lea    edx,[file_search_snd]
  call   load_fset
  call   display_fdir
@@input_loop:
  call   get_key
  cmp    al,27
  je     @@exit
  cmp    ax,kb_up
  je     @@hkb_up
  cmp    ax,kb_down
  je     @@hkb_down
  cmp    ax,kb_pageup
  je     @@hkb_pageup
  cmp    ax,kb_pagedn
  je     @@hkb_pagedn
  cmp    al,13
  je     @@enter_key
  jmp    @@input_loop
@@scroll_fdir_up:
  call   display_fdir
  jmp    @@input_loop
@@scroll_fdir_dw:
  call   display_fdir
  jmp    @@input_loop
@@hkb_up:
  call   fdir_scroll_up
  call   display_fdir
  jmp    @@input_loop
@@hkb_down:
  call   fdir_scroll_dn
  call   display_fdir
  jmp    @@input_loop
@@hkb_pageup:
  call   fdir_scroll_pageup
  call   display_fdir
  jmp    @@input_loop
@@hkb_pagedn:
  call   fdir_scroll_pagedn
  call   display_fdir
  jmp    @@input_loop
@@enter_key:
  mov    cl,size tfdirectory
  mov    ax,[word fdir_real]
  add    al,[byte fdir_hl]
  adc    ah,0
  mul    cl
  movzx  esi,ax
  add    esi,[dword fdirectory_buffer]
  cmp    [byte esi+tfdirectory.attr],10h
  jne    @@load_file
  push   esi
  lea    esi,[sample_dir]
  mov    edi,esi
  call   get_directory
  pop    esi
  lea    esi,[esi+tfdirectory.fname]
  call   goto_end_str
  cmp    ebx,3
  jne    @@form_path2
  call   mini_trans_str
  jmp    @@change_dir
@@form_path2:
  mov    [byte edi+ebx],'\'
  inc    ebx
  call   mini_trans_str
@@change_dir:
  lea    edx,[sample_dir]
  call   set_directory
  lea    esi,[sample_dir]
  call   get_directory
  lea    edx,[file_search_wav]
  call   load_fdirectory
  xor    bl,bl
  lea    edx,[file_search_snd]
  call   load_fset
  call   display_fdir
  jmp    @@input_loop
@@load_file:
  push   esi
  mov    al,[byte sam_real]
  add    al,[byte sam_hl]
  movzx  esi,al
  shl    esi,5
  add    esi,[funk_hr_ptr]
  add    esi,offset (tfunk_hr).funk_sb
  cmp    [dword esi+tfunk_sb.length],0
  je     @@dont_del
  @splash_on_sm  "Deleting old sample ready for replacement, please wait"
  call   sam_del_nd
  call   sam_ins_nd
  @splash_off_sm
@@dont_del:
  pop    esi
  mov    al,[byte sam_real]
  add    al,[byte sam_hl]
  movzx  edi,al
  shl    edi,5
  add    edi,[funk_hr_ptr]
  add    edi,offset (tfunk_hr).funk_sb
  push   edi
  mov    ecx,19
  mov    al," "
@@clr_sname:
  stosb
  dec    ecx
  jnz    @@clr_sname
  pop    edi
  lea    esi,[esi+tfdirectory.fname]
  push   esi
  xor    ebx,ebx
  call   mini_trans_str
  pop    esi
@@search_type:
  cmp    [byte esi],"."
  je     @@done_st
  inc    esi
  jmp    @@search_type
@@done_st:
  cmp    [dword esi],"DNS."
  je     @@do_SMP
  call   load_single_WAV
  jmp    @@load_done
@@do_SMP:
  call   load_single_SMP
@@load_done:
;;;;;;;;;;;;
  mov    edx,offset file_temp
  mov    ah,41h
  int    21h
;;;;;;;;;;;
@@exit:
  call   display_mode
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc se_handle
  cmp    ax,kb_up
  je     @@hkb_up
  cmp    ax,kb_down
  je     @@hkb_down
  cmp    ax,kb_pageup
  je     @@hkb_pageup
  cmp    ax,kb_pagedn
  je     @@hkb_pagedn
  cmp    ax,kb_left
  je     @@hkb_left
  cmp    ax,kb_right
  je     @@hkb_right
  cmp    al,"/"
  je     @@dec_oct
  cmp    al,"*"
  je     @@inc_oct
  push   eax
  call   mus_kb_input
  pop    eax
  cmp    al,"["
  je     @@edit_field
  cmp    ax,kb_insert
  je     @@insert_sb
  cmp    ax,kb_delete
  je     @@delete_sb
  cmp    al," "
  je     @@load_sample
  jmp    @@input_loop
@@hkb_up:
  call   sam_scroll_up
  call   display_samples
  jmp    @@input_loop
@@hkb_down:
  call   sam_scroll_dn
  call   display_samples
  jmp    @@input_loop
@@hkb_pageup:
  call   sam_pageup
  call   display_samples
  jmp    @@input_loop
@@hkb_pagedn:
  call   sam_pagedn
  call   display_samples
  jmp    @@input_loop
@@hkb_left:
  cmp    [byte sam_col],0
  je     @@input_loop
  dec    [byte sam_col]
  call   display_samples
  jmp    @@input_loop
@@hkb_right:
  cmp    [byte sam_col],9
  je     @@input_loop
  inc    [byte sam_col]
  call   display_samples
  jmp    @@input_loop
@@dec_oct:
  cmp    [byte octave],0
  je     @@input_loop
  dec    [byte octave]
  call   update_octave
  jmp    @@input_loop
@@inc_oct:
  cmp    [byte octave],4
  je     @@input_loop
  inc    [byte octave]
  call   update_octave
  jmp    @@input_loop
@@edit_field:
  cmp    [byte sam_col],1
  je     @@edit_f2
  cmp    [byte sam_col],2
  je     @@edit_f3
  cmp    [byte sam_col],3
  je     @@edit_f4
  cmp    [byte sam_col],4
  je     @@edit_f5
  cmp    [byte sam_col],5
  je     @@edit_f6
  cmp    [byte sam_col],6
  je     @@edit_f7
  cmp    [byte sam_col],7
  je     @@edit_f8
  cmp    [byte sam_col],8
  je     @@edit_f9
  cmp    [byte sam_col],9
  je     @@edit_f10
@@edit_f1:
  call   edit_sname
  jmp    @@input_loop
@@edit_f2:
  call   edit_sstart
  jmp    @@input_loop
@@edit_f3:
  call   edit_svolume
  jmp    @@input_loop
@@edit_f4:
  call   edit_sbalance
  jmp    @@input_loop
@@edit_f5:
  call   edit_port_type
  jmp    @@input_loop
@@edit_f6:
  call   edit_ssample_op
  jmp    @@input_loop
@@edit_f7:
  call   edit_svwt
  jmp    @@input_loop
@@edit_f8:
  call   edit_svvwt
  jmp    @@input_loop
@@edit_f9:
  call   edit_retriglim
  jmp    @@input_loop
@@edit_f10:
  call   edit_arpspeed
  jmp    @@input_loop
@@insert_sb:
  call   sam_ins
  jmp    @@input_loop
@@delete_sb:
  call   sam_del
  jmp    @@input_loop
@@load_sample:
  call   select_sample_file
  jmp    @@input_loop
@@input_loop:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc trak_seq_info
  mov    esi,[funk_hr_ptr]

  mov    ah,13h
  mov    edi,(12*2)+(46*160)
  mov    bl,[byte funk_info.sequence_ofs]
  call   display_byte

  mov    edi,(28*2)+(46*160)
  xor    ebx,ebx
  mov    bl,[byte funk_info.sequence_ofs]
  mov    bl,[byte esi+ebx+tfunk_hr.order_list]
  call   display_byte

  mov    edi,(28*2)+(47*160)
  mov    bl,[byte funk_info.pattern_ofs]
  call   display_byte

  mov    edi,(39*2)+(46*160)
  mov    bl,[byte funk_info.tempo]
  call   display_nibble

  mov    edi,(39*2)+(47*160)
  mov    bl,[byte funk_info.master_volume]
  call   display_nibble
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc track_screen_debug
  call   trak_seq_info
  mov    ah,03h
  lea    esi,[funk_chan1]
  mov    cl,8
  xor    edx,edx
@@display_chan_dump:
  push   ecx edx
;;;
  mov    edi,(1*2)+(37*160)
  add    edi,edx
  movzx  ebx,[word esi+tfunk_chan.command]
  call   display_command
;;
  mov    edi,(5*2)+(37*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_chan.sample]
  call   display_byte
;;;
  mov    edi,(8*2)+(37*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_chan.balance]
  call   display_byte
;;;
  mov    edi,(10*2)+(37*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_chan.port_type]
  call   display_nibble
;;;
  mov    edi,(11*2)+(37*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_chan.sample_ofs_parm]
  call   display_nibble
;;;
  mov    edi,(12*2)+(37*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_chan.vib_waveform]
  call   display_nibble
;;;
  mov    edi,(13*2)+(37*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_chan.vol_vib_waveform]
  call   display_nibble
;;;
  mov    edi,(14*2)+(37*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_chan.retrig_limit]
  call   display_nibble
;;;
  mov    edi,(15*2)+(37*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_chan.arp_speed]
  call   display_nibble
;;;
  mov    edi,(16*2)+(37*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_chan.funkctrl]
  call   display_nibble
;;;
  mov    edi,(18*2)+(37*160)
  add    edi,edx
  movzx  ebx,[word esi+tfunk_chan.note_command]
  call   display_command
;;
  mov    edi,(22*2)+(37*160)
  add    edi,edx
  movzx  ebx,[byte esi+tfunk_chan.note]
  call   display_note
;;;
  mov    edi,(26*2)+(37*160)
  add    edi,edx
  mov    ecx,[dword esi+tfunk_chan.ifreq]
  call   display_word
;;;
  mov    edi,(31*2)+(37*160)
  add    edi,edx
  mov    ecx,[dword esi+tfunk_chan.ifreq_vibrato]
  call   display_word
;;;
  mov    edi,(36*2)+(37*160)
  add    edi,edx
  mov    ecx,[dword esi+tfunk_chan.ifreq_portdest]
  call   display_word
;;;
  mov    edi,(41*2)+(37*160)
  add    edi,edx
  mov    ecx,[dword esi+tfunk_chan.rfreq]
  call   display_dword
;;;
  mov    edi,(50*2)+(37*160)
  add    edi,edx
  mov    ecx,[dword esi+tfunk_chan.rfreq_adjust]
  call   display_word
;;;
  mov    edi,(55*2)+(37*160)
  add    edi,edx
  mov    ecx,[dword esi+tfunk_chan.rfreq_portdest]
  call   display_dword
;;;
  mov    edi,(64*2)+(37*160)
  add    edi,edx
  movzx  ebx,[word esi+tfunk_chan.volume_command]
  call   display_command
;;
  mov    edi,(68*2)+(37*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_chan.volume]
  call   display_byte
;;;
  mov    edi,(71*2)+(37*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_chan.volume_vibrato]
  call   display_byte
;;;
  mov    edi,(74*2)+(37*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_chan.volume_portdest]
  call   display_byte
;;;
  mov    edi,(77*2)+(37*160)
  add    edi,edx
  mov    bl,[byte esi+tfunk_chan.rvolume]
  call   display_byte
;;;
  pop    edx ecx
  add    esi,size tfunk_chan
  add    dx,160
  dec    cl
  jnz    @@display_chan_dump
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc track_screen_play
  call   trak_seq_info
  lea    esi,[funk_chan1]
  mov    cl,8
  xor    edx,edx
@@display_chan_dump:
  push   ecx edx
;;;
  mov    ah,0fh
  push   esi
  mov    al,[byte esi+tfunk_chan.sample]
  movzx  esi,al
  shl    esi,5
  add    esi,[funk_hr_ptr]
  add    esi,offset (tfunk_hr).funk_sb
  mov    edi,(1*2)+(36*160)
  add    edi,edx
  mov    cl,19
  call   byte_write2
  pop    esi
;;;
  mov    ah,03h
  mov    edi,(56*2)+(36*160)
  add    edi,edx
  movzx  ebx,[word esi+tfunk_chan.command]
  call   display_command
;;
  mov    edi,(61*2)+(36*160)
  add    edi,edx
  movzx  ebx,[word esi+tfunk_chan.note_command]
  call   display_command
;;
  mov    edi,(66*2)+(36*160)
  add    edi,edx
  movzx  ebx,[word esi+tfunk_chan.volume_command]
  call   display_command
;;
  mov    edi,(22*2)+(36*160)
  add    edi,[_0b8000h]
  add    edi,edx
  mov    bl,[byte esi+tfunk_chan.rvolume]
  shr    bl,3
  xor    cl,cl
@@p_trek_bar:
  cmp    cl,bl
  je     @@paint_end
  mov    al," "
  ja     @@asd
  mov    al,205
  jmp    @@asd
@@paint_end:
  mov    al,[byte esi+tfunk_chan.rvolume]
  and    al,111b
  add    al,198
@@asd:
  stosb
  inc    edi
  inc    cl
  cmp    cl,32
  jnz    @@p_trek_bar
;;
  pop    edx ecx
  add    esi,size tfunk_chan
  add    edx,160
  dec    cl
  jnz    @@display_chan_dump

  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; dl = colour adjust ; eax = pattern ofs
proc display_trak
  and    al,11111b
  mov    edi,[_0b8000h]
  add    edi,((4*2)+(2*160))+1
  mov    ebx,eax
  shl    eax,7
  shl    ebx,5
  add    edi,eax
  add    edi,ebx
  mov    cl,9*8
@@hl_trek:
  and    [byte edi],1111b
  or     [byte edi],dl
  add    edi,2
  dec    cl
  jnz    @@hl_trek
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc trak_pattern
  movzx  ebx,[byte funk_info.sequence_ofs]
  cmp    bl,80h
  jae    @@end
  cmp    bl,[byte funk_info.sequence_ofs_old]
  jne    @@draw_pat
  mov    al,[byte funk_info.pattern_ofs2_old]
  mov    ah,[byte funk_info.pattern_ofs]
  shr    al,5
  shr    ah,5
  cmp    al,ah
  je     @@clear_bar
@@draw_pat:
  mov    [byte funk_info.sequence_ofs_old],bl
  mov    esi,[funk_hr_ptr]
  movzx  ebx,[byte esi+ebx+tfunk_hr.order_list]
  movzx  esi,bl
  mov    dh,[byte funk_info.pattern_ofs]
  and    dh,100000b
  call   display_pattern
  jmp    @@set_bar
@@clear_bar:
  xor    dl,dl
  movzx  eax,[byte funk_info.pattern_ofs2_old]
  call   display_trak
@@set_bar:
  mov    dl,70h
  movzx  eax,[byte funk_info.pattern_ofs]
  mov    [byte funk_info.pattern_ofs2_old],al
  call   display_trak
@@end:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc trak_paint_screen
  mov    ecx,main_screen_size
  lea    esi,[main_screen]
  mov    edi,[_0b8000h]
  call   uncrush_text
  lea    esi,[song_name]
  mov    edi,(72*2)
  mov    cl,8
  mov    ah,0dh
  call   byte_write1
  cmp    [byte trakplay_type],1                        ; 1 = ply
  je     @@dis_ply
  mov    ecx,trakd_screen_size
  lea    esi,[trakd_screen]
  mov    edi,[_0b8000h]
  add    edi,5600
  call   uncrush_text
  jmp    @@dis_done
@@dis_ply:
  mov    ecx,trakp_screen_size
  lea    esi,[trakp_screen]
  mov    edi,[_0b8000h]
  add    edi,5600
  call   uncrush_text
@@dis_done:
  ret
endp

proc trak_play
  call   init_for_play
  cmp    [byte trakplay_type],2                        ; 1 = ply
  jb     @@dont_pay_from_mod
  xor    eax,eax
  mov    al,[byte seq_real]
  add    al,[byte seq_hl]
  add    eax,[funk_hr_ptr]
  cmp    [byte eax+tfunk_hr.order_list],080h
  jae    @@mess2
  @splash_on_sm "Backtracking, please wait"
  mov    al,[byte seq_real]
  add    al,[byte seq_hl]
@@back_trak:
  cli
  push   eax
  mov    [byte funk_info.trek_status],PLAY
  call   funk_tracker
  mov    [byte funk_info.trek_status],STOP
  call   stop_all_voices
  pop    eax
  sti
  cmp    [byte funk_info.sequence_ofs],al
  jne    @@back_trak
  sub    [byte trakplay_type],2
  @splash_off_sm
@@dont_pay_from_mod:
  call   trak_paint_screen
  call   dis_chan_status
  call   display_seqlist
  cmp    [byte funk_info.no_of_sequences],0ffh
  je     @@mess1
  mov    [byte funk_info.trek_status],PLAY
@@input_loop:
  @WaitVertEnd
  @WaitVert
  call   trak_pattern
  cmp    [byte trakplay_type],1                        ; 1 = ply
  je     @@trak_ply
  call   track_screen_debug
  jmp    @@trak_done
@@trak_ply:
  call   track_screen_play
@@trak_done:
  cmp    [byte funk_info.trek_status],STOP
  je     @@exit
  call   key_pressed2
  jnc    @@input_loop
  call   get_key
  cmp    al,27
  je     @@exit
  cmp    ax,kb_altd
  je     @@dosshell
  call   channel_toggle
  jmp    @@input_loop
@@dosshell:
  call   dos_shell
  mov    [byte funk_info.sequence_ofs_old],0ffh
  mov    [byte funk_info.pattern_ofs2_old],0ffh
  call   trak_paint_screen
  call   display_seqlist
  jmp    @@input_loop
@@exit:
  mov    [byte funk_info.trek_status],STOP
  call   stop_all_voices
  ret
@@mess1:
  @error_mess "You can not play a song with an empty order list"
  ret
@@mess2:
  @error_mess "backtrack order out of range, try another sequence"
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc init_vars
  mov    [byte edit_mode],0
  mov    [byte pat_number],0
  mov    [byte pat_real],0
  mov    [byte pat_hl],0
  mov    [byte pat_chan],0
  mov    [byte pat_old_hl],0
  mov    [byte pat_old_chan],0
  mov    [byte sam_real],0
  mov    [byte sam_hl],0
  mov    [byte sam_col],0
  mov    [byte note],0
  mov    [byte octave],2
  mov    [byte seq_real],0
  mov    [byte seq_hl],0
  mov    [word fdir_real],0
  mov    [byte fdir_hl],0
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; Routine from Intel Corp                                                 ;
;                                                                         ;
; 0=????                                                                  ;
; 1=????                                                                  ;
; 2=????                                                                  ;
; 3=Intel386(TM) processor                                                ;
; 4=Intel486(TM) processor                                                ;
; 5=Pentium(TM) processor                                                 ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
cpu_vendor_id         db 12 dup (?)
cpu_cpu_type          db ?
cpu_c_model           db ?
cpu_stepping          db ?
cpu_id_flag           db 0
cpu_intel_proc        db 0
cpu_feature_flags     dw 2 dup (0)

macro @CPUID
  db     0fh
  db     0a2h
endm

proc get_cpuid
  mov    [byte cpu_cpu_type],0
  mov    [byte cpu_id_flag],0
  mov    [byte cpu_intel_proc],0
  pushad
  mov    ebx,esp
  and    esp,not 3
  pushf
  pop    eax
  mov    ecx,eax
  xor    eax,40000h
  push   eax
  popf
  pushf
  pop    eax
  xor    eax,ecx
  mov    [byte cpu_cpu_type],3
  mov    esp,ebx
  jz     @@end_get_cpuid
  and    esp,not 3
  push   ecx
  popf
  mov    esp,ebx
@@check_80486:
  mov    [byte cpu_cpu_type],4
  mov    eax,ecx
  xor    eax,200000h
  push   eax
  popf
  pushf
  pop    eax
  xor    eax,ecx
  je     @@end_get_cpuid
@@check_vendor:
  mov    [byte cpu_id_flag],1
  xor    eax,eax
  @CPUID
  mov    [word cpu_vendor_id],bx
  mov    [word 4+cpu_vendor_id],dx
  mov    [word 8+cpu_vendor_id],cx
  lea    esi,[cpu_vendor_id]
  lea    edi,[@@intel_id]
  mov    ecx,length @@intel_id
@@compare:
  repe   cmpsb
  or     ecx,ecx
  jnz    @@end_get_cpuid
@@intel_processor:
  mov    [byte cpu_intel_proc],1
@@cpuid_data:
  cmp    eax,1
  jl     @@end_get_cpuid
  xor    eax,eax
  inc    eax
  @CPUID
  mov    [byte cpu_stepping],al
  and    [byte cpu_stepping],0fh
  and    al,0f0h
  shr    al,4
  mov    [byte cpu_c_model],al
  and    ax,0f00h
  shr    ax,8
  mov    [byte cpu_cpu_type],al
  mov    [word cpu_feature_flags],dx
@@end_get_cpuid:
  popad
  ret
@@intel_id:
  db      "GenuineIntel"
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; 'info' code:                                                             ;
;                                                                          ;
;  0 0 0 0 0 0 0 0   1 1 1 1 1 1 1 1   2 2 2 2 2 2 2 2   3 3 3 3 3 3 3 3   ;
;  \-day---/ \month--/ \----year---/   \-card/ \-CPU-/   | 0 0 0 0 0 0 0   ;
;                                                        | \memory reqi/   ;
;                                                        |                 ;
;                                         16 bit = 1 ----|                 ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc clear_all_funk
;CLEAR HEADER
  mov    esi,[funk_hr_ptr]
  mov    [dword esi+tfunk_hr.sig],"knuF"
  mov    [dword esi+tfunk_hr.LZH_check_sum],"80kF"
  mov    ah,2ah
  int    21h
  movzx  eax,dl
  movzx  edx,dh
  shl    edx,5
  or     eax,edx
  sub    ecx,1980
  shl    ecx,9
  or     eax,ecx
  mov    edi,[funk_hr_ptr]
  mov    [word edi+tfunk_hr.info],ax
  movzx  ax,[byte init_settings.card_type]
  mov    bl,[byte cpu_cpu_type]
  shl    bl,4
  or     al,bl
  mov    [word edi+2+tfunk_hr.info],ax
  mov    [byte edi+tfunk_hr.loop_order],0ffh
  add    edi,offset (tfunk_hr).order_list
  mov    al,0ffh
  mov    ecx,256
  rep    stosb
  mov    al,03fh
  mov    ecx,128
  rep    stosb
;CLEAR SAMPLE BLOCK
  mov    dl,64
  mov    edi,[funk_hr_ptr]
  add    edi,offset (tfunk_hr).funk_sb
@@clear_sb:
  xor    al,al
  mov    ecx,19
  rep    stosb
  sub    edi,19
  mov    [dword edi+tfunk_sb.start],0ffffffffh
  mov    [dword edi+tfunk_sb.length],0
  mov    [byte edi+tfunk_sb.volume],0ffh
  mov    [byte edi+tfunk_sb.balance],80h
  mov    [byte edi+tfunk_sb.pt_and_sop],08h
  mov    [byte edi+tfunk_sb.vv_waveform],0
  mov    [byte edi+tfunk_sb.rl_and_as],43h
  add    edi,size tfunk_sb
  dec    dl
  jnz    @@clear_sb
;CLEAR PATTERNS
  mov    esi,[funk_hr_ptr]
  add    esi,size tfunk_hr
  movzx  eax,[byte funk_info.funk_pd_size]
  mov    ecx,8*64
  mul    ecx
  mov    ecx,eax
@@clear_patterns:
  @mini_clear_slot
  add    esi,3
  dec    ecx
  jnz    @@clear_patterns
  call   resync_sample_ptrs
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; returns eax           MODIFIED: Adam 10/5/95 V1.06                       ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc find_funk_size_parity
  mov    ebx,[dword file_handle_funk]
  mov    eax,4202h
  xor    edx,edx
  int    21h
  push   eax
  mov    ebx,[dword file_handle_funk]
  mov    eax,4200h
  xor    edx,edx
  int    21h
  pop    eax
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; edx = points to the filename ANSIIZ                                      ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc load_funk_module
  push   edx
  call   clear_all_funk
  mov    eax,3d00h
  pop    edx
  int    21h
  jc     @@mess1
  mov    [dword file_handle_funk],eax
  call   find_funk_size_parity                    ; find parity and size
  mov    [dword @@temp_size],eax
  mov    ebx,[dword file_handle_funk]
  mov    edx,[funk_hr_ptr]
  mov    ecx,size tfunk_hr
  mov    ah,3fh                                   ; read header+sample block
  int    21h
  cmp    [dword edx+tfunk_hr.sig],"knuF"
  jne    @@mess2
  movzx  eax,[byte edx+3+tfunk_hr.info]           ; find memory requirement
  and    al,11111110b
  add    al,2
  shl    eax,18
  cmp    eax,[dword funk_info.sample_memory_lim]
  ja     @@mess3
  call   find_pats_seqs
  mov    al,[byte funk_info.no_of_patterns]
  cmp    al,[funk_info.funk_pd_size]
  ja     @@mess3
  call   resync_sample_ptrs
  mov    eax,[dword @@temp_size]                  ; check size and parity
  mov    edx,[funk_hr_ptr]
  cmp    [dword edx+tfunk_hr.LZH_check_size],eax
  jne    @@mess2
  push   edx
  mov    eax,600h                                 ; save patterns
  movzx  ecx,[byte funk_info.no_of_patterns]
  mul    ecx
  mov    ebx,[dword file_handle_funk]
  pop    edx
  add    edx,size tfunk_hr
  mov    ecx,eax
  mov    ah,3fh
  int    21h
  mov    eax,[dword funk_info.sample_block_size]
  sub    eax,[dword funk_info.sample_ptrs]
  mov    ebx,[dword file_handle_funk]
  mov    edx,[dword funk_sd_ptr]
  mov    ecx,eax
  mov    ah,3fh
  int    21h
  mov    ebx,[dword file_handle_funk]
  mov    ah,3eh                                   ; close
  int    21h
  call   upload_exteral_data
  mov    al,0
  ret
@@mess1:
  mov    al,1                                     ;can't load song
  ret
@@mess2:
  call   clear_all_funk                           ;invalid song
  mov    al,2
@@mess3:
  call   clear_all_funk                           ;not enough sample mem
  mov    al,3
  ret
@@temp_size:
  dd     ?
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc dnload_exteral_data
  cmp    [byte init_settings.card_type],GUS_VARB_CARD
  je     @@GUS_mem_move
  cmp    [byte init_settings.card_type],GUS_FIXB_CARD
  je     @@GUS_mem_move
  ret
@@GUS_mem_move:
  call   GUS_reset
  mov    edi,[dword funk_sd_ptr]
  mov    esi,[dword funk_info.sample_ptrs]
  mov    ecx,[dword funk_info.sample_block_size]
  sub    ecx,[dword funk_info.sample_ptrs]
  call   GUS_dnload
  call   GUS_reset
  call   GUS_intready
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; edx = points to the filename ANSIIZ                                      ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc save_funk_module
  mov    [dword @@fn],edx
  call   find_pats_seqs
  call   resync_sample_ptrs
  cmp    [byte funk_info.no_of_sequences],0ffh
  je     @@mess1
  mov    eax,[dword funk_info.sample_block_size]
  cmp    eax,[dword funk_info.sample_ptrs]
  je     @@mess2
; disk space test
  mov    ah,36h
  xor    dl,dl
  int    21h
  mul    ecx
  mul    ebx
  or     edx,edx
  jnz    @@heaps_of_space
  push   eax
  mov    eax,600h
  movzx  ecx,[byte funk_info.no_of_sequences]
  inc    ecx
  mul    ecx
  mov    ecx,[dword funk_info.sample_block_size]
  sub    ecx,[dword funk_info.sample_ptrs]
  add    eax,ecx
  add    eax,size tfunk_hr
  pop    ecx
  cmp    eax,ecx
  jbe    @@heaps_of_space
  jmp    @@mess4
@@heaps_of_space:
  call   dnload_exteral_data
  mov    eax,3c00h
  mov    edx,[dword @@fn]
  xor    ecx,ecx
  int    21h
  jc     @@mess3
  mov    [dword file_handle_funk],eax
  mov    ebx,eax
  mov    edx,[funk_hr_ptr]
  mov    ecx,size tfunk_hr
  mov    ah,40h                                   ; save tables+sample block
  int    21h
  mov    eax,600h                                 ; save patterns
  movzx  ecx,[byte funk_info.no_of_patterns]
  mul    ecx
  mov    ebx,[dword file_handle_funk]
  mov    edx,[funk_hr_ptr]
  add    edx,size tfunk_hr
  mov    ecx,eax
  mov    ah,40h
  int    21h
  mov    eax,[dword funk_info.sample_block_size]
  sub    eax,[dword funk_info.sample_ptrs]
  mov    ebx,[dword file_handle_funk]
  mov    edx,[dword funk_sd_ptr]
  mov    ecx,eax
  mov    ah,40h
  int    21h
; write memory requirement
  mov    eax,[dword funk_info.sample_block_size]
  sub    eax,[dword funk_info.sample_ptrs]
  and    al,11111110b
  shr    eax,18
;; or     al,10000000b
;; set bit 7 if a 16 bit sample
  mov    edx,[funk_hr_ptr]
  mov    [byte edx+3+tfunk_hr.info],al
  call   find_funk_size_parity
  mov    edx,[funk_hr_ptr]
  mov    [dword edx+tfunk_hr.LZH_check_size],eax
  mov    edx,[funk_hr_ptr]
  mov    ecx,offset (tfunk_hr).loop_order
  mov    ah,40h
  int    21h
  mov    ah,3eh                                   ;close
  int    21h
  mov    al,0
  ret
@@mess1:
  mov    al,0                                     ;can't save song with emptylist
  ret
@@mess2:
  mov    al,1                                     ;no samples
  ret
@@mess3:
  mov    al,2                                     ;can't save song
  ret
@@mess4:
  mov    al,3                                     ;not enough save on harddisk
  ret
@@fn     dd ?
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; displays file direct                                                     ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc sload_funk
  call   stop_all_voices
  lea    edx,[song_dir]
  call   set_directory
  mov    ecx,modefile_screen_size
  lea    esi,[modefile_screen]
  mov    edi,[_0b8000h]
  call   uncrush_text
  lea    edx,[file_search_funk]
  call   load_fdirectory
  call   display_fdir
@@input_loop:
  call   get_key
  cmp    al,27
  je     @@exit
  cmp    ax,kb_up
  je     @@hkb_up
  cmp    ax,kb_down
  je     @@hkb_down
  cmp    ax,kb_pageup
  je     @@hkb_pageup
  cmp    ax,kb_pagedn
  je     @@hkb_pagedn
  cmp    al,13
  je     @@enter_key
  jmp    @@input_loop
@@scroll_fdir_up:
  call   display_fdir
  jmp    @@input_loop
@@scroll_fdir_dw:
  call   display_fdir
  jmp    @@input_loop
@@hkb_up:
  call   fdir_scroll_up
  call   display_fdir
  jmp    @@input_loop
@@hkb_down:
  call   fdir_scroll_dn
  call   display_fdir
  jmp    @@input_loop
@@hkb_pageup:
  call   fdir_scroll_pageup
  call   display_fdir
  jmp    @@input_loop
@@hkb_pagedn:
  call   fdir_scroll_pagedn
  call   display_fdir
  jmp    @@input_loop
@@enter_key:
  mov    cl,size tfdirectory
  mov    ax,[word fdir_real]
  add    al,[byte fdir_hl]
  adc    ah,0
  mul    cl
  movzx  esi,ax
  add    esi,[dword fdirectory_buffer]
  cmp    [byte esi+tfdirectory.attr],10h
  jne    @@load_file
  push   esi
  lea    esi,[song_dir]
  mov    edi,esi
  call   get_directory
  pop    esi
  lea    esi,[esi+tfdirectory.fname]
  call   goto_end_str
  cmp    ebx,3
  jne    @@form_path2
  call   mini_trans_str
  jmp    @@change_dir
@@form_path2:
  mov    [byte edi+ebx],'\'
  inc    ebx
  call   mini_trans_str
@@change_dir:
  lea    edx,[song_dir]
  call   set_directory
  lea    esi,[song_dir]
  call   get_directory
  lea    edx,[file_search_funk]
  call   load_fdirectory
  call   display_fdir
  jmp    @@input_loop
@@load_file:
  lea    edi,[song_name]
  lea    esi,[esi+tfdirectory.fname]
  xor    ebx,ebx
  call   mini_trans_str
  lea    esi,[song_name]
  mov    edi,(72*2)
  mov    cl,8
  mov    ah,0dh
  call   byte_write1
  lea    edx,[song_name]
  @splash_on_sm  "Loading music, please wait"
  call   load_funk_module
  cmp    al,1
  je     @@mess1
  cmp    al,2
  je     @@mess2
  cmp    al,3
  je     @@mess3
  @splash_off_sm
  jmp    @@end_mess
@@mess1:
  @error_mess "Error: Can not load song"
  jmp    @@end_mess
@@mess2:
  @error_mess "Error: A corrupted or invalid funk song!"
  jmp    @@end_mess
@@mess3:
  @error_mess "Abort: Not enough pattern/sample memory"
@@end_mess:
  call   init_vars
@@exit:
  call   display_mode
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc isave_funk_module
  @splash_on_sm  "Saving your music, please wait"
  call   save_funk_module
  cmp    al,1
  je     @@mess1
  cmp    al,2
  je     @@mess2
  cmp    al,3
  je     @@mess3
  cmp    al,4
  je     @@mess4
  @splash_off_sm
  ret
@@mess1:
  @error_mess "Error: Can not save song with empty order list"
  ret
@@mess2:
  @error_mess "Error: Can not save song with no samples"
  ret
@@mess3:
  @error_mess "Error: Unable to save song"
  ret
@@mess4:
  @error_mess "Error: Not enough space on harddisk to save song"
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc ssave_funk
  mov    ch,8
  mov    edx,0048h
  call   get_input
  jc     @@abort
  lea    esi,[song_name]
  mov    cl,8
  call   get_string
  mov    [byte esi],"."
  mov    [byte esi+1],"F"
  mov    [byte esi+2],"N"
  mov    [byte esi+3],"K"
  mov    [byte esi+4],0
  lea    edx,[song_dir]
  call   set_directory
  lea    edx,[song_name]
  call   isave_funk_module
@@abort:
  lea    esi,[song_name]
  mov    edi,(72*2)
  mov    cl,8
  mov    ah,0dh
  call   byte_write1
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc dump_GUSmem
  mov    al,[byte init_settings.card_type]
  cmp    al,GUS_VARB_CARD
  je     @@GUS_mem_move
  cmp    al,GUS_FIXB_CARD
  je     @@GUS_mem_move
  ret
@@GUS_mem_move:
; disk space test
  mov    ah,36h
  xor    dl,dl
  int    21h
  mul    ecx
  mul    ebx
  or     edx,edx
  jz     @@heaps_of_space
  cmp    eax,[dword funk_info.sample_memory_lim]
  jb     @@mess3
@@heaps_of_space:
  @splash_on_sm  "dumping GUSmem to '\GUS_DUMPSND', please wait"
  mov    eax,3c00h
  lea    edx,[@@dump_name]                        ; create
  xor    ecx,ecx
  int    21h
  jc     @@mess3
  mov    [dword file_handle_funk],eax
  call   GUS_reset
  mov    eax,[dword funk_info.sample_memory_lim]
  or     eax,eax
  jz     @@end
  mov    ebx,4000h
  xor    edx,edx
  div    ebx
  mov    ecx,eax
  mov    esi,[dword funk_info.sample_ptrs]
@@dnlop:
  push   ecx
  mov    edi,[dword fdirectory_buffer]
  mov    ecx,4000h
  call   GUS_dnload
  mov    ebx,[dword file_handle_funk]
  mov    edx,[dword fdirectory_buffer]
  mov    ecx,4000h
  mov    ah,40h
  int    21h
  pop    ecx
  dec    ecx
  jnz    @@dnlop
  call   GUS_reset
@@end:
  mov    ebx,[dword file_handle_funk]
  mov    ah,3eh                                   ; close
  int    21h
  call   GUS_intready
  @splash_off_sm
  ret
@@dump_name:
  db     "\GUS_DUMP.SND",0
@@mess3:
  @error_mess "Error: Unable to save dump"
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc display_s_info
  mov    edi,(16*2)+(37*160)
  mov    eax,[dword funk_info.sample_memory_lim]
  call   print_decn9
  mov    edi,(46*2)+(37*160)
  mov    eax,[dword funk_info.sample_block_size]
  sub    eax,[dword funk_info.sample_ptrs]
  call   print_decn9
  mov    edi,(46*2)+(38*160)
  mov    eax,[dword funk_info.sample_memory_lim]
  mov    ecx,[dword funk_info.sample_block_size]
  sub    ecx,[dword funk_info.sample_ptrs]
  sub    eax,ecx
  call   print_decn9
  ret
endp

proc display_midi
  mov    edi,[_0B8000h]
  cmp    [MIDI.midi_status],STOP
  je     @@ddm
  mov    [dword edi+(32*2)],0a490a4dh
  mov    [dword edi+(32*2)+4],0a490a44h
  mov    [dword edi+(32*2)+8],0a4f0a20h
  mov    [dword edi+(32*2)+12],0a200a4eh
  jmp    @@t_chord
@@ddm:
  mov    [dword edi+(32*2)],0
  mov    [dword edi+(32*2)+4],0
  mov    [dword edi+(32*2)+8],0
  mov    [dword edi+(32*2)+12],0
@@t_chord:
  cmp    [byte MIDI_quantise],1
  jne    @@no_chord
  mov    [dword edi+(32*2)+16],0a640a43h
  ret
@@no_chord:
  mov    [dword edi+(32*2)+16],0
  ret
endp

proc other_info
  mov    ebx,[funk_hr_ptr]
;Display date
  mov    al,[byte ebx+tfunk_hr.info]
  and    al,11111b
  mov    edi,(68*2)+(40*160)
  call   print_decn1
  movzx  eax,[word ebx+tfunk_hr.info]
  shr    eax,5
  and    al,1111b
  mov    edi,(71*2)+(40*160)
  call   print_decn1
  movzx  eax,[word ebx+tfunk_hr.info]
  shr    eax,9
  and    eax,1111111b
  add    eax,1980
  mov    edi,(74*2)+(40*160)
  call   print_decn3
;display cpu
  movzx  esi,[byte ebx+2+tfunk_hr.info]
  shr    esi,1
  and    esi,1111000b
  add    esi,offset @@cpu_display
  mov    edi,(68*2)+(41*160)
  mov    ah,1dh
  mov    cl,8
  call   byte_write2
;display card
  mov    ebx,[funk_hr_ptr]
  movzx  esi,[byte ebx+2+tfunk_hr.info]
  and    esi,1111b
  lea    esi,[esi*8]
  add    esi,offset @@card_display
  mov    edi,(68*2)+(42*160)
  mov    ah,1dh
  mov    cl,8
  call   byte_write2
; display memory
  mov    ebx,[funk_hr_ptr]
  movzx  eax,[byte ebx+3+tfunk_hr.info]
  and    al,11111110b
  add    al,2
  shl    eax,18
  mov    edi,(68*2)+(43*160)
  call   print_decn9
;precision
  lea    esi,[@@precision1]
  test   [byte ebx+3+tfunk_hr.info],10000000b
  jz     @@8bit_module
  lea    esi,[@@precision2]
@@8bit_module:
  mov    edi,(68*2)+(44*160)
  mov    ah,1dh
  mov    cl,2
  call   byte_write2
; LZH size
  mov    ebx,[funk_hr_ptr]
  mov    edi,(68*2)+(45*160)
  mov    eax,[dword ebx+tfunk_hr.LZH_check_size]
  call   print_decn9
; LZH checksum
  mov    esi,offset (tfunk_hr).LZH_check_sum
  add    esi,ebx
  cmp    [byte esi],"F"
  jne    @@endchksum
  mov    edi,(68*2)+(46*160)
  mov    ah,1dh
  mov    cl,4
  call   byte_write2
@@endchksum:
  ret
@@cpu_display:
  db     "Unknown "     ;0
  db     "IBM ????"     ;1
  db     "IBM ????"     ;2
  db     "Intel386"     ;3
  db     "Intel486"     ;4
  db     "Pentium "     ;5
  db     ">Pentium"     ;6
  db     ">Pentium"     ;7
  db     ">Pentium"     ;8
  db     ">Pentium"     ;9
  db     ">Pentium"     ;a
  db     ">Pentium"     ;b
  db     ">Pentium"     ;c
  db     ">Pentium"     ;d
  db     ">Pentium"     ;e
  db     ">Pentium"     ;f
@@card_display:
  db     "SB 2.0  "     ;0
  db     "SB PRO  "     ;1
  db     "GUS v<> "     ;2
  db     "SB COMP "     ;3
  db     "SB 16   "     ;4
  db     "GUS f<> "     ;5
  db     "Ripped  "     ;6
  db     "PAS 16  "     ;7
  db     "????????"     ;8
  db     "????????"     ;9
  db     "????????"     ;a
  db     "????????"     ;b
  db     "????????"     ;c
  db     "????????"     ;d
  db     "????????"     ;e
  db     "????????"     ;f
@@precision1:
  db     "08"
@@precision2:
  db     "16"
endp

proc display_mode
  @WaitVertEnd
  cmp    [byte edit_mode],0
  je     @@se
  cmp    [byte edit_mode],1
  je     @@pe
  ret
@@se:
  mov    ecx,se_screen_size
  lea    esi,[se_screen]
  mov    edi,[_0b8000h]
  call   uncrush_text
  call   display_samples
  call   display_s_info
  call   update_octave
  call   other_info
  jmp    @@all
@@pe:
  mov    ecx,main_screen_size
  lea    esi,[main_screen]
  mov    edi,[_0b8000h]
  call   uncrush_text
  mov    ecx,pe_screen_size
  lea    esi,[pe_screen]
  mov    edi,[_0b8000h]
  add    edi,5600
  call   uncrush_text
  call   dis_sample_name
  call   dis_pattern_no
  call   dis_order_loop
  call   update_octave
  movzx  esi,[byte pat_number]
  mov    dh,[byte pat_real]
  call   display_pattern
  call   display_seqlist
  mov    cl,20h
  call   display_slot
  call   dis_chan_status
@@all:
  lea    esi,[song_name]
  mov    edi,(72*2)
  mov    cl,8
  mov    ah,0dh
  call   byte_write1
  call   display_midi
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc set_colour
  @splash_on_sm  "What Colour do you wish to change?: "
  mov    ch,2
  mov    dh,49
  mov    dl,36
  call   get_input
  jc     @@abort
  call   get_ibyte
  mov    [byte @@colour],al
  lea    edi,[@@red_v]
  mov    ecx,3
  mov    edx,3c7h                                   ; read palette
  out    dx,al
  add    edx,2
  rep    insb
; returns al
@@input_loop:
  call   get_key
  cmp    al,27
  je     @@abort
  cmp    al,"q"
  je     @@dec_r
  cmp    al,"a"
  je     @@inc_r
  cmp    al,"w"
  je     @@dec_g
  cmp    al,"s"
  je     @@inc_g
  cmp    al,"e"
  je     @@dec_b
  cmp    al,"d"
  je     @@inc_b
  jmp    @@input_loop
@@dec_r:
  cmp    [byte @@red_v],0
  je     @@input_loop
  dec    [byte @@red_v]
  jmp    @@set_pal
@@inc_r:
  cmp    [byte @@red_v],63
  je     @@input_loop
  inc    [byte @@red_v]
  jmp    @@set_pal
@@dec_g:
  cmp    [byte @@grn_v],0
  je     @@input_loop
  dec    [byte @@grn_v]
  jmp    @@set_pal
@@inc_g:
  cmp    [byte @@grn_v],63
  je     @@input_loop
  inc    [byte @@grn_v]
  jmp    @@set_pal
@@dec_b:
  cmp    [byte @@ble_v],0
  je     @@input_loop
  dec    [byte @@ble_v]
  jmp    @@set_pal
@@inc_b:
  cmp    [byte @@ble_v],63
  je     @@input_loop
  inc    [byte @@ble_v]
@@set_pal:
  lea    esi,[@@red_v]
  mov    ecx,3
  mov    edx,3c8h                                   ; read palette
  mov    al,[byte @@colour]
  out    dx,al
  inc    edx
  rep    outsb
  mov    ah,0fh
  mov    edi,(60*2)+(49*160)
  mov    bl,[byte @@red_v]
  call   display_byte
  mov    edi,(64*2)+(49*160)
  mov    bl,[byte @@grn_v]
  call   display_byte
  mov    edi,(68*2)+(49*160)
  mov    bl,[byte @@ble_v]
  call   display_byte
  jmp    @@input_loop
@@abort:
  @splash_off_sm
  ret
@@red_v:
  db     ?
@@grn_v:
  db     ?
@@ble_v:
  db     ?
@@colour:
  db     ?
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; Shell to MessyDOS (from DOS32 libraries)                                 ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc dos_shell
  mov    eax,3h
  int    10h
  mov    edx,offset @@shell_mess
  mov    ah,9
  int    21h
  mov    ax,0EE02h
  int    31h
@@get_str_loop:
  cmp    [dword edi],'SMOC'
  jne    @@not_string
  cmp    [dword edi+4],'=CEP'
  je     @@got_string
@@not_string:
  mov    al,0
  mov    ecx,20000
  repne  scasb
  jmp    @@get_str_loop
@@got_string:
  add    edi,8
  mov    edx,edi
  mov    ah,4Bh
  mov    al,0
  mov    edi,00000
  mov    esi,Offset @@dummy_cmd_tail
  int    21h
  call   setup_screen
  ret
@@shell_mess:
db "Ŀ",13,10
db "  In V86 mode,so please keep it clean. ",13,10
db "  Type 'EXIT' to return to FunkTracker ",13,10
db "$"
@@dummy_cmd_tail      db 1,' '
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
MIDI_test_mode        db ?
MIDI_chan             db ?

proc MIDI_off
  cmp    [MIDI.midi_status],STOP
  je     @@end
  cmp    [byte init_settings.card_type],SB16_CARD
  je     @@sb16_s
  ret
@@sb16_s:
  call   MPU401_Reset
  mov    [MIDI.midi_status],STOP
@@end:
  ret
endp

proc MIDI_toggle
  cmp    [MIDI.midi_status],PLAY
  je     @@stop_midi
  cmp    [byte init_settings.card_type],SB16_CARD
  je     @@sb16_p
  ret
@@sb16_p:
  mov    [MIDI_quantise],0
  call   MPU401_Reset
  or     al,al
  jnz    @@fail
  call   MPU401_EUARTM
  or     al,al
  jnz    @@fail2
  mov    [MIDI.midi_status],PLAY
  call   display_midi

  @splash_on_sm  "Please hit C#1 on your MIDI board...now"
  mov    [byte MIDI_test_mode],PLAY
@@l:
  call   MIDI_decode_single
  cmp    [byte MIDI_test_mode],PLAY
  je     @@l
  @splash_off_sm
  ret
@@stop_midi:
  call   MIDI_off
  call   display_midi
  ret
@@fail:
  @error_mess "Error: MIDI not detected"
  ret
@@fail2:
  call   MPU401_Reset
  @error_mess "Error: MIDI not responding"
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc fire_note_chord
  mov    al,[MIDI.byte2]
  sub    al,[MIDI.base]
  cmp    al,59
  ja     @@done
  xor    ah,ah
  mov    cl,12
  div    cl
  mov    [byte octave],al
  mov    [byte note],ah

  cmp    [byte edit_mode],1
  jne    @@ignore
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  mov    dl,[MIDI_chan]
  call   enter_slot_data         ;dl= [byte pat_chan]

  xor    cl,cl
  movzx  esi,[byte pat_number]
  mov    dl,[MIDI_chan]
  mov    dh,[byte pat_real]
  mov    ch,[byte pat_hl]
  add    dh,ch
  call   display_slot_f
@@ignore:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  mov    cl,[MIDI_chan]
  call   play_keynote
  call   dis_keyboard2
  cmp    [MIDI_chan],7
  je     @@done
  inc    [MIDI_chan]
@@done:
  ret
endp

proc MIDI_decode_chord
  cmp    [MIDI.midi_status],STOP
  je     @@exit
  call   MIDI_queue_out_sig
  jc     @@exit
  mov    ah,al
  shr    al,4
  cmp    al,1001b
  je     @@note_on
  ret
@@note_on:
  mov    [MIDI.byte1],ah
  mov    al,[pat_chan]
  mov    [MIDI_chan],al
  call   clr_keyboard
@@next_note:
  call   MIDI_queue_out_pol
  cmp    al,0feh
  je     @@done
  mov    [MIDI.byte2],al
  call   MIDI_queue_out_pol
  mov    [MIDI.byte3],al
  or     al,al
  jz     @@next_note
  call   fire_note_chord
  jmp    @@next_note
@@done:
  cmp    [byte edit_mode],1
  jne    @@exit
  call   pat_scroll_dn
@@exit:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc fire_note_single
  cmp    [byte MIDI_test_mode],PLAY
  je     @@test_mode
;  mov    edi,(40*2)+(0*160)
;  add    edi,[@@scroller2]
;  mov    bl,[MIDI.byte2]
;  mov    ah,[@@colour2]
;  add    ah,8
;  call   display_byte
;  add    [@@scroller2],4
;  and    [@@scroller2],31
;  jz     @@c
;  inc    [byte @@colour2]
;  and    [byte @@colour2],7
;@@c:

  mov    al,[MIDI.byte2]
  sub    al,[MIDI.base]
  cmp    al,59
  ja     @@done
  xor    ah,ah
  mov    cl,12
  div    cl
  mov    [byte octave],al
  mov    [byte note],ah

  cmp    [byte edit_mode],1
  jne    @@ignore
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  mov    dl,[pat_chan]
  call   enter_slot_data         ;dl= [byte pat_chan]

  xor    cl,cl
  movzx  esi,[byte pat_number]
  mov    dl,[pat_chan]
  mov    dh,[byte pat_real]
  mov    ch,[byte pat_hl]
  add    dh,ch
  call   display_slot_f
@@ignore:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  mov    cl,[pat_chan]
  call   play_keynote
  call   dis_keyboard
  cmp    [byte edit_mode],1
  jne    @@done
  call   pat_scroll_dn
@@done:
  ret
;@@scroller2           dd 0
;@@colour2             db 0
@@test_mode:
  mov    al,[MIDI.byte2]
  mov    [MIDI.base],al
  mov    [byte MIDI_test_mode],STOP
  ret
endp

proc MIDI_decode_single
  cmp    [MIDI.midi_status],STOP
  je     @@exit
  call   MIDI_queue_out_sig
  jc     @@exit
  mov    ah,al
  shr    al,4
  cmp    al,1001b
  je     @@note_on
  ret
@@note_on:
  mov    [MIDI.byte1],ah
@@next_note:
  call   MIDI_queue_out_pol
  cmp    al,0feh
  je     @@exit
  mov    [MIDI.byte2],al
  call   MIDI_queue_out_pol
  mov    [MIDI.byte3],al
  or     al,al
  jz     @@next_note
  call   fire_note_single
  jmp    @@next_note
@@exit:
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc display_about
  call   display_mode
  lea    esi,[splash_screen]
  mov    edi,[_0b8000h]
  add    edi,(19*2)+(14*160)
  mov    ebx,42
  mov    dl,12
  call   paint_window

  call   get_key
  call   display_mode
  ret
endp

proc main_handle
  call   display_about
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
@@input_loop:
  cmp    [byte MIDI_quantise],1
  je     @@get_chord
  call   MIDI_decode_single
  jmp    @@cont
@@get_chord:
  call   MIDI_decode_chord
@@cont:
  call   key_pressed2
  jnc    @@input_loop
  call   get_key
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  cmp    ax,kb_altx
  je     @@exit
  cmp    ax,kb_f1
  je     @@set_to_se
  cmp    ax,kb_f2
  je     @@set_to_pe
  cmp    ax,kb_f3
  je     @@dis_help
  cmp    ax,kb_f5
  je     @@set_to_trakdbg
  cmp    ax,kb_altf5
  je     @@set_to_trakply
  cmp    ax,kb_f6
  je     @@set_to_trakfm_dbg
  cmp    ax,kb_altf6
  je     @@set_to_trakfm_ply
  cmp    ax,kb_f7
  je     @@stop_voices
  cmp    ax,kb_f8
  je     @@load
  cmp    ax,kb_f9
  je     @@saveas
  cmp    ax,kb_f10
  je     @@save
  cmp    ax,kb_altv
  je     @@dumptofile
  cmp    ax,kb_altn
  je     @@clear_module
  cmp    ax,kb_altm
  je     @@set_colour
  cmp    ax,kb_altd
  je     @@dosshell
  cmp    ax,kb_altk
  je     @@MIDI_toggle
  cmp    ax,kb_altq
  je     @@MIDI_quantise
  cmp    ax,kb_alth
  je     @@about
  cmp    ax,kb_altt
  je     @@toggle_chan
  cmp    [byte edit_mode],0
  je     @@se
  cmp    [byte edit_mode],1
  je     @@pe
  jmp    @@input_loop
@@dis_help:
  mov    ecx,help_screen_size
  lea    esi,[help_screen]
  call   help_scroll
  jmp    @@input_loop
@@set_to_se:
  mov    [byte edit_mode],0
  call   display_mode
  jmp    @@input_loop
@@set_to_pe:
  mov    [byte edit_mode],1
  call   display_mode
  jmp    @@input_loop
@@set_to_trakdbg:
  mov    [byte trakplay_type],0
  call   trak_play
  call   display_mode
  jmp    @@input_loop
@@set_to_trakply:
  mov    [byte trakplay_type],1
  call   trak_play
  call   display_mode
  jmp    @@input_loop
@@set_to_trakfm_dbg:
  mov    [byte trakplay_type],2
  call   trak_play
  call   display_mode
  jmp    @@input_loop
@@set_to_trakfm_ply:
  mov    [byte trakplay_type],3
  call   trak_play
  call   display_mode
  jmp    @@input_loop
@@se:
  call   se_handle
  jmp    @@input_loop
@@pe:
  call   pe_handle
  jmp    @@input_loop
@@stop_voices:
  call   stop_all_voices
  jmp    @@input_loop
@@load:
  call   sload_funk
  jmp    @@input_loop
@@saveas:
  call   ssave_funk
  jmp    @@input_loop
@@save:
  lea    edx,[song_dir]
  call   set_directory
  lea    edx,[song_name]
  call   isave_funk_module
  jmp    @@input_loop
@@clear_module:
  lea    esi,[@@file_name]
  lea    edi,[song_name]
  mov    ecx,13
  rep    movsb
  call   clear_all_funk
  call   display_mode
  jmp    @@input_loop
@@set_colour:
  call   set_colour
  jmp    @@input_loop
@@dumptofile:
  call   dump_GUSmem
  jmp    @@input_loop
@@dosshell:
  call   dos_shell
  call   display_mode
  jmp    @@input_loop
@@MIDI_toggle:
  call   MIDI_toggle
  jmp    @@input_loop
@@MIDI_quantise:
  xor    [byte MIDI_quantise],1
  call   display_midi
  jmp    @@input_loop
@@about:
  call   display_about
  jmp    @@input_loop
@@toggle_chan:
  mov    ebx,[funk_hr_ptr]
  cmp    [word ebx+tfunk_hr.LZH_check_sum],"kF"
  je     @@toggle_chan1
  cmp    [word ebx+tfunk_hr.LZH_check_sum],"vF"
  je     @@toggle_chan2
  jmp    @@input_loop
@@toggle_chan1:
  mov    ebx,[funk_hr_ptr]
  mov    [word ebx+tfunk_hr.LZH_check_sum],"vF"
  call   other_info
  jmp    @@input_loop
@@toggle_chan2:
  mov    [word ebx+tfunk_hr.LZH_check_sum],"kF"
  call   other_info
  jmp    @@input_loop
@@exit:
  @splash_on_sm  "Do you really wish to Retreat? (y/n)"
  call   get_key
  push   eax
  @splash_off_sm
  pop    eax
  cmp    al,"y"
  je     @@really_exit
  cmp    al,"Y"
  je     @@really_exit
  jmp    @@input_loop
@@really_exit:
  ret
@@file_name:
  db     "NEW_SONG.FNK",0
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
help_mess             db 13,10,"COMMAND LINE: funk -h -cX -iXX -dXX -sX -pXX -bXXXXXXXX",13,10
                      db "       cX: Card type (0=PAS16 only, 1=GUS, 2=CT card)",13,10
                      db "      iXX: override soundcard IRQ [default - autodetected]",13,10
                      db "      dXX: override soundcard DMA [default - autodetected]",13,10
                      db "       sX: Sample rate (0=11025hz,1=16538hz,2=22050hz,3=33075hz,4=44100hz)",13,10
                      db "      pXX: Pattern allocation, hex number [default -p80]",13,10
                      db "bXXXXXXXX: Sample allocation, hex number [default  -b00100000]",13,10,13,10
                      db "Additional Info:",13,10
                      db "",13,10
                      db "  IRQ and DMA override values are not selfchecking. If you enter a bogus",13,10
                      db "   setting, then the computer will hang.",13,10
                      db "  If you have any weird ProAudio cards other than a PAS16, then you have to",13,10
                      db "   force SoundBlaster compatability mode. (ie -c2 option)",13,10
                      db "  Pattern Allocation and Sample Allocation simply means the number of patterns",13,10
                      db "   and sample memory you wish to allocate. The pattern allocation is set on the",13,10
                      db "   highest level as default. The sample allocation is 1Meg default.",13,10
                      db "  Number parameters are expected to be in hexidecimal,",13,10
                      db "$"
parm_card             db 0ffh
parm_IRQ              db 0ffh
parm_DMA              db 0ffh

proc search_funkline
  mov    bx,"h-"
  call   @@get_parm
  jnc    @@help
  mov    bx,"c-"
  call   @@get_parm
  jnc    @@set_card
@@sIRQ:
  mov    bx,"i-"
  call   @@get_parm
  jnc    @@set_sIRQ
@@sDMA:
  mov    bx,"d-"
  call   @@get_parm
  jnc    @@set_sDMA
@@scb:
  mov    bx,"s-"
  call   @@get_parm
  jnc    @@set_sr
@@scp:
  mov    bx,"p-"
  call   @@get_parm
  jnc    @@set_pa
@@scbb:
  mov    bx,"b-"
  call   @@get_parm
  jnc    @@set_sa
@@end:
  ret
@@help:
  lea    edx,[help_mess]
  mov    ah,9
  int    21h
  mov    eax,4c00h
  int    21h
@@set_card:
  sub    al,"0"
  mov    [byte parm_card],al
  jmp    @@sIRQ
@@set_sIRQ:
  add    edi,2
  call   get_vbyte
  mov    [parm_IRQ],al
  jmp    @@sDMA
@@set_sDMA:
  add    edi,2
  call   get_vbyte
  mov    [parm_DMA],al
  jmp    @@scb
@@set_sr:
  sub    al,"0"
  js     @@end
  call   FNK_set_sr
  jmp    @@scp
@@set_pa:
  add    edi,2
  call   get_vbyte
  mov    [funk_info.funk_pd_size],al
  jmp    @@scbb
@@set_sa:
  add    edi,2
  call   get_vdword
  mov    [funk_info.sample_memory_lim],ebx
  jmp    @@end
proc @@get_parm
  mov    edi,[PSP_Address]
  add    edi,81h
  mov    cl,128
@@l:
  cmp    bx,[word edi]
  je     @@found
  cmp    [byte edi],13
  je     @@eol
  inc    edi
  dec    cl
  jnz    @@l
@@eol:
  stc
  ret
@@found:
  mov    al,[byte edi+2]
  clc
  ret
endp
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Allocate various buffers used by FunkTracker                            ;
; Modified by Adam Seychell 09/20/95 (V1.08b)                             ;
;                                                                         ;
; Hi Jason, below is the alloc_funk_mem from FUNK.ASM v1.08. There        ;
; was a small bug, you had cli instead of clc and sti instead of stc      ;
; when the function returns. This would not return carry clear set        ;
; even if there wasn't enough memory. I also changed it so                ;
; the it allocates the three buffers in one hit. It's better to           ;
; do like that. Smaller and faster code.                                  ;
; Please replace this func in your current version of FUNK.ASM.           ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc alloc_funk_mem
;allocate DMA buffer
  mov    eax,0EE41h         ; allocate a 16Kb DMA buffer
  Int    31h                ;  rets EDX->near pointer EBX = phys address
  jc     @@memory_error
  mov    [funk_dma_buffer_addr],edx


; Allocate header buffer, sample buffer and directory buffer.
;
 ;Get funk header block size
  cmp    [byte funk_info.funk_pd_size],2
  jb     @@illegal_mem
  cmp    [byte funk_info.funk_pd_size],80h
  ja     @@illegal_mem
  movzx  ecx,[byte funk_info.funk_pd_size]     ;(600h*128)
  mov    eax,600h
  mul    ecx
  mov    edi,eax
  add    edi,size tfunk_hr

 ;Add sample block size
  mov    eax,[dword funk_info.sample_memory_lim]
  cmp    eax,00001000h
  jb     @@illegal_mem
  add    edi,eax

 ;Add directory block size
  add    edi,fdir_max_length * (Size tfdirectory) + 1000h

  mov    edx,edi            ; allocate all three blocks at once
  mov    AX,0EE42h          ; allocate a DOS32 memory block
  int    31h                ;  expects EDX = size; ret EAX=size, EDX->pointer
  jc     @@memory_error

 ;Save pointers to each of the three blocks
  mov    [funk_sd_ptr],edx
  add    edx,[dword funk_info.sample_memory_lim]
  mov    [fdirectory_buffer],edx
  add    edx, fdir_max_length * (Size tfdirectory) + 1000h
  mov    [funk_hr_ptr],edx
  clc
  ret

@@memory_error:
  mov    eax,3h
  int    10h
  lea    edx,[@@main_mess1]
  mov    ah,9
  int    21h
  stc
  ret
@@illegal_mem:
  mov    eax,3h
  int    10h
  lea    edx,[@@main_mess2]
  mov    ah,9
  int    21h
  stc
  ret
@@main_mess1:
db "Memory Error. FunkTracker unable to run.",13,10,"$"
@@main_mess2:
db "Invalid memory entry as parameter. FunkTracker unable to run.",13,10,"$"
endp

proc dealloc_funk_mem
;dealloc hdr blok, sam blok & directory buffer
  mov    eax,0EE40h
  int    31h
;delloc DMA
  mov    eax,0EE40h
  int    31h
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
main_mess0:
db "Using DOS32 V"
ver_major:
db "0."
ver_minor:
db "00 by Adam Seychell",13,10,"$"
main_mess1:
db "FunkTracker/SuperReal                                       by Jason Nunn (JsNO)"
db "$"
main_mess3:
db "No legal sound card detected.",13,10,"$"
main_mess4:
db "Soundcard initisation failed. FunkTracker unable to run.",13,10,"$"

Start_FunkTracker:
;  call   debug
  cld
  mov    ax,0EE02h       ; get DOS32 address information
  int    31h
  neg    ebx
  mov    [Zero_Addr],ebx
  add    ebx,0b8000h
  mov    [_0B8000h],ebx
  mov    [Environment_Address],edi
  mov    [PSP_Address],esi

  lea    edx,[main_mess1]
  mov    ah,9
  int    21h
  call   get_cpuid
  mov    eax,0EE00h
  int    31h
  push   edx
  and    eax,0f0fh
  add    [byte ver_major],ah
  add    [byte ver_minor+1],al
  lea    edx,[main_mess0]
  mov    ah,9
  int    21h
  pop    edx
  call   search_funkline
  call   alloc_funk_mem
  jc     @@abort
  call   init_vars
  mov    bl,[parm_card]
  mov    al,[parm_IRQ]
  mov    ah,[parm_DMA]
  call   FNK_autodetect
  jc     @@card_not_found
  mov    cl,100
@@waitabit:         ;so the user can read the detected settings
  @WaitVertEnd
  @WaitVert
  dec    cl
  jnz    @@waitabit
  lea    esi,[initial_dir]
  call   get_directory
  lea    esi,[song_dir]
  call   get_directory
  lea    esi,[sample_dir]
  call   get_directory
  mov    eax,[funk_dma_buffer_addr]
  call   FNK_card_init
  jc     @@card_error
  call   init_for_play
  call   clear_all_funk
  call   setup_screen
  call   main_handle
  call   MIDI_off
  call   FNK_card_deinit
  call   text_ded_pfout
  lea    edx,[initial_dir]
  call   set_directory
  mov    eax,3h
  int    10h
  mov    ecx,end_screen_size
  lea    esi,[end_screen]
  mov    edi,[_0b8000h]
  call   uncrush_text
  mov    ah,02h
  xor    bh,bh
  mov    edx,0400h
  int    10h
@@abort:
  call   dealloc_funk_mem
  mov    eax,4c00h
  int    21h
@@card_not_found:
  lea    edx,[main_mess3]
  mov    ah,9
  int    21h
  jmp    @@abort
@@card_error:
  lea    edx,[main_mess4]
  mov    ah,9
  int    21h
  jmp    @@abort
ends

end Start_FunkTracker
