#define COMPILING_BLOCK

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "globals.h"
#include "block.h"
#include "inst.h"
#include "song.h"

block::block(unsigned int lines) {
  unsigned int counter;

  highest_line = lines - 1;
  for (counter = 0;counter < MAX_TRACKS;counter++) {
    if (counter <= song_obj.highest_track) {
      track_pointer[counter] = make_blank_track(lines);
      track_bytes[counter] = lines * 4;
    }
    else {
      track_pointer[counter] = 0;
      track_bytes[counter] = 0;
    }
  }
}

block::~block() {
  unsigned int counter, stepper, trackstep;
  unsigned char *track_mem;

  for (trackstep = 0;trackstep <= song_obj.highest_track;trackstep++)
    if (track_pointer[trackstep]) {
      track_mem = track_pointer[trackstep];
      for (stepper = 0;stepper <= song_obj.highest_block;stepper++)
        for (counter = 0;counter <= song_obj.highest_track;counter++)
          if (song_obj.block_pointer[stepper]->track_pointer[counter]
            == track_mem)
            song_obj.block_pointer[stepper]->track_pointer[counter] = 0;
      free(track_mem);
    }
}

unsigned char *block::make_blank_track(unsigned int lines) {
  unsigned char *new_track;
  unsigned char *track_init;
  unsigned int stepper;

  new_track = (unsigned char *) malloc(lines * 4);
  assert(new_track);
  track_init = new_track;
  for (stepper = 0;stepper < lines;stepper++) {
    *(track_init++) = 128;
    *(track_init++) = 128;
    *(track_init++) = 0;
    *(track_init++) = 0;
  }
  return new_track;
}
