// A simple program to load and play GMS modules.

#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>
#include "globals.h"
#ifdef TARGET_MSDOS
#include <conio.h>
#endif
#include "inst.h"
#include "block.h"
#include "song.h"
#include "musdrv.h"

int main (int argc, char *argv[]) {
  int counter;
  FILE *module;

  cout << "Game Music System 1.0 command-line player" << endl;
  cout << "Written by Roland Acton in 1996 - public domain" << endl;
  if (argc > 1) {   // Did the user type a filename?
    cout << endl;
    cout << "Press any key to stop playing." << endl;
    cout << endl;
    counter = 1;
    music.wedge_player();   // Start interrupt.
    music.reset_card();
    while (counter < argc) {   // Loop until all files have been played.
      cout << argv[counter] << ": ";
      module = fopen(argv[counter], "rb");
      if (module) {   // Check to make sure file exists.
        cout << "loading...";
        if (song_obj.load_gms(module)) {   // Make sure it is a GMS module.
          cout << "playing...";
          music.set_up_card();
          music.start_playing();
#ifdef TARGET_MSDOS
          getch();   // Wait until user presses a key.
#endif
          music.stop_playing();
          music.reset_card();
          cout << "done.";
        }
        else {
          cout << "not a GMS 1.0 module.";
        }
      }
      else {
        cout << "couldn't open file.";
      }
      cout << endl;
      counter++;
    }
    music.remove_player();   // Remove interrupt.
  }
  else {
    cout << "Syntax: PLAYGMS <filename> [<filename>] [...]" << endl;
  }
  return EXIT_SUCCESS;
}
