#define COMPILING_SONG

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "globals.h"
#ifdef TARGET_MSDOS
#include <dos.h>
#endif
#include <assert.h>
#include "block.h"
#include "inst.h"
#include "song.h"
#include "musdrv.h"
#ifdef EDITOR_HOOKS
#include "intrface.h"
#include "gengad.h"
#include "statbar.h"
#endif

song::song() {
  name = new char [51];
  *name = 0;
  info_page = (char *) malloc(14);
  memset(info_page, 0, 14);
  pattern_list[0] = 0;
  highest_pattern = 0;
  highest_stereo_left = 3;
  highest_track = 8;
  soundsystem = adlib;
  overall_am_vib.byte = 0; 
  tempo = 130;
  secondary_tempo = 6;
  block_pointer[0] = new block;
  highest_block = 0;
  instrument_pointer[0] = new instrument;
  instrument_pointer[0]->a_d1.byte = 0xFF;
  instrument_pointer[0]->a_d2.byte = 0xFF;
  instrument_pointer[0]->s_r1.byte = 0xFF;
  instrument_pointer[0]->s_r2.byte = 0xFF;
  instrument_pointer[1] = new instrument;
  highest_instrument = 1;
  position_jump(0);
}

song::~song() {
  delete [] name;
  wipe_old_song();
  delete instrument_pointer[0];
  free(info_page);
}

void song::position_jump(unsigned int new_pattern, unsigned int new_line) {
  music.forbid_playing();
  if (new_pattern > highest_pattern)
    new_pattern = highest_pattern; 
  block_jump(pattern_list[new_pattern], new_line);
  current_pattern = new_pattern;
  music.permit_playing();
}

void song::block_jump(unsigned int new_block, unsigned int new_line) {
  unsigned int stepper, stepper2;

  music.forbid_playing();
  if (new_block > highest_block)
    new_block = highest_block;
  for(stepper = 0;stepper <= highest_track;stepper++)
    current_note[stepper] =
      block_pointer[new_block]->track_pointer[stepper];
  if (new_line) {
    if (new_line > block_pointer[new_block]->highest_line)
      new_line = block_pointer[new_block]->highest_line;
    for(stepper = 0;stepper <= highest_track;stepper++)
      for(stepper2 = 0;stepper2 < new_line;stepper2++)
        skip_note(current_note[stepper]);
  }
  current_block = new_block;
  current_line = new_line;
  music.reset_accumulated_ticks();
  music.permit_playing();
}

void song::advance_line() {
// Advance to the next line, and possibly to the next pattern.
  unsigned int stepper;

  if (++current_line > block_pointer[current_block]->highest_line) {
#ifdef EDITOR_HOOKS
    if (music.play_block_mode)
      block_jump(current_block);
    else {
#endif
      if(++current_pattern > highest_pattern)
        current_pattern = 0;
      position_jump(current_pattern);
#ifdef EDITOR_HOOKS
    }
#endif
  }
  else
    for (stepper = 0;stepper <= highest_track;stepper++)
      skip_note(current_note[stepper]); 
}

void song::wipe_old_song() {
  unsigned int stepper;

  for (stepper = 0;stepper <= highest_block;stepper++)
    delete block_pointer[stepper];
  for (stepper = 1;stepper <= highest_instrument;stepper++)
    delete instrument_pointer[stepper];
}

unsigned int song::load_gms(FILE *module) {
  char tracker_id_reader[20];
  unsigned int inbyte;
  unsigned int counter, stepper;
  char *char_read;
  int track_memory[MAX_BLOCKS][MAX_TRACKS];
  unsigned int track_counter, track_max;
  unsigned int track_lines;
  unsigned int track_start, track_end;
  unsigned char *mem_holder;

  fread(tracker_id_reader, 1, tracker_id_length[GMS_MOD_OFFSET], module);
  if (memcmp(tracker_id_reader, tracker_id_string[GMS_MOD_OFFSET],
    tracker_id_length[GMS_MOD_OFFSET])) {
#ifdef EDITOR_HOOKS
    status_bar_obj.message_output("This is not a GMS module.");
#endif
    return NO;
  }
  else {
    inbyte = fgetc(module);
    if (inbyte == 0) {
#ifdef EDITOR_HOOKS
      status_bar_obj.message_output("This is a GMS 1.0 module.");
#endif
      wipe_old_song();
// Load song info.
      stepper = 0;
      while ((*(name + stepper++) = fgetc(module)));
      free(info_page);
      info_page = (char *) malloc(784);
      char_read = info_page;
      for (counter = 0;counter < 14;counter++)
        while ((*(char_read++) = fgetc(module)));
      info_page = (char *) realloc(info_page, char_read - info_page);
      overall_am_vib.byte = fgetc(module);
      highest_track = fgetc(module);
      tempo = fgetc(module);
      secondary_tempo = fgetc(module);
      soundsystem = (sound_cards) fgetc(module);
      highest_stereo_left = fgetc(module);
// Load instruments.
      highest_instrument = fgetc(module);
      for (counter = 1;counter <= highest_instrument;counter++) {
        instrument_pointer[counter] = new instrument;
        stepper = 0;
        while ((*(instrument_pointer[counter]->name + stepper++)
          = fgetc(module)));
        instrument_pointer[counter]->am_vib1.byte = fgetc(module);
        instrument_pointer[counter]->scaling_volume1.byte = fgetc(module);
        instrument_pointer[counter]->a_d1.byte = fgetc(module);
        instrument_pointer[counter]->s_r1.byte = fgetc(module);
        instrument_pointer[counter]->wave1.byte = fgetc(module);
        instrument_pointer[counter]->am_vib2.byte = fgetc(module);
        instrument_pointer[counter]->scaling_volume2.byte = fgetc(module);
        instrument_pointer[counter]->a_d2.byte = fgetc(module);
        instrument_pointer[counter]->s_r2.byte = fgetc(module);
        instrument_pointer[counter]->wave2.byte = fgetc(module);
        instrument_pointer[counter]->op1mod_feedback.byte = fgetc(module);
      }
// Load pattern-list data.
      highest_pattern = fgetc(module);
      for (counter = 0;counter <= highest_pattern;counter++)
        pattern_list[counter] = fgetc(module);
// Load blocks.
      highest_block = fgetc(module);
      track_max = 0;
      for (counter = 0;counter <= highest_block;counter++) {
        block_pointer[counter] = new block;
        block_pointer[counter]->highest_line = fgetc(module);
        for (stepper = 0;stepper <= highest_track;stepper++) {
          inbyte = fgetc(module);
          track_memory[counter][stepper] = (inbyte << 8) + fgetc(module);
          if (!track_memory[counter][stepper]) {
            free(block_pointer[counter]->track_pointer[stepper]);
            block_pointer[counter]->track_pointer[stepper] = 0;
            block_pointer[counter]->track_bytes[stepper] = 0;
          }
          if (track_memory[counter][stepper] > (int) track_max)
            track_max = track_memory[counter][stepper];
        }
      }
      for (track_counter = 1;track_counter <= track_max;track_counter++) {
        track_lines = 9999;
        for (counter = 0;counter <= highest_block;counter++)
          for (stepper = 0;stepper <= highest_track;stepper++)
            if (track_memory[counter][stepper] == (int) track_counter)
              track_lines = block_pointer[counter]->highest_line;
        assert(track_lines != 9999);
        track_start = ftell(module);
        for (counter = 0;counter <= track_lines;counter++) {
          if (fgetc(module) & 128)
            if (fgetc(module) & 128)
              do {
                inbyte = fgetc(module);
                fgetc(module);
              } while (inbyte & 128);
        }
        track_end = ftell(module);
        fseek(module, track_start, SEEK_SET);
        mem_holder = (unsigned char *) malloc(track_end - track_start);
        fread(mem_holder, 1, track_end - track_start, module);
        for (counter = 0;counter <= highest_block;counter++)
          for (stepper = 0;stepper <= highest_track;stepper++)
            if (track_memory[counter][stepper] == (int) track_counter) {
              free(block_pointer[counter]->track_pointer[stepper]);
              block_pointer[counter]->track_pointer[stepper] = mem_holder;
              block_pointer[counter]->track_bytes[stepper] = track_end
                - track_start;
            }
      }
#ifdef EDITOR_HOOKS
      editor_reformat();
#endif
      position_jump(0);
      return YES;
    }
    else {
#ifdef EDITOR_HOOKS
      status_bar_obj.message_output("Unknown GMS format. You need a newer version of GMS.");
#endif
      return NO;
    }
  }
}
