;
; Test-Code by Shayde/Reality Feb95.
;
; Assembled with TASM 4.0.
;
; This is a test code to demonstrate how to use the RAD-Player code in your
; own productions.  All it does is start the tune playing, waits for a key-
; press and stops.  Complex stuff, eh?! :-)
;
; This code assumes the tune is a 50Hz (normal-timer) tune and changes the PC
; hardware clock to interrupt 50 times a second (although it still calls the
; BIOS interrupt 18.2 times a second).  It is easy enough to modify it to
; stay at the default 18.2Hz for any slow-timer tunez.  If you want to
; create a new tune .INC file I have included the Reality Data-maker in this
; package.
;

		.286
		jumps
		locals



IPS		=	50



Code16		segment public use16
		assume cs:Code16, ds:Code16


;
; Main.
;
Start:		mov	ax,cs
		mov	ds,ax

		mov	ax,Music
		mov	es,ax
		call	InitPlayer
		call	SetInt

	; wait for keypress
		xor	ah,ah
		int	16h

	; stop tune
		call	ResetInt
		call	EndPlayer
		mov	ax,4c00h
		int	21h





;
; Enables and starts the player interrupt.
;
SetInt:		push	ax es

		cli
		xor	ax,ax
		mov	es,ax
		mov	ax,es:[8*4]
		mov	word ptr OldInt,ax
		mov	ax,es:2[8*4]
		mov	word ptr OldInt+2,ax
		mov	word ptr es:[8*4], offset PlayerInt
		mov	es:2[8*4],cs

		mov	ax,IPS
		call	SetTimer

		sti
		pop	es ax
		ret






;
; Disables the player interrupt.
;
ResetInt:	push	ax es

		cli
		xor	ax,ax
		mov	es,ax
		mov	ax,word ptr OldInt
		mov	es:[8*4],ax
		mov	ax,word ptr OldInt+2
		mov	es:2[8*4],ax

		call	ResetTimer

		sti
		pop	es ax
		ret






;
; The player interrupt.  Called 50 times a second.
;
PlayerInt:	push	ax

		call	PlayMusic

	; see if we have passed 18.2/s mark
	@@lx:	mov	ax,TimerSteps		; this no. of steps per int.
		add	TimerCnt,ax
		jnc	@@ly			; don't call timer interrupt
		pop	ax
		jmp	cs:OldInt		; call old interrupt handlers

	; standard exit
	@@ly:	mov	al,20h
		out	20h,al
		pop	ax
		iret






;
; Sets the interrupt timer duty cycle.
; IN:
;	AX	- number of times per second for INT08.
;
SetTimer:	push	ax bx dx

		mov	bx,ax
		mov	ax,13532	; 1193180 mod 65536 (TASM craps out)
		mov	dx,18		; 1193180/65536 (TASM can't calculate this)
		div	bx
		mov	bx,ax

		mov	al,36h
		out	43h,al
		mov	al,bl
		out	40h,al
		mov	al,bh
		out	40h,al

		mov	TimerSteps,bx	; for keeping 18.2 timer correct
		mov	TimerCnt,0	; counter

		pop	dx bx ax
		ret






;
; Resets the interrupt timer back to 18.2/sec duty cycle.
;
ResetTimer:	push	ax

		mov	al,36h
		out	43h,al
		xor	al,al
		out	40h,al
		out	40h,al

		pop	ax
		ret




		include		Player.Asm




OldInt		dd	?
TimerCnt	dw	?
TimerSteps	dw	?
		ends



Music		segment para public use16
                include Raster.Inc
		ends



Stack16		segment para public use16 stack
		dw	100h dup (?)
		ends

		end	Start
